/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the hardware of a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalDatabaseHardware implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalDatabaseHardware.Builder, RelationalDatabaseHardware> {
    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RelationalDatabaseHardware::cpuCount)).setter(setter(Builder::cpuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()).build();

    private static final SdkField<Integer> DISK_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RelationalDatabaseHardware::diskSizeInGb)).setter(setter(Builder::diskSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSizeInGb").build()).build();

    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(RelationalDatabaseHardware::ramSizeInGb)).setter(setter(Builder::ramSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_COUNT_FIELD,
            DISK_SIZE_IN_GB_FIELD, RAM_SIZE_IN_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cpuCount;

    private final Integer diskSizeInGb;

    private final Float ramSizeInGb;

    private RelationalDatabaseHardware(BuilderImpl builder) {
        this.cpuCount = builder.cpuCount;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.ramSizeInGb = builder.ramSizeInGb;
    }

    /**
     * <p>
     * The number of vCPUs for the database.
     * </p>
     * 
     * @return The number of vCPUs for the database.
     */
    public Integer cpuCount() {
        return cpuCount;
    }

    /**
     * <p>
     * The size of the disk for the database.
     * </p>
     * 
     * @return The size of the disk for the database.
     */
    public Integer diskSizeInGb() {
        return diskSizeInGb;
    }

    /**
     * <p>
     * The amount of RAM in GB for the database.
     * </p>
     * 
     * @return The amount of RAM in GB for the database.
     */
    public Float ramSizeInGb() {
        return ramSizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(diskSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(ramSizeInGb());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseHardware)) {
            return false;
        }
        RelationalDatabaseHardware other = (RelationalDatabaseHardware) obj;
        return Objects.equals(cpuCount(), other.cpuCount()) && Objects.equals(diskSizeInGb(), other.diskSizeInGb())
                && Objects.equals(ramSizeInGb(), other.ramSizeInGb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RelationalDatabaseHardware").add("CpuCount", cpuCount()).add("DiskSizeInGb", diskSizeInGb())
                .add("RamSizeInGb", ramSizeInGb()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpuCount":
            return Optional.ofNullable(clazz.cast(cpuCount()));
        case "diskSizeInGb":
            return Optional.ofNullable(clazz.cast(diskSizeInGb()));
        case "ramSizeInGb":
            return Optional.ofNullable(clazz.cast(ramSizeInGb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseHardware, T> g) {
        return obj -> g.apply((RelationalDatabaseHardware) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalDatabaseHardware> {
        /**
         * <p>
         * The number of vCPUs for the database.
         * </p>
         * 
         * @param cpuCount
         *        The number of vCPUs for the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCount(Integer cpuCount);

        /**
         * <p>
         * The size of the disk for the database.
         * </p>
         * 
         * @param diskSizeInGb
         *        The size of the disk for the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSizeInGb(Integer diskSizeInGb);

        /**
         * <p>
         * The amount of RAM in GB for the database.
         * </p>
         * 
         * @param ramSizeInGb
         *        The amount of RAM in GB for the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramSizeInGb(Float ramSizeInGb);
    }

    static final class BuilderImpl implements Builder {
        private Integer cpuCount;

        private Integer diskSizeInGb;

        private Float ramSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseHardware model) {
            cpuCount(model.cpuCount);
            diskSizeInGb(model.diskSizeInGb);
            ramSizeInGb(model.ramSizeInGb);
        }

        public final Integer getCpuCount() {
            return cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Integer getDiskSizeInGb() {
            return diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        public final Float getRamSizeInGb() {
            return ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        @Override
        public RelationalDatabaseHardware build() {
            return new RelationalDatabaseHardware(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
