/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.LightsailException;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.TagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.TagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UntagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.UntagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachInstancesToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCloudFormationStackRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAutoSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKnownHostKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DisableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.EnableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ExportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAutoSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCloudFormationStackRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDisksRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetExportSnapshotRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMasterUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabasesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateLoadBalancerAttributeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link LightsailAsyncClient}.
 *
 * @see LightsailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLightsailAsyncClient implements LightsailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLightsailAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLightsailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     *
     * @param allocateStaticIpRequest
     * @return A Java Future containing the result of the AllocateStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AllocateStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AllocateStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AllocateStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateStaticIpRequest, AllocateStaticIpResponse>()
                            .withOperationName("AllocateStaticIp")
                            .withMarshaller(new AllocateStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(allocateStaticIpRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the
     * specified disk name.
     * </p>
     * <p>
     * The <code>attach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachDiskRequest
     * @return A Java Future containing the result of the AttachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachDiskResponse> attachDisk(AttachDiskRequest attachDiskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AttachDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachDiskRequest, AttachDiskResponse>().withOperationName("AttachDisk")
                            .withMarshaller(new AttachDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachDiskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches one or more Lightsail instances to a load balancer.
     * </p>
     * <p>
     * After some time, the instances are attached to the load balancer and the health check status is available.
     * </p>
     * <p>
     * The <code>attach instances to load balancer</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachInstancesToLoadBalancerRequest
     * @return A Java Future containing the result of the AttachInstancesToLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachInstancesToLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachInstancesToLoadBalancerResponse> attachInstancesToLoadBalancer(
            AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachInstancesToLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachInstancesToLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachInstancesToLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachInstancesToLoadBalancerRequest, AttachInstancesToLoadBalancerResponse>()
                            .withOperationName("AttachInstancesToLoadBalancer")
                            .withMarshaller(new AttachInstancesToLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachInstancesToLoadBalancerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure
     * version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API
     * to rotate the certificates on your account. Use the <code>attach load balancer tls certificate</code> operation
     * with the non-attached certificate, and it will replace the existing one and become the attached certificate.
     * </p>
     * <p>
     * The <code>attach load balancer tls certificate</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">Lightsail
     * Dev Guide</a>.
     * </p>
     *
     * @param attachLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the AttachLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachLoadBalancerTlsCertificateResponse> attachLoadBalancerTlsCertificate(
            AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AttachLoadBalancerTlsCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachLoadBalancerTlsCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachLoadBalancerTlsCertificateRequest, AttachLoadBalancerTlsCertificateResponse>()
                            .withOperationName("AttachLoadBalancerTlsCertificate")
                            .withMarshaller(new AttachLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachLoadBalancerTlsCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     *
     * @param attachStaticIpRequest
     * @return A Java Future containing the result of the AttachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachStaticIpResponse> attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachStaticIpRequest, AttachStaticIpResponse>()
                            .withOperationName("AttachStaticIp")
                            .withMarshaller(new AttachStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachStaticIpRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Closes the public ports on a specific Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>close instance public ports</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param closeInstancePublicPortsRequest
     * @return A Java Future containing the result of the CloseInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(
            CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CloseInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CloseInstancePublicPortsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CloseInstancePublicPortsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResponse>()
                            .withOperationName("CloseInstancePublicPorts")
                            .withMarshaller(new CloseInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(closeInstancePublicPortsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an
     * instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of
     * an instance or a disk from one AWS Region to another in Amazon Lightsail.
     * </p>
     * <p>
     * When copying a <i>manual snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source snapshot name</code>, and <code>target snapshot name</code> parameters.
     * </p>
     * <p>
     * When copying an <i>automatic snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source resource name</code>, <code>target snapshot name</code>, and either the <code>restore date</code> or
     * the <code>use latest restorable auto snapshot</code> parameters.
     * </p>
     *
     * @param copySnapshotRequest
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CopySnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CopySnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                            .withOperationName("CopySnapshot").withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(copySnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail
     * snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS
     * CloudFormation stack created. Use the <code>get cloud formation stack records</code> operation to get a list of
     * the CloudFormation stacks created.
     * </p>
     * <important>
     * <p>
     * Wait until after your new Amazon EC2 instance is created before running the
     * <code>create cloud formation stack</code> operation again with the same export snapshot record.
     * </p>
     * </important>
     *
     * @param createCloudFormationStackRequest
     * @return A Java Future containing the result of the CreateCloudFormationStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateCloudFormationStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCloudFormationStack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudFormationStackResponse> createCloudFormationStack(
            CreateCloudFormationStackRequest createCloudFormationStackRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCloudFormationStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCloudFormationStackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCloudFormationStackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudFormationStackRequest, CreateCloudFormationStackResponse>()
                            .withOperationName("CreateCloudFormationStack")
                            .withMarshaller(new CreateCloudFormationStackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createCloudFormationStackRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone
     * (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk</code> operation supports tag-based access control via request tags. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskRequest
     * @return A Java Future containing the result of the CreateDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskResponse> createDisk(CreateDiskRequest createDiskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDiskRequest, CreateDiskResponse>().withOperationName("CreateDisk")
                            .withMarshaller(new CreateDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDiskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to
     * an Amazon Lightsail instance in the same Availability Zone (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>disk snapshot name</code>. For more information, see
     * the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">
     * Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskFromSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskFromSnapshotResponse> createDiskFromSnapshot(
            CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDiskFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDiskFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDiskFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDiskFromSnapshotRequest, CreateDiskFromSnapshotResponse>()
                            .withOperationName("CreateDiskFromSnapshot")
                            .withMarshaller(new CreateDiskFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDiskFromSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to
     * save data before shutting down a Lightsail instance.
     * </p>
     * <p>
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been
     * written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached
     * by any applications or the operating system. If you can pause any file systems on the disk long enough to take a
     * snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you
     * should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then
     * remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the
     * snapshot status is pending.
     * </p>
     * <p>
     * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this,
     * for example, to recover data from the system volume of a botched instance or to create a backup of the system
     * volume like you would for a block storage disk. To create a snapshot of a system volume, just define the
     * <code>instance name</code> parameter when issuing the snapshot command, and a snapshot of the defined instance's
     * system volume will be created. After the snapshot is available, you can create a block storage disk from the
     * snapshot and attach it to a running instance to access the data on the disk.
     * </p>
     * <p>
     * The <code>create disk snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskSnapshotResponse> createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDiskSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDiskSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDiskSnapshotRequest, CreateDiskSnapshotResponse>()
                            .withOperationName("CreateDiskSnapshot")
                            .withMarshaller(new CreateDiskSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDiskSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     * <p>
     * The <code>create domain</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                            .withOperationName("CreateDomain").withMarshaller(new CreateDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDomainRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one of the following entry records associated with the domain: Address (A), canonical name (CNAME), mail
     * exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     * </p>
     * <p>
     * The <code>create domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDomainEntryRequest
     * @return A Java Future containing the result of the CreateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainEntryResponse> createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDomainEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainEntryRequest, CreateDomainEntryResponse>()
                            .withOperationName("CreateDomainEntry")
                            .withMarshaller(new CreateDomainEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDomainEntryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     * <p>
     * The <code>create instance snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstanceSnapshotRequest
     * @return A Java Future containing the result of the CreateInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(
            CreateInstanceSnapshotRequest createInstanceSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInstanceSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInstanceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResponse>()
                            .withOperationName("CreateInstanceSnapshot")
                            .withMarshaller(new CreateInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInstanceSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail instances.
     * </p>
     * <p>
     * The <code>create instances</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstancesRequest
     * @return A Java Future containing the result of the CreateInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesResponse> createInstances(CreateInstancesRequest createInstancesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstancesRequest, CreateInstancesResponse>()
                            .withOperationName("CreateInstances")
                            .withMarshaller(new CreateInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more new instances from a manual or automatic snapshot of an instance.
     * </p>
     * <p>
     * The <code>create instances from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>instance snapshot name</code>. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstancesFromSnapshotRequest
     * @return A Java Future containing the result of the CreateInstancesFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(
            CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstancesFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInstancesFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInstancesFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResponse>()
                            .withOperationName("CreateInstancesFromSnapshot")
                            .withMarshaller(new CreateInstancesFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInstancesFromSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SSH key pair.
     * </p>
     * <p>
     * The <code>create key pair</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                            .withOperationName("CreateKeyPair")
                            .withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createKeyPairRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing">
     * Configure your Lightsail instances for load balancing</a>. You can create up to 5 load balancers per AWS Region
     * in your account.
     * </p>
     * <p>
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load
     * balancer settings, use the <code>UpdateLoadBalancerAttribute</code> operation.
     * </p>
     * <p>
     * The <code>create load balancer</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoadBalancerRequest, CreateLoadBalancerResponse>()
                            .withOperationName("CreateLoadBalancer")
                            .withMarshaller(new CreateLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLoadBalancerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Lightsail load balancer TLS certificate.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * The <code>create load balancer tls certificate</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">Lightsail
     * Dev Guide</a>.
     * </p>
     *
     * @param createLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the CreateLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerTlsCertificateResponse> createLoadBalancerTlsCertificate(
            CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateLoadBalancerTlsCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLoadBalancerTlsCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoadBalancerTlsCertificateRequest, CreateLoadBalancerTlsCertificateResponse>()
                            .withOperationName("CreateLoadBalancerTlsCertificate")
                            .withMarshaller(new CreateLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLoadBalancerTlsCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>create relational database</code> operation supports tag-based access control via request tags. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseRequest
     * @return A Java Future containing the result of the CreateRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRelationalDatabaseResponse> createRelationalDatabase(
            CreateRelationalDatabaseRequest createRelationalDatabaseRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRelationalDatabaseRequest, CreateRelationalDatabaseResponse>()
                            .withOperationName("CreateRelationalDatabase")
                            .withMarshaller(new CreateRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRelationalDatabaseRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new database from an existing database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * You can create a new database from a snapshot in if something goes wrong with your original database, or to
     * change it to a different plan, such as a high availability or standard plan.
     * </p>
     * <p>
     * The <code>create relational database from snapshot</code> operation supports tag-based access control via request
     * tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseFromSnapshotRequest
     * @return A Java Future containing the result of the CreateRelationalDatabaseFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateRelationalDatabaseFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRelationalDatabaseFromSnapshotResponse> createRelationalDatabaseFromSnapshot(
            CreateRelationalDatabaseFromSnapshotRequest createRelationalDatabaseFromSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRelationalDatabaseFromSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateRelationalDatabaseFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRelationalDatabaseFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRelationalDatabaseFromSnapshotRequest, CreateRelationalDatabaseFromSnapshotResponse>()
                            .withOperationName("CreateRelationalDatabaseFromSnapshot")
                            .withMarshaller(new CreateRelationalDatabaseFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRelationalDatabaseFromSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a
     * database, and to save data before deleting a database.
     * </p>
     * <p>
     * The <code>create relational database snapshot</code> operation supports tag-based access control via request
     * tags. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseSnapshotRequest
     * @return A Java Future containing the result of the CreateRelationalDatabaseSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRelationalDatabaseSnapshotResponse> createRelationalDatabaseSnapshot(
            CreateRelationalDatabaseSnapshotRequest createRelationalDatabaseSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRelationalDatabaseSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateRelationalDatabaseSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRelationalDatabaseSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRelationalDatabaseSnapshotRequest, CreateRelationalDatabaseSnapshotResponse>()
                            .withOperationName("CreateRelationalDatabaseSnapshot")
                            .withMarshaller(new CreateRelationalDatabaseSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRelationalDatabaseSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an automatic snapshot of an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteAutoSnapshotRequest
     * @return A Java Future containing the result of the DeleteAutoSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteAutoSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAutoSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAutoSnapshotResponse> deleteAutoSnapshot(DeleteAutoSnapshotRequest deleteAutoSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAutoSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAutoSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAutoSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAutoSnapshotRequest, DeleteAutoSnapshotResponse>()
                            .withOperationName("DeleteAutoSnapshot")
                            .withMarshaller(new DeleteAutoSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteAutoSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified block storage disk. The disk must be in the <code>available</code> state (not attached to a
     * Lightsail instance).
     * </p>
     * <note>
     * <p>
     * The disk may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note>
     * <p>
     * The <code>delete disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDiskRequest
     * @return A Java Future containing the result of the DeleteDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDiskResponse> deleteDisk(DeleteDiskRequest deleteDiskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDiskRequest, DeleteDiskResponse>().withOperationName("DeleteDisk")
                            .withMarshaller(new DeleteDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDiskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified disk snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that
     * have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data
     * not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the disk.
     * </p>
     * <p>
     * The <code>delete disk snapshot</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>disk snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDiskSnapshotRequest
     * @return A Java Future containing the result of the DeleteDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDiskSnapshotResponse> deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDiskSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDiskSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDiskSnapshotRequest, DeleteDiskSnapshotResponse>()
                            .withOperationName("DeleteDiskSnapshot")
                            .withMarshaller(new DeleteDiskSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDiskSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     * <p>
     * The <code>delete domain</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                            .withOperationName("DeleteDomain").withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDomainRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     * <p>
     * The <code>delete domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDomainEntryRequest
     * @return A Java Future containing the result of the DeleteDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDomainEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainEntryRequest, DeleteDomainEntryResponse>()
                            .withOperationName("DeleteDomainEntry")
                            .withMarshaller(new DeleteDomainEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDomainEntryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>delete instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceRequest, DeleteInstanceResponse>()
                            .withOperationName("DeleteInstance")
                            .withMarshaller(new DeleteInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     * <p>
     * The <code>delete instance snapshot</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by <code>instance snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteInstanceSnapshotRequest
     * @return A Java Future containing the result of the DeleteInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(
            DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInstanceSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInstanceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResponse>()
                            .withOperationName("DeleteInstanceSnapshot")
                            .withMarshaller(new DeleteInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteInstanceSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     * <p>
     * The <code>delete key pair</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>key pair name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                            .withOperationName("DeleteKeyPair")
                            .withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteKeyPairRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to
     * authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the
     * instance after a host key mismatch.
     * </p>
     * <important>
     * <p>
     * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar
     * with the new host key or certificate on the instance. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection"
     * >Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client</a>.
     * </p>
     * </important>
     *
     * @param deleteKnownHostKeysRequest
     * @return A Java Future containing the result of the DeleteKnownHostKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteKnownHostKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKnownHostKeys" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKnownHostKeysResponse> deleteKnownHostKeys(
            DeleteKnownHostKeysRequest deleteKnownHostKeysRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteKnownHostKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteKnownHostKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteKnownHostKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKnownHostKeysRequest, DeleteKnownHostKeysResponse>()
                            .withOperationName("DeleteKnownHostKeys")
                            .withMarshaller(new DeleteKnownHostKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteKnownHostKeysRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted,
     * you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     * </p>
     * <p>
     * The <code>delete load balancer</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>()
                            .withOperationName("DeleteLoadBalancer")
                            .withMarshaller(new DeleteLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLoadBalancerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     * </p>
     * <p>
     * The <code>delete load balancer tls certificate</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">Lightsail
     * Dev Guide</a>.
     * </p>
     *
     * @param deleteLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the DeleteLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> deleteLoadBalancerTlsCertificate(
            DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteLoadBalancerTlsCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoadBalancerTlsCertificateRequest, DeleteLoadBalancerTlsCertificateResponse>()
                            .withOperationName("DeleteLoadBalancerTlsCertificate")
                            .withMarshaller(new DeleteLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLoadBalancerTlsCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteRelationalDatabaseRequest
     * @return A Java Future containing the result of the DeleteRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRelationalDatabaseResponse> deleteRelationalDatabase(
            DeleteRelationalDatabaseRequest deleteRelationalDatabaseRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRelationalDatabaseRequest, DeleteRelationalDatabaseResponse>()
                            .withOperationName("DeleteRelationalDatabase")
                            .withMarshaller(new DeleteRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRelationalDatabaseRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database snapshot</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteRelationalDatabaseSnapshotRequest
     * @return A Java Future containing the result of the DeleteRelationalDatabaseSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRelationalDatabaseSnapshotResponse> deleteRelationalDatabaseSnapshot(
            DeleteRelationalDatabaseSnapshotRequest deleteRelationalDatabaseSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRelationalDatabaseSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteRelationalDatabaseSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRelationalDatabaseSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRelationalDatabaseSnapshotRequest, DeleteRelationalDatabaseSnapshotResponse>()
                            .withOperationName("DeleteRelationalDatabaseSnapshot")
                            .withMarshaller(new DeleteRelationalDatabaseSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRelationalDatabaseSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the
     * device within your operating system before stopping the instance and detaching the disk.
     * </p>
     * <p>
     * The <code>detach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param detachDiskRequest
     * @return A Java Future containing the result of the DetachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachDiskResponse> detachDisk(DetachDiskRequest detachDiskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetachDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachDiskRequest, DetachDiskResponse>().withOperationName("DetachDisk")
                            .withMarshaller(new DetachDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachDiskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches the specified instances from a Lightsail load balancer.
     * </p>
     * <p>
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     * </p>
     * <p>
     * The <code>detach instances from load balancer</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">Lightsail
     * Dev Guide</a>.
     * </p>
     *
     * @param detachInstancesFromLoadBalancerRequest
     * @return A Java Future containing the result of the DetachInstancesFromLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachInstancesFromLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachInstancesFromLoadBalancerResponse> detachInstancesFromLoadBalancer(
            DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachInstancesFromLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachInstancesFromLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachInstancesFromLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachInstancesFromLoadBalancerRequest, DetachInstancesFromLoadBalancerResponse>()
                            .withOperationName("DetachInstancesFromLoadBalancer")
                            .withMarshaller(new DetachInstancesFromLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachInstancesFromLoadBalancerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     *
     * @param detachStaticIpRequest
     * @return A Java Future containing the result of the DetachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachStaticIpResponse> detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachStaticIpRequest, DetachStaticIpResponse>()
                            .withOperationName("DetachStaticIp")
                            .withMarshaller(new DetachStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachStaticIpRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param disableAddOnRequest
     * @return A Java Future containing the result of the DisableAddOn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DisableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DisableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableAddOnResponse> disableAddOn(DisableAddOnRequest disableAddOnRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableAddOnResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableAddOnResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableAddOnResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableAddOnRequest, DisableAddOnResponse>()
                            .withOperationName("DisableAddOn").withMarshaller(new DisableAddOnRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disableAddOnRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     *
     * @param downloadDefaultKeyPairRequest
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(
            DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DownloadDefaultKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DownloadDefaultKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DownloadDefaultKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResponse>()
                            .withOperationName("DownloadDefaultKeyPair")
                            .withMarshaller(new DownloadDefaultKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(downloadDefaultKeyPairRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param enableAddOnRequest
     * @return A Java Future containing the result of the EnableAddOn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.EnableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/EnableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableAddOnResponse> enableAddOn(EnableAddOnRequest enableAddOnRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableAddOnResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableAddOnResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableAddOnResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableAddOnRequest, EnableAddOnResponse>()
                            .withOperationName("EnableAddOn").withMarshaller(new EnableAddOnRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(enableAddOnRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2).
     * This operation results in an export snapshot record that can be used with the
     * <code>create cloud formation stack</code> operation to create new Amazon EC2 instances.
     * </p>
     * <p>
     * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk
     * appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as
     * Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source
     * Lightsail snapshot.
     * </p>
     * <p/>
     * <p>
     * The <code>export snapshot</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>source snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <note>
     * <p>
     * Use the <code>get instance snapshots</code> or <code>get disk snapshots</code> operations to get a list of
     * snapshots that you can export to Amazon EC2.
     * </p>
     * </note>
     *
     * @param exportSnapshotRequest
     * @return A Java Future containing the result of the ExportSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ExportSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ExportSnapshotResponse> exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExportSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExportSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExportSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExportSnapshotRequest, ExportSnapshotResponse>()
                            .withOperationName("ExportSnapshot")
                            .withMarshaller(new ExportSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(exportSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     *
     * @param getActiveNamesRequest
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetActiveNamesResponse> getActiveNames(GetActiveNamesRequest getActiveNamesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetActiveNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetActiveNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetActiveNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetActiveNamesRequest, GetActiveNamesResponse>()
                            .withOperationName("GetActiveNames")
                            .withMarshaller(new GetActiveNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getActiveNamesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the available automatic snapshots for an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param getAutoSnapshotsRequest
     * @return A Java Future containing the result of the GetAutoSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetAutoSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAutoSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAutoSnapshotsResponse> getAutoSnapshots(GetAutoSnapshotsRequest getAutoSnapshotsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAutoSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAutoSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAutoSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAutoSnapshotsRequest, GetAutoSnapshotsResponse>()
                            .withOperationName("GetAutoSnapshots")
                            .withMarshaller(new GetAutoSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getAutoSnapshotsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * instance already running a specific operating system, as well as a preinstalled app or development stack. The
     * software each instance is running depends on the blueprint image you choose.
     * </p>
     * <note>
     * <p>
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with
     * existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when
     * they become outdated due to operating system updates or new application releases.
     * </p>
     * </note>
     *
     * @param getBlueprintsRequest
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBlueprintsResponse> getBlueprints(GetBlueprintsRequest getBlueprintsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBlueprintsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBlueprintsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBlueprintsRequest, GetBlueprintsResponse>()
                            .withOperationName("GetBlueprints")
                            .withMarshaller(new GetBlueprintsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBlueprintsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     *
     * @param getBundlesRequest
     * @return A Java Future containing the result of the GetBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBundlesResponse> getBundles(GetBundlesRequest getBundlesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBundlesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBundlesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBundlesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBundlesRequest, GetBundlesResponse>().withOperationName("GetBundles")
                            .withMarshaller(new GetBundlesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBundlesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the CloudFormation stack record created as a result of the <code>create cloud formation stack</code>
     * operation.
     * </p>
     * <p>
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     * </p>
     *
     * @param getCloudFormationStackRecordsRequest
     * @return A Java Future containing the result of the GetCloudFormationStackRecords operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetCloudFormationStackRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCloudFormationStackRecords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudFormationStackRecordsResponse> getCloudFormationStackRecords(
            GetCloudFormationStackRecordsRequest getCloudFormationStackRecordsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudFormationStackRecordsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCloudFormationStackRecordsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCloudFormationStackRecordsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudFormationStackRecordsRequest, GetCloudFormationStackRecordsResponse>()
                            .withOperationName("GetCloudFormationStackRecords")
                            .withMarshaller(new GetCloudFormationStackRecordsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getCloudFormationStackRecordsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific block storage disk.
     * </p>
     *
     * @param getDiskRequest
     * @return A Java Future containing the result of the GetDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskResponse> getDisk(GetDiskRequest getDiskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDiskRequest, GetDiskResponse>().withOperationName("GetDisk")
                            .withMarshaller(new GetDiskRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDiskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific block storage disk snapshot.
     * </p>
     *
     * @param getDiskSnapshotRequest
     * @return A Java Future containing the result of the GetDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskSnapshotResponse> getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDiskSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDiskSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDiskSnapshotRequest, GetDiskSnapshotResponse>()
                            .withOperationName("GetDiskSnapshot")
                            .withMarshaller(new GetDiskSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getDiskSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disk snapshots, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getDiskSnapshotsRequest
     * @return A Java Future containing the result of the GetDiskSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDiskSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDiskSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDiskSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDiskSnapshotsRequest, GetDiskSnapshotsResponse>()
                            .withOperationName("GetDiskSnapshots")
                            .withMarshaller(new GetDiskSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getDiskSnapshotsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     * <p>
     * If you are describing a long list of disks, you can paginate the output to make the list more manageable. You can
     * use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getDisksRequest
     * @return A Java Future containing the result of the GetDisks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDisksResponse> getDisks(GetDisksRequest getDisksRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDisksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDisksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDisksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDisksRequest, GetDisksResponse>().withOperationName("GetDisks")
                            .withMarshaller(new GetDisksRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDisksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     *
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainRequest, GetDomainResponse>().withOperationName("GetDomain")
                            .withMarshaller(new GetDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDomainRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     *
     * @param getDomainsRequest
     * @return A Java Future containing the result of the GetDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainsResponse> getDomains(GetDomainsRequest getDomainsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainsRequest, GetDomainsResponse>().withOperationName("GetDomains")
                            .withMarshaller(new GetDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getDomainsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the export snapshot record created as a result of the <code>export snapshot</code> operation.
     * </p>
     * <p>
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the
     * <code>create cloud formation stack</code> operation.
     * </p>
     *
     * @param getExportSnapshotRecordsRequest
     * @return A Java Future containing the result of the GetExportSnapshotRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetExportSnapshotRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetExportSnapshotRecords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportSnapshotRecordsResponse> getExportSnapshotRecords(
            GetExportSnapshotRecordsRequest getExportSnapshotRecordsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportSnapshotRecordsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetExportSnapshotRecordsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportSnapshotRecordsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportSnapshotRecordsRequest, GetExportSnapshotRecordsResponse>()
                            .withOperationName("GetExportSnapshotRecords")
                            .withMarshaller(new GetExportSnapshotRecordsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getExportSnapshotRecordsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     *
     * @param getInstanceRequest
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceRequest, GetInstanceResponse>()
                            .withOperationName("GetInstance").withMarshaller(new GetInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     * <p>
     * The <code>get instance access details</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param getInstanceAccessDetailsRequest
     * @return A Java Future containing the result of the GetInstanceAccessDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(
            GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceAccessDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceAccessDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceAccessDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResponse>()
                            .withOperationName("GetInstanceAccessDetails")
                            .withMarshaller(new GetInstanceAccessDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstanceAccessDetailsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     *
     * @param getInstanceMetricDataRequest
     * @return A Java Future containing the result of the GetInstanceMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(
            GetInstanceMetricDataRequest getInstanceMetricDataRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceMetricDataRequest, GetInstanceMetricDataResponse>()
                            .withOperationName("GetInstanceMetricData")
                            .withMarshaller(new GetInstanceMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstanceMetricDataRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the port states for a specific virtual private server, or <i>instance</i>.
     * </p>
     *
     * @param getInstancePortStatesRequest
     * @return A Java Future containing the result of the GetInstancePortStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(
            GetInstancePortStatesRequest getInstancePortStatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstancePortStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstancePortStatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstancePortStatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstancePortStatesRequest, GetInstancePortStatesResponse>()
                            .withOperationName("GetInstancePortStates")
                            .withMarshaller(new GetInstancePortStatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstancePortStatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     *
     * @param getInstanceSnapshotRequest
     * @return A Java Future containing the result of the GetInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(
            GetInstanceSnapshotRequest getInstanceSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceSnapshotRequest, GetInstanceSnapshotResponse>()
                            .withOperationName("GetInstanceSnapshot")
                            .withMarshaller(new GetInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstanceSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     *
     * @param getInstanceSnapshotsRequest
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(
            GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResponse>()
                            .withOperationName("GetInstanceSnapshots")
                            .withMarshaller(new GetInstanceSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstanceSnapshotsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     *
     * @param getInstanceStateRequest
     * @return A Java Future containing the result of the GetInstanceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceStateResponse> getInstanceState(GetInstanceStateRequest getInstanceStateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceStateRequest, GetInstanceStateResponse>()
                            .withOperationName("GetInstanceState")
                            .withMarshaller(new GetInstanceStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstanceStateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @param getInstancesRequest
     * @return A Java Future containing the result of the GetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancesResponse> getInstances(GetInstancesRequest getInstancesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstancesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstancesRequest, GetInstancesResponse>()
                            .withOperationName("GetInstances").withMarshaller(new GetInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     *
     * @param getKeyPairRequest
     * @return A Java Future containing the result of the GetKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairResponse> getKeyPair(GetKeyPairRequest getKeyPairRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKeyPairRequest, GetKeyPairResponse>().withOperationName("GetKeyPair")
                            .withMarshaller(new GetKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getKeyPairRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     *
     * @param getKeyPairsRequest
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairsResponse> getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetKeyPairsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetKeyPairsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetKeyPairsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKeyPairsRequest, GetKeyPairsResponse>()
                            .withOperationName("GetKeyPairs").withMarshaller(new GetKeyPairsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getKeyPairsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerRequest
     * @return A Java Future containing the result of the GetLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerRequest, GetLoadBalancerResponse>()
                            .withOperationName("GetLoadBalancer")
                            .withMarshaller(new GetLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoadBalancerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about health metrics for your Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerMetricDataRequest
     * @return A Java Future containing the result of the GetLoadBalancerMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerMetricDataResponse> getLoadBalancerMetricData(
            GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancerMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancerMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancerMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerMetricDataRequest, GetLoadBalancerMetricDataResponse>()
                            .withOperationName("GetLoadBalancerMetricData")
                            .withMarshaller(new GetLoadBalancerMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoadBalancerMetricDataRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other
     * is inactive.
     * </p>
     *
     * @param getLoadBalancerTlsCertificatesRequest
     * @return A Java Future containing the result of the GetLoadBalancerTlsCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerTlsCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerTlsCertificatesResponse> getLoadBalancerTlsCertificates(
            GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancerTlsCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancerTlsCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancerTlsCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerTlsCertificatesRequest, GetLoadBalancerTlsCertificatesResponse>()
                            .withOperationName("GetLoadBalancerTlsCertificates")
                            .withMarshaller(new GetLoadBalancerTlsCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoadBalancerTlsCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     * <p>
     * If you are describing a long list of load balancers, you can paginate the output to make the list more
     * manageable. You can use the pageToken and nextPageToken values to retrieve the next items in the list.
     * </p>
     *
     * @param getLoadBalancersRequest
     * @return A Java Future containing the result of the GetLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancersResponse> getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancersRequest, GetLoadBalancersResponse>()
                            .withOperationName("GetLoadBalancers")
                            .withMarshaller(new GetLoadBalancersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoadBalancersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     *
     * @param getOperationRequest
     * @return A Java Future containing the result of the GetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOperationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOperationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOperationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOperationRequest, GetOperationResponse>()
                            .withOperationName("GetOperation").withMarshaller(new GetOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOperationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     *
     * @param getOperationsRequest
     * @return A Java Future containing the result of the GetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsResponse> getOperations(GetOperationsRequest getOperationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOperationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOperationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOperationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOperationsRequest, GetOperationsResponse>()
                            .withOperationName("GetOperations")
                            .withMarshaller(new GetOperationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOperationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     *
     * @param getOperationsForResourceRequest
     * @return A Java Future containing the result of the GetOperationsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(
            GetOperationsForResourceRequest getOperationsForResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOperationsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOperationsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOperationsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOperationsForResourceRequest, GetOperationsForResourceResponse>()
                            .withOperationName("GetOperationsForResource")
                            .withMarshaller(new GetOperationsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOperationsForResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the Availability Zones in a region.
     * </p>
     *
     * @param getRegionsRequest
     * @return A Java Future containing the result of the GetRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRegionsResponse> getRegions(GetRegionsRequest getRegionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRegionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRegionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRegionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRegionsRequest, GetRegionsResponse>().withOperationName("GetRegions")
                            .withMarshaller(new GetRegionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRegionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseRequest
     * @return A Java Future containing the result of the GetRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseResponse> getRelationalDatabase(
            GetRelationalDatabaseRequest getRelationalDatabaseRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseRequest, GetRelationalDatabaseResponse>()
                            .withOperationName("GetRelationalDatabase")
                            .withMarshaller(new GetRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine
     * version of a database.
     * </p>
     * <p>
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     * </p>
     *
     * @param getRelationalDatabaseBlueprintsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseBlueprints operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseBlueprintsResponse> getRelationalDatabaseBlueprints(
            GetRelationalDatabaseBlueprintsRequest getRelationalDatabaseBlueprintsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseBlueprintsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseBlueprintsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseBlueprintsRequest, GetRelationalDatabaseBlueprintsResponse>()
                            .withOperationName("GetRelationalDatabaseBlueprints")
                            .withMarshaller(new GetRelationalDatabaseBlueprintsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseBlueprintsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance
     * specifications for a database.
     * </p>
     * <p>
     * You can use a bundle ID to create a new database with explicit performance specifications.
     * </p>
     *
     * @param getRelationalDatabaseBundlesRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseBundles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseBundlesResponse> getRelationalDatabaseBundles(
            GetRelationalDatabaseBundlesRequest getRelationalDatabaseBundlesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseBundlesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseBundlesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseBundlesRequest, GetRelationalDatabaseBundlesResponse>()
                            .withOperationName("GetRelationalDatabaseBundles")
                            .withMarshaller(new GetRelationalDatabaseBundlesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseBundlesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of events for a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseEventsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseEventsResponse> getRelationalDatabaseEvents(
            GetRelationalDatabaseEventsRequest getRelationalDatabaseEventsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseEventsRequest, GetRelationalDatabaseEventsResponse>()
                            .withOperationName("GetRelationalDatabaseEvents")
                            .withMarshaller(new GetRelationalDatabaseEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseEventsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of log events for a database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseLogEventsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseLogEvents operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseLogEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseLogEventsResponse> getRelationalDatabaseLogEvents(
            GetRelationalDatabaseLogEventsRequest getRelationalDatabaseLogEventsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseLogEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseLogEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseLogEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseLogEventsRequest, GetRelationalDatabaseLogEventsResponse>()
                            .withOperationName("GetRelationalDatabaseLogEvents")
                            .withMarshaller(new GetRelationalDatabaseLogEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseLogEventsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of available log streams for a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseLogStreamsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseLogStreams operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseLogStreams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseLogStreamsResponse> getRelationalDatabaseLogStreams(
            GetRelationalDatabaseLogStreamsRequest getRelationalDatabaseLogStreamsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseLogStreamsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseLogStreamsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseLogStreamsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseLogStreamsRequest, GetRelationalDatabaseLogStreamsResponse>()
                            .withOperationName("GetRelationalDatabaseLogStreams")
                            .withMarshaller(new GetRelationalDatabaseLogStreamsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseLogStreamsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
     * </p>
     * <p>
     * The <code>GetRelationalDatabaseMasterUserPassword</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName.
     * </p>
     *
     * @param getRelationalDatabaseMasterUserPasswordRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseMasterUserPassword operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseMasterUserPassword
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseMasterUserPasswordResponse> getRelationalDatabaseMasterUserPassword(
            GetRelationalDatabaseMasterUserPasswordRequest getRelationalDatabaseMasterUserPasswordRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseMasterUserPasswordResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetRelationalDatabaseMasterUserPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseMasterUserPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseMasterUserPasswordRequest, GetRelationalDatabaseMasterUserPasswordResponse>()
                            .withOperationName("GetRelationalDatabaseMasterUserPassword")
                            .withMarshaller(new GetRelationalDatabaseMasterUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseMasterUserPasswordRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data points of the specified metric for a database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseMetricDataRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseMetricData operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseMetricDataResponse> getRelationalDatabaseMetricData(
            GetRelationalDatabaseMetricDataRequest getRelationalDatabaseMetricDataRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseMetricDataRequest, GetRelationalDatabaseMetricDataResponse>()
                            .withOperationName("GetRelationalDatabaseMetricData")
                            .withMarshaller(new GetRelationalDatabaseMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseMetricDataRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific
     * database in Amazon Lightsail.
     * </p>
     * <p>
     * In addition to the parameter names and values, this operation returns other information about each parameter.
     * This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed
     * values, and the data types.
     * </p>
     *
     * @param getRelationalDatabaseParametersRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseParametersResponse> getRelationalDatabaseParameters(
            GetRelationalDatabaseParametersRequest getRelationalDatabaseParametersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseParametersRequest, GetRelationalDatabaseParametersResponse>()
                            .withOperationName("GetRelationalDatabaseParameters")
                            .withMarshaller(new GetRelationalDatabaseParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseParametersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific database snapshot in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseSnapshotRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotResponse> getRelationalDatabaseSnapshot(
            GetRelationalDatabaseSnapshotRequest getRelationalDatabaseSnapshotRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseSnapshotRequest, GetRelationalDatabaseSnapshotResponse>()
                            .withOperationName("GetRelationalDatabaseSnapshot")
                            .withMarshaller(new GetRelationalDatabaseSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all of your database snapshots in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseSnapshotsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseSnapshots operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotsResponse> getRelationalDatabaseSnapshots(
            GetRelationalDatabaseSnapshotsRequest getRelationalDatabaseSnapshotsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseSnapshotsRequest, GetRelationalDatabaseSnapshotsResponse>()
                            .withOperationName("GetRelationalDatabaseSnapshots")
                            .withMarshaller(new GetRelationalDatabaseSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabaseSnapshotsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all of your databases in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabasesRequest
     * @return A Java Future containing the result of the GetRelationalDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabasesResponse> getRelationalDatabases(
            GetRelationalDatabasesRequest getRelationalDatabasesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabasesRequest, GetRelationalDatabasesResponse>()
                            .withOperationName("GetRelationalDatabases")
                            .withMarshaller(new GetRelationalDatabasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRelationalDatabasesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     *
     * @param getStaticIpRequest
     * @return A Java Future containing the result of the GetStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpResponse> getStaticIp(GetStaticIpRequest getStaticIpRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStaticIpRequest, GetStaticIpResponse>()
                            .withOperationName("GetStaticIp").withMarshaller(new GetStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getStaticIpRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     *
     * @param getStaticIpsRequest
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpsResponse> getStaticIps(GetStaticIpsRequest getStaticIpsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStaticIpsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStaticIpsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStaticIpsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStaticIpsRequest, GetStaticIpsResponse>()
                            .withOperationName("GetStaticIps").withMarshaller(new GetStaticIpsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getStaticIpsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     *
     * @param importKeyPairRequest
     * @return A Java Future containing the result of the ImportKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportKeyPairRequest, ImportKeyPairResponse>()
                            .withOperationName("ImportKeyPair")
                            .withMarshaller(new ImportKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(importKeyPairRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     *
     * @param isVpcPeeredRequest
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<IsVpcPeeredResponse> isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<IsVpcPeeredResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    IsVpcPeeredResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<IsVpcPeeredResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<IsVpcPeeredRequest, IsVpcPeeredResponse>()
                            .withOperationName("IsVpcPeered").withMarshaller(new IsVpcPeeredRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(isVpcPeeredRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds public ports to an Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>open instance public ports</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param openInstancePublicPortsRequest
     * @return A Java Future containing the result of the OpenInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(
            OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<OpenInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, OpenInstancePublicPortsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<OpenInstancePublicPortsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResponse>()
                            .withOperationName("OpenInstancePublicPorts")
                            .withMarshaller(new OpenInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(openInstancePublicPortsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     *
     * @param peerVpcRequest
     * @return A Java Future containing the result of the PeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PeerVpcResponse> peerVpc(PeerVpcRequest peerVpcRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PeerVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PeerVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PeerVpcRequest, PeerVpcResponse>().withOperationName("PeerVpc")
                            .withMarshaller(new PeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(peerVpcRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the specified open ports for an Amazon Lightsail instance, and closes all ports for every protocol not
     * included in the current request.
     * </p>
     * <p>
     * The <code>put instance public ports</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param putInstancePublicPortsRequest
     * @return A Java Future containing the result of the PutInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(
            PutInstancePublicPortsRequest putInstancePublicPortsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutInstancePublicPortsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutInstancePublicPortsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInstancePublicPortsRequest, PutInstancePublicPortsResponse>()
                            .withOperationName("PutInstancePublicPorts")
                            .withMarshaller(new PutInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putInstancePublicPortsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a specific instance.
     * </p>
     * <p>
     * The <code>reboot instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param rebootInstanceRequest
     * @return A Java Future containing the result of the RebootInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RebootInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RebootInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RebootInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootInstanceRequest, RebootInstanceResponse>()
                            .withOperationName("RebootInstance")
                            .withMarshaller(new RebootInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(rebootInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a specific database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>reboot relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param rebootRelationalDatabaseRequest
     * @return A Java Future containing the result of the RebootRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RebootRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RebootRelationalDatabaseResponse> rebootRelationalDatabase(
            RebootRelationalDatabaseRequest rebootRelationalDatabaseRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RebootRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RebootRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RebootRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootRelationalDatabaseRequest, RebootRelationalDatabaseResponse>()
                            .withOperationName("RebootRelationalDatabase")
                            .withMarshaller(new RebootRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(rebootRelationalDatabaseRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     *
     * @param releaseStaticIpRequest
     * @return A Java Future containing the result of the ReleaseStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ReleaseStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ReleaseStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ReleaseStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ReleaseStaticIpRequest, ReleaseStaticIpResponse>()
                            .withOperationName("ReleaseStaticIp")
                            .withMarshaller(new ReleaseStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(releaseStaticIpRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the
     * <code>reboot instance</code> operation.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>start instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param startInstanceRequest
     * @return A Java Future containing the result of the StartInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartInstanceRequest, StartInstanceResponse>()
                            .withOperationName("StartInstance")
                            .withMarshaller(new StartInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the
     * <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>start relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param startRelationalDatabaseRequest
     * @return A Java Future containing the result of the StartRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StartRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartRelationalDatabaseResponse> startRelationalDatabase(
            StartRelationalDatabaseRequest startRelationalDatabaseRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRelationalDatabaseRequest, StartRelationalDatabaseResponse>()
                            .withOperationName("StartRelationalDatabase")
                            .withMarshaller(new StartRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startRelationalDatabaseRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>stop instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param stopInstanceRequest
     * @return A Java Future containing the result of the StopInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopInstanceRequest, StopInstanceResponse>()
                            .withOperationName("StopInstance").withMarshaller(new StopInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(stopInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specific database that is currently running in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>stop relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param stopRelationalDatabaseRequest
     * @return A Java Future containing the result of the StopRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StopRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopRelationalDatabaseResponse> stopRelationalDatabase(
            StopRelationalDatabaseRequest stopRelationalDatabaseRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopRelationalDatabaseRequest, StopRelationalDatabaseResponse>()
                            .withOperationName("StopRelationalDatabase")
                            .withMarshaller(new StopRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(stopRelationalDatabaseRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
     * </p>
     * <p>
     * The <code>tag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(tagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     *
     * @param unpeerVpcRequest
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnpeerVpcResponse> unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UnpeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UnpeerVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UnpeerVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UnpeerVpcRequest, UnpeerVpcResponse>().withOperationName("UnpeerVpc")
                            .withMarshaller(new UnpeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(unpeerVpcRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
     * </p>
     * <p>
     * The <code>untag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(untagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     * <p>
     * The <code>update domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateDomainEntryRequest
     * @return A Java Future containing the result of the UpdateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDomainEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDomainEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDomainEntryRequest, UpdateDomainEntryResponse>()
                            .withOperationName("UpdateDomainEntry")
                            .withMarshaller(new UpdateDomainEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateDomainEntryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     * </p>
     * <p>
     * The <code>update load balancer attribute</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateLoadBalancerAttributeRequest
     * @return A Java Future containing the result of the UpdateLoadBalancerAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateLoadBalancerAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLoadBalancerAttributeResponse> updateLoadBalancerAttribute(
            UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLoadBalancerAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLoadBalancerAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLoadBalancerAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLoadBalancerAttributeRequest, UpdateLoadBalancerAttributeResponse>()
                            .withOperationName("UpdateLoadBalancerAttribute")
                            .withMarshaller(new UpdateLoadBalancerAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateLoadBalancerAttributeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the update of one or more attributes of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the
     * database's predefined maintenance window.
     * </p>
     * <p>
     * The <code>update relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateRelationalDatabaseRequest
     * @return A Java Future containing the result of the UpdateRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRelationalDatabaseResponse> updateRelationalDatabase(
            UpdateRelationalDatabaseRequest updateRelationalDatabaseRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRelationalDatabaseRequest, UpdateRelationalDatabaseResponse>()
                            .withOperationName("UpdateRelationalDatabase")
                            .withMarshaller(new UpdateRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateRelationalDatabaseRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the update of one or more parameters of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance
     * window. However, there are two ways in which parameter updates are applied: <code>dynamic</code> or
     * <code>pending-reboot</code>. Parameters marked with a <code>dynamic</code> apply type are applied immediately.
     * Parameters marked with a <code>pending-reboot</code> apply type are applied only after the database is rebooted
     * using the <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>update relational database parameters</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateRelationalDatabaseParametersRequest
     * @return A Java Future containing the result of the UpdateRelationalDatabaseParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your AWS Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRelationalDatabaseParametersResponse> updateRelationalDatabaseParameters(
            UpdateRelationalDatabaseParametersRequest updateRelationalDatabaseParametersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRelationalDatabaseParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateRelationalDatabaseParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRelationalDatabaseParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRelationalDatabaseParametersRequest, UpdateRelationalDatabaseParametersResponse>()
                            .withOperationName("UpdateRelationalDatabaseParameters")
                            .withMarshaller(new UpdateRelationalDatabaseParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateRelationalDatabaseParametersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LightsailException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationFailureException")
                                .exceptionBuilderSupplier(OperationFailureException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthenticatedException")
                                .exceptionBuilderSupplier(UnauthenticatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInputException")
                                .exceptionBuilderSupplier(InvalidInputException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountSetupInProgressException")
                                .exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
