/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to access a
 * resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessDeniedException extends LightsailException implements
        ToCopyableBuilder<AccessDeniedException.Builder, AccessDeniedException> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessDeniedException::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> DOCS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessDeniedException::docs)).setter(setter(Builder::docs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("docs").build()).build();

    private static final SdkField<String> TIP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessDeniedException::tip)).setter(setter(Builder::tip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tip").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, DOCS_FIELD,
            TIP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String docs;

    private final String tip;

    private AccessDeniedException(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
        this.docs = builder.docs;
        this.tip = builder.tip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public String code() {
        return code;
    }

    /**
     * Returns the value of the Docs property for this object.
     * 
     * @return The value of the Docs property for this object.
     */
    public String docs() {
        return docs;
    }

    /**
     * Returns the value of the Tip property for this object.
     * 
     * @return The value of the Tip property for this object.
     */
    public String tip() {
        return tip;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessDeniedException, T> g) {
        return obj -> g.apply((AccessDeniedException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessDeniedException>, LightsailException.Builder {
        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * Sets the value of the Docs property for this object.
         *
         * @param docs
         *        The new value for the Docs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder docs(String docs);

        /**
         * Sets the value of the Tip property for this object.
         *
         * @param tip
         *        The new value for the Tip property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tip(String tip);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends LightsailException.BuilderImpl implements Builder {
        private String code;

        private String docs;

        private String tip;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessDeniedException model) {
            super(model);
            code(model.code);
            docs(model.docs);
            tip(model.tip);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDocs() {
            return docs;
        }

        @Override
        public final Builder docs(String docs) {
            this.docs = docs;
            return this;
        }

        public final void setDocs(String docs) {
            this.docs = docs;
        }

        public final String getTip() {
            return tip;
        }

        @Override
        public final Builder tip(String tip) {
            this.tip = tip;
            return this;
        }

        public final void setTip(String tip) {
            this.tip = tip;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public AccessDeniedException build() {
            return new AccessDeniedException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
