/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCloudFormationStackRecordsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetCloudFormationStackRecordsResponse.Builder, GetCloudFormationStackRecordsResponse> {
    private static final SdkField<List<CloudFormationStackRecord>> CLOUD_FORMATION_STACK_RECORDS_FIELD = SdkField
            .<List<CloudFormationStackRecord>> builder(MarshallingType.LIST)
            .getter(getter(GetCloudFormationStackRecordsResponse::cloudFormationStackRecords))
            .setter(setter(Builder::cloudFormationStackRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationStackRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudFormationStackRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudFormationStackRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCloudFormationStackRecordsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_FORMATION_STACK_RECORDS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<CloudFormationStackRecord> cloudFormationStackRecords;

    private final String nextPageToken;

    private GetCloudFormationStackRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFormationStackRecords = builder.cloudFormationStackRecords;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the CloudFormationStackRecords property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasCloudFormationStackRecords() {
        return cloudFormationStackRecords != null && !(cloudFormationStackRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects describing the CloudFormation stack records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCloudFormationStackRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects describing the CloudFormation stack records.
     */
    public List<CloudFormationStackRecord> cloudFormationStackRecords() {
        return cloudFormationStackRecords;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results of your get relational database bundles request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results of your get relational database bundles request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationStackRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFormationStackRecordsResponse)) {
            return false;
        }
        GetCloudFormationStackRecordsResponse other = (GetCloudFormationStackRecordsResponse) obj;
        return Objects.equals(cloudFormationStackRecords(), other.cloudFormationStackRecords())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCloudFormationStackRecordsResponse")
                .add("CloudFormationStackRecords", cloudFormationStackRecords()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudFormationStackRecords":
            return Optional.ofNullable(clazz.cast(cloudFormationStackRecords()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCloudFormationStackRecordsResponse, T> g) {
        return obj -> g.apply((GetCloudFormationStackRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCloudFormationStackRecordsResponse> {
        /**
         * <p>
         * A list of objects describing the CloudFormation stack records.
         * </p>
         * 
         * @param cloudFormationStackRecords
         *        A list of objects describing the CloudFormation stack records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationStackRecords(Collection<CloudFormationStackRecord> cloudFormationStackRecords);

        /**
         * <p>
         * A list of objects describing the CloudFormation stack records.
         * </p>
         * 
         * @param cloudFormationStackRecords
         *        A list of objects describing the CloudFormation stack records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationStackRecords(CloudFormationStackRecord... cloudFormationStackRecords);

        /**
         * <p>
         * A list of objects describing the CloudFormation stack records.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CloudFormationStackRecord>.Builder}
         * avoiding the need to create one manually via {@link List<CloudFormationStackRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudFormationStackRecord>.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudFormationStackRecords(List<CloudFormationStackRecord>)}.
         * 
         * @param cloudFormationStackRecords
         *        a consumer that will call methods on {@link List<CloudFormationStackRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormationStackRecords(List<CloudFormationStackRecord>)
         */
        Builder cloudFormationStackRecords(Consumer<CloudFormationStackRecord.Builder>... cloudFormationStackRecords);

        /**
         * <p>
         * A token used for advancing to the next page of results of your get relational database bundles request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results of your get relational database bundles
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<CloudFormationStackRecord> cloudFormationStackRecords = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFormationStackRecordsResponse model) {
            super(model);
            cloudFormationStackRecords(model.cloudFormationStackRecords);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<CloudFormationStackRecord.Builder> getCloudFormationStackRecords() {
            return cloudFormationStackRecords != null ? cloudFormationStackRecords.stream()
                    .map(CloudFormationStackRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudFormationStackRecords(Collection<CloudFormationStackRecord> cloudFormationStackRecords) {
            this.cloudFormationStackRecords = CloudFormationStackRecordListCopier.copy(cloudFormationStackRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudFormationStackRecords(CloudFormationStackRecord... cloudFormationStackRecords) {
            cloudFormationStackRecords(Arrays.asList(cloudFormationStackRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudFormationStackRecords(Consumer<CloudFormationStackRecord.Builder>... cloudFormationStackRecords) {
            cloudFormationStackRecords(Stream.of(cloudFormationStackRecords)
                    .map(c -> CloudFormationStackRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudFormationStackRecords(
                Collection<CloudFormationStackRecord.BuilderImpl> cloudFormationStackRecords) {
            this.cloudFormationStackRecords = CloudFormationStackRecordListCopier.copyFromBuilder(cloudFormationStackRecords);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetCloudFormationStackRecordsResponse build() {
            return new GetCloudFormationStackRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
