/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoadBalancerMetricDataRequest extends LightsailRequest implements
        ToCopyableBuilder<GetLoadBalancerMetricDataRequest.Builder, GetLoadBalancerMetricDataRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetLoadBalancerMetricDataRequest::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetLoadBalancerMetricDataRequest::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetLoadBalancerMetricDataRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetLoadBalancerMetricDataRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetLoadBalancerMetricDataRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetLoadBalancerMetricDataRequest::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetLoadBalancerMetricDataRequest::statisticsAsStrings))
            .setter(setter(Builder::statisticsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            METRIC_NAME_FIELD, PERIOD_FIELD, START_TIME_FIELD, END_TIME_FIELD, UNIT_FIELD, STATISTICS_FIELD));

    private final String loadBalancerName;

    private final String metricName;

    private final Integer period;

    private final Instant startTime;

    private final Instant endTime;

    private final String unit;

    private final List<String> statistics;

    private GetLoadBalancerMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.metricName = builder.metricName;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The metric about which you want to return information. Valid values are listed below, along with the most useful
     * <code>statistics</code> to include in your request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response codes generated by the target
     * instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from the
     * load balancer. This count does not include any response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link LoadBalancerMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric about which you want to return information. Valid values are listed below, along with the most
     *         useful <code>statistics</code> to include in your request.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *         client that did not establish a session with the load balancer. Possible causes include a mismatch of
     *         ciphers or protocols.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
     *         from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *         requests have not been received by the target instance. This count does not include any response codes
     *         generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
     *         from the load balancer. This count does not include any response codes generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *         load balancer until a response from the target instance is received.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *         load balancer had reached its maximum number of connections.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *         the requests with a response generated by a target instance of the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     * @see LoadBalancerMetricName
     */
    public LoadBalancerMetricName metricName() {
        return LoadBalancerMetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The metric about which you want to return information. Valid values are listed below, along with the most useful
     * <code>statistics</code> to include in your request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response codes generated by the target
     * instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from the
     * load balancer. This count does not include any response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link LoadBalancerMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric about which you want to return information. Valid values are listed below, along with the most
     *         useful <code>statistics</code> to include in your request.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *         client that did not establish a session with the load balancer. Possible causes include a mismatch of
     *         ciphers or protocols.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
     *         from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *         requests have not been received by the target instance. This count does not include any response codes
     *         generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
     *         from the load balancer. This count does not include any response codes generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *         load balancer until a response from the target instance is received.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *         load balancer had reached its maximum number of connections.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *         the requests with a response generated by a target instance of the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     * @see LoadBalancerMetricName
     */
    public String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points.
     * </p>
     * 
     * @return The granularity, in seconds, of the returned data points.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The start time of the period.
     * </p>
     * 
     * @return The start time of the period.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the period.
     * </p>
     * 
     * @return The end time of the period.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The unit for the time period request. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the time period request. Valid values are listed below.
     * @see MetricUnit
     */
    public MetricUnit unit() {
        return MetricUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit for the time period request. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the time period request. Valid values are listed below.
     * @see MetricUnit
     */
    public String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * An array of statistics that you want to request metrics for. Valid values are listed below.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical calculation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing this
     * statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close the average
     * use is to the Minimum and Maximum. This comparison helps you to know when to increase or decrease your resources
     * as needed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic can be
     * useful for determining the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this value to
     * determine low volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this value to
     * determine high volumes of activity for your application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of statistics that you want to request metrics for. Valid values are listed below.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical
     *         calculation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing
     *         this statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close
     *         the average use is to the Minimum and Maximum. This comparison helps you to know when to increase or
     *         decrease your resources as needed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic
     *         can be useful for determining the total volume of a metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this
     *         value to determine low volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this
     *         value to determine high volumes of activity for your application.
     *         </p>
     *         </li>
     */
    public List<MetricStatistic> statistics() {
        return MetricStatisticListCopier.copyStringToEnum(statistics);
    }

    /**
     * Returns true if the Statistics property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStatistics() {
        return statistics != null && !(statistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of statistics that you want to request metrics for. Valid values are listed below.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical calculation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing this
     * statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close the average
     * use is to the Minimum and Maximum. This comparison helps you to know when to increase or decrease your resources
     * as needed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic can be
     * useful for determining the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this value to
     * determine low volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this value to
     * determine high volumes of activity for your application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of statistics that you want to request metrics for. Valid values are listed below.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical
     *         calculation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing
     *         this statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close
     *         the average use is to the Minimum and Maximum. This comparison helps you to know when to increase or
     *         decrease your resources as needed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic
     *         can be useful for determining the total volume of a metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this
     *         value to determine low volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this
     *         value to determine high volumes of activity for your application.
     *         </p>
     *         </li>
     */
    public List<String> statisticsAsStrings() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerMetricDataRequest)) {
            return false;
        }
        GetLoadBalancerMetricDataRequest other = (GetLoadBalancerMetricDataRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(metricNameAsString(), other.metricNameAsString()) && Objects.equals(period(), other.period())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(statisticsAsStrings(), other.statisticsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetLoadBalancerMetricDataRequest").add("LoadBalancerName", loadBalancerName())
                .add("MetricName", metricNameAsString()).add("Period", period()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Unit", unitAsString()).add("Statistics", statisticsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statisticsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancerMetricDataRequest, T> g) {
        return obj -> g.apply((GetLoadBalancerMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLoadBalancerMetricDataRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The metric about which you want to return information. Valid values are listed below, along with the most
         * useful <code>statistics</code> to include in your request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client
         * that did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or
         * protocols.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from
         * the load balancer. Client errors are generated when requests are malformed or incomplete. These requests have
         * not been received by the target instance. This count does not include any response codes generated by the
         * target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from
         * the load balancer. This count does not include any response codes generated by the target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
         * balancer until a response from the target instance is received.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
         * balancer had reached its maximum number of connections.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
         * requests with a response generated by a target instance of the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        The metric about which you want to return information. Valid values are listed below, along with the
         *        most useful <code>statistics</code> to include in your request.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
         *        client that did not establish a session with the load balancer. Possible causes include a mismatch of
         *        ciphers or protocols.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered
         *        unhealthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
         *        from the load balancer. Client errors are generated when requests are malformed or incomplete. These
         *        requests have not been received by the target instance. This count does not include any response codes
         *        generated by the target instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
         *        from the load balancer. This count does not include any response codes generated by the target
         *        instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that
         *        <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves
         *        the load balancer until a response from the target instance is received.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because
         *        the load balancer had reached its maximum number of connections.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes
         *        only the requests with a response generated by a target instance of the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         * @see LoadBalancerMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric about which you want to return information. Valid values are listed below, along with the most
         * useful <code>statistics</code> to include in your request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client
         * that did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or
         * protocols.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from
         * the load balancer. Client errors are generated when requests are malformed or incomplete. These requests have
         * not been received by the target instance. This count does not include any response codes generated by the
         * target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from
         * the load balancer. This count does not include any response codes generated by the target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
         * balancer until a response from the target instance is received.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
         * balancer had reached its maximum number of connections.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
         * requests with a response generated by a target instance of the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        The metric about which you want to return information. Valid values are listed below, along with the
         *        most useful <code>statistics</code> to include in your request.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
         *        client that did not establish a session with the load balancer. Possible causes include a mismatch of
         *        ciphers or protocols.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered
         *        unhealthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
         *        from the load balancer. Client errors are generated when requests are malformed or incomplete. These
         *        requests have not been received by the target instance. This count does not include any response codes
         *        generated by the target instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
         *        from the load balancer. This count does not include any response codes generated by the target
         *        instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that
         *        <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves
         *        the load balancer until a response from the target instance is received.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because
         *        the load balancer had reached its maximum number of connections.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes
         *        only the requests with a response generated by a target instance of the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         * @see LoadBalancerMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerMetricName
         */
        Builder metricName(LoadBalancerMetricName metricName);

        /**
         * <p>
         * The granularity, in seconds, of the returned data points.
         * </p>
         * 
         * @param period
         *        The granularity, in seconds, of the returned data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The start time of the period.
         * </p>
         * 
         * @param startTime
         *        The start time of the period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the period.
         * </p>
         * 
         * @param endTime
         *        The end time of the period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The unit for the time period request. Valid values are listed below.
         * </p>
         * 
         * @param unit
         *        The unit for the time period request. Valid values are listed below.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit for the time period request. Valid values are listed below.
         * </p>
         * 
         * @param unit
         *        The unit for the time period request. Valid values are listed below.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(MetricUnit unit);

        /**
         * <p>
         * An array of statistics that you want to request metrics for. Valid values are listed below.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical calculation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum. This comparison helps you to know when to increase or decrease
         * your resources as needed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic can
         * be useful for determining the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this value
         * to determine low volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this
         * value to determine high volumes of activity for your application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        An array of statistics that you want to request metrics for. Valid values are listed below.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical
         *        calculation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By
         *        comparing this statistic with the Minimum and Maximum, you can determine the full scope of a metric
         *        and how close the average use is to the Minimum and Maximum. This comparison helps you to know when to
         *        increase or decrease your resources as needed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This
         *        statistic can be useful for determining the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use
         *        this value to determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use
         *        this value to determine high volumes of activity for your application.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(Collection<String> statistics);

        /**
         * <p>
         * An array of statistics that you want to request metrics for. Valid values are listed below.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical calculation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum. This comparison helps you to know when to increase or decrease
         * your resources as needed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic can
         * be useful for determining the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this value
         * to determine low volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this
         * value to determine high volumes of activity for your application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        An array of statistics that you want to request metrics for. Valid values are listed below.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical
         *        calculation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By
         *        comparing this statistic with the Minimum and Maximum, you can determine the full scope of a metric
         *        and how close the average use is to the Minimum and Maximum. This comparison helps you to know when to
         *        increase or decrease your resources as needed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This
         *        statistic can be useful for determining the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use
         *        this value to determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use
         *        this value to determine high volumes of activity for your application.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(String... statistics);

        /**
         * <p>
         * An array of statistics that you want to request metrics for. Valid values are listed below.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical calculation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum. This comparison helps you to know when to increase or decrease
         * your resources as needed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic can
         * be useful for determining the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this value
         * to determine low volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this
         * value to determine high volumes of activity for your application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        An array of statistics that you want to request metrics for. Valid values are listed below.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical
         *        calculation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By
         *        comparing this statistic with the Minimum and Maximum, you can determine the full scope of a metric
         *        and how close the average use is to the Minimum and Maximum. This comparison helps you to know when to
         *        increase or decrease your resources as needed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This
         *        statistic can be useful for determining the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use
         *        this value to determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use
         *        this value to determine high volumes of activity for your application.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<MetricStatistic> statistics);

        /**
         * <p>
         * An array of statistics that you want to request metrics for. Valid values are listed below.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical calculation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum. This comparison helps you to know when to increase or decrease
         * your resources as needed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This statistic can
         * be useful for determining the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use this value
         * to determine low volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use this
         * value to determine high volumes of activity for your application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        An array of statistics that you want to request metrics for. Valid values are listed below.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>SampleCount</code> </b> - The count (number) of data points used for the statistical
         *        calculation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Average</code> </b> - The value of Sum / SampleCount during the specified period. By
         *        comparing this statistic with the Minimum and Maximum, you can determine the full scope of a metric
         *        and how close the average use is to the Minimum and Maximum. This comparison helps you to know when to
         *        increase or decrease your resources as needed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Sum</code> </b> - All values submitted for the matching metric added together. This
         *        statistic can be useful for determining the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Minimum</code> </b> - The lowest value observed during the specified period. You can use
         *        this value to determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Maximum</code> </b> - The highest value observed during the specified period. You can use
         *        this value to determine high volumes of activity for your application.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(MetricStatistic... statistics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String metricName;

        private Integer period;

        private Instant startTime;

        private Instant endTime;

        private String unit;

        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerMetricDataRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            metricName(model.metricName);
            period(model.period);
            startTime(model.startTime);
            endTime(model.endTime);
            unit(model.unit);
            statisticsWithStrings(model.statistics);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getMetricNameAsString() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(LoadBalancerMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getUnitAsString() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<String> getStatisticsAsStrings() {
            return statistics;
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String... statistics) {
            statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<MetricStatistic> statistics) {
            this.statistics = MetricStatisticListCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(MetricStatistic... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        public final void setStatisticsWithStrings(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLoadBalancerMetricDataRequest build() {
            return new GetLoadBalancerMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
