/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDiskRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteDiskRequest.Builder, DeleteDiskRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDiskRequest::diskName)).setter(setter(Builder::diskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_ADD_ONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteDiskRequest::forceDeleteAddOns)).setter(setter(Builder::forceDeleteAddOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDeleteAddOns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD,
            FORCE_DELETE_ADD_ONS_FIELD));

    private final String diskName;

    private final Boolean forceDeleteAddOns;

    private DeleteDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.forceDeleteAddOns = builder.forceDeleteAddOns;
    }

    /**
     * <p>
     * The unique name of the disk you want to delete (e.g., <code>my-disk</code>).
     * </p>
     * 
     * @return The unique name of the disk you want to delete (e.g., <code>my-disk</code>).
     */
    public String diskName() {
        return diskName;
    }

    /**
     * <p>
     * A Boolean value to indicate whether to delete the enabled add-ons for the disk.
     * </p>
     * 
     * @return A Boolean value to indicate whether to delete the enabled add-ons for the disk.
     */
    public Boolean forceDeleteAddOns() {
        return forceDeleteAddOns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(forceDeleteAddOns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDiskRequest)) {
            return false;
        }
        DeleteDiskRequest other = (DeleteDiskRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(forceDeleteAddOns(), other.forceDeleteAddOns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDiskRequest").add("DiskName", diskName()).add("ForceDeleteAddOns", forceDeleteAddOns())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.ofNullable(clazz.cast(diskName()));
        case "forceDeleteAddOns":
            return Optional.ofNullable(clazz.cast(forceDeleteAddOns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDiskRequest, T> g) {
        return obj -> g.apply((DeleteDiskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDiskRequest> {
        /**
         * <p>
         * The unique name of the disk you want to delete (e.g., <code>my-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique name of the disk you want to delete (e.g., <code>my-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * A Boolean value to indicate whether to delete the enabled add-ons for the disk.
         * </p>
         * 
         * @param forceDeleteAddOns
         *        A Boolean value to indicate whether to delete the enabled add-ons for the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDeleteAddOns(Boolean forceDeleteAddOns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private Boolean forceDeleteAddOns;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDiskRequest model) {
            super(model);
            diskName(model.diskName);
            forceDeleteAddOns(model.forceDeleteAddOns);
        }

        public final String getDiskName() {
            return diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final Boolean getForceDeleteAddOns() {
            return forceDeleteAddOns;
        }

        @Override
        public final Builder forceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
            return this;
        }

        public final void setForceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDiskRequest build() {
            return new DeleteDiskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
