/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the metric data point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDatapoint implements SdkPojo, Serializable, ToCopyableBuilder<MetricDatapoint.Builder, MetricDatapoint> {
    private static final SdkField<Double> AVERAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MetricDatapoint::average)).setter(setter(Builder::average))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("average").build()).build();

    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MetricDatapoint::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()).build();

    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MetricDatapoint::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()).build();

    private static final SdkField<Double> SAMPLE_COUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MetricDatapoint::sampleCount)).setter(setter(Builder::sampleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleCount").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MetricDatapoint::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MetricDatapoint::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricDatapoint::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_FIELD, MAXIMUM_FIELD,
            MINIMUM_FIELD, SAMPLE_COUNT_FIELD, SUM_FIELD, TIMESTAMP_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double average;

    private final Double maximum;

    private final Double minimum;

    private final Double sampleCount;

    private final Double sum;

    private final Instant timestamp;

    private final String unit;

    private MetricDatapoint(BuilderImpl builder) {
        this.average = builder.average;
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.timestamp = builder.timestamp;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The average.
     * </p>
     * 
     * @return The average.
     */
    public Double average() {
        return average;
    }

    /**
     * <p>
     * The maximum.
     * </p>
     * 
     * @return The maximum.
     */
    public Double maximum() {
        return maximum;
    }

    /**
     * <p>
     * The minimum.
     * </p>
     * 
     * @return The minimum.
     */
    public Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The sample count.
     * </p>
     * 
     * @return The sample count.
     */
    public Double sampleCount() {
        return sampleCount;
    }

    /**
     * <p>
     * The sum.
     * </p>
     * 
     * @return The sum.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The timestamp (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp (e.g., <code>1479816991.349</code>).
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit.
     * @see MetricUnit
     */
    public MetricUnit unit() {
        return MetricUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit.
     * @see MetricUnit
     */
    public String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(average());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatapoint)) {
            return false;
        }
        MetricDatapoint other = (MetricDatapoint) obj;
        return Objects.equals(average(), other.average()) && Objects.equals(maximum(), other.maximum())
                && Objects.equals(minimum(), other.minimum()) && Objects.equals(sampleCount(), other.sampleCount())
                && Objects.equals(sum(), other.sum()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MetricDatapoint").add("Average", average()).add("Maximum", maximum()).add("Minimum", minimum())
                .add("SampleCount", sampleCount()).add("Sum", sum()).add("Timestamp", timestamp()).add("Unit", unitAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "average":
            return Optional.ofNullable(clazz.cast(average()));
        case "maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "sampleCount":
            return Optional.ofNullable(clazz.cast(sampleCount()));
        case "sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDatapoint, T> g) {
        return obj -> g.apply((MetricDatapoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDatapoint> {
        /**
         * <p>
         * The average.
         * </p>
         * 
         * @param average
         *        The average.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(Double average);

        /**
         * <p>
         * The maximum.
         * </p>
         * 
         * @param maximum
         *        The maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);

        /**
         * <p>
         * The minimum.
         * </p>
         * 
         * @param minimum
         *        The minimum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The sample count.
         * </p>
         * 
         * @param sampleCount
         *        The sample count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleCount(Double sampleCount);

        /**
         * <p>
         * The sum.
         * </p>
         * 
         * @param sum
         *        The sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The timestamp (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param timestamp
         *        The timestamp (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(MetricUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Double average;

        private Double maximum;

        private Double minimum;

        private Double sampleCount;

        private Double sum;

        private Instant timestamp;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatapoint model) {
            average(model.average);
            maximum(model.maximum);
            minimum(model.minimum);
            sampleCount(model.sampleCount);
            sum(model.sum);
            timestamp(model.timestamp);
            unit(model.unit);
        }

        public final Double getAverage() {
            return average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final Double getMinimum() {
            return minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getSampleCount() {
            return sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getUnitAsString() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public MetricDatapoint build() {
            return new MetricDatapoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
