/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteContactMethodRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteContactMethodRequest.Builder, DeleteContactMethodRequest> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteContactMethodRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD));

    private final String protocol;

    private DeleteContactMethodRequest(BuilderImpl builder) {
        super(builder);
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).
     * </p>
     * <note>
     * <p>
     * To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ContactProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).</p>
     *         <note>
     *         <p>
     *         To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run
     *         separate <code>DeleteContactMethod</code> actions to delete each protocol.
     *         </p>
     * @see ContactProtocol
     */
    public ContactProtocol protocol() {
        return ContactProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).
     * </p>
     * <note>
     * <p>
     * To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run separate
     * <code>DeleteContactMethod</code> actions to delete each protocol.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ContactProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).</p>
     *         <note>
     *         <p>
     *         To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run
     *         separate <code>DeleteContactMethod</code> actions to delete each protocol.
     *         </p>
     * @see ContactProtocol
     */
    public String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteContactMethodRequest)) {
            return false;
        }
        DeleteContactMethodRequest other = (DeleteContactMethodRequest) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteContactMethodRequest").add("Protocol", protocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteContactMethodRequest, T> g) {
        return obj -> g.apply((DeleteContactMethodRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteContactMethodRequest> {
        /**
         * <p>
         * The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).
         * </p>
         * <note>
         * <p>
         * To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run
         * separate <code>DeleteContactMethod</code> actions to delete each protocol.
         * </p>
         * </note>
         * 
         * @param protocol
         *        The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text
         *        messaging).</p> <note>
         *        <p>
         *        To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run
         *        separate <code>DeleteContactMethod</code> actions to delete each protocol.
         *        </p>
         * @see ContactProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).
         * </p>
         * <note>
         * <p>
         * To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run
         * separate <code>DeleteContactMethod</code> actions to delete each protocol.
         * </p>
         * </note>
         * 
         * @param protocol
         *        The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text
         *        messaging).</p> <note>
         *        <p>
         *        To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run
         *        separate <code>DeleteContactMethod</code> actions to delete each protocol.
         *        </p>
         * @see ContactProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactProtocol
         */
        Builder protocol(ContactProtocol protocol);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteContactMethodRequest model) {
            super(model);
            protocol(model.protocol);
        }

        public final String getProtocolAsString() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ContactProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteContactMethodRequest build() {
            return new DeleteContactMethodRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
