/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRelationalDatabaseFromSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateRelationalDatabaseFromSnapshotRequest.Builder, CreateRelationalDatabaseFromSnapshotRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<String> RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::relationalDatabaseSnapshotName))
            .setter(setter(Builder::relationalDatabaseSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSnapshotName")
                    .build()).build();

    private static final SdkField<String> RELATIONAL_DATABASE_BUNDLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::relationalDatabaseBundleId))
            .setter(setter(Builder::relationalDatabaseBundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBundleId").build())
            .build();

    private static final SdkField<String> SOURCE_RELATIONAL_DATABASE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::sourceRelationalDatabaseName))
            .setter(setter(Builder::sourceRelationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRelationalDatabaseName")
                    .build()).build();

    private static final SdkField<Instant> RESTORE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::restoreTime)).setter(setter(Builder::restoreTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreTime").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::useLatestRestorableTime))
            .setter(setter(Builder::useLatestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableTime").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateRelationalDatabaseFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, AVAILABILITY_ZONE_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD, RELATIONAL_DATABASE_BUNDLE_ID_FIELD, SOURCE_RELATIONAL_DATABASE_NAME_FIELD,
            RESTORE_TIME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD, TAGS_FIELD));

    private final String relationalDatabaseName;

    private final String availabilityZone;

    private final Boolean publiclyAccessible;

    private final String relationalDatabaseSnapshotName;

    private final String relationalDatabaseBundleId;

    private final String sourceRelationalDatabaseName;

    private final Instant restoreTime;

    private final Boolean useLatestRestorableTime;

    private final List<Tag> tags;

    private CreateRelationalDatabaseFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.availabilityZone = builder.availabilityZone;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.relationalDatabaseSnapshotName = builder.relationalDatabaseSnapshotName;
        this.relationalDatabaseBundleId = builder.relationalDatabaseBundleId;
        this.sourceRelationalDatabaseName = builder.sourceRelationalDatabaseName;
        this.restoreTime = builder.restoreTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name to use for your new database.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 2 to 255 alphanumeric characters, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first and last character must be a letter or number.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name to use for your new database.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 2 to 255 alphanumeric characters, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first and last character must be a letter or number.
     *         </p>
     *         </li>
     */
    public String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive
     * format.
     * </p>
     * <p>
     * You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the
     * <code>include relational database Availability Zones</code> parameter to your request.
     * </p>
     * 
     * @return The Availability Zone in which to create your new database. Use the <code>us-east-2a</code>
     *         case-sensitive format.</p>
     *         <p>
     *         You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add
     *         the <code>include relational database Availability Zones</code> parameter to your request.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database that
     * is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database
     * that is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @return Specifies the accessibility options for your new database. A value of <code>true</code> specifies a
     *         database that is available to resources outside of your Lightsail account. A value of <code>false</code>
     *         specifies a database that is available only to your Lightsail resources in the same region as your
     *         database.
     */
    public Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The name of the database snapshot from which to create your new database.
     * </p>
     * 
     * @return The name of the database snapshot from which to create your new database.
     */
    public String relationalDatabaseSnapshotName() {
        return relationalDatabaseSnapshotName;
    }

    /**
     * <p>
     * The bundle ID for your new database. A bundle describes the performance specifications for your database.
     * </p>
     * <p>
     * You can get a list of database bundle IDs by using the <code>get relational database bundles</code> operation.
     * </p>
     * <p>
     * When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle of the
     * source database.
     * </p>
     * 
     * @return The bundle ID for your new database. A bundle describes the performance specifications for your
     *         database.</p>
     *         <p>
     *         You can get a list of database bundle IDs by using the <code>get relational database bundles</code>
     *         operation.
     *         </p>
     *         <p>
     *         When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle
     *         of the source database.
     */
    public String relationalDatabaseBundleId() {
        return relationalDatabaseBundleId;
    }

    /**
     * <p>
     * The name of the source database.
     * </p>
     * 
     * @return The name of the source database.
     */
    public String sourceRelationalDatabaseName() {
        return sourceRelationalDatabaseName;
    }

    /**
     * <p>
     * The date and time to restore your database from.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be before the latest restorable time for the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be specified if the <code>use latest restorable time</code> parameter is <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input
     * <code>1538424000</code> as the restore time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The date and time to restore your database from.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be before the latest restorable time for the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be specified if the <code>use latest restorable time</code> parameter is <code>true</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input
     *         <code>1538424000</code> as the restore time.
     *         </p>
     *         </li>
     */
    public Instant restoreTime() {
        return restoreTime;
    }

    /**
     * <p>
     * Specifies whether your database is restored from the latest backup time. A value of <code>true</code> restores
     * from the latest backup time.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <p>
     * Constraints: Cannot be specified if the <code>restore time</code> parameter is provided.
     * </p>
     * 
     * @return Specifies whether your database is restored from the latest backup time. A value of <code>true</code>
     *         restores from the latest backup time. </p>
     *         <p>
     *         Default: <code>false</code>
     *         </p>
     *         <p>
     *         Constraints: Cannot be specified if the <code>restore time</code> parameter is provided.
     */
    public Boolean useLatestRestorableTime() {
        return useLatestRestorableTime;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * To tag a resource after it has been created, see the <code>tag resource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         To tag a resource after it has been created, see the <code>tag resource</code> operation.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRelationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTime());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelationalDatabaseFromSnapshotRequest)) {
            return false;
        }
        CreateRelationalDatabaseFromSnapshotRequest other = (CreateRelationalDatabaseFromSnapshotRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(relationalDatabaseSnapshotName(), other.relationalDatabaseSnapshotName())
                && Objects.equals(relationalDatabaseBundleId(), other.relationalDatabaseBundleId())
                && Objects.equals(sourceRelationalDatabaseName(), other.sourceRelationalDatabaseName())
                && Objects.equals(restoreTime(), other.restoreTime())
                && Objects.equals(useLatestRestorableTime(), other.useLatestRestorableTime())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRelationalDatabaseFromSnapshotRequest")
                .add("RelationalDatabaseName", relationalDatabaseName()).add("AvailabilityZone", availabilityZone())
                .add("PubliclyAccessible", publiclyAccessible())
                .add("RelationalDatabaseSnapshotName", relationalDatabaseSnapshotName())
                .add("RelationalDatabaseBundleId", relationalDatabaseBundleId())
                .add("SourceRelationalDatabaseName", sourceRelationalDatabaseName()).add("RestoreTime", restoreTime())
                .add("UseLatestRestorableTime", useLatestRestorableTime()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "relationalDatabaseSnapshotName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseSnapshotName()));
        case "relationalDatabaseBundleId":
            return Optional.ofNullable(clazz.cast(relationalDatabaseBundleId()));
        case "sourceRelationalDatabaseName":
            return Optional.ofNullable(clazz.cast(sourceRelationalDatabaseName()));
        case "restoreTime":
            return Optional.ofNullable(clazz.cast(restoreTime()));
        case "useLatestRestorableTime":
            return Optional.ofNullable(clazz.cast(useLatestRestorableTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRelationalDatabaseFromSnapshotRequest, T> g) {
        return obj -> g.apply((CreateRelationalDatabaseFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRelationalDatabaseFromSnapshotRequest> {
        /**
         * <p>
         * The name to use for your new database.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 2 to 255 alphanumeric characters, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first and last character must be a letter or number.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relationalDatabaseName
         *        The name to use for your new database.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 2 to 255 alphanumeric characters, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first and last character must be a letter or number.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive
         * format.
         * </p>
         * <p>
         * You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the
         * <code>include relational database Availability Zones</code> parameter to your request.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to create your new database. Use the <code>us-east-2a</code>
         *        case-sensitive format.</p>
         *        <p>
         *        You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to
         *        add the <code>include relational database Availability Zones</code> parameter to your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database
         * that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a
         * database that is available only to your Lightsail resources in the same region as your database.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for your new database. A value of <code>true</code> specifies a
         *        database that is available to resources outside of your Lightsail account. A value of
         *        <code>false</code> specifies a database that is available only to your Lightsail resources in the same
         *        region as your database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The name of the database snapshot from which to create your new database.
         * </p>
         * 
         * @param relationalDatabaseSnapshotName
         *        The name of the database snapshot from which to create your new database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseSnapshotName(String relationalDatabaseSnapshotName);

        /**
         * <p>
         * The bundle ID for your new database. A bundle describes the performance specifications for your database.
         * </p>
         * <p>
         * You can get a list of database bundle IDs by using the <code>get relational database bundles</code>
         * operation.
         * </p>
         * <p>
         * When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle of
         * the source database.
         * </p>
         * 
         * @param relationalDatabaseBundleId
         *        The bundle ID for your new database. A bundle describes the performance specifications for your
         *        database.</p>
         *        <p>
         *        You can get a list of database bundle IDs by using the <code>get relational database bundles</code>
         *        operation.
         *        </p>
         *        <p>
         *        When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the
         *        bundle of the source database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseBundleId(String relationalDatabaseBundleId);

        /**
         * <p>
         * The name of the source database.
         * </p>
         * 
         * @param sourceRelationalDatabaseName
         *        The name of the source database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRelationalDatabaseName(String sourceRelationalDatabaseName);

        /**
         * <p>
         * The date and time to restore your database from.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be before the latest restorable time for the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be specified if the <code>use latest restorable time</code> parameter is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input
         * <code>1538424000</code> as the restore time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param restoreTime
         *        The date and time to restore your database from.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be before the latest restorable time for the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be specified if the <code>use latest restorable time</code> parameter is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input
         *        <code>1538424000</code> as the restore time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTime(Instant restoreTime);

        /**
         * <p>
         * Specifies whether your database is restored from the latest backup time. A value of <code>true</code>
         * restores from the latest backup time.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * <p>
         * Constraints: Cannot be specified if the <code>restore time</code> parameter is provided.
         * </p>
         * 
         * @param useLatestRestorableTime
         *        Specifies whether your database is restored from the latest backup time. A value of <code>true</code>
         *        restores from the latest backup time. </p>
         *        <p>
         *        Default: <code>false</code>
         *        </p>
         *        <p>
         *        Constraints: Cannot be specified if the <code>restore time</code> parameter is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableTime(Boolean useLatestRestorableTime);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String availabilityZone;

        private Boolean publiclyAccessible;

        private String relationalDatabaseSnapshotName;

        private String relationalDatabaseBundleId;

        private String sourceRelationalDatabaseName;

        private Instant restoreTime;

        private Boolean useLatestRestorableTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelationalDatabaseFromSnapshotRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            availabilityZone(model.availabilityZone);
            publiclyAccessible(model.publiclyAccessible);
            relationalDatabaseSnapshotName(model.relationalDatabaseSnapshotName);
            relationalDatabaseBundleId(model.relationalDatabaseBundleId);
            sourceRelationalDatabaseName(model.sourceRelationalDatabaseName);
            restoreTime(model.restoreTime);
            useLatestRestorableTime(model.useLatestRestorableTime);
            tags(model.tags);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getRelationalDatabaseSnapshotName() {
            return relationalDatabaseSnapshotName;
        }

        @Override
        public final Builder relationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
            return this;
        }

        public final void setRelationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
        }

        public final String getRelationalDatabaseBundleId() {
            return relationalDatabaseBundleId;
        }

        @Override
        public final Builder relationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
            return this;
        }

        public final void setRelationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
        }

        public final String getSourceRelationalDatabaseName() {
            return sourceRelationalDatabaseName;
        }

        @Override
        public final Builder sourceRelationalDatabaseName(String sourceRelationalDatabaseName) {
            this.sourceRelationalDatabaseName = sourceRelationalDatabaseName;
            return this;
        }

        public final void setSourceRelationalDatabaseName(String sourceRelationalDatabaseName) {
            this.sourceRelationalDatabaseName = sourceRelationalDatabaseName;
        }

        public final Instant getRestoreTime() {
            return restoreTime;
        }

        @Override
        public final Builder restoreTime(Instant restoreTime) {
            this.restoreTime = restoreTime;
            return this;
        }

        public final void setRestoreTime(Instant restoreTime) {
            this.restoreTime = restoreTime;
        }

        public final Boolean getUseLatestRestorableTime() {
            return useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelationalDatabaseFromSnapshotRequest build() {
            return new CreateRelationalDatabaseFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
