/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum MetricName {
    CPU_UTILIZATION("CPUUtilization"),

    NETWORK_IN("NetworkIn"),

    NETWORK_OUT("NetworkOut"),

    STATUS_CHECK_FAILED("StatusCheckFailed"),

    STATUS_CHECK_FAILED_INSTANCE("StatusCheckFailed_Instance"),

    STATUS_CHECK_FAILED_SYSTEM("StatusCheckFailed_System"),

    CLIENT_TLS_NEGOTIATION_ERROR_COUNT("ClientTLSNegotiationErrorCount"),

    HEALTHY_HOST_COUNT("HealthyHostCount"),

    UNHEALTHY_HOST_COUNT("UnhealthyHostCount"),

    HTTP_CODE_LB_4_XX_COUNT("HTTPCode_LB_4XX_Count"),

    HTTP_CODE_LB_5_XX_COUNT("HTTPCode_LB_5XX_Count"),

    HTTP_CODE_INSTANCE_2_XX_COUNT("HTTPCode_Instance_2XX_Count"),

    HTTP_CODE_INSTANCE_3_XX_COUNT("HTTPCode_Instance_3XX_Count"),

    HTTP_CODE_INSTANCE_4_XX_COUNT("HTTPCode_Instance_4XX_Count"),

    HTTP_CODE_INSTANCE_5_XX_COUNT("HTTPCode_Instance_5XX_Count"),

    INSTANCE_RESPONSE_TIME("InstanceResponseTime"),

    REJECTED_CONNECTION_COUNT("RejectedConnectionCount"),

    REQUEST_COUNT("RequestCount"),

    DATABASE_CONNECTIONS("DatabaseConnections"),

    DISK_QUEUE_DEPTH("DiskQueueDepth"),

    FREE_STORAGE_SPACE("FreeStorageSpace"),

    NETWORK_RECEIVE_THROUGHPUT("NetworkReceiveThroughput"),

    NETWORK_TRANSMIT_THROUGHPUT("NetworkTransmitThroughput"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MetricName corresponding to the value
     */
    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetricName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MetricName}s
     */
    public static Set<MetricName> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
