/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopySnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceSnapshotName)).setter(CopySnapshotRequest.setter(Builder::sourceSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotName").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceResourceName)).setter(CopySnapshotRequest.setter(Builder::sourceResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceResourceName").build()}).build();
    private static final SdkField<String> RESTORE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::restoreDate)).setter(CopySnapshotRequest.setter(Builder::restoreDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreDate").build()}).build();
    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CopySnapshotRequest.getter(CopySnapshotRequest::useLatestRestorableAutoSnapshot)).setter(CopySnapshotRequest.setter(Builder::useLatestRestorableAutoSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableAutoSnapshot").build()}).build();
    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::targetSnapshotName)).setter(CopySnapshotRequest.setter(Builder::targetSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSnapshotName").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceRegionAsString)).setter(CopySnapshotRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD, SOURCE_RESOURCE_NAME_FIELD, RESTORE_DATE_FIELD, USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD, TARGET_SNAPSHOT_NAME_FIELD, SOURCE_REGION_FIELD));
    private final String sourceSnapshotName;
    private final String sourceResourceName;
    private final String restoreDate;
    private final Boolean useLatestRestorableAutoSnapshot;
    private final String targetSnapshotName;
    private final String sourceRegion;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.sourceResourceName = builder.sourceResourceName;
        this.restoreDate = builder.restoreDate;
        this.useLatestRestorableAutoSnapshot = builder.useLatestRestorableAutoSnapshot;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.sourceRegion = builder.sourceRegion;
    }

    public String sourceSnapshotName() {
        return this.sourceSnapshotName;
    }

    public String sourceResourceName() {
        return this.sourceResourceName;
    }

    public String restoreDate() {
        return this.restoreDate;
    }

    public Boolean useLatestRestorableAutoSnapshot() {
        return this.useLatestRestorableAutoSnapshot;
    }

    public String targetSnapshotName() {
        return this.targetSnapshotName;
    }

    public RegionName sourceRegion() {
        return RegionName.fromValue(this.sourceRegion);
    }

    public String sourceRegionAsString() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableAutoSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceSnapshotName(), other.sourceSnapshotName()) && Objects.equals(this.sourceResourceName(), other.sourceResourceName()) && Objects.equals(this.restoreDate(), other.restoreDate()) && Objects.equals(this.useLatestRestorableAutoSnapshot(), other.useLatestRestorableAutoSnapshot()) && Objects.equals(this.targetSnapshotName(), other.targetSnapshotName()) && Objects.equals(this.sourceRegionAsString(), other.sourceRegionAsString());
    }

    public String toString() {
        return ToString.builder((String)"CopySnapshotRequest").add("SourceSnapshotName", (Object)this.sourceSnapshotName()).add("SourceResourceName", (Object)this.sourceResourceName()).add("RestoreDate", (Object)this.restoreDate()).add("UseLatestRestorableAutoSnapshot", (Object)this.useLatestRestorableAutoSnapshot()).add("TargetSnapshotName", (Object)this.targetSnapshotName()).add("SourceRegion", (Object)this.sourceRegionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotName()));
            }
            case "sourceResourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceName()));
            }
            case "restoreDate": {
                return Optional.ofNullable(clazz.cast(this.restoreDate()));
            }
            case "useLatestRestorableAutoSnapshot": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableAutoSnapshot()));
            }
            case "targetSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.targetSnapshotName()));
            }
            case "sourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotRequest, T> g) {
        return obj -> g.apply((CopySnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String sourceSnapshotName;
        private String sourceResourceName;
        private String restoreDate;
        private Boolean useLatestRestorableAutoSnapshot;
        private String targetSnapshotName;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            this.sourceSnapshotName(model.sourceSnapshotName);
            this.sourceResourceName(model.sourceResourceName);
            this.restoreDate(model.restoreDate);
            this.useLatestRestorableAutoSnapshot(model.useLatestRestorableAutoSnapshot);
            this.targetSnapshotName(model.targetSnapshotName);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getSourceSnapshotName() {
            return this.sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        public final String getSourceResourceName() {
            return this.sourceResourceName;
        }

        @Override
        public final Builder sourceResourceName(String sourceResourceName) {
            this.sourceResourceName = sourceResourceName;
            return this;
        }

        public final void setSourceResourceName(String sourceResourceName) {
            this.sourceResourceName = sourceResourceName;
        }

        public final String getRestoreDate() {
            return this.restoreDate;
        }

        @Override
        public final Builder restoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public final void setRestoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
        }

        public final Boolean getUseLatestRestorableAutoSnapshot() {
            return this.useLatestRestorableAutoSnapshot;
        }

        @Override
        public final Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
            return this;
        }

        public final void setUseLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
        }

        public final String getTargetSnapshotName() {
            return this.targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public final Builder sourceRegion(RegionName sourceRegion) {
            this.sourceRegion(sourceRegion == null ? null : sourceRegion.toString());
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder sourceSnapshotName(String var1);

        public Builder sourceResourceName(String var1);

        public Builder restoreDate(String var1);

        public Builder useLatestRestorableAutoSnapshot(Boolean var1);

        public Builder targetSnapshotName(String var1);

        public Builder sourceRegion(String var1);

        public Builder sourceRegion(RegionName var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

