/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseMetricDataRequest extends LightsailRequest implements
        ToCopyableBuilder<GetRelationalDatabaseMetricDataRequest.Builder, GetRelationalDatabaseMetricDataRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabaseMetricDataRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabaseMetricDataRequest::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetRelationalDatabaseMetricDataRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetRelationalDatabaseMetricDataRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetRelationalDatabaseMetricDataRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabaseMetricDataRequest::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetRelationalDatabaseMetricDataRequest::statisticsAsStrings))
            .setter(setter(Builder::statisticsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, METRIC_NAME_FIELD, PERIOD_FIELD, START_TIME_FIELD, END_TIME_FIELD, UNIT_FIELD,
            STATISTICS_FIELD));

    private final String relationalDatabaseName;

    private final String metricName;

    private final Integer period;

    private final Instant startTime;

    private final Instant endTime;

    private final String unit;

    private final List<String> statistics;

    private GetRelationalDatabaseMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.metricName = builder.metricName;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The name of your database from which to get metric data.
     * </p>
     * 
     * @return The name of your database from which to get metric data.
     */
    public String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The metric for which you want to return information.
     * </p>
     * <p>
     * Valid relational database metric names are listed below, along with the most useful <code>statistics</code> to
     * include in your request, and the published <code>unit</code> value. All relational database metric data is
     * available in 1-minute (60 seconds) granularity.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the database.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Percent</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are waiting to
     * access the disk.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Bytes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the database,
     * including both customer database traffic and AWS traffic used for monitoring and replication.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the database,
     * including both customer database traffic and AWS traffic used for monitoring and replication.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link RelationalDatabaseMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric for which you want to return information.</p>
     *         <p>
     *         Valid relational database metric names are listed below, along with the most useful
     *         <code>statistics</code> to include in your request, and the published <code>unit</code> value. All
     *         relational database metric data is available in 1-minute (60 seconds) granularity.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the
     *         database.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Percent</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are
     *         waiting to access the disk.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Bytes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the database,
     *         including both customer database traffic and AWS traffic used for monitoring and replication.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the
     *         database, including both customer database traffic and AWS traffic used for monitoring and replication.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     *         </p>
     *         </li>
     * @see RelationalDatabaseMetricName
     */
    public RelationalDatabaseMetricName metricName() {
        return RelationalDatabaseMetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The metric for which you want to return information.
     * </p>
     * <p>
     * Valid relational database metric names are listed below, along with the most useful <code>statistics</code> to
     * include in your request, and the published <code>unit</code> value. All relational database metric data is
     * available in 1-minute (60 seconds) granularity.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the database.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Percent</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are waiting to
     * access the disk.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Count</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Bytes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the database,
     * including both customer database traffic and AWS traffic used for monitoring and replication.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the database,
     * including both customer database traffic and AWS traffic used for monitoring and replication.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * <p>
     * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link RelationalDatabaseMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric for which you want to return information.</p>
     *         <p>
     *         Valid relational database metric names are listed below, along with the most useful
     *         <code>statistics</code> to include in your request, and the published <code>unit</code> value. All
     *         relational database metric data is available in 1-minute (60 seconds) granularity.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the
     *         database.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Percent</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are
     *         waiting to access the disk.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Count</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Bytes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the database,
     *         including both customer database traffic and AWS traffic used for monitoring and replication.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the
     *         database, including both customer database traffic and AWS traffic used for monitoring and replication.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         <p>
     *         <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
     *         </p>
     *         </li>
     * @see RelationalDatabaseMetricName
     */
    public String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points.
     * </p>
     * <p>
     * All relational database metric data is available in 1-minute (60 seconds) granularity.
     * </p>
     * 
     * @return The granularity, in seconds, of the returned data points.</p>
     *         <p>
     *         All relational database metric data is available in 1-minute (60 seconds) granularity.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The start of the time interval from which to get metric data.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
     * <code>1538424000</code> as the start time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The start of the time interval from which to get metric data.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
     *         <code>1538424000</code> as the start time.
     *         </p>
     *         </li>
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time interval from which to get metric data.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
     * <code>1538424000</code> as the end time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The end of the time interval from which to get metric data.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
     *         <code>1538424000</code> as the end time.
     *         </p>
     *         </li>
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The unit for the metric data request. Valid units depend on the metric data being required. For the valid units
     * with each available metric, see the <code>metricName</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the metric data request. Valid units depend on the metric data being required. For the valid
     *         units with each available metric, see the <code>metricName</code> parameter.
     * @see MetricUnit
     */
    public MetricUnit unit() {
        return MetricUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit for the metric data request. Valid units depend on the metric data being required. For the valid units
     * with each available metric, see the <code>metricName</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link MetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the metric data request. Valid units depend on the metric data being required. For the valid
     *         units with each available metric, see the <code>metricName</code> parameter.
     * @see MetricUnit
     */
    public String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> — The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> — All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The statistic for the metric.</p>
     *         <p>
     *         The following statistics are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine
     *         low volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Maximum</code> — The highest value observed during the specified period. Use this value to
     *         determine high volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Sum</code> — All values submitted for the matching metric added together. You can use this
     *         statistic to determine the total volume of a metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
     *         statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close
     *         the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase
     *         or decrease your resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
     *         </p>
     *         </li>
     */
    public List<MetricStatistic> statistics() {
        return MetricStatisticListCopier.copyStringToEnum(statistics);
    }

    /**
     * Returns true if the Statistics property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStatistics() {
        return statistics != null && !(statistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * The following statistics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine low
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maximum</code> — The highest value observed during the specified period. Use this value to determine high
     * volumes of activity for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Sum</code> — All values submitted for the matching metric added together. You can use this statistic to
     * determine the total volume of a metric.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this statistic
     * with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use
     * is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your
     * resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The statistic for the metric.</p>
     *         <p>
     *         The following statistics are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine
     *         low volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Maximum</code> — The highest value observed during the specified period. Use this value to
     *         determine high volumes of activity for your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Sum</code> — All values submitted for the matching metric added together. You can use this
     *         statistic to determine the total volume of a metric.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
     *         statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close
     *         the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase
     *         or decrease your resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
     *         </p>
     *         </li>
     */
    public List<String> statisticsAsStrings() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseMetricDataRequest)) {
            return false;
        }
        GetRelationalDatabaseMetricDataRequest other = (GetRelationalDatabaseMetricDataRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(metricNameAsString(), other.metricNameAsString()) && Objects.equals(period(), other.period())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(statisticsAsStrings(), other.statisticsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRelationalDatabaseMetricDataRequest").add("RelationalDatabaseName", relationalDatabaseName())
                .add("MetricName", metricNameAsString()).add("Period", period()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Unit", unitAsString()).add("Statistics", statisticsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statisticsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseMetricDataRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseMetricDataRequest> {
        /**
         * <p>
         * The name of your database from which to get metric data.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of your database from which to get metric data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The metric for which you want to return information.
         * </p>
         * <p>
         * Valid relational database metric names are listed below, along with the most useful <code>statistics</code>
         * to include in your request, and the published <code>unit</code> value. All relational database metric data is
         * available in 1-minute (60 seconds) granularity.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the database.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Percent</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Count</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are waiting
         * to access the disk.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Count</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Bytes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the database,
         * including both customer database traffic and AWS traffic used for monitoring and replication.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the database,
         * including both customer database traffic and AWS traffic used for monitoring and replication.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        The metric for which you want to return information.</p>
         *        <p>
         *        Valid relational database metric names are listed below, along with the most useful
         *        <code>statistics</code> to include in your request, and the published <code>unit</code> value. All
         *        relational database metric data is available in 1-minute (60 seconds) granularity.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the
         *        database.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Percent</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Count</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are
         *        waiting to access the disk.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Count</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Bytes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the
         *        database, including both customer database traffic and AWS traffic used for monitoring and
         *        replication.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the
         *        database, including both customer database traffic and AWS traffic used for monitoring and
         *        replication.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         *        </p>
         *        </li>
         * @see RelationalDatabaseMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationalDatabaseMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric for which you want to return information.
         * </p>
         * <p>
         * Valid relational database metric names are listed below, along with the most useful <code>statistics</code>
         * to include in your request, and the published <code>unit</code> value. All relational database metric data is
         * available in 1-minute (60 seconds) granularity.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the database.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Percent</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Count</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are waiting
         * to access the disk.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Count</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Bytes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the database,
         * including both customer database traffic and AWS traffic used for monitoring and replication.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the database,
         * including both customer database traffic and AWS traffic used for monitoring and replication.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * <p>
         * <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        The metric for which you want to return information.</p>
         *        <p>
         *        Valid relational database metric names are listed below, along with the most useful
         *        <code>statistics</code> to include in your request, and the published <code>unit</code> value. All
         *        relational database metric data is available in 1-minute (60 seconds) granularity.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>CPUUtilization</code> </b> — The percentage of CPU utilization currently in use on the
         *        database.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Percent</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>DatabaseConnections</code> </b> — The number of database connections in use.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Count</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>DiskQueueDepth</code> </b> — The number of outstanding IOs (read/write requests) that are
         *        waiting to access the disk.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Count</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>FreeStorageSpace</code> </b> — The amount of available storage space.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Bytes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>NetworkReceiveThroughput</code> </b> — The incoming (Receive) network traffic on the
         *        database, including both customer database traffic and AWS traffic used for monitoring and
         *        replication.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>NetworkTransmitThroughput</code> </b> — The outgoing (Transmit) network traffic on the
         *        database, including both customer database traffic and AWS traffic used for monitoring and
         *        replication.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        <p>
         *        <code>Unit</code>: The published unit is <code>Bytes/Second</code>.
         *        </p>
         *        </li>
         * @see RelationalDatabaseMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationalDatabaseMetricName
         */
        Builder metricName(RelationalDatabaseMetricName metricName);

        /**
         * <p>
         * The granularity, in seconds, of the returned data points.
         * </p>
         * <p>
         * All relational database metric data is available in 1-minute (60 seconds) granularity.
         * </p>
         * 
         * @param period
         *        The granularity, in seconds, of the returned data points.</p>
         *        <p>
         *        All relational database metric data is available in 1-minute (60 seconds) granularity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The start of the time interval from which to get metric data.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
         * <code>1538424000</code> as the start time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param startTime
         *        The start of the time interval from which to get metric data.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
         *        <code>1538424000</code> as the start time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time interval from which to get metric data.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
         * <code>1538424000</code> as the end time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endTime
         *        The end of the time interval from which to get metric data.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
         *        <code>1538424000</code> as the end time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The unit for the metric data request. Valid units depend on the metric data being required. For the valid
         * units with each available metric, see the <code>metricName</code> parameter.
         * </p>
         * 
         * @param unit
         *        The unit for the metric data request. Valid units depend on the metric data being required. For the
         *        valid units with each available metric, see the <code>metricName</code> parameter.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit for the metric data request. Valid units depend on the metric data being required. For the valid
         * units with each available metric, see the <code>metricName</code> parameter.
         * </p>
         * 
         * @param unit
         *        The unit for the metric data request. Valid units depend on the metric data being required. For the
         *        valid units with each available metric, see the <code>metricName</code> parameter.
         * @see MetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricUnit
         */
        Builder unit(MetricUnit unit);

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * <p>
         * The following statistics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine low
         * volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Maximum</code> — The highest value observed during the specified period. Use this value to determine
         * high volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sum</code> — All values submitted for the matching metric added together. You can use this statistic to
         * determine the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or
         * decrease your resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        The statistic for the metric.</p>
         *        <p>
         *        The following statistics are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Minimum</code> — The lowest value observed during the specified period. Use this value to
         *        determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Maximum</code> — The highest value observed during the specified period. Use this value to
         *        determine high volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sum</code> — All values submitted for the matching metric added together. You can use this
         *        statistic to determine the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how
         *        close the average use is to the Minimum and Maximum values. This comparison helps you to know when to
         *        increase or decrease your resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(Collection<String> statistics);

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * <p>
         * The following statistics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine low
         * volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Maximum</code> — The highest value observed during the specified period. Use this value to determine
         * high volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sum</code> — All values submitted for the matching metric added together. You can use this statistic to
         * determine the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or
         * decrease your resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        The statistic for the metric.</p>
         *        <p>
         *        The following statistics are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Minimum</code> — The lowest value observed during the specified period. Use this value to
         *        determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Maximum</code> — The highest value observed during the specified period. Use this value to
         *        determine high volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sum</code> — All values submitted for the matching metric added together. You can use this
         *        statistic to determine the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how
         *        close the average use is to the Minimum and Maximum values. This comparison helps you to know when to
         *        increase or decrease your resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(String... statistics);

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * <p>
         * The following statistics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine low
         * volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Maximum</code> — The highest value observed during the specified period. Use this value to determine
         * high volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sum</code> — All values submitted for the matching metric added together. You can use this statistic to
         * determine the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or
         * decrease your resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        The statistic for the metric.</p>
         *        <p>
         *        The following statistics are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Minimum</code> — The lowest value observed during the specified period. Use this value to
         *        determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Maximum</code> — The highest value observed during the specified period. Use this value to
         *        determine high volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sum</code> — All values submitted for the matching metric added together. You can use this
         *        statistic to determine the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how
         *        close the average use is to the Minimum and Maximum values. This comparison helps you to know when to
         *        increase or decrease your resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<MetricStatistic> statistics);

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * <p>
         * The following statistics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Minimum</code> — The lowest value observed during the specified period. Use this value to determine low
         * volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Maximum</code> — The highest value observed during the specified period. Use this value to determine
         * high volumes of activity for your application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Sum</code> — All values submitted for the matching metric added together. You can use this statistic to
         * determine the total volume of a metric.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         * statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the
         * average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or
         * decrease your resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        The statistic for the metric.</p>
         *        <p>
         *        The following statistics are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Minimum</code> — The lowest value observed during the specified period. Use this value to
         *        determine low volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Maximum</code> — The highest value observed during the specified period. Use this value to
         *        determine high volumes of activity for your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Sum</code> — All values submitted for the matching metric added together. You can use this
         *        statistic to determine the total volume of a metric.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> — The value of Sum / SampleCount during the specified period. By comparing this
         *        statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how
         *        close the average use is to the Minimum and Maximum values. This comparison helps you to know when to
         *        increase or decrease your resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SampleCount</code> — The count, or number, of data points used for the statistical calculation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(MetricStatistic... statistics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String metricName;

        private Integer period;

        private Instant startTime;

        private Instant endTime;

        private String unit;

        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseMetricDataRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            metricName(model.metricName);
            period(model.period);
            startTime(model.startTime);
            endTime(model.endTime);
            unit(model.unit);
            statisticsWithStrings(model.statistics);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(RelationalDatabaseMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<String> getStatistics() {
            return statistics;
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String... statistics) {
            statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<MetricStatistic> statistics) {
            this.statistics = MetricStatisticListCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(MetricStatistic... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseMetricDataRequest build() {
            return new GetRelationalDatabaseMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
