/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLoadBalancerAttributeRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateLoadBalancerAttributeRequest.Builder, UpdateLoadBalancerAttributeRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLoadBalancerAttributeRequest::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLoadBalancerAttributeRequest::attributeNameAsString)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLoadBalancerAttributeRequest::attributeValue)).setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUE_FIELD));

    private final String loadBalancerName;

    private final String attributeName;

    private final String attributeValue;

    private UpdateLoadBalancerAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * The name of the load balancer that you want to modify (e.g., <code>my-load-balancer</code>.
     * </p>
     * 
     * @return The name of the load balancer that you want to modify (e.g., <code>my-load-balancer</code>.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The name of the attribute you want to update. Valid values are below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeName}
     * will return {@link LoadBalancerAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeNameAsString}.
     * </p>
     * 
     * @return The name of the attribute you want to update. Valid values are below.
     * @see LoadBalancerAttributeName
     */
    public LoadBalancerAttributeName attributeName() {
        return LoadBalancerAttributeName.fromValue(attributeName);
    }

    /**
     * <p>
     * The name of the attribute you want to update. Valid values are below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeName}
     * will return {@link LoadBalancerAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeNameAsString}.
     * </p>
     * 
     * @return The name of the attribute you want to update. Valid values are below.
     * @see LoadBalancerAttributeName
     */
    public String attributeNameAsString() {
        return attributeName;
    }

    /**
     * <p>
     * The value that you want to specify for the attribute name.
     * </p>
     * 
     * @return The value that you want to specify for the attribute name.
     */
    public String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLoadBalancerAttributeRequest)) {
            return false;
        }
        UpdateLoadBalancerAttributeRequest other = (UpdateLoadBalancerAttributeRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(attributeNameAsString(), other.attributeNameAsString())
                && Objects.equals(attributeValue(), other.attributeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateLoadBalancerAttributeRequest").add("LoadBalancerName", loadBalancerName())
                .add("AttributeName", attributeNameAsString()).add("AttributeValue", attributeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "attributeName":
            return Optional.ofNullable(clazz.cast(attributeNameAsString()));
        case "attributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLoadBalancerAttributeRequest, T> g) {
        return obj -> g.apply((UpdateLoadBalancerAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLoadBalancerAttributeRequest> {
        /**
         * <p>
         * The name of the load balancer that you want to modify (e.g., <code>my-load-balancer</code>.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer that you want to modify (e.g., <code>my-load-balancer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The name of the attribute you want to update. Valid values are below.
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute you want to update. Valid values are below.
         * @see LoadBalancerAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerAttributeName
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The name of the attribute you want to update. Valid values are below.
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute you want to update. Valid values are below.
         * @see LoadBalancerAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerAttributeName
         */
        Builder attributeName(LoadBalancerAttributeName attributeName);

        /**
         * <p>
         * The value that you want to specify for the attribute name.
         * </p>
         * 
         * @param attributeValue
         *        The value that you want to specify for the attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String attributeName;

        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLoadBalancerAttributeRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @Override
        public final Builder attributeName(LoadBalancerAttributeName attributeName) {
            this.attributeName(attributeName == null ? null : attributeName.toString());
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLoadBalancerAttributeRequest build() {
            return new UpdateLoadBalancerAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
