/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the resource location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceLocation.Builder, ResourceLocation> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceLocation::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceLocation::regionNameAsString)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            REGION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String regionName;

    private ResourceLocation(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.regionName = builder.regionName;
    }

    /**
     * <p>
     * The Availability Zone. Follows the format <code>us-east-2a</code> (case-sensitive).
     * </p>
     * 
     * @return The Availability Zone. Follows the format <code>us-east-2a</code> (case-sensitive).
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AWS Region name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionName} will
     * return {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionNameAsString}.
     * </p>
     * 
     * @return The AWS Region name.
     * @see RegionName
     */
    public RegionName regionName() {
        return RegionName.fromValue(regionName);
    }

    /**
     * <p>
     * The AWS Region name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionName} will
     * return {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionNameAsString}.
     * </p>
     * 
     * @return The AWS Region name.
     * @see RegionName
     */
    public String regionNameAsString() {
        return regionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(regionNameAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation other = (ResourceLocation) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(regionNameAsString(), other.regionNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceLocation").add("AvailabilityZone", availabilityZone())
                .add("RegionName", regionNameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "regionName":
            return Optional.ofNullable(clazz.cast(regionNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceLocation, T> g) {
        return obj -> g.apply((ResourceLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceLocation> {
        /**
         * <p>
         * The Availability Zone. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AWS Region name.
         * </p>
         * 
         * @param regionName
         *        The AWS Region name.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The AWS Region name.
         * </p>
         * 
         * @param regionName
         *        The AWS Region name.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder regionName(RegionName regionName);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceLocation model) {
            availabilityZone(model.availabilityZone);
            regionName(model.regionName);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public final Builder regionName(RegionName regionName) {
            this.regionName(regionName == null ? null : regionName.toString());
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public ResourceLocation build() {
            return new ResourceLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
