/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRelationalDatabaseParametersRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateRelationalDatabaseParametersRequest.Builder, UpdateRelationalDatabaseParametersRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRelationalDatabaseParametersRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<List<RelationalDatabaseParameter>> PARAMETERS_FIELD = SdkField
            .<List<RelationalDatabaseParameter>> builder(MarshallingType.LIST)
            .getter(getter(UpdateRelationalDatabaseParametersRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelationalDatabaseParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelationalDatabaseParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, PARAMETERS_FIELD));

    private final String relationalDatabaseName;

    private final List<RelationalDatabaseParameter> parameters;

    private UpdateRelationalDatabaseParametersRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The name of your database for which to update parameters.
     * </p>
     * 
     * @return The name of your database for which to update parameters.
     */
    public String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The database parameters to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The database parameters to update.
     */
    public List<RelationalDatabaseParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelationalDatabaseParametersRequest)) {
            return false;
        }
        UpdateRelationalDatabaseParametersRequest other = (UpdateRelationalDatabaseParametersRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRelationalDatabaseParametersRequest")
                .add("RelationalDatabaseName", relationalDatabaseName()).add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelationalDatabaseParametersRequest, T> g) {
        return obj -> g.apply((UpdateRelationalDatabaseParametersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRelationalDatabaseParametersRequest> {
        /**
         * <p>
         * The name of your database for which to update parameters.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of your database for which to update parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The database parameters to update.
         * </p>
         * 
         * @param parameters
         *        The database parameters to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<RelationalDatabaseParameter> parameters);

        /**
         * <p>
         * The database parameters to update.
         * </p>
         * 
         * @param parameters
         *        The database parameters to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(RelationalDatabaseParameter... parameters);

        /**
         * <p>
         * The database parameters to update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RelationalDatabaseParameter>.Builder}
         * avoiding the need to create one manually via {@link List<RelationalDatabaseParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RelationalDatabaseParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<RelationalDatabaseParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<RelationalDatabaseParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<RelationalDatabaseParameter>)
         */
        Builder parameters(Consumer<RelationalDatabaseParameter.Builder>... parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private List<RelationalDatabaseParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelationalDatabaseParametersRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            parameters(model.parameters);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final Collection<RelationalDatabaseParameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(RelationalDatabaseParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<RelationalDatabaseParameter> parameters) {
            this.parameters = RelationalDatabaseParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(RelationalDatabaseParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<RelationalDatabaseParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> RelationalDatabaseParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<RelationalDatabaseParameter.BuilderImpl> parameters) {
            this.parameters = RelationalDatabaseParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelationalDatabaseParametersRequest build() {
            return new UpdateRelationalDatabaseParametersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
