/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDistributionRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateDistributionRequest.Builder, UpdateDistributionRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDistributionRequest::distributionName)).setter(setter(Builder::distributionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()).build();

    private static final SdkField<InputOrigin> ORIGIN_FIELD = SdkField.<InputOrigin> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDistributionRequest::origin)).setter(setter(Builder::origin)).constructor(InputOrigin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()).build();

    private static final SdkField<CacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField
            .<CacheBehavior> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDistributionRequest::defaultCacheBehavior))
            .setter(setter(Builder::defaultCacheBehavior)).constructor(CacheBehavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCacheBehavior").build())
            .build();

    private static final SdkField<CacheSettings> CACHE_BEHAVIOR_SETTINGS_FIELD = SdkField
            .<CacheSettings> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDistributionRequest::cacheBehaviorSettings))
            .setter(setter(Builder::cacheBehaviorSettings)).constructor(CacheSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviorSettings").build())
            .build();

    private static final SdkField<List<CacheBehaviorPerPath>> CACHE_BEHAVIORS_FIELD = SdkField
            .<List<CacheBehaviorPerPath>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDistributionRequest::cacheBehaviors))
            .setter(setter(Builder::cacheBehaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CacheBehaviorPerPath> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheBehaviorPerPath::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateDistributionRequest::isEnabled)).setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD,
            ORIGIN_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIOR_SETTINGS_FIELD, CACHE_BEHAVIORS_FIELD, IS_ENABLED_FIELD));

    private final String distributionName;

    private final InputOrigin origin;

    private final CacheBehavior defaultCacheBehavior;

    private final CacheSettings cacheBehaviorSettings;

    private final List<CacheBehaviorPerPath> cacheBehaviors;

    private final Boolean isEnabled;

    private UpdateDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.origin = builder.origin;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviorSettings = builder.cacheBehaviorSettings;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.isEnabled = builder.isEnabled;
    }

    /**
     * <p>
     * The name of the distribution to update.
     * </p>
     * <p>
     * Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
     * </p>
     * 
     * @return The name of the distribution to update.</p>
     *         <p>
     *         Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
     */
    public String distributionName() {
        return distributionName;
    }

    /**
     * <p>
     * An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer.
     * </p>
     * <p>
     * The distribution pulls, caches, and serves content from the origin.
     * </p>
     * 
     * @return An object that describes the origin resource for the distribution, such as a Lightsail instance or load
     *         balancer.</p>
     *         <p>
     *         The distribution pulls, caches, and serves content from the origin.
     */
    public InputOrigin origin() {
        return origin;
    }

    /**
     * <p>
     * An object that describes the default cache behavior for the distribution.
     * </p>
     * 
     * @return An object that describes the default cache behavior for the distribution.
     */
    public CacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * An object that describes the cache behavior settings for the distribution.
     * </p>
     * <note>
     * <p>
     * The <code>cacheBehaviorSettings</code> specified in your <code>UpdateDistributionRequest</code> will replace your
     * distribution's existing settings.
     * </p>
     * </note>
     * 
     * @return An object that describes the cache behavior settings for the distribution.</p> <note>
     *         <p>
     *         The <code>cacheBehaviorSettings</code> specified in your <code>UpdateDistributionRequest</code> will
     *         replace your distribution's existing settings.
     *         </p>
     */
    public CacheSettings cacheBehaviorSettings() {
        return cacheBehaviorSettings;
    }

    /**
     * Returns true if the CacheBehaviors property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCacheBehaviors() {
        return cacheBehaviors != null && !(cacheBehaviors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the per-path cache behavior for the distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheBehaviors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe the per-path cache behavior for the distribution.
     */
    public List<CacheBehaviorPerPath> cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * Indicates whether to enable the distribution.
     * </p>
     * 
     * @return Indicates whether to enable the distribution.
     */
    public Boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviorSettings());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionRequest)) {
            return false;
        }
        UpdateDistributionRequest other = (UpdateDistributionRequest) obj;
        return Objects.equals(distributionName(), other.distributionName()) && Objects.equals(origin(), other.origin())
                && Objects.equals(defaultCacheBehavior(), other.defaultCacheBehavior())
                && Objects.equals(cacheBehaviorSettings(), other.cacheBehaviorSettings())
                && Objects.equals(cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(isEnabled(), other.isEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDistributionRequest").add("DistributionName", distributionName()).add("Origin", origin())
                .add("DefaultCacheBehavior", defaultCacheBehavior()).add("CacheBehaviorSettings", cacheBehaviorSettings())
                .add("CacheBehaviors", cacheBehaviors()).add("IsEnabled", isEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distributionName":
            return Optional.ofNullable(clazz.cast(distributionName()));
        case "origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "defaultCacheBehavior":
            return Optional.ofNullable(clazz.cast(defaultCacheBehavior()));
        case "cacheBehaviorSettings":
            return Optional.ofNullable(clazz.cast(cacheBehaviorSettings()));
        case "cacheBehaviors":
            return Optional.ofNullable(clazz.cast(cacheBehaviors()));
        case "isEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionRequest, T> g) {
        return obj -> g.apply((UpdateDistributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDistributionRequest> {
        /**
         * <p>
         * The name of the distribution to update.
         * </p>
         * <p>
         * Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
         * </p>
         * 
         * @param distributionName
         *        The name of the distribution to update.</p>
         *        <p>
         *        Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionName(String distributionName);

        /**
         * <p>
         * An object that describes the origin resource for the distribution, such as a Lightsail instance or load
         * balancer.
         * </p>
         * <p>
         * The distribution pulls, caches, and serves content from the origin.
         * </p>
         * 
         * @param origin
         *        An object that describes the origin resource for the distribution, such as a Lightsail instance or
         *        load balancer.</p>
         *        <p>
         *        The distribution pulls, caches, and serves content from the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(InputOrigin origin);

        /**
         * <p>
         * An object that describes the origin resource for the distribution, such as a Lightsail instance or load
         * balancer.
         * </p>
         * <p>
         * The distribution pulls, caches, and serves content from the origin.
         * </p>
         * This is a convenience that creates an instance of the {@link InputOrigin.Builder} avoiding the need to create
         * one manually via {@link InputOrigin#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputOrigin.Builder#build()} is called immediately and its result
         * is passed to {@link #origin(InputOrigin)}.
         * 
         * @param origin
         *        a consumer that will call methods on {@link InputOrigin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origin(InputOrigin)
         */
        default Builder origin(Consumer<InputOrigin.Builder> origin) {
            return origin(InputOrigin.builder().applyMutation(origin).build());
        }

        /**
         * <p>
         * An object that describes the default cache behavior for the distribution.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        An object that describes the default cache behavior for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * An object that describes the default cache behavior for the distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link CacheBehavior.Builder} avoiding the need to
         * create one manually via {@link CacheBehavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheBehavior.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultCacheBehavior(CacheBehavior)}.
         * 
         * @param defaultCacheBehavior
         *        a consumer that will call methods on {@link CacheBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCacheBehavior(CacheBehavior)
         */
        default Builder defaultCacheBehavior(Consumer<CacheBehavior.Builder> defaultCacheBehavior) {
            return defaultCacheBehavior(CacheBehavior.builder().applyMutation(defaultCacheBehavior).build());
        }

        /**
         * <p>
         * An object that describes the cache behavior settings for the distribution.
         * </p>
         * <note>
         * <p>
         * The <code>cacheBehaviorSettings</code> specified in your <code>UpdateDistributionRequest</code> will replace
         * your distribution's existing settings.
         * </p>
         * </note>
         * 
         * @param cacheBehaviorSettings
         *        An object that describes the cache behavior settings for the distribution.</p> <note>
         *        <p>
         *        The <code>cacheBehaviorSettings</code> specified in your <code>UpdateDistributionRequest</code> will
         *        replace your distribution's existing settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings);

        /**
         * <p>
         * An object that describes the cache behavior settings for the distribution.
         * </p>
         * <note>
         * <p>
         * The <code>cacheBehaviorSettings</code> specified in your <code>UpdateDistributionRequest</code> will replace
         * your distribution's existing settings.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link CacheSettings.Builder} avoiding the need
         * to create one manually via {@link CacheSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheBehaviorSettings(CacheSettings)}.
         * 
         * @param cacheBehaviorSettings
         *        a consumer that will call methods on {@link CacheSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviorSettings(CacheSettings)
         */
        default Builder cacheBehaviorSettings(Consumer<CacheSettings.Builder> cacheBehaviorSettings) {
            return cacheBehaviorSettings(CacheSettings.builder().applyMutation(cacheBehaviorSettings).build());
        }

        /**
         * <p>
         * An array of objects that describe the per-path cache behavior for the distribution.
         * </p>
         * 
         * @param cacheBehaviors
         *        An array of objects that describe the per-path cache behavior for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors);

        /**
         * <p>
         * An array of objects that describe the per-path cache behavior for the distribution.
         * </p>
         * 
         * @param cacheBehaviors
         *        An array of objects that describe the per-path cache behavior for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(CacheBehaviorPerPath... cacheBehaviors);

        /**
         * <p>
         * An array of objects that describe the per-path cache behavior for the distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CacheBehaviorPerPath>.Builder} avoiding the
         * need to create one manually via {@link List<CacheBehaviorPerPath>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheBehaviorPerPath>.Builder#build()} is called immediately
         * and its result is passed to {@link #cacheBehaviors(List<CacheBehaviorPerPath>)}.
         * 
         * @param cacheBehaviors
         *        a consumer that will call methods on {@link List<CacheBehaviorPerPath>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviors(List<CacheBehaviorPerPath>)
         */
        Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder>... cacheBehaviors);

        /**
         * <p>
         * Indicates whether to enable the distribution.
         * </p>
         * 
         * @param isEnabled
         *        Indicates whether to enable the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String distributionName;

        private InputOrigin origin;

        private CacheBehavior defaultCacheBehavior;

        private CacheSettings cacheBehaviorSettings;

        private List<CacheBehaviorPerPath> cacheBehaviors = DefaultSdkAutoConstructList.getInstance();

        private Boolean isEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionRequest model) {
            super(model);
            distributionName(model.distributionName);
            origin(model.origin);
            defaultCacheBehavior(model.defaultCacheBehavior);
            cacheBehaviorSettings(model.cacheBehaviorSettings);
            cacheBehaviors(model.cacheBehaviors);
            isEnabled(model.isEnabled);
        }

        public final String getDistributionName() {
            return distributionName;
        }

        @Override
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        public final InputOrigin.Builder getOrigin() {
            return origin != null ? origin.toBuilder() : null;
        }

        @Override
        public final Builder origin(InputOrigin origin) {
            this.origin = origin;
            return this;
        }

        public final void setOrigin(InputOrigin.BuilderImpl origin) {
            this.origin = origin != null ? origin.build() : null;
        }

        public final CacheBehavior.Builder getDefaultCacheBehavior() {
            return defaultCacheBehavior != null ? defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(CacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheSettings.Builder getCacheBehaviorSettings() {
            return cacheBehaviorSettings != null ? cacheBehaviorSettings.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        public final void setCacheBehaviorSettings(CacheSettings.BuilderImpl cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings != null ? cacheBehaviorSettings.build() : null;
        }

        public final Collection<CacheBehaviorPerPath.Builder> getCacheBehaviors() {
            return cacheBehaviors != null ? cacheBehaviors.stream().map(CacheBehaviorPerPath::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copy(cacheBehaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(CacheBehaviorPerPath... cacheBehaviors) {
            cacheBehaviors(Arrays.asList(cacheBehaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder>... cacheBehaviors) {
            cacheBehaviors(Stream.of(cacheBehaviors).map(c -> CacheBehaviorPerPath.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCacheBehaviors(Collection<CacheBehaviorPerPath.BuilderImpl> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copyFromBuilder(cacheBehaviors);
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionRequest build() {
            return new UpdateDistributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
