/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PeerVpcResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, PeerVpcResponse> {
    private static final SdkField<Operation> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("operation").getter(PeerVpcResponse.getter(PeerVpcResponse::operation)).setter(PeerVpcResponse.setter(Builder::operation)).constructor(Operation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD));
    private final Operation operation;

    private PeerVpcResponse(BuilderImpl builder) {
        super(builder);
        this.operation = builder.operation;
    }

    public Operation operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeerVpcResponse)) {
            return false;
        }
        PeerVpcResponse other = (PeerVpcResponse)((Object)obj);
        return Objects.equals(this.operation(), other.operation());
    }

    public String toString() {
        return ToString.builder((String)"PeerVpcResponse").add("Operation", (Object)this.operation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PeerVpcResponse, T> g) {
        return obj -> g.apply((PeerVpcResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(PeerVpcResponse model) {
            super(model);
            this.operation(model.operation);
        }

        public final Operation.Builder getOperation() {
            return this.operation != null ? this.operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public PeerVpcResponse build() {
            return new PeerVpcResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PeerVpcResponse> {
        public Builder operation(Operation var1);

        default public Builder operation(Consumer<Operation.Builder> operation) {
            return this.operation((Operation)((Operation.Builder)Operation.builder().applyMutation(operation)).build());
        }
    }
}

