/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDiskFromSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateDiskFromSnapshotRequest.Builder, CreateDiskFromSnapshotRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskName").getter(getter(CreateDiskFromSnapshotRequest::diskName)).setter(setter(Builder::diskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()).build();

    private static final SdkField<String> DISK_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskSnapshotName").getter(getter(CreateDiskFromSnapshotRequest::diskSnapshotName))
            .setter(setter(Builder::diskSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshotName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateDiskFromSnapshotRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInGb").getter(getter(CreateDiskFromSnapshotRequest::sizeInGb)).setter(setter(Builder::sizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDiskFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField
            .<List<AddOnRequest>> builder(MarshallingType.LIST)
            .memberName("addOns")
            .getter(getter(CreateDiskFromSnapshotRequest::addOns))
            .setter(setter(Builder::addOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOnRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOnRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceDiskName").getter(getter(CreateDiskFromSnapshotRequest::sourceDiskName))
            .setter(setter(Builder::sourceDiskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDiskName").build()).build();

    private static final SdkField<String> RESTORE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restoreDate").getter(getter(CreateDiskFromSnapshotRequest::restoreDate))
            .setter(setter(Builder::restoreDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreDate").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useLatestRestorableAutoSnapshot")
            .getter(getter(CreateDiskFromSnapshotRequest::useLatestRestorableAutoSnapshot))
            .setter(setter(Builder::useLatestRestorableAutoSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableAutoSnapshot")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD,
            DISK_SNAPSHOT_NAME_FIELD, AVAILABILITY_ZONE_FIELD, SIZE_IN_GB_FIELD, TAGS_FIELD, ADD_ONS_FIELD,
            SOURCE_DISK_NAME_FIELD, RESTORE_DATE_FIELD, USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD));

    private final String diskName;

    private final String diskSnapshotName;

    private final String availabilityZone;

    private final Integer sizeInGb;

    private final List<Tag> tags;

    private final List<AddOnRequest> addOns;

    private final String sourceDiskName;

    private final String restoreDate;

    private final Boolean useLatestRestorableAutoSnapshot;

    private CreateDiskFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.diskSnapshotName = builder.diskSnapshotName;
        this.availabilityZone = builder.availabilityZone;
        this.sizeInGb = builder.sizeInGb;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.sourceDiskName = builder.sourceDiskName;
        this.restoreDate = builder.restoreDate;
        this.useLatestRestorableAutoSnapshot = builder.useLatestRestorableAutoSnapshot;
    }

    /**
     * <p>
     * The unique Lightsail disk name (e.g., <code>my-disk</code>).
     * </p>
     * 
     * @return The unique Lightsail disk name (e.g., <code>my-disk</code>).
     */
    public String diskName() {
        return diskName;
    }

    /**
     * <p>
     * The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage disk.
     * </p>
     * <p>
     * Constraint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>source disk name</code> parameter. The
     * <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage
     *         disk.</p>
     *         <p>
     *         Constraint:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>source disk name</code> parameter. The
     *         <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
     *         </p>
     *         </li>
     */
    public String diskSnapshotName() {
        return diskSnapshotName;
    }

    /**
     * <p>
     * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
     * Availability Zone as the Lightsail instance where you want to create the disk.
     * </p>
     * <p>
     * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
     * </p>
     * 
     * @return The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
     *         Availability Zone as the Lightsail instance where you want to create the disk.</p>
     *         <p>
     *         Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The size of the disk in GB (e.g., <code>32</code>).
     * </p>
     * 
     * @return The size of the disk in GB (e.g., <code>32</code>).
     */
    public Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the AddOns property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAddOns() {
        return addOns != null && !(addOns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that represent the add-ons to enable for the new disk.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddOns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that represent the add-ons to enable for the new disk.
     */
    public List<AddOnRequest> addOns() {
        return addOns;
    }

    /**
     * <p>
     * The name of the source disk from which the source automatic snapshot was created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
     * <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">
     * Lightsail Dev Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the source disk from which the source automatic snapshot was created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
     *         <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new disk from an automatic snapshot. For more information, see
     *         the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Lightsail Dev Guide</a>.
     *         </p>
     *         </li>
     */
    public String sourceDiskName() {
        return sourceDiskName;
    }

    /**
     * <p>
     * The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code> operation to
     * identify the dates of the available automatic snapshots.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be specified in <code>YYYY-MM-DD</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter.
     * The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually
     * exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">
     * Lightsail Dev Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code>
     *         operation to identify the dates of the available automatic snapshots.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be specified in <code>YYYY-MM-DD</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
     *         parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters
     *         are mutually exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new disk from an automatic snapshot. For more information, see
     *         the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Lightsail Dev Guide</a>.
     *         </p>
     *         </li>
     */
    public String restoreDate() {
        return restoreDate;
    }

    /**
     * <p>
     * A Boolean value to indicate whether to use the latest available automatic snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>restore date</code> parameter. The
     * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">
     * Lightsail Dev Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>restore date</code> parameter. The
     *         <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
     *         exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new disk from an automatic snapshot. For more information, see
     *         the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Lightsail Dev Guide</a>.
     *         </p>
     *         </li>
     */
    public Boolean useLatestRestorableAutoSnapshot() {
        return useLatestRestorableAutoSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(addOns());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDiskName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDate());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableAutoSnapshot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskFromSnapshotRequest)) {
            return false;
        }
        CreateDiskFromSnapshotRequest other = (CreateDiskFromSnapshotRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(diskSnapshotName(), other.diskSnapshotName())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(sizeInGb(), other.sizeInGb())
                && Objects.equals(tags(), other.tags()) && Objects.equals(addOns(), other.addOns())
                && Objects.equals(sourceDiskName(), other.sourceDiskName()) && Objects.equals(restoreDate(), other.restoreDate())
                && Objects.equals(useLatestRestorableAutoSnapshot(), other.useLatestRestorableAutoSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDiskFromSnapshotRequest").add("DiskName", diskName())
                .add("DiskSnapshotName", diskSnapshotName()).add("AvailabilityZone", availabilityZone())
                .add("SizeInGb", sizeInGb()).add("Tags", tags()).add("AddOns", addOns()).add("SourceDiskName", sourceDiskName())
                .add("RestoreDate", restoreDate()).add("UseLatestRestorableAutoSnapshot", useLatestRestorableAutoSnapshot())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.ofNullable(clazz.cast(diskName()));
        case "diskSnapshotName":
            return Optional.ofNullable(clazz.cast(diskSnapshotName()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "sizeInGb":
            return Optional.ofNullable(clazz.cast(sizeInGb()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "addOns":
            return Optional.ofNullable(clazz.cast(addOns()));
        case "sourceDiskName":
            return Optional.ofNullable(clazz.cast(sourceDiskName()));
        case "restoreDate":
            return Optional.ofNullable(clazz.cast(restoreDate()));
        case "useLatestRestorableAutoSnapshot":
            return Optional.ofNullable(clazz.cast(useLatestRestorableAutoSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDiskFromSnapshotRequest, T> g) {
        return obj -> g.apply((CreateDiskFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDiskFromSnapshotRequest> {
        /**
         * <p>
         * The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage disk.
         * </p>
         * <p>
         * Constraint:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>source disk name</code> parameter. The
         * <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param diskSnapshotName
         *        The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage
         *        disk.</p>
         *        <p>
         *        Constraint:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>source disk name</code> parameter. The
         *        <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshotName(String diskSnapshotName);

        /**
         * <p>
         * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
         * Availability Zone as the Lightsail instance where you want to create the disk.
         * </p>
         * <p>
         * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the
         *        same Availability Zone as the Lightsail instance where you want to create the disk.</p>
         *        <p>
         *        Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The size of the disk in GB (e.g., <code>32</code>).
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB (e.g., <code>32</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * 
         * @param addOns
         *        An array of objects that represent the add-ons to enable for the new disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(Collection<AddOnRequest> addOns);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * 
         * @param addOns
         *        An array of objects that represent the add-ons to enable for the new disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(AddOnRequest... addOns);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddOnRequest>.Builder} avoiding the need to
         * create one manually via {@link List<AddOnRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddOnRequest>.Builder#build()} is called immediately and its
         * result is passed to {@link #addOns(List<AddOnRequest>)}.
         * 
         * @param addOns
         *        a consumer that will call methods on {@link List<AddOnRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOns(List<AddOnRequest>)
         */
        Builder addOns(Consumer<AddOnRequest.Builder>... addOns);

        /**
         * <p>
         * The name of the source disk from which the source automatic snapshot was created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
         * <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the
         * <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Lightsail Dev Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDiskName
         *        The name of the source disk from which the source automatic snapshot was created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
         *        <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new disk from an automatic snapshot. For more information,
         *        see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Lightsail Dev Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDiskName(String sourceDiskName);

        /**
         * <p>
         * The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code> operation
         * to identify the dates of the available automatic snapshots.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be specified in <code>YYYY-MM-DD</code> format.
         * </p>
         * </li>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         * parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are
         * mutually exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the
         * <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Lightsail Dev Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param restoreDate
         *        The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code>
         *        operation to identify the dates of the available automatic snapshots.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be specified in <code>YYYY-MM-DD</code> format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         *        parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code>
         *        parameters are mutually exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new disk from an automatic snapshot. For more information,
         *        see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Lightsail Dev Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDate(String restoreDate);

        /**
         * <p>
         * A Boolean value to indicate whether to use the latest available automatic snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>restore date</code> parameter. The
         * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         * exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the
         * <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Lightsail Dev Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param useLatestRestorableAutoSnapshot
         *        A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>restore date</code> parameter. The
         *        <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         *        exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new disk from an automatic snapshot. For more information,
         *        see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Lightsail Dev Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private String diskSnapshotName;

        private String availabilityZone;

        private Integer sizeInGb;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();

        private String sourceDiskName;

        private String restoreDate;

        private Boolean useLatestRestorableAutoSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskFromSnapshotRequest model) {
            super(model);
            diskName(model.diskName);
            diskSnapshotName(model.diskSnapshotName);
            availabilityZone(model.availabilityZone);
            sizeInGb(model.sizeInGb);
            tags(model.tags);
            addOns(model.addOns);
            sourceDiskName(model.sourceDiskName);
            restoreDate(model.restoreDate);
            useLatestRestorableAutoSnapshot(model.useLatestRestorableAutoSnapshot);
        }

        public final String getDiskName() {
            return diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getDiskSnapshotName() {
            return diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<AddOnRequest.Builder> getAddOns() {
            return addOns != null ? addOns.stream().map(AddOnRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOnRequest... addOns) {
            addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder>... addOns) {
            addOns(Stream.of(addOns).map(c -> AddOnRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        public final String getSourceDiskName() {
            return sourceDiskName;
        }

        @Override
        public final Builder sourceDiskName(String sourceDiskName) {
            this.sourceDiskName = sourceDiskName;
            return this;
        }

        public final void setSourceDiskName(String sourceDiskName) {
            this.sourceDiskName = sourceDiskName;
        }

        public final String getRestoreDate() {
            return restoreDate;
        }

        @Override
        public final Builder restoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public final void setRestoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
        }

        public final Boolean getUseLatestRestorableAutoSnapshot() {
            return useLatestRestorableAutoSnapshot;
        }

        @Override
        public final Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
            return this;
        }

        public final void setUseLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskFromSnapshotRequest build() {
            return new CreateDiskFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
