/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryStringObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryStringObject> {
    private static final SdkField<Boolean> OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("option").getter(QueryStringObject.getter(QueryStringObject::option)).setter(QueryStringObject.setter(Builder::option)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("option").build()}).build();
    private static final SdkField<List<String>> QUERY_STRINGS_ALLOW_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queryStringsAllowList").getter(QueryStringObject.getter(QueryStringObject::queryStringsAllowList)).setter(QueryStringObject.setter(Builder::queryStringsAllowList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryStringsAllowList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_FIELD, QUERY_STRINGS_ALLOW_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean option;
    private final List<String> queryStringsAllowList;

    private QueryStringObject(BuilderImpl builder) {
        this.option = builder.option;
        this.queryStringsAllowList = builder.queryStringsAllowList;
    }

    public Boolean option() {
        return this.option;
    }

    public boolean hasQueryStringsAllowList() {
        return this.queryStringsAllowList != null && !(this.queryStringsAllowList instanceof SdkAutoConstructList);
    }

    public List<String> queryStringsAllowList() {
        return this.queryStringsAllowList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.option());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStringsAllowList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStringObject)) {
            return false;
        }
        QueryStringObject other = (QueryStringObject)obj;
        return Objects.equals(this.option(), other.option()) && Objects.equals(this.queryStringsAllowList(), other.queryStringsAllowList());
    }

    public String toString() {
        return ToString.builder((String)"QueryStringObject").add("Option", (Object)this.option()).add("QueryStringsAllowList", this.queryStringsAllowList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "option": {
                return Optional.ofNullable(clazz.cast(this.option()));
            }
            case "queryStringsAllowList": {
                return Optional.ofNullable(clazz.cast(this.queryStringsAllowList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryStringObject, T> g) {
        return obj -> g.apply((QueryStringObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean option;
        private List<String> queryStringsAllowList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStringObject model) {
            this.option(model.option);
            this.queryStringsAllowList(model.queryStringsAllowList);
        }

        public final Boolean getOption() {
            return this.option;
        }

        @Override
        public final Builder option(Boolean option) {
            this.option = option;
            return this;
        }

        public final void setOption(Boolean option) {
            this.option = option;
        }

        public final Collection<String> getQueryStringsAllowList() {
            return this.queryStringsAllowList;
        }

        @Override
        public final Builder queryStringsAllowList(Collection<String> queryStringsAllowList) {
            this.queryStringsAllowList = StringListCopier.copy(queryStringsAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryStringsAllowList(String ... queryStringsAllowList) {
            this.queryStringsAllowList(Arrays.asList(queryStringsAllowList));
            return this;
        }

        public final void setQueryStringsAllowList(Collection<String> queryStringsAllowList) {
            this.queryStringsAllowList = StringListCopier.copy(queryStringsAllowList);
        }

        public QueryStringObject build() {
            return new QueryStringObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryStringObject> {
        public Builder option(Boolean var1);

        public Builder queryStringsAllowList(Collection<String> var1);

        public Builder queryStringsAllowList(String ... var1);
    }
}

