/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCertificatesRequest extends LightsailRequest implements
        ToCopyableBuilder<GetCertificatesRequest.Builder, GetCertificatesRequest> {
    private static final SdkField<List<String>> CERTIFICATE_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("certificateStatuses")
            .getter(getter(GetCertificatesRequest::certificateStatusesAsStrings))
            .setter(setter(Builder::certificateStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_CERTIFICATE_DETAILS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("includeCertificateDetails")
            .getter(getter(GetCertificatesRequest::includeCertificateDetails)).setter(setter(Builder::includeCertificateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeCertificateDetails").build())
            .build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateName").getter(getter(GetCertificatesRequest::certificateName))
            .setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_STATUSES_FIELD,
            INCLUDE_CERTIFICATE_DETAILS_FIELD, CERTIFICATE_NAME_FIELD));

    private final List<String> certificateStatuses;

    private final Boolean includeCertificateDetails;

    private final String certificateName;

    private GetCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.certificateStatuses = builder.certificateStatuses;
        this.includeCertificateDetails = builder.includeCertificateDetails;
        this.certificateName = builder.certificateName;
    }

    /**
     * <p>
     * The status of the certificates for which to return information.
     * </p>
     * <p>
     * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     * </p>
     * <p>
     * When omitted, the response includes all of your certificates in the AWS region where the request is made,
     * regardless of their current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificateStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the certificates for which to return information.</p>
     *         <p>
     *         For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     *         </p>
     *         <p>
     *         When omitted, the response includes all of your certificates in the AWS region where the request is made,
     *         regardless of their current status.
     */
    public List<CertificateStatus> certificateStatuses() {
        return CertificateStatusListCopier.copyStringToEnum(certificateStatuses);
    }

    /**
     * Returns true if the CertificateStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCertificateStatuses() {
        return certificateStatuses != null && !(certificateStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the certificates for which to return information.
     * </p>
     * <p>
     * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     * </p>
     * <p>
     * When omitted, the response includes all of your certificates in the AWS region where the request is made,
     * regardless of their current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificateStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the certificates for which to return information.</p>
     *         <p>
     *         For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     *         </p>
     *         <p>
     *         When omitted, the response includes all of your certificates in the AWS region where the request is made,
     *         regardless of their current status.
     */
    public List<String> certificateStatusesAsStrings() {
        return certificateStatuses;
    }

    /**
     * <p>
     * Indicates whether to include detailed information about the certificates in the response.
     * </p>
     * <p>
     * When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names, and
     * tags.
     * </p>
     * 
     * @return Indicates whether to include detailed information about the certificates in the response.</p>
     *         <p>
     *         When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain
     *         names, and tags.
     */
    public Boolean includeCertificateDetails() {
        return includeCertificateDetails;
    }

    /**
     * <p>
     * The name for the certificate for which to return information.
     * </p>
     * <p>
     * When omitted, the response includes all of your certificates in the AWS region where the request is made.
     * </p>
     * 
     * @return The name for the certificate for which to return information.</p>
     *         <p>
     *         When omitted, the response includes all of your certificates in the AWS region where the request is made.
     */
    public String certificateName() {
        return certificateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateStatuses() ? certificateStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeCertificateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificatesRequest)) {
            return false;
        }
        GetCertificatesRequest other = (GetCertificatesRequest) obj;
        return hasCertificateStatuses() == other.hasCertificateStatuses()
                && Objects.equals(certificateStatusesAsStrings(), other.certificateStatusesAsStrings())
                && Objects.equals(includeCertificateDetails(), other.includeCertificateDetails())
                && Objects.equals(certificateName(), other.certificateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCertificatesRequest")
                .add("CertificateStatuses", hasCertificateStatuses() ? certificateStatusesAsStrings() : null)
                .add("IncludeCertificateDetails", includeCertificateDetails()).add("CertificateName", certificateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateStatuses":
            return Optional.ofNullable(clazz.cast(certificateStatusesAsStrings()));
        case "includeCertificateDetails":
            return Optional.ofNullable(clazz.cast(includeCertificateDetails()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCertificatesRequest, T> g) {
        return obj -> g.apply((GetCertificatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCertificatesRequest> {
        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the AWS region where the request is made,
         * regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the AWS region where the request is
         *        made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatusesWithStrings(Collection<String> certificateStatuses);

        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the AWS region where the request is made,
         * regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the AWS region where the request is
         *        made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatusesWithStrings(String... certificateStatuses);

        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the AWS region where the request is made,
         * regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the AWS region where the request is
         *        made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatuses(Collection<CertificateStatus> certificateStatuses);

        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the AWS region where the request is made,
         * regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the AWS region where the request is
         *        made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatuses(CertificateStatus... certificateStatuses);

        /**
         * <p>
         * Indicates whether to include detailed information about the certificates in the response.
         * </p>
         * <p>
         * When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names,
         * and tags.
         * </p>
         * 
         * @param includeCertificateDetails
         *        Indicates whether to include detailed information about the certificates in the response.</p>
         *        <p>
         *        When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain
         *        names, and tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCertificateDetails(Boolean includeCertificateDetails);

        /**
         * <p>
         * The name for the certificate for which to return information.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the AWS region where the request is made.
         * </p>
         * 
         * @param certificateName
         *        The name for the certificate for which to return information.</p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the AWS region where the request is
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<String> certificateStatuses = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeCertificateDetails;

        private String certificateName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificatesRequest model) {
            super(model);
            certificateStatusesWithStrings(model.certificateStatuses);
            includeCertificateDetails(model.includeCertificateDetails);
            certificateName(model.certificateName);
        }

        public final Collection<String> getCertificateStatuses() {
            if (certificateStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return certificateStatuses;
        }

        @Override
        public final Builder certificateStatusesWithStrings(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copy(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatusesWithStrings(String... certificateStatuses) {
            certificateStatusesWithStrings(Arrays.asList(certificateStatuses));
            return this;
        }

        @Override
        public final Builder certificateStatuses(Collection<CertificateStatus> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copyEnumToString(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatuses(CertificateStatus... certificateStatuses) {
            certificateStatuses(Arrays.asList(certificateStatuses));
            return this;
        }

        public final void setCertificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copy(certificateStatuses);
        }

        public final Boolean getIncludeCertificateDetails() {
            return includeCertificateDetails;
        }

        @Override
        public final Builder includeCertificateDetails(Boolean includeCertificateDetails) {
            this.includeCertificateDetails = includeCertificateDetails;
            return this;
        }

        public final void setIncludeCertificateDetails(Boolean includeCertificateDetails) {
            this.includeCertificateDetails = includeCertificateDetails;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCertificatesRequest build() {
            return new GetCertificatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
