/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceSnapshotsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstanceSnapshotsResponse.Builder, GetInstanceSnapshotsResponse> {
    private static final SdkField<List<InstanceSnapshot>> INSTANCE_SNAPSHOTS_FIELD = SdkField
            .<List<InstanceSnapshot>> builder(MarshallingType.LIST)
            .memberName("instanceSnapshots")
            .getter(getter(GetInstanceSnapshotsResponse::instanceSnapshots))
            .setter(setter(Builder::instanceSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceSnapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceSnapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetInstanceSnapshotsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SNAPSHOTS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<InstanceSnapshot> instanceSnapshots;

    private final String nextPageToken;

    private GetInstanceSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshots = builder.instanceSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the InstanceSnapshots property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInstanceSnapshots() {
        return instanceSnapshots != null && !(instanceSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance snapshots request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceSnapshots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance snapshots
     *         request.
     */
    public List<InstanceSnapshot> instanceSnapshots() {
        return instanceSnapshots;
    }

    /**
     * <p>
     * The token to advance to the next page of resutls from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetInstanceSnapshots</code> request and specify the next
     * page token using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of resutls from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetInstanceSnapshots</code> request and specify
     *         the next page token using the <code>pageToken</code> parameter.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceSnapshots() ? instanceSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotsResponse)) {
            return false;
        }
        GetInstanceSnapshotsResponse other = (GetInstanceSnapshotsResponse) obj;
        return hasInstanceSnapshots() == other.hasInstanceSnapshots()
                && Objects.equals(instanceSnapshots(), other.instanceSnapshots())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetInstanceSnapshotsResponse")
                .add("InstanceSnapshots", hasInstanceSnapshots() ? instanceSnapshots() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceSnapshots":
            return Optional.ofNullable(clazz.cast(instanceSnapshots()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceSnapshotsResponse, T> g) {
        return obj -> g.apply((GetInstanceSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshots request.
         * </p>
         * 
         * @param instanceSnapshots
         *        An array of key-value pairs containing information about the results of your get instance snapshots
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshots request.
         * </p>
         * 
         * @param instanceSnapshots
         *        An array of key-value pairs containing information about the results of your get instance snapshots
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshots(InstanceSnapshot... instanceSnapshots);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshots request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceSnapshot>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceSnapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceSnapshot>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceSnapshots(List<InstanceSnapshot>)}.
         * 
         * @param instanceSnapshots
         *        a consumer that will call methods on {@link List<InstanceSnapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceSnapshots(List<InstanceSnapshot>)
         */
        Builder instanceSnapshots(Consumer<InstanceSnapshot.Builder>... instanceSnapshots);

        /**
         * <p>
         * The token to advance to the next page of resutls from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetInstanceSnapshots</code> request and specify the
         * next page token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of resutls from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetInstanceSnapshots</code> request and specify
         *        the next page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<InstanceSnapshot> instanceSnapshots = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotsResponse model) {
            super(model);
            instanceSnapshots(model.instanceSnapshots);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<InstanceSnapshot.Builder> getInstanceSnapshots() {
            if (instanceSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceSnapshots != null ? instanceSnapshots.stream().map(InstanceSnapshot::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copy(instanceSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSnapshots(InstanceSnapshot... instanceSnapshots) {
            instanceSnapshots(Arrays.asList(instanceSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSnapshots(Consumer<InstanceSnapshot.Builder>... instanceSnapshots) {
            instanceSnapshots(Stream.of(instanceSnapshots).map(c -> InstanceSnapshot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceSnapshots(Collection<InstanceSnapshot.BuilderImpl> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copyFromBuilder(instanceSnapshots);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetInstanceSnapshotsResponse build() {
            return new GetInstanceSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
