/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.AddOnRequest;
import software.amazon.awssdk.services.lightsail.model.AddOnRequestListCopier;
import software.amazon.awssdk.services.lightsail.model.AttachedDiskMapCopier;
import software.amazon.awssdk.services.lightsail.model.DiskMap;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstancesFromSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateInstancesFromSnapshotRequest> {
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceNames").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::instanceNames)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::instanceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<DiskMap>>> ATTACHED_DISK_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attachedDiskMapping").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::attachedDiskMapping)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::attachedDiskMapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedDiskMapping").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiskMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::availabilityZone)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> INSTANCE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceSnapshotName").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::instanceSnapshotName)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::instanceSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshotName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::bundleId)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userData").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::userData)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()}).build();
    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPairName").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::keyPairName)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::keyPairName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::tags)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addOns").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::addOns)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::addOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOnRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceInstanceName").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::sourceInstanceName)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::sourceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceInstanceName").build()}).build();
    private static final SdkField<String> RESTORE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restoreDate").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::restoreDate)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::restoreDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreDate").build()}).build();
    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useLatestRestorableAutoSnapshot").getter(CreateInstancesFromSnapshotRequest.getter(CreateInstancesFromSnapshotRequest::useLatestRestorableAutoSnapshot)).setter(CreateInstancesFromSnapshotRequest.setter(Builder::useLatestRestorableAutoSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableAutoSnapshot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAMES_FIELD, ATTACHED_DISK_MAPPING_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_SNAPSHOT_NAME_FIELD, BUNDLE_ID_FIELD, USER_DATA_FIELD, KEY_PAIR_NAME_FIELD, TAGS_FIELD, ADD_ONS_FIELD, SOURCE_INSTANCE_NAME_FIELD, RESTORE_DATE_FIELD, USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD));
    private final List<String> instanceNames;
    private final Map<String, List<DiskMap>> attachedDiskMapping;
    private final String availabilityZone;
    private final String instanceSnapshotName;
    private final String bundleId;
    private final String userData;
    private final String keyPairName;
    private final List<Tag> tags;
    private final List<AddOnRequest> addOns;
    private final String sourceInstanceName;
    private final String restoreDate;
    private final Boolean useLatestRestorableAutoSnapshot;

    private CreateInstancesFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.attachedDiskMapping = builder.attachedDiskMapping;
        this.availabilityZone = builder.availabilityZone;
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.sourceInstanceName = builder.sourceInstanceName;
        this.restoreDate = builder.restoreDate;
        this.useLatestRestorableAutoSnapshot = builder.useLatestRestorableAutoSnapshot;
    }

    public boolean hasInstanceNames() {
        return this.instanceNames != null && !(this.instanceNames instanceof SdkAutoConstructList);
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public boolean hasAttachedDiskMapping() {
        return this.attachedDiskMapping != null && !(this.attachedDiskMapping instanceof SdkAutoConstructMap);
    }

    public Map<String, List<DiskMap>> attachedDiskMapping() {
        return this.attachedDiskMapping;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String instanceSnapshotName() {
        return this.instanceSnapshotName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String userData() {
        return this.userData;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public boolean hasAddOns() {
        return this.addOns != null && !(this.addOns instanceof SdkAutoConstructList);
    }

    public List<AddOnRequest> addOns() {
        return this.addOns;
    }

    public String sourceInstanceName() {
        return this.sourceInstanceName;
    }

    public String restoreDate() {
        return this.restoreDate;
    }

    public Boolean useLatestRestorableAutoSnapshot() {
        return this.useLatestRestorableAutoSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceNames() ? this.instanceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachedDiskMapping() ? this.attachedDiskMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOns() ? this.addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableAutoSnapshot());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesFromSnapshotRequest)) {
            return false;
        }
        CreateInstancesFromSnapshotRequest other = (CreateInstancesFromSnapshotRequest)((Object)obj);
        return this.hasInstanceNames() == other.hasInstanceNames() && Objects.equals(this.instanceNames(), other.instanceNames()) && this.hasAttachedDiskMapping() == other.hasAttachedDiskMapping() && Objects.equals(this.attachedDiskMapping(), other.attachedDiskMapping()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceSnapshotName(), other.instanceSnapshotName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.keyPairName(), other.keyPairName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAddOns() == other.hasAddOns() && Objects.equals(this.addOns(), other.addOns()) && Objects.equals(this.sourceInstanceName(), other.sourceInstanceName()) && Objects.equals(this.restoreDate(), other.restoreDate()) && Objects.equals(this.useLatestRestorableAutoSnapshot(), other.useLatestRestorableAutoSnapshot());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstancesFromSnapshotRequest").add("InstanceNames", this.hasInstanceNames() ? this.instanceNames() : null).add("AttachedDiskMapping", this.hasAttachedDiskMapping() ? this.attachedDiskMapping() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceSnapshotName", (Object)this.instanceSnapshotName()).add("BundleId", (Object)this.bundleId()).add("UserData", (Object)this.userData()).add("KeyPairName", (Object)this.keyPairName()).add("Tags", this.hasTags() ? this.tags() : null).add("AddOns", this.hasAddOns() ? this.addOns() : null).add("SourceInstanceName", (Object)this.sourceInstanceName()).add("RestoreDate", (Object)this.restoreDate()).add("UseLatestRestorableAutoSnapshot", (Object)this.useLatestRestorableAutoSnapshot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceNames": {
                return Optional.ofNullable(clazz.cast(this.instanceNames()));
            }
            case "attachedDiskMapping": {
                return Optional.ofNullable(clazz.cast(this.attachedDiskMapping()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "instanceSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.instanceSnapshotName()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "userData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "keyPairName": {
                return Optional.ofNullable(clazz.cast(this.keyPairName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "addOns": {
                return Optional.ofNullable(clazz.cast(this.addOns()));
            }
            case "sourceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.sourceInstanceName()));
            }
            case "restoreDate": {
                return Optional.ofNullable(clazz.cast(this.restoreDate()));
            }
            case "useLatestRestorableAutoSnapshot": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableAutoSnapshot()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstancesFromSnapshotRequest, T> g) {
        return obj -> g.apply((CreateInstancesFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<DiskMap>> attachedDiskMapping = DefaultSdkAutoConstructMap.getInstance();
        private String availabilityZone;
        private String instanceSnapshotName;
        private String bundleId;
        private String userData;
        private String keyPairName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();
        private String sourceInstanceName;
        private String restoreDate;
        private Boolean useLatestRestorableAutoSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesFromSnapshotRequest model) {
            super(model);
            this.instanceNames(model.instanceNames);
            this.attachedDiskMapping(model.attachedDiskMapping);
            this.availabilityZone(model.availabilityZone);
            this.instanceSnapshotName(model.instanceSnapshotName);
            this.bundleId(model.bundleId);
            this.userData(model.userData);
            this.keyPairName(model.keyPairName);
            this.tags(model.tags);
            this.addOns(model.addOns);
            this.sourceInstanceName(model.sourceInstanceName);
            this.restoreDate(model.restoreDate);
            this.useLatestRestorableAutoSnapshot(model.useLatestRestorableAutoSnapshot);
        }

        public final Collection<String> getInstanceNames() {
            if (this.instanceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        public final Map<String, ? extends Collection<DiskMap>> getAttachedDiskMapping() {
            if (this.attachedDiskMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attachedDiskMapping;
        }

        @Override
        public final Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copy(attachedDiskMapping);
            return this;
        }

        public final void setAttachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copy(attachedDiskMapping);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceSnapshotName() {
            return this.instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<AddOnRequest.Builder> getAddOns() {
            if (this.addOns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addOns != null ? (Collection)this.addOns.stream().map(AddOnRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOnRequest ... addOns) {
            this.addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder> ... addOns) {
            this.addOns(Stream.of(addOns).map(c -> (AddOnRequest)((AddOnRequest.Builder)AddOnRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        public final String getSourceInstanceName() {
            return this.sourceInstanceName;
        }

        @Override
        public final Builder sourceInstanceName(String sourceInstanceName) {
            this.sourceInstanceName = sourceInstanceName;
            return this;
        }

        public final void setSourceInstanceName(String sourceInstanceName) {
            this.sourceInstanceName = sourceInstanceName;
        }

        public final String getRestoreDate() {
            return this.restoreDate;
        }

        @Override
        public final Builder restoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public final void setRestoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
        }

        public final Boolean getUseLatestRestorableAutoSnapshot() {
            return this.useLatestRestorableAutoSnapshot;
        }

        @Override
        public final Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
            return this;
        }

        public final void setUseLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstancesFromSnapshotRequest build() {
            return new CreateInstancesFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstancesFromSnapshotRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> var1);

        public Builder availabilityZone(String var1);

        public Builder instanceSnapshotName(String var1);

        public Builder bundleId(String var1);

        public Builder userData(String var1);

        public Builder keyPairName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder addOns(Collection<AddOnRequest> var1);

        public Builder addOns(AddOnRequest ... var1);

        public Builder addOns(Consumer<AddOnRequest.Builder> ... var1);

        public Builder sourceInstanceName(String var1);

        public Builder restoreDate(String var1);

        public Builder useLatestRestorableAutoSnapshot(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

