/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the login information for the container image registry of an Amazon Lightsail account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerServiceRegistryLogin implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerServiceRegistryLogin.Builder, ContainerServiceRegistryLogin> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(ContainerServiceRegistryLogin::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("password").getter(getter(ContainerServiceRegistryLogin::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(ContainerServiceRegistryLogin::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final SdkField<String> REGISTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registry").getter(getter(ContainerServiceRegistryLogin::registry)).setter(setter(Builder::registry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, EXPIRES_AT_FIELD, REGISTRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private final Instant expiresAt;

    private final String registry;

    private ContainerServiceRegistryLogin(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.expiresAt = builder.expiresAt;
        this.registry = builder.registry;
    }

    /**
     * <p>
     * The container service registry username to use to push container images to the container image registry of a
     * Lightsail account.
     * </p>
     * 
     * @return The container service registry username to use to push container images to the container image registry
     *         of a Lightsail account.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The container service registry password to use to push container images to the container image registry of a
     * Lightsail account
     * </p>
     * 
     * @return The container service registry password to use to push container images to the container image registry
     *         of a Lightsail account
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * The timestamp of when the container image registry username and password expire.
     * </p>
     * <p>
     * The log in credentials expire 12 hours after they are created, at which point you will need to create a new set
     * of log in credentials using the <code>CreateContainerServiceRegistryLogin</code> action.
     * </p>
     * 
     * @return The timestamp of when the container image registry username and password expire.</p>
     *         <p>
     *         The log in credentials expire 12 hours after they are created, at which point you will need to create a
     *         new set of log in credentials using the <code>CreateContainerServiceRegistryLogin</code> action.
     */
    public Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The address to use to push container images to the container image registry of a Lightsail account.
     * </p>
     * 
     * @return The address to use to push container images to the container image registry of a Lightsail account.
     */
    public String registry() {
        return registry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(registry());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceRegistryLogin)) {
            return false;
        }
        ContainerServiceRegistryLogin other = (ContainerServiceRegistryLogin) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(expiresAt(), other.expiresAt()) && Objects.equals(registry(), other.registry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContainerServiceRegistryLogin").add("Username", username()).add("Password", password())
                .add("ExpiresAt", expiresAt()).add("Registry", registry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        case "password":
            return Optional.ofNullable(clazz.cast(password()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "registry":
            return Optional.ofNullable(clazz.cast(registry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceRegistryLogin, T> g) {
        return obj -> g.apply((ContainerServiceRegistryLogin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerServiceRegistryLogin> {
        /**
         * <p>
         * The container service registry username to use to push container images to the container image registry of a
         * Lightsail account.
         * </p>
         * 
         * @param username
         *        The container service registry username to use to push container images to the container image
         *        registry of a Lightsail account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The container service registry password to use to push container images to the container image registry of a
         * Lightsail account
         * </p>
         * 
         * @param password
         *        The container service registry password to use to push container images to the container image
         *        registry of a Lightsail account
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The timestamp of when the container image registry username and password expire.
         * </p>
         * <p>
         * The log in credentials expire 12 hours after they are created, at which point you will need to create a new
         * set of log in credentials using the <code>CreateContainerServiceRegistryLogin</code> action.
         * </p>
         * 
         * @param expiresAt
         *        The timestamp of when the container image registry username and password expire.</p>
         *        <p>
         *        The log in credentials expire 12 hours after they are created, at which point you will need to create
         *        a new set of log in credentials using the <code>CreateContainerServiceRegistryLogin</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The address to use to push container images to the container image registry of a Lightsail account.
         * </p>
         * 
         * @param registry
         *        The address to use to push container images to the container image registry of a Lightsail account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registry(String registry);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private Instant expiresAt;

        private String registry;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceRegistryLogin model) {
            username(model.username);
            password(model.password);
            expiresAt(model.expiresAt);
            registry(model.registry);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        public final String getRegistry() {
            return registry;
        }

        @Override
        public final Builder registry(String registry) {
            this.registry = registry;
            return this;
        }

        public final void setRegistry(String registry) {
            this.registry = registry;
        }

        @Override
        public ContainerServiceRegistryLogin build() {
            return new ContainerServiceRegistryLogin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
