/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetDistributionCacheResponse extends LightsailResponse implements
        ToCopyableBuilder<ResetDistributionCacheResponse.Builder, ResetDistributionCacheResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ResetDistributionCacheResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ResetDistributionCacheResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Operation> OPERATION_FIELD = SdkField.<Operation> builder(MarshallingType.SDK_POJO)
            .memberName("operation").getter(getter(ResetDistributionCacheResponse::operation)).setter(setter(Builder::operation))
            .constructor(Operation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CREATE_TIME_FIELD, OPERATION_FIELD));

    private final String status;

    private final Instant createTime;

    private final Operation operation;

    private ResetDistributionCacheResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * The status of the reset cache request.
     * </p>
     * 
     * @return The status of the reset cache request.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The timestamp of the reset cache request (e.g., <code>1479734909.17</code>) in Unix time format.
     * </p>
     * 
     * @return The timestamp of the reset cache request (e.g., <code>1479734909.17</code>) in Unix time format.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * An array of objects that describe the result of the action, such as the status of the request, the timestamp of
     * the request, and the resources affected by the request.
     * </p>
     * 
     * @return An array of objects that describe the result of the action, such as the status of the request, the
     *         timestamp of the request, and the resources affected by the request.
     */
    public Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDistributionCacheResponse)) {
            return false;
        }
        ResetDistributionCacheResponse other = (ResetDistributionCacheResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResetDistributionCacheResponse").add("Status", status()).add("CreateTime", createTime())
                .add("Operation", operation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetDistributionCacheResponse, T> g) {
        return obj -> g.apply((ResetDistributionCacheResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResetDistributionCacheResponse> {
        /**
         * <p>
         * The status of the reset cache request.
         * </p>
         * 
         * @param status
         *        The status of the reset cache request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The timestamp of the reset cache request (e.g., <code>1479734909.17</code>) in Unix time format.
         * </p>
         * 
         * @param createTime
         *        The timestamp of the reset cache request (e.g., <code>1479734909.17</code>) in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * 
         * @param operation
         *        An array of objects that describe the result of the action, such as the status of the request, the
         *        timestamp of the request, and the resources affected by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * This is a convenience that creates an instance of the {@link Operation.Builder} avoiding the need to create
         * one manually via {@link Operation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Operation.Builder#build()} is called immediately and its result
         * is passed to {@link #operation(Operation)}.
         * 
         * @param operation
         *        a consumer that will call methods on {@link Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operation(Operation)
         */
        default Builder operation(Consumer<Operation.Builder> operation) {
            return operation(Operation.builder().applyMutation(operation).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String status;

        private Instant createTime;

        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetDistributionCacheResponse model) {
            super(model);
            status(model.status);
            createTime(model.createTime);
            operation(model.operation);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Operation.Builder getOperation() {
            return operation != null ? operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public ResetDistributionCacheResponse build() {
            return new ResetDistributionCacheResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
