/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerServicesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetContainerServicesResponse.Builder, GetContainerServicesResponse> {
    private static final SdkField<List<ContainerService>> CONTAINER_SERVICES_FIELD = SdkField
            .<List<ContainerService>> builder(MarshallingType.LIST)
            .memberName("containerServices")
            .getter(getter(GetContainerServicesResponse::containerServices))
            .setter(setter(Builder::containerServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerService> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_SERVICES_FIELD));

    private final List<ContainerService> containerServices;

    private GetContainerServicesResponse(BuilderImpl builder) {
        super(builder);
        this.containerServices = builder.containerServices;
    }

    /**
     * Returns true if the ContainerServices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasContainerServices() {
        return containerServices != null && !(containerServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe one or more container services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContainerServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe one or more container services.
     */
    public List<ContainerService> containerServices() {
        return containerServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerServices() ? containerServices() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerServicesResponse)) {
            return false;
        }
        GetContainerServicesResponse other = (GetContainerServicesResponse) obj;
        return hasContainerServices() == other.hasContainerServices()
                && Objects.equals(containerServices(), other.containerServices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetContainerServicesResponse")
                .add("ContainerServices", hasContainerServices() ? containerServices() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerServices":
            return Optional.ofNullable(clazz.cast(containerServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerServicesResponse, T> g) {
        return obj -> g.apply((GetContainerServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContainerServicesResponse> {
        /**
         * <p>
         * An array of objects that describe one or more container services.
         * </p>
         * 
         * @param containerServices
         *        An array of objects that describe one or more container services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerServices(Collection<ContainerService> containerServices);

        /**
         * <p>
         * An array of objects that describe one or more container services.
         * </p>
         * 
         * @param containerServices
         *        An array of objects that describe one or more container services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerServices(ContainerService... containerServices);

        /**
         * <p>
         * An array of objects that describe one or more container services.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerService>.Builder} avoiding the
         * need to create one manually via {@link List<ContainerService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerService>.Builder#build()} is called immediately and
         * its result is passed to {@link #containerServices(List<ContainerService>)}.
         * 
         * @param containerServices
         *        a consumer that will call methods on {@link List<ContainerService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerServices(List<ContainerService>)
         */
        Builder containerServices(Consumer<ContainerService.Builder>... containerServices);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ContainerService> containerServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerServicesResponse model) {
            super(model);
            containerServices(model.containerServices);
        }

        public final Collection<ContainerService.Builder> getContainerServices() {
            if (containerServices instanceof SdkAutoConstructList) {
                return null;
            }
            return containerServices != null ? containerServices.stream().map(ContainerService::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containerServices(Collection<ContainerService> containerServices) {
            this.containerServices = ContainerServiceListCopier.copy(containerServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerServices(ContainerService... containerServices) {
            containerServices(Arrays.asList(containerServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerServices(Consumer<ContainerService.Builder>... containerServices) {
            containerServices(Stream.of(containerServices).map(c -> ContainerService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContainerServices(Collection<ContainerService.BuilderImpl> containerServices) {
            this.containerServices = ContainerServiceListCopier.copyFromBuilder(containerServices);
        }

        @Override
        public GetContainerServicesResponse build() {
            return new GetContainerServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
