/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerLogRequest extends LightsailRequest implements
        ToCopyableBuilder<GetContainerLogRequest.Builder, GetContainerLogRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(GetContainerLogRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerName").getter(getter(GetContainerLogRequest::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetContainerLogRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetContainerLogRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(GetContainerLogRequest::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pageToken").getter(getter(GetContainerLogRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            CONTAINER_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, FILTER_PATTERN_FIELD, PAGE_TOKEN_FIELD));

    private final String serviceName;

    private final String containerName;

    private final Instant startTime;

    private final Instant endTime;

    private final String filterPattern;

    private final String pageToken;

    private GetContainerLogRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.containerName = builder.containerName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filterPattern = builder.filterPattern;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The name of the container service for which to get a container log.
     * </p>
     * 
     * @return The name of the container service for which to get a container log.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The name of the container that is either running or previously ran on the container service for which to return a
     * log.
     * </p>
     * 
     * @return The name of the container that is either running or previously ran on the container service for which to
     *         return a log.
     */
    public String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The start of the time interval for which to get log data.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify <code>1538424000</code> as
     * the start time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can convert a human-friendly time to Unix time format using a converter like <a
     * href="https://www.epochconverter.com/">Epoch converter</a>.
     * </p>
     * 
     * @return The start of the time interval for which to get log data.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
     *         <code>1538424000</code> as the start time.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can convert a human-friendly time to Unix time format using a converter like <a
     *         href="https://www.epochconverter.com/">Epoch converter</a>.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time interval for which to get log data.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify <code>1538427600</code> as
     * the end time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can convert a human-friendly time to Unix time format using a converter like <a
     * href="https://www.epochconverter.com/">Epoch converter</a>.
     * </p>
     * 
     * @return The end of the time interval for which to get log data.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify
     *         <code>1538427600</code> as the end time.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can convert a human-friendly time to Unix time format using a converter like <a
     *         href="https://www.epochconverter.com/">Epoch converter</a>.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The pattern to use to filter the returned log events to a specific term.
     * </p>
     * <p>
     * The following are a few examples of filter patterns that you can specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To return all log events, specify a filter pattern of <code>""</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To exclude log events that contain the <code>ERROR</code> term, and return all other log events, specify a filter
     * pattern of <code>"-ERROR"</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To return log events that contain the <code>ERROR</code> term, specify a filter pattern of <code>"ERROR"</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To return log events that contain both the <code>ERROR</code> and <code>Exception</code> terms, specify a filter
     * pattern of <code>"ERROR Exception"</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To return log events that contain the <code>ERROR</code> <i>or</i> the <code>Exception</code> term, specify a
     * filter pattern of <code>"?ERROR ?Exception"</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The pattern to use to filter the returned log events to a specific term.</p>
     *         <p>
     *         The following are a few examples of filter patterns that you can specify:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To return all log events, specify a filter pattern of <code>""</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To exclude log events that contain the <code>ERROR</code> term, and return all other log events, specify
     *         a filter pattern of <code>"-ERROR"</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To return log events that contain the <code>ERROR</code> term, specify a filter pattern of
     *         <code>"ERROR"</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To return log events that contain both the <code>ERROR</code> and <code>Exception</code> terms, specify a
     *         filter pattern of <code>"ERROR Exception"</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To return log events that contain the <code>ERROR</code> <i>or</i> the <code>Exception</code> term,
     *         specify a filter pattern of <code>"?ERROR ?Exception"</code>.
     *         </p>
     *         </li>
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * To get a page token, perform an initial <code>GetContainerLog</code> request. If your results are paginated, the
     * response will return a next page token that you can specify as the page token in a subsequent request.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         To get a page token, perform an initial <code>GetContainerLog</code> request. If your results are
     *         paginated, the response will return a next page token that you can specify as the page token in a
     *         subsequent request.
     */
    public String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerLogRequest)) {
            return false;
        }
        GetContainerLogRequest other = (GetContainerLogRequest) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(containerName(), other.containerName())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(filterPattern(), other.filterPattern()) && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetContainerLogRequest").add("ServiceName", serviceName()).add("ContainerName", containerName())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("FilterPattern", filterPattern())
                .add("PageToken", pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "containerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "pageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerLogRequest, T> g) {
        return obj -> g.apply((GetContainerLogRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetContainerLogRequest> {
        /**
         * <p>
         * The name of the container service for which to get a container log.
         * </p>
         * 
         * @param serviceName
         *        The name of the container service for which to get a container log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the container that is either running or previously ran on the container service for which to
         * return a log.
         * </p>
         * 
         * @param containerName
         *        The name of the container that is either running or previously ran on the container service for which
         *        to return a log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The start of the time interval for which to get log data.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify <code>1538424000</code>
         * as the start time.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can convert a human-friendly time to Unix time format using a converter like <a
         * href="https://www.epochconverter.com/">Epoch converter</a>.
         * </p>
         * 
         * @param startTime
         *        The start of the time interval for which to get log data.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
         *        <code>1538424000</code> as the start time.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can convert a human-friendly time to Unix time format using a converter like <a
         *        href="https://www.epochconverter.com/">Epoch converter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time interval for which to get log data.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify <code>1538427600</code>
         * as the end time.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can convert a human-friendly time to Unix time format using a converter like <a
         * href="https://www.epochconverter.com/">Epoch converter</a>.
         * </p>
         * 
         * @param endTime
         *        The end of the time interval for which to get log data.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify
         *        <code>1538427600</code> as the end time.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can convert a human-friendly time to Unix time format using a converter like <a
         *        href="https://www.epochconverter.com/">Epoch converter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The pattern to use to filter the returned log events to a specific term.
         * </p>
         * <p>
         * The following are a few examples of filter patterns that you can specify:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To return all log events, specify a filter pattern of <code>""</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To exclude log events that contain the <code>ERROR</code> term, and return all other log events, specify a
         * filter pattern of <code>"-ERROR"</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To return log events that contain the <code>ERROR</code> term, specify a filter pattern of
         * <code>"ERROR"</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To return log events that contain both the <code>ERROR</code> and <code>Exception</code> terms, specify a
         * filter pattern of <code>"ERROR Exception"</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To return log events that contain the <code>ERROR</code> <i>or</i> the <code>Exception</code> term, specify a
         * filter pattern of <code>"?ERROR ?Exception"</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filterPattern
         *        The pattern to use to filter the returned log events to a specific term.</p>
         *        <p>
         *        The following are a few examples of filter patterns that you can specify:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To return all log events, specify a filter pattern of <code>""</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To exclude log events that contain the <code>ERROR</code> term, and return all other log events,
         *        specify a filter pattern of <code>"-ERROR"</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To return log events that contain the <code>ERROR</code> term, specify a filter pattern of
         *        <code>"ERROR"</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To return log events that contain both the <code>ERROR</code> and <code>Exception</code> terms,
         *        specify a filter pattern of <code>"ERROR Exception"</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To return log events that contain the <code>ERROR</code> <i>or</i> the <code>Exception</code> term,
         *        specify a filter pattern of <code>"?ERROR ?Exception"</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * To get a page token, perform an initial <code>GetContainerLog</code> request. If your results are paginated,
         * the response will return a next page token that you can specify as the page token in a subsequent request.
         * </p>
         * 
         * @param pageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        To get a page token, perform an initial <code>GetContainerLog</code> request. If your results are
         *        paginated, the response will return a next page token that you can specify as the page token in a
         *        subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String serviceName;

        private String containerName;

        private Instant startTime;

        private Instant endTime;

        private String filterPattern;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerLogRequest model) {
            super(model);
            serviceName(model.serviceName);
            containerName(model.containerName);
            startTime(model.startTime);
            endTime(model.endTime);
            filterPattern(model.filterPattern);
            pageToken(model.pageToken);
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getContainerName() {
            return containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetContainerLogRequest build() {
            return new GetContainerLogRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
