/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContainerServiceResponse extends LightsailResponse implements
        ToCopyableBuilder<UpdateContainerServiceResponse.Builder, UpdateContainerServiceResponse> {
    private static final SdkField<ContainerService> CONTAINER_SERVICE_FIELD = SdkField
            .<ContainerService> builder(MarshallingType.SDK_POJO).memberName("containerService")
            .getter(getter(UpdateContainerServiceResponse::containerService)).setter(setter(Builder::containerService))
            .constructor(ContainerService::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerService").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_SERVICE_FIELD));

    private final ContainerService containerService;

    private UpdateContainerServiceResponse(BuilderImpl builder) {
        super(builder);
        this.containerService = builder.containerService;
    }

    /**
     * <p>
     * An object that describes a container service.
     * </p>
     * 
     * @return An object that describes a container service.
     */
    public ContainerService containerService() {
        return containerService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerService());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerServiceResponse)) {
            return false;
        }
        UpdateContainerServiceResponse other = (UpdateContainerServiceResponse) obj;
        return Objects.equals(containerService(), other.containerService());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateContainerServiceResponse").add("ContainerService", containerService()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerService":
            return Optional.ofNullable(clazz.cast(containerService()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerServiceResponse, T> g) {
        return obj -> g.apply((UpdateContainerServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContainerServiceResponse> {
        /**
         * <p>
         * An object that describes a container service.
         * </p>
         * 
         * @param containerService
         *        An object that describes a container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerService(ContainerService containerService);

        /**
         * <p>
         * An object that describes a container service.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerService.Builder} avoiding the need to
         * create one manually via {@link ContainerService#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerService.Builder#build()} is called immediately and its
         * result is passed to {@link #containerService(ContainerService)}.
         * 
         * @param containerService
         *        a consumer that will call methods on {@link ContainerService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerService(ContainerService)
         */
        default Builder containerService(Consumer<ContainerService.Builder> containerService) {
            return containerService(ContainerService.builder().applyMutation(containerService).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private ContainerService containerService;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerServiceResponse model) {
            super(model);
            containerService(model.containerService);
        }

        public final ContainerService.Builder getContainerService() {
            return containerService != null ? containerService.toBuilder() : null;
        }

        @Override
        public final Builder containerService(ContainerService containerService) {
            this.containerService = containerService;
            return this;
        }

        public final void setContainerService(ContainerService.BuilderImpl containerService) {
            this.containerService = containerService != null ? containerService.build() : null;
        }

        @Override
        public UpdateContainerServiceResponse build() {
            return new UpdateContainerServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
