/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContainerServiceRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateContainerServiceRequest.Builder, UpdateContainerServiceRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(UpdateContainerServiceRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> POWER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("power")
            .getter(getter(UpdateContainerServiceRequest::powerAsString)).setter(setter(Builder::power))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("power").build()).build();

    private static final SdkField<Integer> SCALE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("scale")
            .getter(getter(UpdateContainerServiceRequest::scale)).setter(setter(Builder::scale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()).build();

    private static final SdkField<Boolean> IS_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDisabled").getter(getter(UpdateContainerServiceRequest::isDisabled))
            .setter(setter(Builder::isDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDisabled").build()).build();

    private static final SdkField<Map<String, List<String>>> PUBLIC_DOMAIN_NAMES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("publicDomainNames")
            .getter(getter(UpdateContainerServiceRequest::publicDomainNames))
            .setter(setter(Builder::publicDomainNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDomainNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            POWER_FIELD, SCALE_FIELD, IS_DISABLED_FIELD, PUBLIC_DOMAIN_NAMES_FIELD));

    private final String serviceName;

    private final String power;

    private final Integer scale;

    private final Boolean isDisabled;

    private final Map<String, List<String>> publicDomainNames;

    private UpdateContainerServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.power = builder.power;
        this.scale = builder.scale;
        this.isDisabled = builder.isDisabled;
        this.publicDomainNames = builder.publicDomainNames;
    }

    /**
     * <p>
     * The name of the container service to update.
     * </p>
     * 
     * @return The name of the container service to update.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The power for the container service.
     * </p>
     * <p>
     * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The
     * <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine
     * the monthly price of your container service, multiply the base price of the <code>power</code> with the
     * <code>scale</code> (the number of nodes) of the service.
     * </p>
     * <p>
     * Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #power} will return
     * {@link ContainerServicePowerName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerAsString}.
     * </p>
     * 
     * @return The power for the container service.</p>
     *         <p>
     *         The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
     *         service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
     *         capacity. To determine the monthly price of your container service, multiply the base price of the
     *         <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
     *         </p>
     *         <p>
     *         Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
     * @see ContainerServicePowerName
     */
    public ContainerServicePowerName power() {
        return ContainerServicePowerName.fromValue(power);
    }

    /**
     * <p>
     * The power for the container service.
     * </p>
     * <p>
     * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The
     * <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine
     * the monthly price of your container service, multiply the base price of the <code>power</code> with the
     * <code>scale</code> (the number of nodes) of the service.
     * </p>
     * <p>
     * Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #power} will return
     * {@link ContainerServicePowerName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerAsString}.
     * </p>
     * 
     * @return The power for the container service.</p>
     *         <p>
     *         The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
     *         service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
     *         capacity. To determine the monthly price of your container service, multiply the base price of the
     *         <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
     *         </p>
     *         <p>
     *         Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
     * @see ContainerServicePowerName
     */
    public String powerAsString() {
        return power;
    }

    /**
     * <p>
     * The scale for the container service.
     * </p>
     * <p>
     * The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
     * <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of
     * your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the number
     * of nodes) of the service.
     * </p>
     * 
     * @return The scale for the container service.</p>
     *         <p>
     *         The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
     *         <code>scale</code> of a container service makes up its configured capacity. To determine the monthly
     *         price of your container service, multiply the base price of the <code>power</code> with the
     *         <code>scale</code> (the number of nodes) of the service.
     */
    public Integer scale() {
        return scale;
    }

    /**
     * <p>
     * A Boolean value to indicate whether the container service is disabled.
     * </p>
     * 
     * @return A Boolean value to indicate whether the container service is disabled.
     */
    public Boolean isDisabled() {
        return isDisabled;
    }

    /**
     * Returns true if the PublicDomainNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPublicDomainNames() {
        return publicDomainNames != null && !(publicDomainNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The public domain names to use with the container service, such as <code>example.com</code> and
     * <code>www.example.com</code>.
     * </p>
     * <p>
     * You can specify up to four public domain names for a container service. The domain names that you specify are
     * used when you create a deployment with a container configured as the public endpoint of your container service.
     * </p>
     * <p>
     * If you don't specify public domain names, then you can use the default domain of the container service.
     * </p>
     * <important>
     * <p>
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container
     * service. Use the <code>CreateCertificate</code> action to create a certificate for the public domain names you
     * want to use with your container service.
     * </p>
     * </important>
     * <p>
     * You can specify public domain names using a string to array map as shown in the example later on this page.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPublicDomainNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The public domain names to use with the container service, such as <code>example.com</code> and
     *         <code>www.example.com</code>.</p>
     *         <p>
     *         You can specify up to four public domain names for a container service. The domain names that you specify
     *         are used when you create a deployment with a container configured as the public endpoint of your
     *         container service.
     *         </p>
     *         <p>
     *         If you don't specify public domain names, then you can use the default domain of the container service.
     *         </p>
     *         <important>
     *         <p>
     *         You must create and validate an SSL/TLS certificate before you can use public domain names with your
     *         container service. Use the <code>CreateCertificate</code> action to create a certificate for the public
     *         domain names you want to use with your container service.
     *         </p>
     *         </important>
     *         <p>
     *         You can specify public domain names using a string to array map as shown in the example later on this
     *         page.
     */
    public Map<String, List<String>> publicDomainNames() {
        return publicDomainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(powerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        hashCode = 31 * hashCode + Objects.hashCode(isDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicDomainNames() ? publicDomainNames() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerServiceRequest)) {
            return false;
        }
        UpdateContainerServiceRequest other = (UpdateContainerServiceRequest) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(powerAsString(), other.powerAsString())
                && Objects.equals(scale(), other.scale()) && Objects.equals(isDisabled(), other.isDisabled())
                && hasPublicDomainNames() == other.hasPublicDomainNames()
                && Objects.equals(publicDomainNames(), other.publicDomainNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateContainerServiceRequest").add("ServiceName", serviceName()).add("Power", powerAsString())
                .add("Scale", scale()).add("IsDisabled", isDisabled())
                .add("PublicDomainNames", hasPublicDomainNames() ? publicDomainNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "power":
            return Optional.ofNullable(clazz.cast(powerAsString()));
        case "scale":
            return Optional.ofNullable(clazz.cast(scale()));
        case "isDisabled":
            return Optional.ofNullable(clazz.cast(isDisabled()));
        case "publicDomainNames":
            return Optional.ofNullable(clazz.cast(publicDomainNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerServiceRequest, T> g) {
        return obj -> g.apply((UpdateContainerServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContainerServiceRequest> {
        /**
         * <p>
         * The name of the container service to update.
         * </p>
         * 
         * @param serviceName
         *        The name of the container service to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The power for the container service.
         * </p>
         * <p>
         * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service.
         * The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To
         * determine the monthly price of your container service, multiply the base price of the <code>power</code> with
         * the <code>scale</code> (the number of nodes) of the service.
         * </p>
         * <p>
         * Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
         * </p>
         * 
         * @param power
         *        The power for the container service.</p>
         *        <p>
         *        The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
         *        service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
         *        capacity. To determine the monthly price of your container service, multiply the base price of the
         *        <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
         *        </p>
         *        <p>
         *        Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
         * @see ContainerServicePowerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerServicePowerName
         */
        Builder power(String power);

        /**
         * <p>
         * The power for the container service.
         * </p>
         * <p>
         * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service.
         * The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To
         * determine the monthly price of your container service, multiply the base price of the <code>power</code> with
         * the <code>scale</code> (the number of nodes) of the service.
         * </p>
         * <p>
         * Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
         * </p>
         * 
         * @param power
         *        The power for the container service.</p>
         *        <p>
         *        The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
         *        service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
         *        capacity. To determine the monthly price of your container service, multiply the base price of the
         *        <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
         *        </p>
         *        <p>
         *        Use the <code>GetContainerServicePowers</code> action to view the specifications of each power option.
         * @see ContainerServicePowerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerServicePowerName
         */
        Builder power(ContainerServicePowerName power);

        /**
         * <p>
         * The scale for the container service.
         * </p>
         * <p>
         * The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
         * <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of
         * your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the
         * number of nodes) of the service.
         * </p>
         * 
         * @param scale
         *        The scale for the container service.</p>
         *        <p>
         *        The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
         *        <code>scale</code> of a container service makes up its configured capacity. To determine the monthly
         *        price of your container service, multiply the base price of the <code>power</code> with the
         *        <code>scale</code> (the number of nodes) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(Integer scale);

        /**
         * <p>
         * A Boolean value to indicate whether the container service is disabled.
         * </p>
         * 
         * @param isDisabled
         *        A Boolean value to indicate whether the container service is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDisabled(Boolean isDisabled);

        /**
         * <p>
         * The public domain names to use with the container service, such as <code>example.com</code> and
         * <code>www.example.com</code>.
         * </p>
         * <p>
         * You can specify up to four public domain names for a container service. The domain names that you specify are
         * used when you create a deployment with a container configured as the public endpoint of your container
         * service.
         * </p>
         * <p>
         * If you don't specify public domain names, then you can use the default domain of the container service.
         * </p>
         * <important>
         * <p>
         * You must create and validate an SSL/TLS certificate before you can use public domain names with your
         * container service. Use the <code>CreateCertificate</code> action to create a certificate for the public
         * domain names you want to use with your container service.
         * </p>
         * </important>
         * <p>
         * You can specify public domain names using a string to array map as shown in the example later on this page.
         * </p>
         * 
         * @param publicDomainNames
         *        The public domain names to use with the container service, such as <code>example.com</code> and
         *        <code>www.example.com</code>.</p>
         *        <p>
         *        You can specify up to four public domain names for a container service. The domain names that you
         *        specify are used when you create a deployment with a container configured as the public endpoint of
         *        your container service.
         *        </p>
         *        <p>
         *        If you don't specify public domain names, then you can use the default domain of the container
         *        service.
         *        </p>
         *        <important>
         *        <p>
         *        You must create and validate an SSL/TLS certificate before you can use public domain names with your
         *        container service. Use the <code>CreateCertificate</code> action to create a certificate for the
         *        public domain names you want to use with your container service.
         *        </p>
         *        </important>
         *        <p>
         *        You can specify public domain names using a string to array map as shown in the example later on this
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String serviceName;

        private String power;

        private Integer scale;

        private Boolean isDisabled;

        private Map<String, List<String>> publicDomainNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerServiceRequest model) {
            super(model);
            serviceName(model.serviceName);
            power(model.power);
            scale(model.scale);
            isDisabled(model.isDisabled);
            publicDomainNames(model.publicDomainNames);
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getPower() {
            return power;
        }

        @Override
        public final Builder power(String power) {
            this.power = power;
            return this;
        }

        @Override
        public final Builder power(ContainerServicePowerName power) {
            this.power(power == null ? null : power.toString());
            return this;
        }

        public final void setPower(String power) {
            this.power = power;
        }

        public final Integer getScale() {
            return scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final Boolean getIsDisabled() {
            return isDisabled;
        }

        @Override
        public final Builder isDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public final void setIsDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
        }

        public final Map<String, ? extends Collection<String>> getPublicDomainNames() {
            if (publicDomainNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return publicDomainNames;
        }

        @Override
        public final Builder publicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
            return this;
        }

        public final void setPublicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContainerServiceRequest build() {
            return new UpdateContainerServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
