/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteInstanceRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, DeleteInstanceRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(DeleteInstanceRequest.getter(DeleteInstanceRequest::instanceName)).setter(DeleteInstanceRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<Boolean> FORCE_DELETE_ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceDeleteAddOns").getter(DeleteInstanceRequest.getter(DeleteInstanceRequest::forceDeleteAddOns)).setter(DeleteInstanceRequest.setter(Builder::forceDeleteAddOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDeleteAddOns").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD, FORCE_DELETE_ADD_ONS_FIELD));
    private final String instanceName;
    private final Boolean forceDeleteAddOns;

    private DeleteInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.forceDeleteAddOns = builder.forceDeleteAddOns;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public Boolean forceDeleteAddOns() {
        return this.forceDeleteAddOns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDeleteAddOns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceRequest)) {
            return false;
        }
        DeleteInstanceRequest other = (DeleteInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.forceDeleteAddOns(), other.forceDeleteAddOns());
    }

    public String toString() {
        return ToString.builder((String)"DeleteInstanceRequest").add("InstanceName", (Object)this.instanceName()).add("ForceDeleteAddOns", (Object)this.forceDeleteAddOns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "forceDeleteAddOns": {
                return Optional.ofNullable(clazz.cast(this.forceDeleteAddOns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceRequest, T> g) {
        return obj -> g.apply((DeleteInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private Boolean forceDeleteAddOns;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceRequest model) {
            super(model);
            this.instanceName(model.instanceName);
            this.forceDeleteAddOns(model.forceDeleteAddOns);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final Boolean getForceDeleteAddOns() {
            return this.forceDeleteAddOns;
        }

        @Override
        public final Builder forceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
            return this;
        }

        public final void setForceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstanceRequest build() {
            return new DeleteInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteInstanceRequest> {
        public Builder instanceName(String var1);

        public Builder forceDeleteAddOns(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

