/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDistributionBundlesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDistributionBundlesResponse.Builder, GetDistributionBundlesResponse> {
    private static final SdkField<List<DistributionBundle>> BUNDLES_FIELD = SdkField
            .<List<DistributionBundle>> builder(MarshallingType.LIST)
            .memberName("bundles")
            .getter(getter(GetDistributionBundlesResponse::bundles))
            .setter(setter(Builder::bundles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DistributionBundle> builder(MarshallingType.SDK_POJO)
                                            .constructor(DistributionBundle::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLES_FIELD));

    private final List<DistributionBundle> bundles;

    private GetDistributionBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
    }

    /**
     * Returns true if the Bundles property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBundles() {
        return bundles != null && !(bundles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that describes a distribution bundle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBundles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that describes a distribution bundle.
     */
    public List<DistributionBundle> bundles() {
        return bundles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBundles() ? bundles() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionBundlesResponse)) {
            return false;
        }
        GetDistributionBundlesResponse other = (GetDistributionBundlesResponse) obj;
        return hasBundles() == other.hasBundles() && Objects.equals(bundles(), other.bundles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDistributionBundlesResponse").add("Bundles", hasBundles() ? bundles() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundles":
            return Optional.ofNullable(clazz.cast(bundles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionBundlesResponse, T> g) {
        return obj -> g.apply((GetDistributionBundlesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDistributionBundlesResponse> {
        /**
         * <p>
         * An object that describes a distribution bundle.
         * </p>
         * 
         * @param bundles
         *        An object that describes a distribution bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(Collection<DistributionBundle> bundles);

        /**
         * <p>
         * An object that describes a distribution bundle.
         * </p>
         * 
         * @param bundles
         *        An object that describes a distribution bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(DistributionBundle... bundles);

        /**
         * <p>
         * An object that describes a distribution bundle.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DistributionBundle>.Builder} avoiding the
         * need to create one manually via {@link List<DistributionBundle>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DistributionBundle>.Builder#build()} is called immediately
         * and its result is passed to {@link #bundles(List<DistributionBundle>)}.
         * 
         * @param bundles
         *        a consumer that will call methods on {@link List<DistributionBundle>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundles(List<DistributionBundle>)
         */
        Builder bundles(Consumer<DistributionBundle.Builder>... bundles);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<DistributionBundle> bundles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionBundlesResponse model) {
            super(model);
            bundles(model.bundles);
        }

        public final Collection<DistributionBundle.Builder> getBundles() {
            if (bundles instanceof SdkAutoConstructList) {
                return null;
            }
            return bundles != null ? bundles.stream().map(DistributionBundle::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bundles(Collection<DistributionBundle> bundles) {
            this.bundles = DistributionBundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(DistributionBundle... bundles) {
            bundles(Arrays.asList(bundles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Consumer<DistributionBundle.Builder>... bundles) {
            bundles(Stream.of(bundles).map(c -> DistributionBundle.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBundles(Collection<DistributionBundle.BuilderImpl> bundles) {
            this.bundles = DistributionBundleListCopier.copyFromBuilder(bundles);
        }

        @Override
        public GetDistributionBundlesResponse build() {
            return new GetDistributionBundlesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
