/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the specifications of a distribution bundle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionBundle implements SdkPojo, Serializable,
        ToCopyableBuilder<DistributionBundle.Builder, DistributionBundle> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(DistributionBundle::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DistributionBundle::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Float> PRICE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("price")
            .getter(getter(DistributionBundle::price)).setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()).build();

    private static final SdkField<Integer> TRANSFER_PER_MONTH_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("transferPerMonthInGb").getter(getter(DistributionBundle::transferPerMonthInGb))
            .setter(setter(Builder::transferPerMonthInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferPerMonthInGb").build())
            .build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(DistributionBundle::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, NAME_FIELD,
            PRICE_FIELD, TRANSFER_PER_MONTH_IN_GB_FIELD, IS_ACTIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bundleId;

    private final String name;

    private final Float price;

    private final Integer transferPerMonthInGb;

    private final Boolean isActive;

    private DistributionBundle(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.name = builder.name;
        this.price = builder.price;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
        this.isActive = builder.isActive;
    }

    /**
     * <p>
     * The ID of the bundle.
     * </p>
     * 
     * @return The ID of the bundle.
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The name of the distribution bundle.
     * </p>
     * 
     * @return The name of the distribution bundle.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The monthly price, in US dollars, of the bundle.
     * </p>
     * 
     * @return The monthly price, in US dollars, of the bundle.
     */
    public Float price() {
        return price;
    }

    /**
     * <p>
     * The monthly network transfer quota of the bundle.
     * </p>
     * 
     * @return The monthly network transfer quota of the bundle.
     */
    public Integer transferPerMonthInGb() {
        return transferPerMonthInGb;
    }

    /**
     * <p>
     * Indicates whether the bundle is active, and can be specified for a new distribution.
     * </p>
     * 
     * @return Indicates whether the bundle is active, and can be specified for a new distribution.
     */
    public Boolean isActive() {
        return isActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(transferPerMonthInGb());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionBundle)) {
            return false;
        }
        DistributionBundle other = (DistributionBundle) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(name(), other.name())
                && Objects.equals(price(), other.price()) && Objects.equals(transferPerMonthInGb(), other.transferPerMonthInGb())
                && Objects.equals(isActive(), other.isActive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DistributionBundle").add("BundleId", bundleId()).add("Name", name()).add("Price", price())
                .add("TransferPerMonthInGb", transferPerMonthInGb()).add("IsActive", isActive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "price":
            return Optional.ofNullable(clazz.cast(price()));
        case "transferPerMonthInGb":
            return Optional.ofNullable(clazz.cast(transferPerMonthInGb()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DistributionBundle, T> g) {
        return obj -> g.apply((DistributionBundle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistributionBundle> {
        /**
         * <p>
         * The ID of the bundle.
         * </p>
         * 
         * @param bundleId
         *        The ID of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The name of the distribution bundle.
         * </p>
         * 
         * @param name
         *        The name of the distribution bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The monthly price, in US dollars, of the bundle.
         * </p>
         * 
         * @param price
         *        The monthly price, in US dollars, of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Float price);

        /**
         * <p>
         * The monthly network transfer quota of the bundle.
         * </p>
         * 
         * @param transferPerMonthInGb
         *        The monthly network transfer quota of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferPerMonthInGb(Integer transferPerMonthInGb);

        /**
         * <p>
         * Indicates whether the bundle is active, and can be specified for a new distribution.
         * </p>
         * 
         * @param isActive
         *        Indicates whether the bundle is active, and can be specified for a new distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private String name;

        private Float price;

        private Integer transferPerMonthInGb;

        private Boolean isActive;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionBundle model) {
            bundleId(model.bundleId);
            name(model.name);
            price(model.price);
            transferPerMonthInGb(model.transferPerMonthInGb);
            isActive(model.isActive);
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Float getPrice() {
            return price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Integer getTransferPerMonthInGb() {
            return transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public DistributionBundle build() {
            return new DistributionBundle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
