/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.NetworkProtocol;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortInfo> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("fromPort").getter(PortInfo.getter(PortInfo::fromPort)).setter(PortInfo.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPort").build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("toPort").getter(PortInfo.getter(PortInfo::toPort)).setter(PortInfo.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(PortInfo.getter(PortInfo::protocolAsString)).setter(PortInfo.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cidrs").getter(PortInfo.getter(PortInfo::cidrs)).setter(PortInfo.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CIDR_LIST_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cidrListAliases").getter(PortInfo.getter(PortInfo::cidrListAliases)).setter(PortInfo.setter(Builder::cidrListAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrListAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD, TO_PORT_FIELD, PROTOCOL_FIELD, CIDRS_FIELD, CIDR_LIST_ALIASES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fromPort;
    private final Integer toPort;
    private final String protocol;
    private final List<String> cidrs;
    private final List<String> cidrListAliases;

    private PortInfo(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.cidrs = builder.cidrs;
        this.cidrListAliases = builder.cidrListAliases;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public List<String> cidrs() {
        return this.cidrs;
    }

    public boolean hasCidrListAliases() {
        return this.cidrListAliases != null && !(this.cidrListAliases instanceof SdkAutoConstructList);
    }

    public List<String> cidrListAliases() {
        return this.cidrListAliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrs() ? this.cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrListAliases() ? this.cidrListAliases() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortInfo)) {
            return false;
        }
        PortInfo other = (PortInfo)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasCidrs() == other.hasCidrs() && Objects.equals(this.cidrs(), other.cidrs()) && this.hasCidrListAliases() == other.hasCidrListAliases() && Objects.equals(this.cidrListAliases(), other.cidrListAliases());
    }

    public String toString() {
        return ToString.builder((String)"PortInfo").add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).add("Protocol", (Object)this.protocolAsString()).add("Cidrs", this.hasCidrs() ? this.cidrs() : null).add("CidrListAliases", this.hasCidrListAliases() ? this.cidrListAliases() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "toPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
            case "cidrListAliases": {
                return Optional.ofNullable(clazz.cast(this.cidrListAliases()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortInfo, T> g) {
        return obj -> g.apply((PortInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String protocol;
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();
        private List<String> cidrListAliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortInfo model) {
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.protocol(model.protocol);
            this.cidrs(model.cidrs);
            this.cidrListAliases(model.cidrListAliases);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Collection<String> getCidrs() {
            if (this.cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrs;
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
        }

        public final Collection<String> getCidrListAliases() {
            if (this.cidrListAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrListAliases;
        }

        @Override
        public final Builder cidrListAliases(Collection<String> cidrListAliases) {
            this.cidrListAliases = StringListCopier.copy(cidrListAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrListAliases(String ... cidrListAliases) {
            this.cidrListAliases(Arrays.asList(cidrListAliases));
            return this;
        }

        public final void setCidrListAliases(Collection<String> cidrListAliases) {
            this.cidrListAliases = StringListCopier.copy(cidrListAliases);
        }

        public PortInfo build() {
            return new PortInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortInfo> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(NetworkProtocol var1);

        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);

        public Builder cidrListAliases(Collection<String> var1);

        public Builder cidrListAliases(String ... var1);
    }
}

