/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiskSnapshotsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDiskSnapshotsResponse.Builder, GetDiskSnapshotsResponse> {
    private static final SdkField<List<DiskSnapshot>> DISK_SNAPSHOTS_FIELD = SdkField
            .<List<DiskSnapshot>> builder(MarshallingType.LIST)
            .memberName("diskSnapshots")
            .getter(getter(GetDiskSnapshotsResponse::diskSnapshots))
            .setter(setter(Builder::diskSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DiskSnapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(DiskSnapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetDiskSnapshotsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_SNAPSHOTS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<DiskSnapshot> diskSnapshots;

    private final String nextPageToken;

    private GetDiskSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.diskSnapshots = builder.diskSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the DiskSnapshots property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDiskSnapshots() {
        return diskSnapshots != null && !(diskSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects containing information about all block storage disk snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDiskSnapshots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects containing information about all block storage disk snapshots.
     */
    public List<DiskSnapshot> diskSnapshots() {
        return diskSnapshots;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetDiskSnapshots</code> request and specify the next page
     * token using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetDiskSnapshots</code> request and specify the
     *         next page token using the <code>pageToken</code> parameter.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDiskSnapshots() ? diskSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiskSnapshotsResponse)) {
            return false;
        }
        GetDiskSnapshotsResponse other = (GetDiskSnapshotsResponse) obj;
        return hasDiskSnapshots() == other.hasDiskSnapshots() && Objects.equals(diskSnapshots(), other.diskSnapshots())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDiskSnapshotsResponse").add("DiskSnapshots", hasDiskSnapshots() ? diskSnapshots() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskSnapshots":
            return Optional.ofNullable(clazz.cast(diskSnapshots()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiskSnapshotsResponse, T> g) {
        return obj -> g.apply((GetDiskSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDiskSnapshotsResponse> {
        /**
         * <p>
         * An array of objects containing information about all block storage disk snapshots.
         * </p>
         * 
         * @param diskSnapshots
         *        An array of objects containing information about all block storage disk snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshots(Collection<DiskSnapshot> diskSnapshots);

        /**
         * <p>
         * An array of objects containing information about all block storage disk snapshots.
         * </p>
         * 
         * @param diskSnapshots
         *        An array of objects containing information about all block storage disk snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshots(DiskSnapshot... diskSnapshots);

        /**
         * <p>
         * An array of objects containing information about all block storage disk snapshots.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DiskSnapshot>.Builder} avoiding the need to
         * create one manually via {@link List<DiskSnapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DiskSnapshot>.Builder#build()} is called immediately and its
         * result is passed to {@link #diskSnapshots(List<DiskSnapshot>)}.
         * 
         * @param diskSnapshots
         *        a consumer that will call methods on {@link List<DiskSnapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskSnapshots(List<DiskSnapshot>)
         */
        Builder diskSnapshots(Consumer<DiskSnapshot.Builder>... diskSnapshots);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetDiskSnapshots</code> request and specify the next
         * page token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetDiskSnapshots</code> request and specify the
         *        next page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<DiskSnapshot> diskSnapshots = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiskSnapshotsResponse model) {
            super(model);
            diskSnapshots(model.diskSnapshots);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<DiskSnapshot.Builder> getDiskSnapshots() {
            if (diskSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return diskSnapshots != null ? diskSnapshots.stream().map(DiskSnapshot::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder diskSnapshots(Collection<DiskSnapshot> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copy(diskSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskSnapshots(DiskSnapshot... diskSnapshots) {
            diskSnapshots(Arrays.asList(diskSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskSnapshots(Consumer<DiskSnapshot.Builder>... diskSnapshots) {
            diskSnapshots(Stream.of(diskSnapshots).map(c -> DiskSnapshot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDiskSnapshots(Collection<DiskSnapshot.BuilderImpl> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copyFromBuilder(diskSnapshots);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDiskSnapshotsResponse build() {
            return new GetDiskSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
