/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerServiceRegistryLoginResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateContainerServiceRegistryLoginResponse.Builder, CreateContainerServiceRegistryLoginResponse> {
    private static final SdkField<ContainerServiceRegistryLogin> REGISTRY_LOGIN_FIELD = SdkField
            .<ContainerServiceRegistryLogin> builder(MarshallingType.SDK_POJO).memberName("registryLogin")
            .getter(getter(CreateContainerServiceRegistryLoginResponse::registryLogin)).setter(setter(Builder::registryLogin))
            .constructor(ContainerServiceRegistryLogin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryLogin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_LOGIN_FIELD));

    private final ContainerServiceRegistryLogin registryLogin;

    private CreateContainerServiceRegistryLoginResponse(BuilderImpl builder) {
        super(builder);
        this.registryLogin = builder.registryLogin;
    }

    /**
     * <p>
     * An object that describes the log in information for the container service registry of your Lightsail account.
     * </p>
     * 
     * @return An object that describes the log in information for the container service registry of your Lightsail
     *         account.
     */
    public ContainerServiceRegistryLogin registryLogin() {
        return registryLogin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryLogin());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerServiceRegistryLoginResponse)) {
            return false;
        }
        CreateContainerServiceRegistryLoginResponse other = (CreateContainerServiceRegistryLoginResponse) obj;
        return Objects.equals(registryLogin(), other.registryLogin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateContainerServiceRegistryLoginResponse").add("RegistryLogin", registryLogin()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryLogin":
            return Optional.ofNullable(clazz.cast(registryLogin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerServiceRegistryLoginResponse, T> g) {
        return obj -> g.apply((CreateContainerServiceRegistryLoginResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateContainerServiceRegistryLoginResponse> {
        /**
         * <p>
         * An object that describes the log in information for the container service registry of your Lightsail account.
         * </p>
         * 
         * @param registryLogin
         *        An object that describes the log in information for the container service registry of your Lightsail
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryLogin(ContainerServiceRegistryLogin registryLogin);

        /**
         * <p>
         * An object that describes the log in information for the container service registry of your Lightsail account.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerServiceRegistryLogin.Builder} avoiding
         * the need to create one manually via {@link ContainerServiceRegistryLogin#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerServiceRegistryLogin.Builder#build()} is called
         * immediately and its result is passed to {@link #registryLogin(ContainerServiceRegistryLogin)}.
         * 
         * @param registryLogin
         *        a consumer that will call methods on {@link ContainerServiceRegistryLogin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryLogin(ContainerServiceRegistryLogin)
         */
        default Builder registryLogin(Consumer<ContainerServiceRegistryLogin.Builder> registryLogin) {
            return registryLogin(ContainerServiceRegistryLogin.builder().applyMutation(registryLogin).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private ContainerServiceRegistryLogin registryLogin;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerServiceRegistryLoginResponse model) {
            super(model);
            registryLogin(model.registryLogin);
        }

        public final ContainerServiceRegistryLogin.Builder getRegistryLogin() {
            return registryLogin != null ? registryLogin.toBuilder() : null;
        }

        @Override
        public final Builder registryLogin(ContainerServiceRegistryLogin registryLogin) {
            this.registryLogin = registryLogin;
            return this;
        }

        public final void setRegistryLogin(ContainerServiceRegistryLogin.BuilderImpl registryLogin) {
            this.registryLogin = registryLogin != null ? registryLogin.build() : null;
        }

        @Override
        public CreateContainerServiceRegistryLoginResponse build() {
            return new CreateContainerServiceRegistryLoginResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
