/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the parameters of a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalDatabaseParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalDatabaseParameter.Builder, RelationalDatabaseParameter> {
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("allowedValues").getter(getter(RelationalDatabaseParameter::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build()).build();

    private static final SdkField<String> APPLY_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applyMethod").getter(getter(RelationalDatabaseParameter::applyMethod))
            .setter(setter(Builder::applyMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyMethod").build()).build();

    private static final SdkField<String> APPLY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applyType").getter(getter(RelationalDatabaseParameter::applyType)).setter(setter(Builder::applyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyType").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(RelationalDatabaseParameter::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RelationalDatabaseParameter::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isModifiable").getter(getter(RelationalDatabaseParameter::isModifiable))
            .setter(setter(Builder::isModifiable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isModifiable").build()).build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterName").getter(getter(RelationalDatabaseParameter::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterName").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterValue").getter(getter(RelationalDatabaseParameter::parameterValue))
            .setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD,
            APPLY_METHOD_FIELD, APPLY_TYPE_FIELD, DATA_TYPE_FIELD, DESCRIPTION_FIELD, IS_MODIFIABLE_FIELD, PARAMETER_NAME_FIELD,
            PARAMETER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allowedValues;

    private final String applyMethod;

    private final String applyType;

    private final String dataType;

    private final String description;

    private final Boolean isModifiable;

    private final String parameterName;

    private final String parameterValue;

    private RelationalDatabaseParameter(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.applyMethod = builder.applyMethod;
        this.applyType = builder.applyType;
        this.dataType = builder.dataType;
        this.description = builder.description;
        this.isModifiable = builder.isModifiable;
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * Specifies the valid range of values for the parameter.
     * </p>
     * 
     * @return Specifies the valid range of values for the parameter.
     */
    public String allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * Indicates when parameter updates are applied.
     * </p>
     * <p>
     * Can be <code>immediate</code> or <code>pending-reboot</code>.
     * </p>
     * 
     * @return Indicates when parameter updates are applied.</p>
     *         <p>
     *         Can be <code>immediate</code> or <code>pending-reboot</code>.
     */
    public String applyMethod() {
        return applyMethod;
    }

    /**
     * <p>
     * Specifies the engine-specific parameter type.
     * </p>
     * 
     * @return Specifies the engine-specific parameter type.
     */
    public String applyType() {
        return applyType;
    }

    /**
     * <p>
     * Specifies the valid data type for the parameter.
     * </p>
     * 
     * @return Specifies the valid data type for the parameter.
     */
    public String dataType() {
        return dataType;
    }

    /**
     * <p>
     * Provides a description of the parameter.
     * </p>
     * 
     * @return Provides a description of the parameter.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A Boolean value indicating whether the parameter can be modified.
     * </p>
     * 
     * @return A Boolean value indicating whether the parameter can be modified.
     */
    public Boolean isModifiable() {
        return isModifiable;
    }

    /**
     * <p>
     * Specifies the name of the parameter.
     * </p>
     * 
     * @return Specifies the name of the parameter.
     */
    public String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * Specifies the value of the parameter.
     * </p>
     * 
     * @return Specifies the value of the parameter.
     */
    public String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(applyMethod());
        hashCode = 31 * hashCode + Objects.hashCode(applyType());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseParameter)) {
            return false;
        }
        RelationalDatabaseParameter other = (RelationalDatabaseParameter) obj;
        return Objects.equals(allowedValues(), other.allowedValues()) && Objects.equals(applyMethod(), other.applyMethod())
                && Objects.equals(applyType(), other.applyType()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(description(), other.description()) && Objects.equals(isModifiable(), other.isModifiable())
                && Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(parameterValue(), other.parameterValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RelationalDatabaseParameter").add("AllowedValues", allowedValues())
                .add("ApplyMethod", applyMethod()).add("ApplyType", applyType()).add("DataType", dataType())
                .add("Description", description()).add("IsModifiable", isModifiable()).add("ParameterName", parameterName())
                .add("ParameterValue", parameterValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "applyMethod":
            return Optional.ofNullable(clazz.cast(applyMethod()));
        case "applyType":
            return Optional.ofNullable(clazz.cast(applyType()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "isModifiable":
            return Optional.ofNullable(clazz.cast(isModifiable()));
        case "parameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "parameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseParameter, T> g) {
        return obj -> g.apply((RelationalDatabaseParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalDatabaseParameter> {
        /**
         * <p>
         * Specifies the valid range of values for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        Specifies the valid range of values for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String allowedValues);

        /**
         * <p>
         * Indicates when parameter updates are applied.
         * </p>
         * <p>
         * Can be <code>immediate</code> or <code>pending-reboot</code>.
         * </p>
         * 
         * @param applyMethod
         *        Indicates when parameter updates are applied.</p>
         *        <p>
         *        Can be <code>immediate</code> or <code>pending-reboot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyMethod(String applyMethod);

        /**
         * <p>
         * Specifies the engine-specific parameter type.
         * </p>
         * 
         * @param applyType
         *        Specifies the engine-specific parameter type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyType(String applyType);

        /**
         * <p>
         * Specifies the valid data type for the parameter.
         * </p>
         * 
         * @param dataType
         *        Specifies the valid data type for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * Provides a description of the parameter.
         * </p>
         * 
         * @param description
         *        Provides a description of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A Boolean value indicating whether the parameter can be modified.
         * </p>
         * 
         * @param isModifiable
         *        A Boolean value indicating whether the parameter can be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isModifiable(Boolean isModifiable);

        /**
         * <p>
         * Specifies the name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        Specifies the name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * Specifies the value of the parameter.
         * </p>
         * 
         * @param parameterValue
         *        Specifies the value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String allowedValues;

        private String applyMethod;

        private String applyType;

        private String dataType;

        private String description;

        private Boolean isModifiable;

        private String parameterName;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseParameter model) {
            allowedValues(model.allowedValues);
            applyMethod(model.applyMethod);
            applyType(model.applyType);
            dataType(model.dataType);
            description(model.description);
            isModifiable(model.isModifiable);
            parameterName(model.parameterName);
            parameterValue(model.parameterValue);
        }

        public final String getAllowedValues() {
            return allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final String getApplyMethod() {
            return applyMethod;
        }

        @Override
        public final Builder applyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
            return this;
        }

        public final void setApplyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
        }

        public final String getApplyType() {
            return applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIsModifiable() {
            return isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getParameterName() {
            return parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public RelationalDatabaseParameter build() {
            return new RelationalDatabaseParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
