/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;
import software.amazon.awssdk.services.lightsail.model.MetricDatapointListCopier;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseMetricDataResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabaseMetricDataResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(GetRelationalDatabaseMetricDataResponse.getter(GetRelationalDatabaseMetricDataResponse::metricNameAsString)).setter(GetRelationalDatabaseMetricDataResponse.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<List<MetricDatapoint>> METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricData").getter(GetRelationalDatabaseMetricDataResponse.getter(GetRelationalDatabaseMetricDataResponse::metricData)).setter(GetRelationalDatabaseMetricDataResponse.setter(Builder::metricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDatapoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, METRIC_DATA_FIELD));
    private final String metricName;
    private final List<MetricDatapoint> metricData;

    private GetRelationalDatabaseMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    public RelationalDatabaseMetricName metricName() {
        return RelationalDatabaseMetricName.fromValue(this.metricName);
    }

    public String metricNameAsString() {
        return this.metricName;
    }

    public boolean hasMetricData() {
        return this.metricData != null && !(this.metricData instanceof SdkAutoConstructList);
    }

    public List<MetricDatapoint> metricData() {
        return this.metricData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseMetricDataResponse)) {
            return false;
        }
        GetRelationalDatabaseMetricDataResponse other = (GetRelationalDatabaseMetricDataResponse)((Object)obj);
        return Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.metricData(), other.metricData());
    }

    public String toString() {
        return ToString.builder((String)"GetRelationalDatabaseMetricDataResponse").add("MetricName", (Object)this.metricNameAsString()).add("MetricData", this.metricData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "metricData": {
                return Optional.ofNullable(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseMetricDataResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private String metricName;
        private List<MetricDatapoint> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseMetricDataResponse model) {
            super(model);
            this.metricName(model.metricName);
            this.metricData(model.metricData);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(RelationalDatabaseMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<MetricDatapoint.Builder> getMetricData() {
            return this.metricData != null ? (Collection)this.metricData.stream().map(MetricDatapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatapoint.Builder> ... metricData) {
            this.metricData(Stream.of(metricData).map(c -> (MetricDatapoint)((MetricDatapoint.Builder)MetricDatapoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricData(Collection<MetricDatapoint.BuilderImpl> metricData) {
            this.metricData = MetricDatapointListCopier.copyFromBuilder(metricData);
        }

        @Override
        public GetRelationalDatabaseMetricDataResponse build() {
            return new GetRelationalDatabaseMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseMetricDataResponse> {
        public Builder metricName(String var1);

        public Builder metricName(RelationalDatabaseMetricName var1);

        public Builder metricData(Collection<MetricDatapoint> var1);

        public Builder metricData(MetricDatapoint ... var1);

        public Builder metricData(Consumer<MetricDatapoint.Builder> ... var1);
    }
}

