/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRelationalDatabaseRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateRelationalDatabaseRequest.Builder, CreateRelationalDatabaseRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseName").getter(getter(CreateRelationalDatabaseRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateRelationalDatabaseRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseBlueprintId")
            .getter(getter(CreateRelationalDatabaseRequest::relationalDatabaseBlueprintId))
            .setter(setter(Builder::relationalDatabaseBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBlueprintId")
                    .build()).build();

    private static final SdkField<String> RELATIONAL_DATABASE_BUNDLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseBundleId")
            .getter(getter(CreateRelationalDatabaseRequest::relationalDatabaseBundleId))
            .setter(setter(Builder::relationalDatabaseBundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBundleId").build())
            .build();

    private static final SdkField<String> MASTER_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("masterDatabaseName").getter(getter(CreateRelationalDatabaseRequest::masterDatabaseName))
            .setter(setter(Builder::masterDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterDatabaseName").build())
            .build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("masterUsername").getter(getter(CreateRelationalDatabaseRequest::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUsername").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("masterUserPassword").getter(getter(CreateRelationalDatabaseRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUserPassword").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preferredBackupWindow").getter(getter(CreateRelationalDatabaseRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("preferredMaintenanceWindow")
            .getter(getter(CreateRelationalDatabaseRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(CreateRelationalDatabaseRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRelationalDatabaseRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, AVAILABILITY_ZONE_FIELD, RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD,
            RELATIONAL_DATABASE_BUNDLE_ID_FIELD, MASTER_DATABASE_NAME_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD));

    private final String relationalDatabaseName;

    private final String availabilityZone;

    private final String relationalDatabaseBlueprintId;

    private final String relationalDatabaseBundleId;

    private final String masterDatabaseName;

    private final String masterUsername;

    private final String masterUserPassword;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean publiclyAccessible;

    private final List<Tag> tags;

    private CreateRelationalDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.availabilityZone = builder.availabilityZone;
        this.relationalDatabaseBlueprintId = builder.relationalDatabaseBlueprintId;
        this.relationalDatabaseBundleId = builder.relationalDatabaseBundleId;
        this.masterDatabaseName = builder.masterDatabaseName;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name to use for your new database.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 2 to 255 alphanumeric characters, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first and last character must be a letter or number.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name to use for your new database.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 2 to 255 alphanumeric characters, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first and last character must be a letter or number.
     *         </p>
     *         </li>
     */
    public final String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive
     * format.
     * </p>
     * <p>
     * You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the
     * <code>include relational database Availability Zones</code> parameter to your request.
     * </p>
     * 
     * @return The Availability Zone in which to create your new database. Use the <code>us-east-2a</code>
     *         case-sensitive format.</p>
     *         <p>
     *         You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add
     *         the <code>include relational database Availability Zones</code> parameter to your request.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The blueprint ID for your new database. A blueprint describes the major engine version of a database.
     * </p>
     * <p>
     * You can get a list of database blueprints IDs by using the <code>get relational database blueprints</code>
     * operation.
     * </p>
     * 
     * @return The blueprint ID for your new database. A blueprint describes the major engine version of a database.</p>
     *         <p>
     *         You can get a list of database blueprints IDs by using the
     *         <code>get relational database blueprints</code> operation.
     */
    public final String relationalDatabaseBlueprintId() {
        return relationalDatabaseBlueprintId;
    }

    /**
     * <p>
     * The bundle ID for your new database. A bundle describes the performance specifications for your database.
     * </p>
     * <p>
     * You can get a list of database bundle IDs by using the <code>get relational database bundles</code> operation.
     * </p>
     * 
     * @return The bundle ID for your new database. A bundle describes the performance specifications for your
     *         database.</p>
     *         <p>
     *         You can get a list of database bundle IDs by using the <code>get relational database bundles</code>
     *         operation.
     */
    public final String relationalDatabaseBundleId() {
        return relationalDatabaseBundleId;
    }

    /**
     * <p>
     * The name of the master database created when the Lightsail database resource is created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 64 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be a word reserved by the specified database engine
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the master database created when the Lightsail database resource is created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 64 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be a word reserved by the specified database engine
     *         </p>
     *         </li>
     */
    public final String masterDatabaseName() {
        return masterDatabaseName;
    }

    /**
     * <p>
     * The master user name for your new database.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Master user name is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain from 1 to 16 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be a reserved word for the database engine you choose.
     * </p>
     * <p>
     * For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for
     * <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> or <a
     * href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> respectively.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The master user name for your new database.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Master user name is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain from 1 to 16 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be a reserved word for the database engine you choose.
     *         </p>
     *         <p>
     *         For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words
     *         articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> or <a
     *         href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> respectively.
     *         </p>
     *         </li>
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The password for the master user of your new database. The password can include any printable ASCII character
     * except "/", """, or "@".
     * </p>
     * <p>
     * Constraints: Must contain 8 to 41 characters.
     * </p>
     * 
     * @return The password for the master user of your new database. The password can include any printable ASCII
     *         character except "/", """, or "@".</p>
     *         <p>
     *         Constraints: Must contain 8 to 41 characters.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created for your new database if automated backups are
     * enabled.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. For more
     * information about the preferred backup window time blocks for each region, see the <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     * >Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>hh24:mi-hh24:mi</code> format.
     * </p>
     * <p>
     * Example: <code>16:00-16:30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created for your new database if automated
     *         backups are enabled.</p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
     *         For more information about the preferred backup window time blocks for each region, see the <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
     *         >Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>hh24:mi-hh24:mi</code> format.
     *         </p>
     *         <p>
     *         Example: <code>16:00-16:30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur on your new database.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: <code>Tue:17:00-Tue:17:30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The weekly time range during which system maintenance can occur on your new database.</p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *         occurring on a random day of the week.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: <code>Tue:17:00-Tue:17:30</code>
     *         </p>
     *         </li>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database that
     * is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database
     * that is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @return Specifies the accessibility options for your new database. A value of <code>true</code> specifies a
     *         database that is available to resources outside of your Lightsail account. A value of <code>false</code>
     *         specifies a database that is available only to your Lightsail resources in the same region as your
     *         database.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(masterDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelationalDatabaseRequest)) {
            return false;
        }
        CreateRelationalDatabaseRequest other = (CreateRelationalDatabaseRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(relationalDatabaseBlueprintId(), other.relationalDatabaseBlueprintId())
                && Objects.equals(relationalDatabaseBundleId(), other.relationalDatabaseBundleId())
                && Objects.equals(masterDatabaseName(), other.masterDatabaseName())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRelationalDatabaseRequest").add("RelationalDatabaseName", relationalDatabaseName())
                .add("AvailabilityZone", availabilityZone())
                .add("RelationalDatabaseBlueprintId", relationalDatabaseBlueprintId())
                .add("RelationalDatabaseBundleId", relationalDatabaseBundleId()).add("MasterDatabaseName", masterDatabaseName())
                .add("MasterUsername", masterUsername())
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("PubliclyAccessible", publiclyAccessible())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "relationalDatabaseBlueprintId":
            return Optional.ofNullable(clazz.cast(relationalDatabaseBlueprintId()));
        case "relationalDatabaseBundleId":
            return Optional.ofNullable(clazz.cast(relationalDatabaseBundleId()));
        case "masterDatabaseName":
            return Optional.ofNullable(clazz.cast(masterDatabaseName()));
        case "masterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "masterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "preferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRelationalDatabaseRequest, T> g) {
        return obj -> g.apply((CreateRelationalDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRelationalDatabaseRequest> {
        /**
         * <p>
         * The name to use for your new database.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 2 to 255 alphanumeric characters, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first and last character must be a letter or number.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relationalDatabaseName
         *        The name to use for your new database.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 2 to 255 alphanumeric characters, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first and last character must be a letter or number.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive
         * format.
         * </p>
         * <p>
         * You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the
         * <code>include relational database Availability Zones</code> parameter to your request.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to create your new database. Use the <code>us-east-2a</code>
         *        case-sensitive format.</p>
         *        <p>
         *        You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to
         *        add the <code>include relational database Availability Zones</code> parameter to your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The blueprint ID for your new database. A blueprint describes the major engine version of a database.
         * </p>
         * <p>
         * You can get a list of database blueprints IDs by using the <code>get relational database blueprints</code>
         * operation.
         * </p>
         * 
         * @param relationalDatabaseBlueprintId
         *        The blueprint ID for your new database. A blueprint describes the major engine version of a
         *        database.</p>
         *        <p>
         *        You can get a list of database blueprints IDs by using the
         *        <code>get relational database blueprints</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseBlueprintId(String relationalDatabaseBlueprintId);

        /**
         * <p>
         * The bundle ID for your new database. A bundle describes the performance specifications for your database.
         * </p>
         * <p>
         * You can get a list of database bundle IDs by using the <code>get relational database bundles</code>
         * operation.
         * </p>
         * 
         * @param relationalDatabaseBundleId
         *        The bundle ID for your new database. A bundle describes the performance specifications for your
         *        database.</p>
         *        <p>
         *        You can get a list of database bundle IDs by using the <code>get relational database bundles</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseBundleId(String relationalDatabaseBundleId);

        /**
         * <p>
         * The name of the master database created when the Lightsail database resource is created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 64 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be a word reserved by the specified database engine
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterDatabaseName
         *        The name of the master database created when the Lightsail database resource is created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 64 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be a word reserved by the specified database engine
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterDatabaseName(String masterDatabaseName);

        /**
         * <p>
         * The master user name for your new database.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Master user name is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain from 1 to 16 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be a reserved word for the database engine you choose.
         * </p>
         * <p>
         * For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles
         * for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> or <a
         * href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> respectively.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUsername
         *        The master user name for your new database.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Master user name is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain from 1 to 16 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be a reserved word for the database engine you choose.
         *        </p>
         *        <p>
         *        For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words
         *        articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> or <a
         *        href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> respectively.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The password for the master user of your new database. The password can include any printable ASCII character
         * except "/", """, or "@".
         * </p>
         * <p>
         * Constraints: Must contain 8 to 41 characters.
         * </p>
         * 
         * @param masterUserPassword
         *        The password for the master user of your new database. The password can include any printable ASCII
         *        character except "/", """, or "@".</p>
         *        <p>
         *        Constraints: Must contain 8 to 41 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The daily time range during which automated backups are created for your new database if automated backups
         * are enabled.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. For
         * more information about the preferred backup window time blocks for each region, see the <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         * >Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the <code>hh24:mi-hh24:mi</code> format.
         * </p>
         * <p>
         * Example: <code>16:00-16:30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created for your new database if automated
         *        backups are enabled.</p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region.
         *        For more information about the preferred backup window time blocks for each region, see the <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow"
         *        >Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the <code>hh24:mi-hh24:mi</code> format.
         *        </p>
         *        <p>
         *        Example: <code>16:00-16:30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur on your new database.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         * occurring on a random day of the week.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: <code>Tue:17:00-Tue:17:30</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur on your new database.</p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         *        occurring on a random day of the week.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: <code>Tue:17:00-Tue:17:30</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database
         * that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a
         * database that is available only to your Lightsail resources in the same region as your database.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for your new database. A value of <code>true</code> specifies a
         *        database that is available to resources outside of your Lightsail account. A value of
         *        <code>false</code> specifies a database that is available only to your Lightsail resources in the same
         *        region as your database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String availabilityZone;

        private String relationalDatabaseBlueprintId;

        private String relationalDatabaseBundleId;

        private String masterDatabaseName;

        private String masterUsername;

        private String masterUserPassword;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean publiclyAccessible;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelationalDatabaseRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            availabilityZone(model.availabilityZone);
            relationalDatabaseBlueprintId(model.relationalDatabaseBlueprintId);
            relationalDatabaseBundleId(model.relationalDatabaseBundleId);
            masterDatabaseName(model.masterDatabaseName);
            masterUsername(model.masterUsername);
            masterUserPassword(model.masterUserPassword);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            publiclyAccessible(model.publiclyAccessible);
            tags(model.tags);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getRelationalDatabaseBlueprintId() {
            return relationalDatabaseBlueprintId;
        }

        @Override
        public final Builder relationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
            return this;
        }

        public final void setRelationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
        }

        public final String getRelationalDatabaseBundleId() {
            return relationalDatabaseBundleId;
        }

        @Override
        public final Builder relationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
            return this;
        }

        public final void setRelationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
        }

        public final String getMasterDatabaseName() {
            return masterDatabaseName;
        }

        @Override
        public final Builder masterDatabaseName(String masterDatabaseName) {
            this.masterDatabaseName = masterDatabaseName;
            return this;
        }

        public final void setMasterDatabaseName(String masterDatabaseName) {
            this.masterDatabaseName = masterDatabaseName;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelationalDatabaseRequest build() {
            return new CreateRelationalDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
