/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether an Amazon Lightsail content delivery network (CDN) distribution forwards cookies to the origin and,
 * if so, which ones.
 * </p>
 * <p>
 * For the cookies that you specify, your distribution caches separate versions of the specified content based on the
 * cookie values in viewer requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CookieObject implements SdkPojo, Serializable, ToCopyableBuilder<CookieObject.Builder, CookieObject> {
    private static final SdkField<String> OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("option")
            .getter(getter(CookieObject::optionAsString)).setter(setter(Builder::option))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("option").build()).build();

    private static final SdkField<List<String>> COOKIES_ALLOW_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cookiesAllowList")
            .getter(getter(CookieObject::cookiesAllowList))
            .setter(setter(Builder::cookiesAllowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cookiesAllowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_FIELD,
            COOKIES_ALLOW_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String option;

    private final List<String> cookiesAllowList;

    private CookieObject(BuilderImpl builder) {
        this.option = builder.option;
        this.cookiesAllowList = builder.cookiesAllowList;
    }

    /**
     * <p>
     * Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>,
     * <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
     * <code>cookiesAllowList</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #option} will
     * return {@link ForwardValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optionAsString}.
     * </p>
     * 
     * @return Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>,
     *         <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
     *         <code>cookiesAllowList</code> parameter.
     * @see ForwardValues
     */
    public ForwardValues option() {
        return ForwardValues.fromValue(option);
    }

    /**
     * <p>
     * Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>,
     * <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
     * <code>cookiesAllowList</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #option} will
     * return {@link ForwardValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optionAsString}.
     * </p>
     * 
     * @return Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>,
     *         <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
     *         <code>cookiesAllowList</code> parameter.
     * @see ForwardValues
     */
    public String optionAsString() {
        return option;
    }

    /**
     * Returns true if the CookiesAllowList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCookiesAllowList() {
        return cookiesAllowList != null && !(cookiesAllowList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific cookies to forward to your distribution's origin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCookiesAllowList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The specific cookies to forward to your distribution's origin.
     */
    public List<String> cookiesAllowList() {
        return cookiesAllowList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cookiesAllowList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieObject)) {
            return false;
        }
        CookieObject other = (CookieObject) obj;
        return Objects.equals(optionAsString(), other.optionAsString())
                && Objects.equals(cookiesAllowList(), other.cookiesAllowList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CookieObject").add("Option", optionAsString()).add("CookiesAllowList", cookiesAllowList())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "option":
            return Optional.ofNullable(clazz.cast(optionAsString()));
        case "cookiesAllowList":
            return Optional.ofNullable(clazz.cast(cookiesAllowList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CookieObject, T> g) {
        return obj -> g.apply((CookieObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CookieObject> {
        /**
         * <p>
         * Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>,
         * <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
         * <code>cookiesAllowList</code> parameter.
         * </p>
         * 
         * @param option
         *        Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>
         *        , <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
         *        <code>cookiesAllowList</code> parameter.
         * @see ForwardValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardValues
         */
        Builder option(String option);

        /**
         * <p>
         * Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>,
         * <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
         * <code>cookiesAllowList</code> parameter.
         * </p>
         * 
         * @param option
         *        Specifies which cookies to forward to the distribution's origin for a cache behavior: <code>all</code>
         *        , <code>none</code>, or <code>allow-list</code> to forward only the cookies specified in the
         *        <code>cookiesAllowList</code> parameter.
         * @see ForwardValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardValues
         */
        Builder option(ForwardValues option);

        /**
         * <p>
         * The specific cookies to forward to your distribution's origin.
         * </p>
         * 
         * @param cookiesAllowList
         *        The specific cookies to forward to your distribution's origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookiesAllowList(Collection<String> cookiesAllowList);

        /**
         * <p>
         * The specific cookies to forward to your distribution's origin.
         * </p>
         * 
         * @param cookiesAllowList
         *        The specific cookies to forward to your distribution's origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookiesAllowList(String... cookiesAllowList);
    }

    static final class BuilderImpl implements Builder {
        private String option;

        private List<String> cookiesAllowList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CookieObject model) {
            option(model.option);
            cookiesAllowList(model.cookiesAllowList);
        }

        public final String getOption() {
            return option;
        }

        @Override
        public final Builder option(String option) {
            this.option = option;
            return this;
        }

        @Override
        public final Builder option(ForwardValues option) {
            this.option(option == null ? null : option.toString());
            return this;
        }

        public final void setOption(String option) {
            this.option = option;
        }

        public final Collection<String> getCookiesAllowList() {
            return cookiesAllowList;
        }

        @Override
        public final Builder cookiesAllowList(Collection<String> cookiesAllowList) {
            this.cookiesAllowList = StringListCopier.copy(cookiesAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cookiesAllowList(String... cookiesAllowList) {
            cookiesAllowList(Arrays.asList(cookiesAllowList));
            return this;
        }

        public final void setCookiesAllowList(Collection<String> cookiesAllowList) {
            this.cookiesAllowList = StringListCopier.copy(cookiesAllowList);
        }

        @Override
        public CookieObject build() {
            return new CookieObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
