/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestAlarmRequest extends LightsailRequest implements
        ToCopyableBuilder<TestAlarmRequest.Builder, TestAlarmRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmName").getter(getter(TestAlarmRequest::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(TestAlarmRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, STATE_FIELD));

    private final String alarmName;

    private final String state;

    private TestAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the alarm to test.
     * </p>
     * 
     * @return The name of the alarm to test.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The alarm state to test.
     * </p>
     * <p>
     * An alarm has the following possible states that can be tested:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALARM</code> - The metric is outside of the defined threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data is
     * available for the metric to determine the alarm state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OK</code> - The metric is within the defined threshold.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AlarmState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The alarm state to test.</p>
     *         <p>
     *         An alarm has the following possible states that can be tested:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALARM</code> - The metric is outside of the defined threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough
     *         data is available for the metric to determine the alarm state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OK</code> - The metric is within the defined threshold.
     *         </p>
     *         </li>
     * @see AlarmState
     */
    public AlarmState state() {
        return AlarmState.fromValue(state);
    }

    /**
     * <p>
     * The alarm state to test.
     * </p>
     * <p>
     * An alarm has the following possible states that can be tested:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALARM</code> - The metric is outside of the defined threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data is
     * available for the metric to determine the alarm state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OK</code> - The metric is within the defined threshold.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AlarmState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The alarm state to test.</p>
     *         <p>
     *         An alarm has the following possible states that can be tested:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALARM</code> - The metric is outside of the defined threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough
     *         data is available for the metric to determine the alarm state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OK</code> - The metric is within the defined threshold.
     *         </p>
     *         </li>
     * @see AlarmState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAlarmRequest)) {
            return false;
        }
        TestAlarmRequest other = (TestAlarmRequest) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestAlarmRequest").add("AlarmName", alarmName()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestAlarmRequest, T> g) {
        return obj -> g.apply((TestAlarmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestAlarmRequest> {
        /**
         * <p>
         * The name of the alarm to test.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The alarm state to test.
         * </p>
         * <p>
         * An alarm has the following possible states that can be tested:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM</code> - The metric is outside of the defined threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data
         * is available for the metric to determine the alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OK</code> - The metric is within the defined threshold.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The alarm state to test.</p>
         *        <p>
         *        An alarm has the following possible states that can be tested:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM</code> - The metric is outside of the defined threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not
         *        enough data is available for the metric to determine the alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OK</code> - The metric is within the defined threshold.
         *        </p>
         *        </li>
         * @see AlarmState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmState
         */
        Builder state(String state);

        /**
         * <p>
         * The alarm state to test.
         * </p>
         * <p>
         * An alarm has the following possible states that can be tested:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM</code> - The metric is outside of the defined threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data
         * is available for the metric to determine the alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OK</code> - The metric is within the defined threshold.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The alarm state to test.</p>
         *        <p>
         *        An alarm has the following possible states that can be tested:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM</code> - The metric is outside of the defined threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not
         *        enough data is available for the metric to determine the alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OK</code> - The metric is within the defined threshold.
         *        </p>
         *        </li>
         * @see AlarmState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmState
         */
        Builder state(AlarmState state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TestAlarmRequest model) {
            super(model);
            alarmName(model.alarmName);
            state(model.state);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AlarmState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestAlarmRequest build() {
            return new TestAlarmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
