/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.PortInfo;
import software.amazon.awssdk.services.lightsail.model.PortInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInstancePublicPortsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, PutInstancePublicPortsRequest> {
    private static final SdkField<List<PortInfo>> PORT_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portInfos").getter(PutInstancePublicPortsRequest.getter(PutInstancePublicPortsRequest::portInfos)).setter(PutInstancePublicPortsRequest.setter(Builder::portInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(PutInstancePublicPortsRequest.getter(PutInstancePublicPortsRequest::instanceName)).setter(PutInstancePublicPortsRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_INFOS_FIELD, INSTANCE_NAME_FIELD));
    private final List<PortInfo> portInfos;
    private final String instanceName;

    private PutInstancePublicPortsRequest(BuilderImpl builder) {
        super(builder);
        this.portInfos = builder.portInfos;
        this.instanceName = builder.instanceName;
    }

    public boolean hasPortInfos() {
        return this.portInfos != null && !(this.portInfos instanceof SdkAutoConstructList);
    }

    public List<PortInfo> portInfos() {
        return this.portInfos;
    }

    public String instanceName() {
        return this.instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsRequest)) {
            return false;
        }
        PutInstancePublicPortsRequest other = (PutInstancePublicPortsRequest)((Object)obj);
        return Objects.equals(this.portInfos(), other.portInfos()) && Objects.equals(this.instanceName(), other.instanceName());
    }

    public String toString() {
        return ToString.builder((String)"PutInstancePublicPortsRequest").add("PortInfos", this.portInfos()).add("InstanceName", (Object)this.instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portInfos": {
                return Optional.ofNullable(clazz.cast(this.portInfos()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInstancePublicPortsRequest, T> g) {
        return obj -> g.apply((PutInstancePublicPortsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private List<PortInfo> portInfos = DefaultSdkAutoConstructList.getInstance();
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsRequest model) {
            super(model);
            this.portInfos(model.portInfos);
            this.instanceName(model.instanceName);
        }

        public final Collection<PortInfo.Builder> getPortInfos() {
            return this.portInfos != null ? (Collection)this.portInfos.stream().map(PortInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portInfos(Collection<PortInfo> portInfos) {
            this.portInfos = PortInfoListCopier.copy(portInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(PortInfo ... portInfos) {
            this.portInfos(Arrays.asList(portInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(Consumer<PortInfo.Builder> ... portInfos) {
            this.portInfos(Stream.of(portInfos).map(c -> (PortInfo)((PortInfo.Builder)PortInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortInfos(Collection<PortInfo.BuilderImpl> portInfos) {
            this.portInfos = PortInfoListCopier.copyFromBuilder(portInfos);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInstancePublicPortsRequest build() {
            return new PutInstancePublicPortsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutInstancePublicPortsRequest> {
        public Builder portInfos(Collection<PortInfo> var1);

        public Builder portInfos(PortInfo ... var1);

        public Builder portInfos(Consumer<PortInfo.Builder> ... var1);

        public Builder instanceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

