/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContactMethod;
import software.amazon.awssdk.services.lightsail.model.ContactMethodsListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactMethodsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetContactMethodsResponse> {
    private static final SdkField<List<ContactMethod>> CONTACT_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contactMethods").getter(GetContactMethodsResponse.getter(GetContactMethodsResponse::contactMethods)).setter(GetContactMethodsResponse.setter(Builder::contactMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactMethod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_METHODS_FIELD));
    private final List<ContactMethod> contactMethods;

    private GetContactMethodsResponse(BuilderImpl builder) {
        super(builder);
        this.contactMethods = builder.contactMethods;
    }

    public final boolean hasContactMethods() {
        return this.contactMethods != null && !(this.contactMethods instanceof SdkAutoConstructList);
    }

    public final List<ContactMethod> contactMethods() {
        return this.contactMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactMethods() ? this.contactMethods() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactMethodsResponse)) {
            return false;
        }
        GetContactMethodsResponse other = (GetContactMethodsResponse)((Object)obj);
        return this.hasContactMethods() == other.hasContactMethods() && Objects.equals(this.contactMethods(), other.contactMethods());
    }

    public final String toString() {
        return ToString.builder((String)"GetContactMethodsResponse").add("ContactMethods", this.hasContactMethods() ? this.contactMethods() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactMethods": {
                return Optional.ofNullable(clazz.cast(this.contactMethods()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactMethodsResponse, T> g) {
        return obj -> g.apply((GetContactMethodsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<ContactMethod> contactMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactMethodsResponse model) {
            super(model);
            this.contactMethods(model.contactMethods);
        }

        public final Collection<ContactMethod.Builder> getContactMethods() {
            if (this.contactMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactMethods != null ? (Collection)this.contactMethods.stream().map(ContactMethod::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contactMethods(Collection<ContactMethod> contactMethods) {
            this.contactMethods = ContactMethodsListCopier.copy(contactMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactMethods(ContactMethod ... contactMethods) {
            this.contactMethods(Arrays.asList(contactMethods));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactMethods(Consumer<ContactMethod.Builder> ... contactMethods) {
            this.contactMethods(Stream.of(contactMethods).map(c -> (ContactMethod)((ContactMethod.Builder)ContactMethod.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContactMethods(Collection<ContactMethod.BuilderImpl> contactMethods) {
            this.contactMethods = ContactMethodsListCopier.copyFromBuilder(contactMethods);
        }

        @Override
        public GetContactMethodsResponse build() {
            return new GetContactMethodsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactMethodsResponse> {
        public Builder contactMethods(Collection<ContactMethod> var1);

        public Builder contactMethods(ContactMethod ... var1);

        public Builder contactMethods(Consumer<ContactMethod.Builder> ... var1);
    }
}

