/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.LightsailException;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.PutAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.TagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.TagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.TestAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.TestAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UntagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.UntagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseResponse;

/**
 * Service client for accessing Amazon Lightsail. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Lightsail is the easiest way to get started with Amazon Web Services (AWS) for developers who need to build
 * websites or web applications. It includes everything you need to launch your project quickly - instances (virtual
 * private servers), container services, managed databases, SSD-based block storage, static IP addresses, load
 * balancers, content delivery network (CDN) distributions, DNS management of registered domains, and resource snapshots
 * (backups) - for a low, predictable monthly price.
 * </p>
 * <p>
 * You can manage your Lightsail resources using the Lightsail console, Lightsail API, AWS Command Line Interface (AWS
 * CLI), or SDKs. For more information about Lightsail concepts and tasks, see the <a href=
 * "http://lightsail.aws.amazon.com/ls/docs/how-to/article/lightsail-how-to-set-up-access-keys-to-use-sdk-api-cli"
 * >Lightsail Dev Guide</a>.
 * </p>
 * <p>
 * This API Reference provides detailed information about the actions, data types, parameters, and errors of the
 * Lightsail service. For more information about the supported AWS Regions, endpoints, and service quotas of the
 * Lightsail service, see <a href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail
 * Endpoints and Quotas</a> in the <i>AWS General Reference</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LightsailClient extends SdkClient {
    String SERVICE_NAME = "lightsail";

    /**
     * Create a {@link LightsailClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LightsailClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LightsailClient}.
     */
    static LightsailClientBuilder builder() {
        return new DefaultLightsailClientBuilder();
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     *
     * @param allocateStaticIpRequest
     * @return Result of the AllocateStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateStaticIpResponse allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateStaticIpRequest.Builder} avoiding the need
     * to create one manually via {@link AllocateStaticIpRequest#builder()}
     * </p>
     *
     * @param allocateStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link AllocateStaticIpRequest.Builder} to create a request.
     * @return Result of the AllocateStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateStaticIpResponse allocateStaticIp(Consumer<AllocateStaticIpRequest.Builder> allocateStaticIpRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return allocateStaticIp(AllocateStaticIpRequest.builder().applyMutation(allocateStaticIpRequest).build());
    }

    /**
     * <p>
     * Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is attached, your distribution accepts HTTPS traffic for all of the domains that are
     * associated with the certificate.
     * </p>
     * <p>
     * Use the <code>CreateCertificate</code> action to create a certificate that you can attach to your distribution.
     * </p>
     * <important>
     * <p>
     * Only certificates created in the <code>us-east-1</code> AWS Region can be attached to Lightsail distributions.
     * Lightsail distributions are global resources that can reference an origin in any AWS Region, and distribute its
     * content globally. However, all distributions are located in the <code>us-east-1</code> Region.
     * </p>
     * </important>
     *
     * @param attachCertificateToDistributionRequest
     * @return Result of the AttachCertificateToDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachCertificateToDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachCertificateToDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachCertificateToDistributionResponse attachCertificateToDistribution(
            AttachCertificateToDistributionRequest attachCertificateToDistributionRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is attached, your distribution accepts HTTPS traffic for all of the domains that are
     * associated with the certificate.
     * </p>
     * <p>
     * Use the <code>CreateCertificate</code> action to create a certificate that you can attach to your distribution.
     * </p>
     * <important>
     * <p>
     * Only certificates created in the <code>us-east-1</code> AWS Region can be attached to Lightsail distributions.
     * Lightsail distributions are global resources that can reference an origin in any AWS Region, and distribute its
     * content globally. However, all distributions are located in the <code>us-east-1</code> Region.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachCertificateToDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link AttachCertificateToDistributionRequest#builder()}
     * </p>
     *
     * @param attachCertificateToDistributionRequest
     *        A {@link Consumer} that will call methods on {@link AttachCertificateToDistributionRequest.Builder} to
     *        create a request.
     * @return Result of the AttachCertificateToDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachCertificateToDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachCertificateToDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachCertificateToDistributionResponse attachCertificateToDistribution(
            Consumer<AttachCertificateToDistributionRequest.Builder> attachCertificateToDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return attachCertificateToDistribution(AttachCertificateToDistributionRequest.builder()
                .applyMutation(attachCertificateToDistributionRequest).build());
    }

    /**
     * <p>
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the
     * specified disk name.
     * </p>
     * <p>
     * The <code>attach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachDiskRequest
     * @return Result of the AttachDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachDiskResponse attachDisk(AttachDiskRequest attachDiskRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the
     * specified disk name.
     * </p>
     * <p>
     * The <code>attach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachDiskRequest.Builder} avoiding the need to
     * create one manually via {@link AttachDiskRequest#builder()}
     * </p>
     *
     * @param attachDiskRequest
     *        A {@link Consumer} that will call methods on {@link AttachDiskRequest.Builder} to create a request.
     * @return Result of the AttachDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachDiskResponse attachDisk(Consumer<AttachDiskRequest.Builder> attachDiskRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return attachDisk(AttachDiskRequest.builder().applyMutation(attachDiskRequest).build());
    }

    /**
     * <p>
     * Attaches one or more Lightsail instances to a load balancer.
     * </p>
     * <p>
     * After some time, the instances are attached to the load balancer and the health check status is available.
     * </p>
     * <p>
     * The <code>attach instances to load balancer</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachInstancesToLoadBalancerRequest
     * @return Result of the AttachInstancesToLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachInstancesToLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachInstancesToLoadBalancerResponse attachInstancesToLoadBalancer(
            AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more Lightsail instances to a load balancer.
     * </p>
     * <p>
     * After some time, the instances are attached to the load balancer and the health check status is available.
     * </p>
     * <p>
     * The <code>attach instances to load balancer</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachInstancesToLoadBalancerRequest.Builder}
     * avoiding the need to create one manually via {@link AttachInstancesToLoadBalancerRequest#builder()}
     * </p>
     *
     * @param attachInstancesToLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link AttachInstancesToLoadBalancerRequest.Builder} to
     *        create a request.
     * @return Result of the AttachInstancesToLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachInstancesToLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachInstancesToLoadBalancerResponse attachInstancesToLoadBalancer(
            Consumer<AttachInstancesToLoadBalancerRequest.Builder> attachInstancesToLoadBalancerRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return attachInstancesToLoadBalancer(AttachInstancesToLoadBalancerRequest.builder()
                .applyMutation(attachInstancesToLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure
     * version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API
     * to rotate the certificates on your account. Use the <code>AttachLoadBalancerTlsCertificate</code> action with the
     * non-attached certificate, and it will replace the existing one and become the attached certificate.
     * </p>
     * <p>
     * The <code>AttachLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachLoadBalancerTlsCertificateRequest
     * @return Result of the AttachLoadBalancerTlsCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancerTlsCertificateResponse attachLoadBalancerTlsCertificate(
            AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure
     * version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API
     * to rotate the certificates on your account. Use the <code>AttachLoadBalancerTlsCertificate</code> action with the
     * non-attached certificate, and it will replace the existing one and become the attached certificate.
     * </p>
     * <p>
     * The <code>AttachLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachLoadBalancerTlsCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link AttachLoadBalancerTlsCertificateRequest#builder()}
     * </p>
     *
     * @param attachLoadBalancerTlsCertificateRequest
     *        A {@link Consumer} that will call methods on {@link AttachLoadBalancerTlsCertificateRequest.Builder} to
     *        create a request.
     * @return Result of the AttachLoadBalancerTlsCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancerTlsCertificateResponse attachLoadBalancerTlsCertificate(
            Consumer<AttachLoadBalancerTlsCertificateRequest.Builder> attachLoadBalancerTlsCertificateRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return attachLoadBalancerTlsCertificate(AttachLoadBalancerTlsCertificateRequest.builder()
                .applyMutation(attachLoadBalancerTlsCertificateRequest).build());
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     *
     * @param attachStaticIpRequest
     * @return Result of the AttachStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachStaticIpResponse attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachStaticIpRequest.Builder} avoiding the need to
     * create one manually via {@link AttachStaticIpRequest#builder()}
     * </p>
     *
     * @param attachStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link AttachStaticIpRequest.Builder} to create a request.
     * @return Result of the AttachStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachStaticIpResponse attachStaticIp(Consumer<AttachStaticIpRequest.Builder> attachStaticIpRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return attachStaticIp(AttachStaticIpRequest.builder().applyMutation(attachStaticIpRequest).build());
    }

    /**
     * <p>
     * Closes ports for a specific Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>CloseInstancePublicPorts</code> action supports tag-based access control via resource tags applied to
     * the resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param closeInstancePublicPortsRequest
     * @return Result of the CloseInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CloseInstancePublicPortsResponse closeInstancePublicPorts(
            CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Closes ports for a specific Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>CloseInstancePublicPorts</code> action supports tag-based access control via resource tags applied to
     * the resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloseInstancePublicPortsRequest.Builder} avoiding
     * the need to create one manually via {@link CloseInstancePublicPortsRequest#builder()}
     * </p>
     *
     * @param closeInstancePublicPortsRequest
     *        A {@link Consumer} that will call methods on {@link CloseInstancePublicPortsRequest.Builder} to create a
     *        request.
     * @return Result of the CloseInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default CloseInstancePublicPortsResponse closeInstancePublicPorts(
            Consumer<CloseInstancePublicPortsRequest.Builder> closeInstancePublicPortsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return closeInstancePublicPorts(CloseInstancePublicPortsRequest.builder().applyMutation(closeInstancePublicPortsRequest)
                .build());
    }

    /**
     * <p>
     * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an
     * instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of
     * an instance or a disk from one AWS Region to another in Amazon Lightsail.
     * </p>
     * <p>
     * When copying a <i>manual snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source snapshot name</code>, and <code>target snapshot name</code> parameters.
     * </p>
     * <p>
     * When copying an <i>automatic snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source resource name</code>, <code>target snapshot name</code>, and either the <code>restore date</code> or
     * the <code>use latest restorable auto snapshot</code> parameters.
     * </p>
     *
     * @param copySnapshotRequest
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an
     * instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of
     * an instance or a disk from one AWS Region to another in Amazon Lightsail.
     * </p>
     * <p>
     * When copying a <i>manual snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source snapshot name</code>, and <code>target snapshot name</code> parameters.
     * </p>
     * <p>
     * When copying an <i>automatic snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source resource name</code>, <code>target snapshot name</code>, and either the <code>restore date</code> or
     * the <code>use latest restorable auto snapshot</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopySnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopySnapshotRequest#builder()}
     * </p>
     *
     * @param copySnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopySnapshotRequest.Builder} to create a request.
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopySnapshotResponse copySnapshot(Consumer<CopySnapshotRequest.Builder> copySnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return copySnapshot(CopySnapshotRequest.builder().applyMutation(copySnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an SSL/TLS certificate for a Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is created, use the <code>AttachCertificateToDistribution</code> action to attach the
     * certificate to your distribution.
     * </p>
     * <important>
     * <p>
     * Only certificates created in the <code>us-east-1</code> AWS Region can be attached to Lightsail distributions.
     * Lightsail distributions are global resources that can reference an origin in any AWS Region, and distribute its
     * content globally. However, all distributions are located in the <code>us-east-1</code> Region.
     * </p>
     * </important>
     *
     * @param createCertificateRequest
     * @return Result of the CreateCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCertificateResponse createCertificate(CreateCertificateRequest createCertificateRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an SSL/TLS certificate for a Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is created, use the <code>AttachCertificateToDistribution</code> action to attach the
     * certificate to your distribution.
     * </p>
     * <important>
     * <p>
     * Only certificates created in the <code>us-east-1</code> AWS Region can be attached to Lightsail distributions.
     * Lightsail distributions are global resources that can reference an origin in any AWS Region, and distribute its
     * content globally. However, all distributions are located in the <code>us-east-1</code> Region.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCertificateRequest#builder()}
     * </p>
     *
     * @param createCertificateRequest
     *        A {@link Consumer} that will call methods on {@link CreateCertificateRequest.Builder} to create a request.
     * @return Result of the CreateCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCertificateResponse createCertificate(Consumer<CreateCertificateRequest.Builder> createCertificateRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return createCertificate(CreateCertificateRequest.builder().applyMutation(createCertificateRequest).build());
    }

    /**
     * <p>
     * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail
     * snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS
     * CloudFormation stack created. Use the <code>get cloud formation stack records</code> operation to get a list of
     * the CloudFormation stacks created.
     * </p>
     * <important>
     * <p>
     * Wait until after your new Amazon EC2 instance is created before running the
     * <code>create cloud formation stack</code> operation again with the same export snapshot record.
     * </p>
     * </important>
     *
     * @param createCloudFormationStackRequest
     * @return Result of the CreateCloudFormationStack operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateCloudFormationStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCloudFormationStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFormationStackResponse createCloudFormationStack(
            CreateCloudFormationStackRequest createCloudFormationStackRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail
     * snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS
     * CloudFormation stack created. Use the <code>get cloud formation stack records</code> operation to get a list of
     * the CloudFormation stacks created.
     * </p>
     * <important>
     * <p>
     * Wait until after your new Amazon EC2 instance is created before running the
     * <code>create cloud formation stack</code> operation again with the same export snapshot record.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudFormationStackRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCloudFormationStackRequest#builder()}
     * </p>
     *
     * @param createCloudFormationStackRequest
     *        A {@link Consumer} that will call methods on {@link CreateCloudFormationStackRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCloudFormationStack operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateCloudFormationStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCloudFormationStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFormationStackResponse createCloudFormationStack(
            Consumer<CreateCloudFormationStackRequest.Builder> createCloudFormationStackRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createCloudFormationStack(CreateCloudFormationStackRequest.builder()
                .applyMutation(createCloudFormationStackRequest).build());
    }

    /**
     * <p>
     * Creates an email or SMS text message contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     *
     * @param createContactMethodRequest
     * @return Result of the CreateContactMethod operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContactMethod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContactMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateContactMethodResponse createContactMethod(CreateContactMethodRequest createContactMethodRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an email or SMS text message contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactMethodRequest.Builder} avoiding the
     * need to create one manually via {@link CreateContactMethodRequest#builder()}
     * </p>
     *
     * @param createContactMethodRequest
     *        A {@link Consumer} that will call methods on {@link CreateContactMethodRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContactMethod operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContactMethod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContactMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateContactMethodResponse createContactMethod(
            Consumer<CreateContactMethodRequest.Builder> createContactMethodRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return createContactMethod(CreateContactMethodRequest.builder().applyMutation(createContactMethodRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Lightsail container service.
     * </p>
     * <p>
     * A Lightsail container service is a compute resource to which you can deploy containers. For more information, see
     * <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services">Container
     * services in Amazon Lightsail</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     *
     * @param createContainerServiceRequest
     * @return Result of the CreateContainerService operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerServiceResponse createContainerService(CreateContainerServiceRequest createContainerServiceRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Lightsail container service.
     * </p>
     * <p>
     * A Lightsail container service is a compute resource to which you can deploy containers. For more information, see
     * <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services">Container
     * services in Amazon Lightsail</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContainerServiceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateContainerServiceRequest#builder()}
     * </p>
     *
     * @param createContainerServiceRequest
     *        A {@link Consumer} that will call methods on {@link CreateContainerServiceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContainerService operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerServiceResponse createContainerService(
            Consumer<CreateContainerServiceRequest.Builder> createContainerServiceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return createContainerService(CreateContainerServiceRequest.builder().applyMutation(createContainerServiceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a deployment for your Amazon Lightsail container service.
     * </p>
     * <p>
     * A deployment specifies the containers that will be launched on the container service and their settings, such as
     * the ports to open, the environment variables to apply, and the launch command to run. It also specifies the
     * container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS
     * port to use, and the health check configuration.
     * </p>
     * <p>
     * You can deploy containers to your container service using container images from a public registry like Docker
     * Hub, or from your local machine. For more information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images"
     * >Creating container images for your Amazon Lightsail container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     *
     * @param createContainerServiceDeploymentRequest
     * @return Result of the CreateContainerServiceDeployment operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContainerServiceDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerServiceDeploymentResponse createContainerServiceDeployment(
            CreateContainerServiceDeploymentRequest createContainerServiceDeploymentRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment for your Amazon Lightsail container service.
     * </p>
     * <p>
     * A deployment specifies the containers that will be launched on the container service and their settings, such as
     * the ports to open, the environment variables to apply, and the launch command to run. It also specifies the
     * container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS
     * port to use, and the health check configuration.
     * </p>
     * <p>
     * You can deploy containers to your container service using container images from a public registry like Docker
     * Hub, or from your local machine. For more information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images"
     * >Creating container images for your Amazon Lightsail container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContainerServiceDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateContainerServiceDeploymentRequest#builder()}
     * </p>
     *
     * @param createContainerServiceDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateContainerServiceDeploymentRequest.Builder} to
     *        create a request.
     * @return Result of the CreateContainerServiceDeployment operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContainerServiceDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerServiceDeploymentResponse createContainerServiceDeployment(
            Consumer<CreateContainerServiceDeploymentRequest.Builder> createContainerServiceDeploymentRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return createContainerServiceDeployment(CreateContainerServiceDeploymentRequest.builder()
                .applyMutation(createContainerServiceDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local
     * machine. After you're logged in, you can use the native Docker commands to push your local container images to
     * the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail
     * container service. The log in credentials expire 12 hours after they are created, at which point you will need to
     * create a new set of log in credentials.
     * </p>
     * <note>
     * <p>
     * You can only push container images to the container service registry of your Lightsail account. You cannot pull
     * container images or perform any other container image management actions on the container service registry.
     * </p>
     * </note>
     * <p>
     * After you push your container images to the container image registry of your Lightsail account, use the
     * <code>RegisterContainerImage</code> action to register the pushed images to a specific Lightsail container
     * service.
     * </p>
     * <note>
     * <p>
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container
     * images to your Lightsail container service. For more information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images">Pushing
     * and managing container images on your Amazon Lightsail container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * </note>
     *
     * @param createContainerServiceRegistryLoginRequest
     * @return Result of the CreateContainerServiceRegistryLogin operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContainerServiceRegistryLogin
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceRegistryLogin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerServiceRegistryLoginResponse createContainerServiceRegistryLogin(
            CreateContainerServiceRegistryLoginRequest createContainerServiceRegistryLoginRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local
     * machine. After you're logged in, you can use the native Docker commands to push your local container images to
     * the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail
     * container service. The log in credentials expire 12 hours after they are created, at which point you will need to
     * create a new set of log in credentials.
     * </p>
     * <note>
     * <p>
     * You can only push container images to the container service registry of your Lightsail account. You cannot pull
     * container images or perform any other container image management actions on the container service registry.
     * </p>
     * </note>
     * <p>
     * After you push your container images to the container image registry of your Lightsail account, use the
     * <code>RegisterContainerImage</code> action to register the pushed images to a specific Lightsail container
     * service.
     * </p>
     * <note>
     * <p>
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container
     * images to your Lightsail container service. For more information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images">Pushing
     * and managing container images on your Amazon Lightsail container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContainerServiceRegistryLoginRequest.Builder}
     * avoiding the need to create one manually via {@link CreateContainerServiceRegistryLoginRequest#builder()}
     * </p>
     *
     * @param createContainerServiceRegistryLoginRequest
     *        A {@link Consumer} that will call methods on {@link CreateContainerServiceRegistryLoginRequest.Builder} to
     *        create a request.
     * @return Result of the CreateContainerServiceRegistryLogin operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateContainerServiceRegistryLogin
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceRegistryLogin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContainerServiceRegistryLoginResponse createContainerServiceRegistryLogin(
            Consumer<CreateContainerServiceRegistryLoginRequest.Builder> createContainerServiceRegistryLoginRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return createContainerServiceRegistryLogin(CreateContainerServiceRegistryLoginRequest.builder()
                .applyMutation(createContainerServiceRegistryLoginRequest).build());
    }

    /**
     * <p>
     * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone
     * (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk</code> operation supports tag-based access control via request tags. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskRequest
     * @return Result of the CreateDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDiskResponse createDisk(CreateDiskRequest createDiskRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone
     * (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk</code> operation supports tag-based access control via request tags. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDiskRequest#builder()}
     * </p>
     *
     * @param createDiskRequest
     *        A {@link Consumer} that will call methods on {@link CreateDiskRequest.Builder} to create a request.
     * @return Result of the CreateDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDiskResponse createDisk(Consumer<CreateDiskRequest.Builder> createDiskRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createDisk(CreateDiskRequest.builder().applyMutation(createDiskRequest).build());
    }

    /**
     * <p>
     * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to
     * an Amazon Lightsail instance in the same Availability Zone (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>disk snapshot name</code>. For more information, see
     * the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">
     * Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskFromSnapshotRequest
     * @return Result of the CreateDiskFromSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDiskFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDiskFromSnapshotResponse createDiskFromSnapshot(CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to
     * an Amazon Lightsail instance in the same Availability Zone (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>disk snapshot name</code>. For more information, see
     * the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">
     * Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiskFromSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDiskFromSnapshotRequest#builder()}
     * </p>
     *
     * @param createDiskFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDiskFromSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDiskFromSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDiskFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDiskFromSnapshotResponse createDiskFromSnapshot(
            Consumer<CreateDiskFromSnapshotRequest.Builder> createDiskFromSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createDiskFromSnapshot(CreateDiskFromSnapshotRequest.builder().applyMutation(createDiskFromSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to
     * save data before shutting down a Lightsail instance.
     * </p>
     * <p>
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been
     * written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached
     * by any applications or the operating system. If you can pause any file systems on the disk long enough to take a
     * snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you
     * should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then
     * remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the
     * snapshot status is pending.
     * </p>
     * <p>
     * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this,
     * for example, to recover data from the system volume of a botched instance or to create a backup of the system
     * volume like you would for a block storage disk. To create a snapshot of a system volume, just define the
     * <code>instance name</code> parameter when issuing the snapshot command, and a snapshot of the defined instance's
     * system volume will be created. After the snapshot is available, you can create a block storage disk from the
     * snapshot and attach it to a running instance to access the data on the disk.
     * </p>
     * <p>
     * The <code>create disk snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskSnapshotRequest
     * @return Result of the CreateDiskSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDiskSnapshotResponse createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to
     * save data before shutting down a Lightsail instance.
     * </p>
     * <p>
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been
     * written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached
     * by any applications or the operating system. If you can pause any file systems on the disk long enough to take a
     * snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you
     * should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then
     * remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the
     * snapshot status is pending.
     * </p>
     * <p>
     * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this,
     * for example, to recover data from the system volume of a botched instance or to create a backup of the system
     * volume like you would for a block storage disk. To create a snapshot of a system volume, just define the
     * <code>instance name</code> parameter when issuing the snapshot command, and a snapshot of the defined instance's
     * system volume will be created. After the snapshot is available, you can create a block storage disk from the
     * snapshot and attach it to a running instance to access the data on the disk.
     * </p>
     * <p>
     * The <code>create disk snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiskSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDiskSnapshotRequest#builder()}
     * </p>
     *
     * @param createDiskSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDiskSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDiskSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDiskSnapshotResponse createDiskSnapshot(Consumer<CreateDiskSnapshotRequest.Builder> createDiskSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createDiskSnapshot(CreateDiskSnapshotRequest.builder().applyMutation(createDiskSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * A distribution is a globally distributed network of caching servers that improve the performance of your website
     * or web application hosted on a Lightsail instance. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions"
     * >Content delivery networks in Amazon Lightsail</a>.
     * </p>
     *
     * @param createDistributionRequest
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * A distribution is a globally distributed network of caching servers that improve the performance of your website
     * or web application hosted on a Lightsail instance. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions"
     * >Content delivery networks in Amazon Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDistributionRequest#builder()}
     * </p>
     *
     * @param createDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDistributionResponse createDistribution(Consumer<CreateDistributionRequest.Builder> createDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return createDistribution(CreateDistributionRequest.builder().applyMutation(createDistributionRequest).build());
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     * <p>
     * The <code>create domain</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     * <p>
     * The <code>create domain</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainRequest.Builder} to create a request.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name
     * (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     * </p>
     * <p>
     * The <code>create domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDomainEntryRequest
     * @return Result of the CreateDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDomainEntryResponse createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name
     * (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     * </p>
     * <p>
     * The <code>create domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainEntryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainEntryRequest#builder()}
     * </p>
     *
     * @param createDomainEntryRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainEntryRequest.Builder} to create a request.
     * @return Result of the CreateDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDomainEntryResponse createDomainEntry(Consumer<CreateDomainEntryRequest.Builder> createDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createDomainEntry(CreateDomainEntryRequest.builder().applyMutation(createDomainEntryRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     * <p>
     * The <code>create instance snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstanceSnapshotRequest
     * @return Result of the CreateInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceSnapshotResponse createInstanceSnapshot(CreateInstanceSnapshotRequest createInstanceSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     * <p>
     * The <code>create instance snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceSnapshotRequest#builder()}
     * </p>
     *
     * @param createInstanceSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstanceSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceSnapshotResponse createInstanceSnapshot(
            Consumer<CreateInstanceSnapshotRequest.Builder> createInstanceSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createInstanceSnapshot(CreateInstanceSnapshotRequest.builder().applyMutation(createInstanceSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail instances.
     * </p>
     * <p>
     * The <code>create instances</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstancesRequest
     * @return Result of the CreateInstances operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstancesResponse createInstances(CreateInstancesRequest createInstancesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail instances.
     * </p>
     * <p>
     * The <code>create instances</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link CreateInstancesRequest#builder()}
     * </p>
     *
     * @param createInstancesRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstancesRequest.Builder} to create a request.
     * @return Result of the CreateInstances operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstancesResponse createInstances(Consumer<CreateInstancesRequest.Builder> createInstancesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createInstances(CreateInstancesRequest.builder().applyMutation(createInstancesRequest).build());
    }

    /**
     * <p>
     * Creates one or more new instances from a manual or automatic snapshot of an instance.
     * </p>
     * <p>
     * The <code>create instances from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>instance snapshot name</code>. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstancesFromSnapshotRequest
     * @return Result of the CreateInstancesFromSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstancesFromSnapshotResponse createInstancesFromSnapshot(
            CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more new instances from a manual or automatic snapshot of an instance.
     * </p>
     * <p>
     * The <code>create instances from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>instance snapshot name</code>. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstancesFromSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link CreateInstancesFromSnapshotRequest#builder()}
     * </p>
     *
     * @param createInstancesFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstancesFromSnapshotRequest.Builder} to create
     *        a request.
     * @return Result of the CreateInstancesFromSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstancesFromSnapshotResponse createInstancesFromSnapshot(
            Consumer<CreateInstancesFromSnapshotRequest.Builder> createInstancesFromSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createInstancesFromSnapshot(CreateInstancesFromSnapshotRequest.builder()
                .applyMutation(createInstancesFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an SSH key pair.
     * </p>
     * <p>
     * The <code>create key pair</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return Result of the CreateKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKeyPairResponse createKeyPair(CreateKeyPairRequest createKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an SSH key pair.
     * </p>
     * <p>
     * The <code>create key pair</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKeyPairRequest#builder()}
     * </p>
     *
     * @param createKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link CreateKeyPairRequest.Builder} to create a request.
     * @return Result of the CreateKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKeyPairResponse createKeyPair(Consumer<CreateKeyPairRequest.Builder> createKeyPairRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createKeyPair(CreateKeyPairRequest.builder().applyMutation(createKeyPairRequest).build());
    }

    /**
     * <p>
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing">
     * Configure your Lightsail instances for load balancing</a>. You can create up to 5 load balancers per AWS Region
     * in your account.
     * </p>
     * <p>
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load
     * balancer settings, use the <code>UpdateLoadBalancerAttribute</code> operation.
     * </p>
     * <p>
     * The <code>create load balancer</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return Result of the CreateLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing">
     * Configure your Lightsail instances for load balancing</a>. You can create up to 5 load balancers per AWS Region
     * in your account.
     * </p>
     * <p>
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load
     * balancer settings, use the <code>UpdateLoadBalancerAttribute</code> operation.
     * </p>
     * <p>
     * The <code>create load balancer</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoadBalancerRequest#builder()}
     * </p>
     *
     * @param createLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoadBalancerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLoadBalancerResponse createLoadBalancer(Consumer<CreateLoadBalancerRequest.Builder> createLoadBalancerRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createLoadBalancer(CreateLoadBalancerRequest.builder().applyMutation(createLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Creates a Lightsail load balancer TLS certificate.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * The <code>CreateLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createLoadBalancerTlsCertificateRequest
     * @return Result of the CreateLoadBalancerTlsCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoadBalancerTlsCertificateResponse createLoadBalancerTlsCertificate(
            CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lightsail load balancer TLS certificate.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * The <code>CreateLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoadBalancerTlsCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLoadBalancerTlsCertificateRequest#builder()}
     * </p>
     *
     * @param createLoadBalancerTlsCertificateRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoadBalancerTlsCertificateRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLoadBalancerTlsCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoadBalancerTlsCertificateResponse createLoadBalancerTlsCertificate(
            Consumer<CreateLoadBalancerTlsCertificateRequest.Builder> createLoadBalancerTlsCertificateRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createLoadBalancerTlsCertificate(CreateLoadBalancerTlsCertificateRequest.builder()
                .applyMutation(createLoadBalancerTlsCertificateRequest).build());
    }

    /**
     * <p>
     * Creates a new database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>create relational database</code> operation supports tag-based access control via request tags. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseRequest
     * @return Result of the CreateRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationalDatabaseResponse createRelationalDatabase(
            CreateRelationalDatabaseRequest createRelationalDatabaseRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>create relational database</code> operation supports tag-based access control via request tags. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRelationalDatabaseRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRelationalDatabaseRequest#builder()}
     * </p>
     *
     * @param createRelationalDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link CreateRelationalDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationalDatabaseResponse createRelationalDatabase(
            Consumer<CreateRelationalDatabaseRequest.Builder> createRelationalDatabaseRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createRelationalDatabase(CreateRelationalDatabaseRequest.builder().applyMutation(createRelationalDatabaseRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new database from an existing database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * You can create a new database from a snapshot in if something goes wrong with your original database, or to
     * change it to a different plan, such as a high availability or standard plan.
     * </p>
     * <p>
     * The <code>create relational database from snapshot</code> operation supports tag-based access control via request
     * tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseFromSnapshotRequest
     * @return Result of the CreateRelationalDatabaseFromSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateRelationalDatabaseFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationalDatabaseFromSnapshotResponse createRelationalDatabaseFromSnapshot(
            CreateRelationalDatabaseFromSnapshotRequest createRelationalDatabaseFromSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new database from an existing database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * You can create a new database from a snapshot in if something goes wrong with your original database, or to
     * change it to a different plan, such as a high availability or standard plan.
     * </p>
     * <p>
     * The <code>create relational database from snapshot</code> operation supports tag-based access control via request
     * tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateRelationalDatabaseFromSnapshotRequest.Builder} avoiding the need to create one manually via
     * {@link CreateRelationalDatabaseFromSnapshotRequest#builder()}
     * </p>
     *
     * @param createRelationalDatabaseFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateRelationalDatabaseFromSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the CreateRelationalDatabaseFromSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateRelationalDatabaseFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationalDatabaseFromSnapshotResponse createRelationalDatabaseFromSnapshot(
            Consumer<CreateRelationalDatabaseFromSnapshotRequest.Builder> createRelationalDatabaseFromSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createRelationalDatabaseFromSnapshot(CreateRelationalDatabaseFromSnapshotRequest.builder()
                .applyMutation(createRelationalDatabaseFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a
     * database, and to save data before deleting a database.
     * </p>
     * <p>
     * The <code>create relational database snapshot</code> operation supports tag-based access control via request
     * tags. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseSnapshotRequest
     * @return Result of the CreateRelationalDatabaseSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationalDatabaseSnapshotResponse createRelationalDatabaseSnapshot(
            CreateRelationalDatabaseSnapshotRequest createRelationalDatabaseSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a
     * database, and to save data before deleting a database.
     * </p>
     * <p>
     * The <code>create relational database snapshot</code> operation supports tag-based access control via request
     * tags. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRelationalDatabaseSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRelationalDatabaseSnapshotRequest#builder()}
     * </p>
     *
     * @param createRelationalDatabaseSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateRelationalDatabaseSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the CreateRelationalDatabaseSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.CreateRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationalDatabaseSnapshotResponse createRelationalDatabaseSnapshot(
            Consumer<CreateRelationalDatabaseSnapshotRequest.Builder> createRelationalDatabaseSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return createRelationalDatabaseSnapshot(CreateRelationalDatabaseSnapshotRequest.builder()
                .applyMutation(createRelationalDatabaseSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes an alarm.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     *
     * @param deleteAlarmRequest
     * @return Result of the DeleteAlarm operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAlarmResponse deleteAlarm(DeleteAlarmRequest deleteAlarmRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alarm.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlarmRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAlarmRequest#builder()}
     * </p>
     *
     * @param deleteAlarmRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAlarmRequest.Builder} to create a request.
     * @return Result of the DeleteAlarm operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAlarmResponse deleteAlarm(Consumer<DeleteAlarmRequest.Builder> deleteAlarmRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        return deleteAlarm(DeleteAlarmRequest.builder().applyMutation(deleteAlarmRequest).build());
    }

    /**
     * <p>
     * Deletes an automatic snapshot of an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteAutoSnapshotRequest
     * @return Result of the DeleteAutoSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteAutoSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAutoSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAutoSnapshotResponse deleteAutoSnapshot(DeleteAutoSnapshotRequest deleteAutoSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an automatic snapshot of an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAutoSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAutoSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteAutoSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAutoSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAutoSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteAutoSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAutoSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAutoSnapshotResponse deleteAutoSnapshot(Consumer<DeleteAutoSnapshotRequest.Builder> deleteAutoSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return deleteAutoSnapshot(DeleteAutoSnapshotRequest.builder().applyMutation(deleteAutoSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Certificates that are currently attached to a distribution cannot be deleted. Use the
     * <code>DetachCertificateFromDistribution</code> action to detach a certificate from a distribution.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws ServiceException, InvalidInputException, AccessDeniedException, NotFoundException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Certificates that are currently attached to a distribution cannot be deleted. Use the
     * <code>DetachCertificateFromDistribution</code> action to detach a certificate from a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCertificateRequest.Builder} to create a request.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest)
            throws ServiceException, InvalidInputException, AccessDeniedException, NotFoundException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes a contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     *
     * @param deleteContactMethodRequest
     * @return Result of the DeleteContactMethod operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteContactMethod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContactMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteContactMethodResponse deleteContactMethod(DeleteContactMethodRequest deleteContactMethodRequest)
            throws ServiceException, InvalidInputException, OperationFailureException, UnauthenticatedException,
            AccessDeniedException, NotFoundException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactMethodRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteContactMethodRequest#builder()}
     * </p>
     *
     * @param deleteContactMethodRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContactMethodRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContactMethod operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteContactMethod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContactMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteContactMethodResponse deleteContactMethod(
            Consumer<DeleteContactMethodRequest.Builder> deleteContactMethodRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        return deleteContactMethod(DeleteContactMethodRequest.builder().applyMutation(deleteContactMethodRequest).build());
    }

    /**
     * <p>
     * Deletes a container image that is registered to your Amazon Lightsail container service.
     * </p>
     *
     * @param deleteContainerImageRequest
     * @return Result of the DeleteContainerImage operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteContainerImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerImage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteContainerImageResponse deleteContainerImage(DeleteContainerImageRequest deleteContainerImageRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a container image that is registered to your Amazon Lightsail container service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContainerImageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteContainerImageRequest#builder()}
     * </p>
     *
     * @param deleteContainerImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContainerImageRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContainerImage operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteContainerImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerImage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteContainerImageResponse deleteContainerImage(
            Consumer<DeleteContainerImageRequest.Builder> deleteContainerImageRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return deleteContainerImage(DeleteContainerImageRequest.builder().applyMutation(deleteContainerImageRequest).build());
    }

    /**
     * <p>
     * Deletes your Amazon Lightsail container service.
     * </p>
     *
     * @param deleteContainerServiceRequest
     * @return Result of the DeleteContainerService operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContainerServiceResponse deleteContainerService(DeleteContainerServiceRequest deleteContainerServiceRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes your Amazon Lightsail container service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContainerServiceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteContainerServiceRequest#builder()}
     * </p>
     *
     * @param deleteContainerServiceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContainerServiceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContainerService operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContainerServiceResponse deleteContainerService(
            Consumer<DeleteContainerServiceRequest.Builder> deleteContainerServiceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return deleteContainerService(DeleteContainerServiceRequest.builder().applyMutation(deleteContainerServiceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified block storage disk. The disk must be in the <code>available</code> state (not attached to a
     * Lightsail instance).
     * </p>
     * <note>
     * <p>
     * The disk may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note>
     * <p>
     * The <code>delete disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDiskRequest
     * @return Result of the DeleteDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDiskResponse deleteDisk(DeleteDiskRequest deleteDiskRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified block storage disk. The disk must be in the <code>available</code> state (not attached to a
     * Lightsail instance).
     * </p>
     * <note>
     * <p>
     * The disk may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note>
     * <p>
     * The <code>delete disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDiskRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDiskRequest#builder()}
     * </p>
     *
     * @param deleteDiskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDiskRequest.Builder} to create a request.
     * @return Result of the DeleteDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDiskResponse deleteDisk(Consumer<DeleteDiskRequest.Builder> deleteDiskRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteDisk(DeleteDiskRequest.builder().applyMutation(deleteDiskRequest).build());
    }

    /**
     * <p>
     * Deletes the specified disk snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that
     * have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data
     * not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the disk.
     * </p>
     * <p>
     * The <code>delete disk snapshot</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>disk snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDiskSnapshotRequest
     * @return Result of the DeleteDiskSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDiskSnapshotResponse deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified disk snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that
     * have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data
     * not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the disk.
     * </p>
     * <p>
     * The <code>delete disk snapshot</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>disk snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDiskSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDiskSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDiskSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDiskSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDiskSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDiskSnapshotResponse deleteDiskSnapshot(Consumer<DeleteDiskSnapshotRequest.Builder> deleteDiskSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteDiskSnapshot(DeleteDiskSnapshotRequest.builder().applyMutation(deleteDiskSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDistributionRequest#builder()}
     * </p>
     *
     * @param deleteDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDistributionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDistributionResponse deleteDistribution(Consumer<DeleteDistributionRequest.Builder> deleteDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return deleteDistribution(DeleteDistributionRequest.builder().applyMutation(deleteDistributionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     * <p>
     * The <code>delete domain</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     * <p>
     * The <code>delete domain</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainRequest.Builder} to create a request.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     * <p>
     * The <code>delete domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDomainEntryRequest
     * @return Result of the DeleteDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDomainEntryResponse deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     * <p>
     * The <code>delete domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainEntryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainEntryRequest#builder()}
     * </p>
     *
     * @param deleteDomainEntryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainEntryRequest.Builder} to create a request.
     * @return Result of the DeleteDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDomainEntryResponse deleteDomainEntry(Consumer<DeleteDomainEntryRequest.Builder> deleteDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteDomainEntry(DeleteDomainEntryRequest.builder().applyMutation(deleteDomainEntryRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>delete instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(DeleteInstanceRequest deleteInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>delete instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceRequest.Builder} to create a request.
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     * <p>
     * The <code>delete instance snapshot</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by <code>instance snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteInstanceSnapshotRequest
     * @return Result of the DeleteInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceSnapshotResponse deleteInstanceSnapshot(DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     * <p>
     * The <code>delete instance snapshot</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by <code>instance snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteInstanceSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceSnapshotResponse deleteInstanceSnapshot(
            Consumer<DeleteInstanceSnapshotRequest.Builder> deleteInstanceSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteInstanceSnapshot(DeleteInstanceSnapshotRequest.builder().applyMutation(deleteInstanceSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     * <p>
     * The <code>delete key pair</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>key pair name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return Result of the DeleteKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKeyPairResponse deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     * <p>
     * The <code>delete key pair</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>key pair name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyPairRequest#builder()}
     * </p>
     *
     * @param deleteKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link DeleteKeyPairRequest.Builder} to create a request.
     * @return Result of the DeleteKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKeyPairResponse deleteKeyPair(Consumer<DeleteKeyPairRequest.Builder> deleteKeyPairRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteKeyPair(DeleteKeyPairRequest.builder().applyMutation(deleteKeyPairRequest).build());
    }

    /**
     * <p>
     * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to
     * authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the
     * instance after a host key mismatch.
     * </p>
     * <important>
     * <p>
     * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar
     * with the new host key or certificate on the instance. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection"
     * >Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client</a>.
     * </p>
     * </important>
     *
     * @param deleteKnownHostKeysRequest
     * @return Result of the DeleteKnownHostKeys operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteKnownHostKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKnownHostKeys" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKnownHostKeysResponse deleteKnownHostKeys(DeleteKnownHostKeysRequest deleteKnownHostKeysRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to
     * authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the
     * instance after a host key mismatch.
     * </p>
     * <important>
     * <p>
     * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar
     * with the new host key or certificate on the instance. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection"
     * >Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKnownHostKeysRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteKnownHostKeysRequest#builder()}
     * </p>
     *
     * @param deleteKnownHostKeysRequest
     *        A {@link Consumer} that will call methods on {@link DeleteKnownHostKeysRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKnownHostKeys operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteKnownHostKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKnownHostKeys" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKnownHostKeysResponse deleteKnownHostKeys(
            Consumer<DeleteKnownHostKeysRequest.Builder> deleteKnownHostKeysRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteKnownHostKeys(DeleteKnownHostKeysRequest.builder().applyMutation(deleteKnownHostKeysRequest).build());
    }

    /**
     * <p>
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted,
     * you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     * </p>
     * <p>
     * The <code>delete load balancer</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return Result of the DeleteLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted,
     * you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     * </p>
     * <p>
     * The <code>delete load balancer</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoadBalancerRequest#builder()}
     * </p>
     *
     * @param deleteLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoadBalancerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLoadBalancerResponse deleteLoadBalancer(Consumer<DeleteLoadBalancerRequest.Builder> deleteLoadBalancerRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteLoadBalancer(DeleteLoadBalancerRequest.builder().applyMutation(deleteLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     * </p>
     * <p>
     * The <code>DeleteLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteLoadBalancerTlsCertificateRequest
     * @return Result of the DeleteLoadBalancerTlsCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoadBalancerTlsCertificateResponse deleteLoadBalancerTlsCertificate(
            DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     * </p>
     * <p>
     * The <code>DeleteLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoadBalancerTlsCertificateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLoadBalancerTlsCertificateRequest#builder()}
     * </p>
     *
     * @param deleteLoadBalancerTlsCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoadBalancerTlsCertificateRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLoadBalancerTlsCertificate operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoadBalancerTlsCertificateResponse deleteLoadBalancerTlsCertificate(
            Consumer<DeleteLoadBalancerTlsCertificateRequest.Builder> deleteLoadBalancerTlsCertificateRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteLoadBalancerTlsCertificate(DeleteLoadBalancerTlsCertificateRequest.builder()
                .applyMutation(deleteLoadBalancerTlsCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes a database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteRelationalDatabaseRequest
     * @return Result of the DeleteRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRelationalDatabaseResponse deleteRelationalDatabase(
            DeleteRelationalDatabaseRequest deleteRelationalDatabaseRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRelationalDatabaseRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRelationalDatabaseRequest#builder()}
     * </p>
     *
     * @param deleteRelationalDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRelationalDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRelationalDatabaseResponse deleteRelationalDatabase(
            Consumer<DeleteRelationalDatabaseRequest.Builder> deleteRelationalDatabaseRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteRelationalDatabase(DeleteRelationalDatabaseRequest.builder().applyMutation(deleteRelationalDatabaseRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database snapshot</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteRelationalDatabaseSnapshotRequest
     * @return Result of the DeleteRelationalDatabaseSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRelationalDatabaseSnapshotResponse deleteRelationalDatabaseSnapshot(
            DeleteRelationalDatabaseSnapshotRequest deleteRelationalDatabaseSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database snapshot</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRelationalDatabaseSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRelationalDatabaseSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteRelationalDatabaseSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRelationalDatabaseSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteRelationalDatabaseSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DeleteRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRelationalDatabaseSnapshotResponse deleteRelationalDatabaseSnapshot(
            Consumer<DeleteRelationalDatabaseSnapshotRequest.Builder> deleteRelationalDatabaseSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return deleteRelationalDatabaseSnapshot(DeleteRelationalDatabaseSnapshotRequest.builder()
                .applyMutation(deleteRelationalDatabaseSnapshotRequest).build());
    }

    /**
     * <p>
     * Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is detached, your distribution stops accepting traffic for all of the domains that are
     * associated with the certificate.
     * </p>
     *
     * @param detachCertificateFromDistributionRequest
     * @return Result of the DetachCertificateFromDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachCertificateFromDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachCertificateFromDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachCertificateFromDistributionResponse detachCertificateFromDistribution(
            DetachCertificateFromDistributionRequest detachCertificateFromDistributionRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is detached, your distribution stops accepting traffic for all of the domains that are
     * associated with the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachCertificateFromDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link DetachCertificateFromDistributionRequest#builder()}
     * </p>
     *
     * @param detachCertificateFromDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DetachCertificateFromDistributionRequest.Builder} to
     *        create a request.
     * @return Result of the DetachCertificateFromDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachCertificateFromDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachCertificateFromDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachCertificateFromDistributionResponse detachCertificateFromDistribution(
            Consumer<DetachCertificateFromDistributionRequest.Builder> detachCertificateFromDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return detachCertificateFromDistribution(DetachCertificateFromDistributionRequest.builder()
                .applyMutation(detachCertificateFromDistributionRequest).build());
    }

    /**
     * <p>
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the
     * device within your operating system before stopping the instance and detaching the disk.
     * </p>
     * <p>
     * The <code>detach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param detachDiskRequest
     * @return Result of the DetachDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachDiskResponse detachDisk(DetachDiskRequest detachDiskRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the
     * device within your operating system before stopping the instance and detaching the disk.
     * </p>
     * <p>
     * The <code>detach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachDiskRequest.Builder} avoiding the need to
     * create one manually via {@link DetachDiskRequest#builder()}
     * </p>
     *
     * @param detachDiskRequest
     *        A {@link Consumer} that will call methods on {@link DetachDiskRequest.Builder} to create a request.
     * @return Result of the DetachDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachDiskResponse detachDisk(Consumer<DetachDiskRequest.Builder> detachDiskRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return detachDisk(DetachDiskRequest.builder().applyMutation(detachDiskRequest).build());
    }

    /**
     * <p>
     * Detaches the specified instances from a Lightsail load balancer.
     * </p>
     * <p>
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     * </p>
     * <p>
     * The <code>detach instances from load balancer</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">Lightsail
     * Dev Guide</a>.
     * </p>
     *
     * @param detachInstancesFromLoadBalancerRequest
     * @return Result of the DetachInstancesFromLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachInstancesFromLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachInstancesFromLoadBalancerResponse detachInstancesFromLoadBalancer(
            DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the specified instances from a Lightsail load balancer.
     * </p>
     * <p>
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     * </p>
     * <p>
     * The <code>detach instances from load balancer</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">Lightsail
     * Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachInstancesFromLoadBalancerRequest.Builder}
     * avoiding the need to create one manually via {@link DetachInstancesFromLoadBalancerRequest#builder()}
     * </p>
     *
     * @param detachInstancesFromLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link DetachInstancesFromLoadBalancerRequest.Builder} to
     *        create a request.
     * @return Result of the DetachInstancesFromLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachInstancesFromLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachInstancesFromLoadBalancerResponse detachInstancesFromLoadBalancer(
            Consumer<DetachInstancesFromLoadBalancerRequest.Builder> detachInstancesFromLoadBalancerRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return detachInstancesFromLoadBalancer(DetachInstancesFromLoadBalancerRequest.builder()
                .applyMutation(detachInstancesFromLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     *
     * @param detachStaticIpRequest
     * @return Result of the DetachStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachStaticIpResponse detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachStaticIpRequest.Builder} avoiding the need to
     * create one manually via {@link DetachStaticIpRequest#builder()}
     * </p>
     *
     * @param detachStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link DetachStaticIpRequest.Builder} to create a request.
     * @return Result of the DetachStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default DetachStaticIpResponse detachStaticIp(Consumer<DetachStaticIpRequest.Builder> detachStaticIpRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return detachStaticIp(DetachStaticIpRequest.builder().applyMutation(detachStaticIpRequest).build());
    }

    /**
     * <p>
     * Disables an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param disableAddOnRequest
     * @return Result of the DisableAddOn operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DisableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DisableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableAddOnResponse disableAddOn(DisableAddOnRequest disableAddOnRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableAddOnRequest.Builder} avoiding the need to
     * create one manually via {@link DisableAddOnRequest#builder()}
     * </p>
     *
     * @param disableAddOnRequest
     *        A {@link Consumer} that will call methods on {@link DisableAddOnRequest.Builder} to create a request.
     * @return Result of the DisableAddOn operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DisableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DisableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableAddOnResponse disableAddOn(Consumer<DisableAddOnRequest.Builder> disableAddOnRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return disableAddOn(DisableAddOnRequest.builder().applyMutation(disableAddOnRequest).build());
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     *
     * @return Result of the DownloadDefaultKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DownloadDefaultKeyPair
     * @see #downloadDefaultKeyPair(DownloadDefaultKeyPairRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    default DownloadDefaultKeyPairResponse downloadDefaultKeyPair() throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return downloadDefaultKeyPair(DownloadDefaultKeyPairRequest.builder().build());
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     *
     * @param downloadDefaultKeyPairRequest
     * @return Result of the DownloadDefaultKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    default DownloadDefaultKeyPairResponse downloadDefaultKeyPair(DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DownloadDefaultKeyPairRequest.Builder} avoiding the
     * need to create one manually via {@link DownloadDefaultKeyPairRequest#builder()}
     * </p>
     *
     * @param downloadDefaultKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link DownloadDefaultKeyPairRequest.Builder} to create a
     *        request.
     * @return Result of the DownloadDefaultKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    default DownloadDefaultKeyPairResponse downloadDefaultKeyPair(
            Consumer<DownloadDefaultKeyPairRequest.Builder> downloadDefaultKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return downloadDefaultKeyPair(DownloadDefaultKeyPairRequest.builder().applyMutation(downloadDefaultKeyPairRequest)
                .build());
    }

    /**
     * <p>
     * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param enableAddOnRequest
     * @return Result of the EnableAddOn operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.EnableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/EnableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableAddOnResponse enableAddOn(EnableAddOnRequest enableAddOnRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableAddOnRequest.Builder} avoiding the need to
     * create one manually via {@link EnableAddOnRequest#builder()}
     * </p>
     *
     * @param enableAddOnRequest
     *        A {@link Consumer} that will call methods on {@link EnableAddOnRequest.Builder} to create a request.
     * @return Result of the EnableAddOn operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.EnableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/EnableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableAddOnResponse enableAddOn(Consumer<EnableAddOnRequest.Builder> enableAddOnRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return enableAddOn(EnableAddOnRequest.builder().applyMutation(enableAddOnRequest).build());
    }

    /**
     * <p>
     * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2).
     * This operation results in an export snapshot record that can be used with the
     * <code>create cloud formation stack</code> operation to create new Amazon EC2 instances.
     * </p>
     * <p>
     * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk
     * appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as
     * Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source
     * Lightsail snapshot.
     * </p>
     * <p/>
     * <p>
     * The <code>export snapshot</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>source snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <note>
     * <p>
     * Use the <code>get instance snapshots</code> or <code>get disk snapshots</code> operations to get a list of
     * snapshots that you can export to Amazon EC2.
     * </p>
     * </note>
     *
     * @param exportSnapshotRequest
     * @return Result of the ExportSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ExportSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportSnapshotResponse exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2).
     * This operation results in an export snapshot record that can be used with the
     * <code>create cloud formation stack</code> operation to create new Amazon EC2 instances.
     * </p>
     * <p>
     * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk
     * appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as
     * Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source
     * Lightsail snapshot.
     * </p>
     * <p/>
     * <p>
     * The <code>export snapshot</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>source snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <note>
     * <p>
     * Use the <code>get instance snapshots</code> or <code>get disk snapshots</code> operations to get a list of
     * snapshots that you can export to Amazon EC2.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link ExportSnapshotRequest#builder()}
     * </p>
     *
     * @param exportSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link ExportSnapshotRequest.Builder} to create a request.
     * @return Result of the ExportSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ExportSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportSnapshotResponse exportSnapshot(Consumer<ExportSnapshotRequest.Builder> exportSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return exportSnapshot(ExportSnapshotRequest.builder().applyMutation(exportSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     *
     * @return Result of the GetActiveNames operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetActiveNames
     * @see #getActiveNames(GetActiveNamesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    default GetActiveNamesResponse getActiveNames() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getActiveNames(GetActiveNamesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     *
     * @param getActiveNamesRequest
     * @return Result of the GetActiveNames operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    default GetActiveNamesResponse getActiveNames(GetActiveNamesRequest getActiveNamesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActiveNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetActiveNamesRequest#builder()}
     * </p>
     *
     * @param getActiveNamesRequest
     *        A {@link Consumer} that will call methods on {@link GetActiveNamesRequest.Builder} to create a request.
     * @return Result of the GetActiveNames operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    default GetActiveNamesResponse getActiveNames(Consumer<GetActiveNamesRequest.Builder> getActiveNamesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getActiveNames(GetActiveNamesRequest.builder().applyMutation(getActiveNamesRequest).build());
    }

    /**
     * <p>
     * Returns information about the configured alarms. Specify an alarm name in your request to return information
     * about a specific alarm, or specify a monitored resource name to return information about all alarms for a
     * specific resource.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     *
     * @param getAlarmsRequest
     * @return Result of the GetAlarms operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetAlarms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAlarmsResponse getAlarms(GetAlarmsRequest getAlarmsRequest) throws ServiceException, InvalidInputException,
            OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the configured alarms. Specify an alarm name in your request to return information
     * about a specific alarm, or specify a monitored resource name to return information about all alarms for a
     * specific resource.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAlarmsRequest.Builder} avoiding the need to
     * create one manually via {@link GetAlarmsRequest#builder()}
     * </p>
     *
     * @param getAlarmsRequest
     *        A {@link Consumer} that will call methods on {@link GetAlarmsRequest.Builder} to create a request.
     * @return Result of the GetAlarms operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetAlarms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAlarmsResponse getAlarms(Consumer<GetAlarmsRequest.Builder> getAlarmsRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        return getAlarms(GetAlarmsRequest.builder().applyMutation(getAlarmsRequest).build());
    }

    /**
     * <p>
     * Returns the available automatic snapshots for an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param getAutoSnapshotsRequest
     * @return Result of the GetAutoSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetAutoSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAutoSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAutoSnapshotsResponse getAutoSnapshots(GetAutoSnapshotsRequest getAutoSnapshotsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the available automatic snapshots for an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutoSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link GetAutoSnapshotsRequest#builder()}
     * </p>
     *
     * @param getAutoSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetAutoSnapshotsRequest.Builder} to create a request.
     * @return Result of the GetAutoSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetAutoSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAutoSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAutoSnapshotsResponse getAutoSnapshots(Consumer<GetAutoSnapshotsRequest.Builder> getAutoSnapshotsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getAutoSnapshots(GetAutoSnapshotsRequest.builder().applyMutation(getAutoSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * instance already running a specific operating system, as well as a preinstalled app or development stack. The
     * software each instance is running depends on the blueprint image you choose.
     * </p>
     * <note>
     * <p>
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with
     * existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when
     * they become outdated due to operating system updates or new application releases.
     * </p>
     * </note>
     *
     * @return Result of the GetBlueprints operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetBlueprints
     * @see #getBlueprints(GetBlueprintsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlueprintsResponse getBlueprints() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getBlueprints(GetBlueprintsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * instance already running a specific operating system, as well as a preinstalled app or development stack. The
     * software each instance is running depends on the blueprint image you choose.
     * </p>
     * <note>
     * <p>
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with
     * existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when
     * they become outdated due to operating system updates or new application releases.
     * </p>
     * </note>
     *
     * @param getBlueprintsRequest
     * @return Result of the GetBlueprints operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlueprintsResponse getBlueprints(GetBlueprintsRequest getBlueprintsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * instance already running a specific operating system, as well as a preinstalled app or development stack. The
     * software each instance is running depends on the blueprint image you choose.
     * </p>
     * <note>
     * <p>
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with
     * existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when
     * they become outdated due to operating system updates or new application releases.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintsRequest.Builder} avoiding the need to
     * create one manually via {@link GetBlueprintsRequest#builder()}
     * </p>
     *
     * @param getBlueprintsRequest
     *        A {@link Consumer} that will call methods on {@link GetBlueprintsRequest.Builder} to create a request.
     * @return Result of the GetBlueprints operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlueprintsResponse getBlueprints(Consumer<GetBlueprintsRequest.Builder> getBlueprintsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getBlueprints(GetBlueprintsRequest.builder().applyMutation(getBlueprintsRequest).build());
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     *
     * @return Result of the GetBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetBundles
     * @see #getBundles(GetBundlesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBundlesResponse getBundles() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getBundles(GetBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     *
     * @param getBundlesRequest
     * @return Result of the GetBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBundlesResponse getBundles(GetBundlesRequest getBundlesRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link GetBundlesRequest#builder()}
     * </p>
     *
     * @param getBundlesRequest
     *        A {@link Consumer} that will call methods on {@link GetBundlesRequest.Builder} to create a request.
     * @return Result of the GetBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBundlesResponse getBundles(Consumer<GetBundlesRequest.Builder> getBundlesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getBundles(GetBundlesRequest.builder().applyMutation(getBundlesRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more Amazon Lightsail SSL/TLS certificates.
     * </p>
     * <note>
     * <p>
     * To get a summary of a certificate, ommit <code>includeCertificateDetails</code> from your request. The response
     * will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
     * </p>
     * </note>
     *
     * @param getCertificatesRequest
     * @return Result of the GetCertificates operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCertificatesResponse getCertificates(GetCertificatesRequest getCertificatesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more Amazon Lightsail SSL/TLS certificates.
     * </p>
     * <note>
     * <p>
     * To get a summary of a certificate, ommit <code>includeCertificateDetails</code> from your request. The response
     * will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link GetCertificatesRequest#builder()}
     * </p>
     *
     * @param getCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link GetCertificatesRequest.Builder} to create a request.
     * @return Result of the GetCertificates operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCertificatesResponse getCertificates(Consumer<GetCertificatesRequest.Builder> getCertificatesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getCertificates(GetCertificatesRequest.builder().applyMutation(getCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns the CloudFormation stack record created as a result of the <code>create cloud formation stack</code>
     * operation.
     * </p>
     * <p>
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     * </p>
     *
     * @return Result of the GetCloudFormationStackRecords operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetCloudFormationStackRecords
     * @see #getCloudFormationStackRecords(GetCloudFormationStackRecordsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCloudFormationStackRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFormationStackRecordsResponse getCloudFormationStackRecords() throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getCloudFormationStackRecords(GetCloudFormationStackRecordsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the CloudFormation stack record created as a result of the <code>create cloud formation stack</code>
     * operation.
     * </p>
     * <p>
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     * </p>
     *
     * @param getCloudFormationStackRecordsRequest
     * @return Result of the GetCloudFormationStackRecords operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetCloudFormationStackRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCloudFormationStackRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFormationStackRecordsResponse getCloudFormationStackRecords(
            GetCloudFormationStackRecordsRequest getCloudFormationStackRecordsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the CloudFormation stack record created as a result of the <code>create cloud formation stack</code>
     * operation.
     * </p>
     * <p>
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudFormationStackRecordsRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudFormationStackRecordsRequest#builder()}
     * </p>
     *
     * @param getCloudFormationStackRecordsRequest
     *        A {@link Consumer} that will call methods on {@link GetCloudFormationStackRecordsRequest.Builder} to
     *        create a request.
     * @return Result of the GetCloudFormationStackRecords operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetCloudFormationStackRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCloudFormationStackRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFormationStackRecordsResponse getCloudFormationStackRecords(
            Consumer<GetCloudFormationStackRecordsRequest.Builder> getCloudFormationStackRecordsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getCloudFormationStackRecords(GetCloudFormationStackRecordsRequest.builder()
                .applyMutation(getCloudFormationStackRecordsRequest).build());
    }

    /**
     * <p>
     * Returns information about the configured contact methods. Specify a protocol in your request to return
     * information about a specific contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     *
     * @param getContactMethodsRequest
     * @return Result of the GetContactMethods operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContactMethods
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContactMethods" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactMethodsResponse getContactMethods(GetContactMethodsRequest getContactMethodsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the configured contact methods. Specify a protocol in your request to return
     * information about a specific contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactMethodsRequest.Builder} avoiding the need
     * to create one manually via {@link GetContactMethodsRequest#builder()}
     * </p>
     *
     * @param getContactMethodsRequest
     *        A {@link Consumer} that will call methods on {@link GetContactMethodsRequest.Builder} to create a request.
     * @return Result of the GetContactMethods operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContactMethods
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContactMethods" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactMethodsResponse getContactMethods(Consumer<GetContactMethodsRequest.Builder> getContactMethodsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getContactMethods(GetContactMethodsRequest.builder().applyMutation(getContactMethodsRequest).build());
    }

    /**
     * <p>
     * Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control
     * (lightsailctl) plugin.
     * </p>
     *
     * @param getContainerApiMetadataRequest
     * @return Result of the GetContainerAPIMetadata operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerAPIMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerAPIMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerApiMetadataResponse getContainerAPIMetadata(GetContainerApiMetadataRequest getContainerApiMetadataRequest)
            throws ServiceException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control
     * (lightsailctl) plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerApiMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link GetContainerApiMetadataRequest#builder()}
     * </p>
     *
     * @param getContainerApiMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerAPIMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the GetContainerAPIMetadata operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerAPIMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerAPIMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerApiMetadataResponse getContainerAPIMetadata(
            Consumer<GetContainerApiMetadataRequest.Builder> getContainerApiMetadataRequest) throws ServiceException,
            AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getContainerAPIMetadata(GetContainerApiMetadataRequest.builder().applyMutation(getContainerApiMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Returns the container images that are registered to your Amazon Lightsail container service.
     * </p>
     * <note>
     * <p>
     * If you created a deployment on your Lightsail container service that uses container images from a public registry
     * like Docker Hub, those images are not returned as part of this action. Those images are not registered to your
     * Lightsail container service.
     * </p>
     * </note>
     *
     * @param getContainerImagesRequest
     * @return Result of the GetContainerImages operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerImages" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContainerImagesResponse getContainerImages(GetContainerImagesRequest getContainerImagesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the container images that are registered to your Amazon Lightsail container service.
     * </p>
     * <note>
     * <p>
     * If you created a deployment on your Lightsail container service that uses container images from a public registry
     * like Docker Hub, those images are not returned as part of this action. Those images are not registered to your
     * Lightsail container service.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerImagesRequest.Builder} avoiding the
     * need to create one manually via {@link GetContainerImagesRequest#builder()}
     * </p>
     *
     * @param getContainerImagesRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerImagesRequest.Builder} to create a
     *        request.
     * @return Result of the GetContainerImages operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerImages" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContainerImagesResponse getContainerImages(Consumer<GetContainerImagesRequest.Builder> getContainerImagesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getContainerImages(GetContainerImagesRequest.builder().applyMutation(getContainerImagesRequest).build());
    }

    /**
     * <p>
     * Returns the log events of a container of your Amazon Lightsail container service.
     * </p>
     * <p>
     * If your container service has more than one node (i.e., a scale greater than 1), then the log events that are
     * returned for the specified container are merged from all nodes on your container service.
     * </p>
     * <note>
     * <p>
     * Container logs are retained for a certain amount of time. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail endpoints and quotas</a> in
     * the <i>AWS General Reference</i>.
     * </p>
     * </note>
     *
     * @param getContainerLogRequest
     * @return Result of the GetContainerLog operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerLog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerLog" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContainerLogResponse getContainerLog(GetContainerLogRequest getContainerLogRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the log events of a container of your Amazon Lightsail container service.
     * </p>
     * <p>
     * If your container service has more than one node (i.e., a scale greater than 1), then the log events that are
     * returned for the specified container are merged from all nodes on your container service.
     * </p>
     * <note>
     * <p>
     * Container logs are retained for a certain amount of time. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail endpoints and quotas</a> in
     * the <i>AWS General Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerLogRequest.Builder} avoiding the need
     * to create one manually via {@link GetContainerLogRequest#builder()}
     * </p>
     *
     * @param getContainerLogRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerLogRequest.Builder} to create a request.
     * @return Result of the GetContainerLog operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerLog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerLog" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContainerLogResponse getContainerLog(Consumer<GetContainerLogRequest.Builder> getContainerLogRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getContainerLog(GetContainerLogRequest.builder().applyMutation(getContainerLogRequest).build());
    }

    /**
     * <p>
     * Returns the deployments for your Amazon Lightsail container service
     * </p>
     * <p>
     * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to
     * your container service.
     * </p>
     * <p>
     * The deployments are ordered by version in ascending order. The newest version is listed at the top of the
     * response.
     * </p>
     * <note>
     * <p>
     * A set number of deployments are kept before the oldest one is replaced with the newest one. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail endpoints and
     * quotas</a> in the <i>AWS General Reference</i>.
     * </p>
     * </note>
     *
     * @param getContainerServiceDeploymentsRequest
     * @return Result of the GetContainerServiceDeployments operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServiceDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerServiceDeploymentsResponse getContainerServiceDeployments(
            GetContainerServiceDeploymentsRequest getContainerServiceDeploymentsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the deployments for your Amazon Lightsail container service
     * </p>
     * <p>
     * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to
     * your container service.
     * </p>
     * <p>
     * The deployments are ordered by version in ascending order. The newest version is listed at the top of the
     * response.
     * </p>
     * <note>
     * <p>
     * A set number of deployments are kept before the oldest one is replaced with the newest one. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail endpoints and
     * quotas</a> in the <i>AWS General Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerServiceDeploymentsRequest.Builder}
     * avoiding the need to create one manually via {@link GetContainerServiceDeploymentsRequest#builder()}
     * </p>
     *
     * @param getContainerServiceDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerServiceDeploymentsRequest.Builder} to
     *        create a request.
     * @return Result of the GetContainerServiceDeployments operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServiceDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerServiceDeploymentsResponse getContainerServiceDeployments(
            Consumer<GetContainerServiceDeploymentsRequest.Builder> getContainerServiceDeploymentsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getContainerServiceDeployments(GetContainerServiceDeploymentsRequest.builder()
                .applyMutation(getContainerServiceDeploymentsRequest).build());
    }

    /**
     * <p>
     * Returns the data points of a specific metric of your Amazon Lightsail container service.
     * </p>
     * <p>
     * Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the
     * reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getContainerServiceMetricDataRequest
     * @return Result of the GetContainerServiceMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServiceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerServiceMetricDataResponse getContainerServiceMetricData(
            GetContainerServiceMetricDataRequest getContainerServiceMetricDataRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data points of a specific metric of your Amazon Lightsail container service.
     * </p>
     * <p>
     * Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the
     * reliability, availability, and performance of your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerServiceMetricDataRequest.Builder}
     * avoiding the need to create one manually via {@link GetContainerServiceMetricDataRequest#builder()}
     * </p>
     *
     * @param getContainerServiceMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerServiceMetricDataRequest.Builder} to
     *        create a request.
     * @return Result of the GetContainerServiceMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServiceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerServiceMetricDataResponse getContainerServiceMetricData(
            Consumer<GetContainerServiceMetricDataRequest.Builder> getContainerServiceMetricDataRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return getContainerServiceMetricData(GetContainerServiceMetricDataRequest.builder()
                .applyMutation(getContainerServiceMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns the list of powers that can be specified for your Amazon Lightsail container services.
     * </p>
     * <p>
     * The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.
     * </p>
     *
     * @param getContainerServicePowersRequest
     * @return Result of the GetContainerServicePowers operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServicePowers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServicePowers"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerServicePowersResponse getContainerServicePowers(
            GetContainerServicePowersRequest getContainerServicePowersRequest) throws ServiceException, InvalidInputException,
            NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of powers that can be specified for your Amazon Lightsail container services.
     * </p>
     * <p>
     * The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerServicePowersRequest.Builder} avoiding
     * the need to create one manually via {@link GetContainerServicePowersRequest#builder()}
     * </p>
     *
     * @param getContainerServicePowersRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerServicePowersRequest.Builder} to create a
     *        request.
     * @return Result of the GetContainerServicePowers operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServicePowers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServicePowers"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContainerServicePowersResponse getContainerServicePowers(
            Consumer<GetContainerServicePowersRequest.Builder> getContainerServicePowersRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return getContainerServicePowers(GetContainerServicePowersRequest.builder()
                .applyMutation(getContainerServicePowersRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more of your Amazon Lightsail container services.
     * </p>
     *
     * @param getContainerServicesRequest
     * @return Result of the GetContainerServices operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServices" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContainerServicesResponse getContainerServices(GetContainerServicesRequest getContainerServicesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more of your Amazon Lightsail container services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerServicesRequest.Builder} avoiding the
     * need to create one manually via {@link GetContainerServicesRequest#builder()}
     * </p>
     *
     * @param getContainerServicesRequest
     *        A {@link Consumer} that will call methods on {@link GetContainerServicesRequest.Builder} to create a
     *        request.
     * @return Result of the GetContainerServices operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetContainerServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServices" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContainerServicesResponse getContainerServices(
            Consumer<GetContainerServicesRequest.Builder> getContainerServicesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return getContainerServices(GetContainerServicesRequest.builder().applyMutation(getContainerServicesRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific block storage disk.
     * </p>
     *
     * @param getDiskRequest
     * @return Result of the GetDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDiskResponse getDisk(GetDiskRequest getDiskRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific block storage disk.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiskRequest.Builder} avoiding the need to create
     * one manually via {@link GetDiskRequest#builder()}
     * </p>
     *
     * @param getDiskRequest
     *        A {@link Consumer} that will call methods on {@link GetDiskRequest.Builder} to create a request.
     * @return Result of the GetDisk operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDiskResponse getDisk(Consumer<GetDiskRequest.Builder> getDiskRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getDisk(GetDiskRequest.builder().applyMutation(getDiskRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific block storage disk snapshot.
     * </p>
     *
     * @param getDiskSnapshotRequest
     * @return Result of the GetDiskSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDiskSnapshotResponse getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific block storage disk snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiskSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link GetDiskSnapshotRequest#builder()}
     * </p>
     *
     * @param getDiskSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link GetDiskSnapshotRequest.Builder} to create a request.
     * @return Result of the GetDiskSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDiskSnapshotResponse getDiskSnapshot(Consumer<GetDiskSnapshotRequest.Builder> getDiskSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getDiskSnapshot(GetDiskSnapshotRequest.builder().applyMutation(getDiskSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     *
     * @return Result of the GetDiskSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDiskSnapshots
     * @see #getDiskSnapshots(GetDiskSnapshotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDiskSnapshotsResponse getDiskSnapshots() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getDiskSnapshots(GetDiskSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     *
     * @param getDiskSnapshotsRequest
     * @return Result of the GetDiskSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDiskSnapshotsResponse getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiskSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDiskSnapshotsRequest#builder()}
     * </p>
     *
     * @param getDiskSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetDiskSnapshotsRequest.Builder} to create a request.
     * @return Result of the GetDiskSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDiskSnapshotsResponse getDiskSnapshots(Consumer<GetDiskSnapshotsRequest.Builder> getDiskSnapshotsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getDiskSnapshots(GetDiskSnapshotsRequest.builder().applyMutation(getDiskSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     *
     * @return Result of the GetDisks operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDisks
     * @see #getDisks(GetDisksRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDisksResponse getDisks() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getDisks(GetDisksRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     *
     * @param getDisksRequest
     * @return Result of the GetDisks operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDisksResponse getDisks(GetDisksRequest getDisksRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDisksRequest.Builder} avoiding the need to
     * create one manually via {@link GetDisksRequest#builder()}
     * </p>
     *
     * @param getDisksRequest
     *        A {@link Consumer} that will call methods on {@link GetDisksRequest.Builder} to create a request.
     * @return Result of the GetDisks operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDisksResponse getDisks(Consumer<GetDisksRequest.Builder> getDisksRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getDisks(GetDisksRequest.builder().applyMutation(getDisksRequest).build());
    }

    /**
     * <p>
     * Returns the list bundles that can be applied to you Amazon Lightsail content delivery network (CDN)
     * distributions.
     * </p>
     * <p>
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution.
     * </p>
     *
     * @param getDistributionBundlesRequest
     * @return Result of the GetDistributionBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributionBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionBundlesResponse getDistributionBundles(GetDistributionBundlesRequest getDistributionBundlesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list bundles that can be applied to you Amazon Lightsail content delivery network (CDN)
     * distributions.
     * </p>
     * <p>
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionBundlesRequest.Builder} avoiding the
     * need to create one manually via {@link GetDistributionBundlesRequest#builder()}
     * </p>
     *
     * @param getDistributionBundlesRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionBundlesRequest.Builder} to create a
     *        request.
     * @return Result of the GetDistributionBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributionBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionBundlesResponse getDistributionBundles(
            Consumer<GetDistributionBundlesRequest.Builder> getDistributionBundlesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getDistributionBundles(GetDistributionBundlesRequest.builder().applyMutation(getDistributionBundlesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network
     * (CDN) distribution.
     * </p>
     *
     * @param getDistributionLatestCacheResetRequest
     * @return Result of the GetDistributionLatestCacheReset operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributionLatestCacheReset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionLatestCacheReset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionLatestCacheResetResponse getDistributionLatestCacheReset(
            GetDistributionLatestCacheResetRequest getDistributionLatestCacheResetRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network
     * (CDN) distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionLatestCacheResetRequest.Builder}
     * avoiding the need to create one manually via {@link GetDistributionLatestCacheResetRequest#builder()}
     * </p>
     *
     * @param getDistributionLatestCacheResetRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionLatestCacheResetRequest.Builder} to
     *        create a request.
     * @return Result of the GetDistributionLatestCacheReset operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributionLatestCacheReset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionLatestCacheReset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionLatestCacheResetResponse getDistributionLatestCacheReset(
            Consumer<GetDistributionLatestCacheResetRequest.Builder> getDistributionLatestCacheResetRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getDistributionLatestCacheReset(GetDistributionLatestCacheResetRequest.builder()
                .applyMutation(getDistributionLatestCacheResetRequest).build());
    }

    /**
     * <p>
     * Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getDistributionMetricDataRequest
     * @return Result of the GetDistributionMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributionMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionMetricDataResponse getDistributionMetricData(
            GetDistributionMetricDataRequest getDistributionMetricDataRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionMetricDataRequest.Builder} avoiding
     * the need to create one manually via {@link GetDistributionMetricDataRequest#builder()}
     * </p>
     *
     * @param getDistributionMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionMetricDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetDistributionMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributionMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionMetricDataResponse getDistributionMetricData(
            Consumer<GetDistributionMetricDataRequest.Builder> getDistributionMetricDataRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getDistributionMetricData(GetDistributionMetricDataRequest.builder()
                .applyMutation(getDistributionMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
     * </p>
     *
     * @param getDistributionsRequest
     * @return Result of the GetDistributions operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDistributionsResponse getDistributions(GetDistributionsRequest getDistributionsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDistributionsRequest#builder()}
     * </p>
     *
     * @param getDistributionsRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionsRequest.Builder} to create a request.
     * @return Result of the GetDistributions operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDistributionsResponse getDistributions(Consumer<GetDistributionsRequest.Builder> getDistributionsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getDistributions(GetDistributionsRequest.builder().applyMutation(getDistributionsRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     *
     * @param getDomainRequest
     * @return Result of the GetDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainResponse getDomain(GetDomainRequest getDomainRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainRequest.Builder} to create a request.
     * @return Result of the GetDomain operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainResponse getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     *
     * @return Result of the GetDomains operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDomains
     * @see #getDomains(GetDomainsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainsResponse getDomains() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getDomains(GetDomainsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     *
     * @param getDomainsRequest
     * @return Result of the GetDomains operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainsResponse getDomains(GetDomainsRequest getDomainsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainsRequest#builder()}
     * </p>
     *
     * @param getDomainsRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainsRequest.Builder} to create a request.
     * @return Result of the GetDomains operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainsResponse getDomains(Consumer<GetDomainsRequest.Builder> getDomainsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getDomains(GetDomainsRequest.builder().applyMutation(getDomainsRequest).build());
    }

    /**
     * <p>
     * Returns the export snapshot record created as a result of the <code>export snapshot</code> operation.
     * </p>
     * <p>
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the
     * <code>create cloud formation stack</code> operation.
     * </p>
     *
     * @return Result of the GetExportSnapshotRecords operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetExportSnapshotRecords
     * @see #getExportSnapshotRecords(GetExportSnapshotRecordsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetExportSnapshotRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExportSnapshotRecordsResponse getExportSnapshotRecords() throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getExportSnapshotRecords(GetExportSnapshotRecordsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the export snapshot record created as a result of the <code>export snapshot</code> operation.
     * </p>
     * <p>
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the
     * <code>create cloud formation stack</code> operation.
     * </p>
     *
     * @param getExportSnapshotRecordsRequest
     * @return Result of the GetExportSnapshotRecords operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetExportSnapshotRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetExportSnapshotRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExportSnapshotRecordsResponse getExportSnapshotRecords(
            GetExportSnapshotRecordsRequest getExportSnapshotRecordsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the export snapshot record created as a result of the <code>export snapshot</code> operation.
     * </p>
     * <p>
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the
     * <code>create cloud formation stack</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportSnapshotRecordsRequest.Builder} avoiding
     * the need to create one manually via {@link GetExportSnapshotRecordsRequest#builder()}
     * </p>
     *
     * @param getExportSnapshotRecordsRequest
     *        A {@link Consumer} that will call methods on {@link GetExportSnapshotRecordsRequest.Builder} to create a
     *        request.
     * @return Result of the GetExportSnapshotRecords operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetExportSnapshotRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetExportSnapshotRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExportSnapshotRecordsResponse getExportSnapshotRecords(
            Consumer<GetExportSnapshotRecordsRequest.Builder> getExportSnapshotRecordsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getExportSnapshotRecords(GetExportSnapshotRecordsRequest.builder().applyMutation(getExportSnapshotRecordsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     *
     * @param getInstanceRequest
     * @return Result of the GetInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link GetInstanceRequest#builder()}
     * </p>
     *
     * @param getInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceRequest.Builder} to create a request.
     * @return Result of the GetInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceResponse getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstance(GetInstanceRequest.builder().applyMutation(getInstanceRequest).build());
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     * <p>
     * The <code>get instance access details</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param getInstanceAccessDetailsRequest
     * @return Result of the GetInstanceAccessDetails operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceAccessDetailsResponse getInstanceAccessDetails(
            GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     * <p>
     * The <code>get instance access details</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceAccessDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetInstanceAccessDetailsRequest#builder()}
     * </p>
     *
     * @param getInstanceAccessDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceAccessDetailsRequest.Builder} to create a
     *        request.
     * @return Result of the GetInstanceAccessDetails operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceAccessDetailsResponse getInstanceAccessDetails(
            Consumer<GetInstanceAccessDetailsRequest.Builder> getInstanceAccessDetailsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstanceAccessDetails(GetInstanceAccessDetailsRequest.builder().applyMutation(getInstanceAccessDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getInstanceMetricDataRequest
     * @return Result of the GetInstanceMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceMetricDataResponse getInstanceMetricData(GetInstanceMetricDataRequest getInstanceMetricDataRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceMetricDataRequest#builder()}
     * </p>
     *
     * @param getInstanceMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceMetricDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetInstanceMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstanceMetricDataResponse getInstanceMetricData(
            Consumer<GetInstanceMetricDataRequest.Builder> getInstanceMetricDataRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstanceMetricData(GetInstanceMetricDataRequest.builder().applyMutation(getInstanceMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to
     * the instance through the ports, and the protocol.
     * </p>
     *
     * @param getInstancePortStatesRequest
     * @return Result of the GetInstancePortStates operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstancePortStatesResponse getInstancePortStates(GetInstancePortStatesRequest getInstancePortStatesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to
     * the instance through the ports, and the protocol.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstancePortStatesRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstancePortStatesRequest#builder()}
     * </p>
     *
     * @param getInstancePortStatesRequest
     *        A {@link Consumer} that will call methods on {@link GetInstancePortStatesRequest.Builder} to create a
     *        request.
     * @return Result of the GetInstancePortStates operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstancePortStatesResponse getInstancePortStates(
            Consumer<GetInstancePortStatesRequest.Builder> getInstancePortStatesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstancePortStates(GetInstancePortStatesRequest.builder().applyMutation(getInstancePortStatesRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     *
     * @param getInstanceSnapshotRequest
     * @return Result of the GetInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceSnapshotResponse getInstanceSnapshot(GetInstanceSnapshotRequest getInstanceSnapshotRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceSnapshotRequest#builder()}
     * </p>
     *
     * @param getInstanceSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the GetInstanceSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceSnapshotResponse getInstanceSnapshot(
            Consumer<GetInstanceSnapshotRequest.Builder> getInstanceSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstanceSnapshot(GetInstanceSnapshotRequest.builder().applyMutation(getInstanceSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     *
     * @return Result of the GetInstanceSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceSnapshots
     * @see #getInstanceSnapshots(GetInstanceSnapshotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceSnapshotsResponse getInstanceSnapshots() throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getInstanceSnapshots(GetInstanceSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     *
     * @param getInstanceSnapshotsRequest
     * @return Result of the GetInstanceSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceSnapshotsResponse getInstanceSnapshots(GetInstanceSnapshotsRequest getInstanceSnapshotsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceSnapshotsRequest#builder()}
     * </p>
     *
     * @param getInstanceSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceSnapshotsRequest.Builder} to create a
     *        request.
     * @return Result of the GetInstanceSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceSnapshotsResponse getInstanceSnapshots(
            Consumer<GetInstanceSnapshotsRequest.Builder> getInstanceSnapshotsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstanceSnapshots(GetInstanceSnapshotsRequest.builder().applyMutation(getInstanceSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     *
     * @param getInstanceStateRequest
     * @return Result of the GetInstanceState operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceStateResponse getInstanceState(GetInstanceStateRequest getInstanceStateRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetInstanceStateRequest#builder()}
     * </p>
     *
     * @param getInstanceStateRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceStateRequest.Builder} to create a request.
     * @return Result of the GetInstanceState operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstanceStateResponse getInstanceState(Consumer<GetInstanceStateRequest.Builder> getInstanceStateRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstanceState(GetInstanceStateRequest.builder().applyMutation(getInstanceStateRequest).build());
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @return Result of the GetInstances operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstances
     * @see #getInstances(GetInstancesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstancesResponse getInstances() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getInstances(GetInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @param getInstancesRequest
     * @return Result of the GetInstances operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstancesResponse getInstances(GetInstancesRequest getInstancesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link GetInstancesRequest#builder()}
     * </p>
     *
     * @param getInstancesRequest
     *        A {@link Consumer} that will call methods on {@link GetInstancesRequest.Builder} to create a request.
     * @return Result of the GetInstances operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInstancesResponse getInstances(Consumer<GetInstancesRequest.Builder> getInstancesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getInstances(GetInstancesRequest.builder().applyMutation(getInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     *
     * @param getKeyPairRequest
     * @return Result of the GetKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKeyPairResponse getKeyPair(GetKeyPairRequest getKeyPairRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link GetKeyPairRequest#builder()}
     * </p>
     *
     * @param getKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyPairRequest.Builder} to create a request.
     * @return Result of the GetKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKeyPairResponse getKeyPair(Consumer<GetKeyPairRequest.Builder> getKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getKeyPair(GetKeyPairRequest.builder().applyMutation(getKeyPairRequest).build());
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     *
     * @return Result of the GetKeyPairs operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetKeyPairs
     * @see #getKeyPairs(GetKeyPairsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKeyPairsResponse getKeyPairs() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getKeyPairs(GetKeyPairsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     *
     * @param getKeyPairsRequest
     * @return Result of the GetKeyPairs operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKeyPairsResponse getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyPairsRequest.Builder} avoiding the need to
     * create one manually via {@link GetKeyPairsRequest#builder()}
     * </p>
     *
     * @param getKeyPairsRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyPairsRequest.Builder} to create a request.
     * @return Result of the GetKeyPairs operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKeyPairsResponse getKeyPairs(Consumer<GetKeyPairsRequest.Builder> getKeyPairsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getKeyPairs(GetKeyPairsRequest.builder().applyMutation(getKeyPairsRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerRequest
     * @return Result of the GetLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLoadBalancerResponse getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Lightsail load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancerRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoadBalancerRequest#builder()}
     * </p>
     *
     * @param getLoadBalancerRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancerRequest.Builder} to create a request.
     * @return Result of the GetLoadBalancer operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLoadBalancerResponse getLoadBalancer(Consumer<GetLoadBalancerRequest.Builder> getLoadBalancerRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getLoadBalancer(GetLoadBalancerRequest.builder().applyMutation(getLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Returns information about health metrics for your Lightsail load balancer.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getLoadBalancerMetricDataRequest
     * @return Result of the GetLoadBalancerMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancerMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoadBalancerMetricDataResponse getLoadBalancerMetricData(
            GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about health metrics for your Lightsail load balancer.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancerMetricDataRequest.Builder} avoiding
     * the need to create one manually via {@link GetLoadBalancerMetricDataRequest#builder()}
     * </p>
     *
     * @param getLoadBalancerMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancerMetricDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetLoadBalancerMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancerMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoadBalancerMetricDataResponse getLoadBalancerMetricData(
            Consumer<GetLoadBalancerMetricDataRequest.Builder> getLoadBalancerMetricDataRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getLoadBalancerMetricData(GetLoadBalancerMetricDataRequest.builder()
                .applyMutation(getLoadBalancerMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other
     * is inactive.
     * </p>
     *
     * @param getLoadBalancerTlsCertificatesRequest
     * @return Result of the GetLoadBalancerTlsCertificates operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancerTlsCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoadBalancerTlsCertificatesResponse getLoadBalancerTlsCertificates(
            GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other
     * is inactive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancerTlsCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link GetLoadBalancerTlsCertificatesRequest#builder()}
     * </p>
     *
     * @param getLoadBalancerTlsCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancerTlsCertificatesRequest.Builder} to
     *        create a request.
     * @return Result of the GetLoadBalancerTlsCertificates operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancerTlsCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoadBalancerTlsCertificatesResponse getLoadBalancerTlsCertificates(
            Consumer<GetLoadBalancerTlsCertificatesRequest.Builder> getLoadBalancerTlsCertificatesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getLoadBalancerTlsCertificates(GetLoadBalancerTlsCertificatesRequest.builder()
                .applyMutation(getLoadBalancerTlsCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     *
     * @return Result of the GetLoadBalancers operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancers
     * @see #getLoadBalancers(GetLoadBalancersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLoadBalancersResponse getLoadBalancers() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getLoadBalancers(GetLoadBalancersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     *
     * @param getLoadBalancersRequest
     * @return Result of the GetLoadBalancers operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLoadBalancersResponse getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoadBalancersRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoadBalancersRequest#builder()}
     * </p>
     *
     * @param getLoadBalancersRequest
     *        A {@link Consumer} that will call methods on {@link GetLoadBalancersRequest.Builder} to create a request.
     * @return Result of the GetLoadBalancers operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLoadBalancersResponse getLoadBalancers(Consumer<GetLoadBalancersRequest.Builder> getLoadBalancersRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getLoadBalancers(GetLoadBalancersRequest.builder().applyMutation(getLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     *
     * @param getOperationRequest
     * @return Result of the GetOperation operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationRequest.Builder} avoiding the need to
     * create one manually via {@link GetOperationRequest#builder()}
     * </p>
     *
     * @param getOperationRequest
     *        A {@link Consumer} that will call methods on {@link GetOperationRequest.Builder} to create a request.
     * @return Result of the GetOperation operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOperationResponse getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getOperation(GetOperationRequest.builder().applyMutation(getOperationRequest).build());
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     *
     * @return Result of the GetOperations operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetOperations
     * @see #getOperations(GetOperationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOperationsResponse getOperations() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getOperations(GetOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     *
     * @param getOperationsRequest
     * @return Result of the GetOperations operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOperationsResponse getOperations(GetOperationsRequest getOperationsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link GetOperationsRequest#builder()}
     * </p>
     *
     * @param getOperationsRequest
     *        A {@link Consumer} that will call methods on {@link GetOperationsRequest.Builder} to create a request.
     * @return Result of the GetOperations operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOperationsResponse getOperations(Consumer<GetOperationsRequest.Builder> getOperationsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getOperations(GetOperationsRequest.builder().applyMutation(getOperationsRequest).build());
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     *
     * @param getOperationsForResourceRequest
     * @return Result of the GetOperationsForResource operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOperationsForResourceResponse getOperationsForResource(
            GetOperationsForResourceRequest getOperationsForResourceRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationsForResourceRequest.Builder} avoiding
     * the need to create one manually via {@link GetOperationsForResourceRequest#builder()}
     * </p>
     *
     * @param getOperationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetOperationsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the GetOperationsForResource operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOperationsForResourceResponse getOperationsForResource(
            Consumer<GetOperationsForResourceRequest.Builder> getOperationsForResourceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getOperationsForResource(GetOperationsForResourceRequest.builder().applyMutation(getOperationsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the Availability Zones in a region.
     * </p>
     *
     * @return Result of the GetRegions operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRegions
     * @see #getRegions(GetRegionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRegionsResponse getRegions() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getRegions(GetRegionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the Availability Zones in a region.
     * </p>
     *
     * @param getRegionsRequest
     * @return Result of the GetRegions operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRegionsResponse getRegions(GetRegionsRequest getRegionsRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the Availability Zones in a region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetRegionsRequest#builder()}
     * </p>
     *
     * @param getRegionsRequest
     *        A {@link Consumer} that will call methods on {@link GetRegionsRequest.Builder} to create a request.
     * @return Result of the GetRegions operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRegionsResponse getRegions(Consumer<GetRegionsRequest.Builder> getRegionsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRegions(GetRegionsRequest.builder().applyMutation(getRegionsRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseRequest
     * @return Result of the GetRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseResponse getRelationalDatabase(GetRelationalDatabaseRequest getRelationalDatabaseRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific database in Amazon Lightsail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseRequest.Builder} avoiding the
     * need to create one manually via {@link GetRelationalDatabaseRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the GetRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseResponse getRelationalDatabase(
            Consumer<GetRelationalDatabaseRequest.Builder> getRelationalDatabaseRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabase(GetRelationalDatabaseRequest.builder().applyMutation(getRelationalDatabaseRequest).build());
    }

    /**
     * <p>
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine
     * version of a database.
     * </p>
     * <p>
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     * </p>
     *
     * @return Result of the GetRelationalDatabaseBlueprints operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseBlueprints
     * @see #getRelationalDatabaseBlueprints(GetRelationalDatabaseBlueprintsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseBlueprintsResponse getRelationalDatabaseBlueprints() throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseBlueprints(GetRelationalDatabaseBlueprintsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine
     * version of a database.
     * </p>
     * <p>
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     * </p>
     *
     * @param getRelationalDatabaseBlueprintsRequest
     * @return Result of the GetRelationalDatabaseBlueprints operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseBlueprintsResponse getRelationalDatabaseBlueprints(
            GetRelationalDatabaseBlueprintsRequest getRelationalDatabaseBlueprintsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine
     * version of a database.
     * </p>
     * <p>
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseBlueprintsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseBlueprintsRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseBlueprintsRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseBlueprintsRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationalDatabaseBlueprints operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseBlueprintsResponse getRelationalDatabaseBlueprints(
            Consumer<GetRelationalDatabaseBlueprintsRequest.Builder> getRelationalDatabaseBlueprintsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseBlueprints(GetRelationalDatabaseBlueprintsRequest.builder()
                .applyMutation(getRelationalDatabaseBlueprintsRequest).build());
    }

    /**
     * <p>
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance
     * specifications for a database.
     * </p>
     * <p>
     * You can use a bundle ID to create a new database with explicit performance specifications.
     * </p>
     *
     * @return Result of the GetRelationalDatabaseBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseBundles
     * @see #getRelationalDatabaseBundles(GetRelationalDatabaseBundlesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseBundlesResponse getRelationalDatabaseBundles() throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getRelationalDatabaseBundles(GetRelationalDatabaseBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance
     * specifications for a database.
     * </p>
     * <p>
     * You can use a bundle ID to create a new database with explicit performance specifications.
     * </p>
     *
     * @param getRelationalDatabaseBundlesRequest
     * @return Result of the GetRelationalDatabaseBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseBundlesResponse getRelationalDatabaseBundles(
            GetRelationalDatabaseBundlesRequest getRelationalDatabaseBundlesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance
     * specifications for a database.
     * </p>
     * <p>
     * You can use a bundle ID to create a new database with explicit performance specifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseBundlesRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseBundlesRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseBundlesRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseBundlesRequest.Builder} to create
     *        a request.
     * @return Result of the GetRelationalDatabaseBundles operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseBundlesResponse getRelationalDatabaseBundles(
            Consumer<GetRelationalDatabaseBundlesRequest.Builder> getRelationalDatabaseBundlesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseBundles(GetRelationalDatabaseBundlesRequest.builder()
                .applyMutation(getRelationalDatabaseBundlesRequest).build());
    }

    /**
     * <p>
     * Returns a list of events for a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseEventsRequest
     * @return Result of the GetRelationalDatabaseEvents operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseEventsResponse getRelationalDatabaseEvents(
            GetRelationalDatabaseEventsRequest getRelationalDatabaseEventsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of events for a specific database in Amazon Lightsail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseEventsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseEventsRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseEventsRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseEventsRequest.Builder} to create
     *        a request.
     * @return Result of the GetRelationalDatabaseEvents operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseEventsResponse getRelationalDatabaseEvents(
            Consumer<GetRelationalDatabaseEventsRequest.Builder> getRelationalDatabaseEventsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseEvents(GetRelationalDatabaseEventsRequest.builder()
                .applyMutation(getRelationalDatabaseEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of log events for a database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseLogEventsRequest
     * @return Result of the GetRelationalDatabaseLogEvents operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseLogEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseLogEventsResponse getRelationalDatabaseLogEvents(
            GetRelationalDatabaseLogEventsRequest getRelationalDatabaseLogEventsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of log events for a database in Amazon Lightsail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseLogEventsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseLogEventsRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseLogEventsRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseLogEventsRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationalDatabaseLogEvents operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseLogEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseLogEventsResponse getRelationalDatabaseLogEvents(
            Consumer<GetRelationalDatabaseLogEventsRequest.Builder> getRelationalDatabaseLogEventsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseLogEvents(GetRelationalDatabaseLogEventsRequest.builder()
                .applyMutation(getRelationalDatabaseLogEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of available log streams for a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseLogStreamsRequest
     * @return Result of the GetRelationalDatabaseLogStreams operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseLogStreams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseLogStreamsResponse getRelationalDatabaseLogStreams(
            GetRelationalDatabaseLogStreamsRequest getRelationalDatabaseLogStreamsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of available log streams for a specific database in Amazon Lightsail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseLogStreamsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseLogStreamsRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseLogStreamsRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseLogStreamsRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationalDatabaseLogStreams operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseLogStreams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseLogStreamsResponse getRelationalDatabaseLogStreams(
            Consumer<GetRelationalDatabaseLogStreamsRequest.Builder> getRelationalDatabaseLogStreamsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseLogStreams(GetRelationalDatabaseLogStreamsRequest.builder()
                .applyMutation(getRelationalDatabaseLogStreamsRequest).build());
    }

    /**
     * <p>
     * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
     * </p>
     * <p>
     * The <code>GetRelationalDatabaseMasterUserPassword</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName.
     * </p>
     *
     * @param getRelationalDatabaseMasterUserPasswordRequest
     * @return Result of the GetRelationalDatabaseMasterUserPassword operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseMasterUserPassword
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseMasterUserPasswordResponse getRelationalDatabaseMasterUserPassword(
            GetRelationalDatabaseMasterUserPasswordRequest getRelationalDatabaseMasterUserPasswordRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
     * </p>
     * <p>
     * The <code>GetRelationalDatabaseMasterUserPassword</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetRelationalDatabaseMasterUserPasswordRequest.Builder} avoiding the need to create one manually via
     * {@link GetRelationalDatabaseMasterUserPasswordRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseMasterUserPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetRelationalDatabaseMasterUserPasswordRequest.Builder} to create a request.
     * @return Result of the GetRelationalDatabaseMasterUserPassword operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseMasterUserPassword
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseMasterUserPasswordResponse getRelationalDatabaseMasterUserPassword(
            Consumer<GetRelationalDatabaseMasterUserPasswordRequest.Builder> getRelationalDatabaseMasterUserPasswordRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseMasterUserPassword(GetRelationalDatabaseMasterUserPasswordRequest.builder()
                .applyMutation(getRelationalDatabaseMasterUserPasswordRequest).build());
    }

    /**
     * <p>
     * Returns the data points of the specified metric for a database in Amazon Lightsail.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getRelationalDatabaseMetricDataRequest
     * @return Result of the GetRelationalDatabaseMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseMetricDataResponse getRelationalDatabaseMetricData(
            GetRelationalDatabaseMetricDataRequest getRelationalDatabaseMetricDataRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data points of the specified metric for a database in Amazon Lightsail.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseMetricDataRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseMetricDataRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseMetricDataRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationalDatabaseMetricData operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseMetricDataResponse getRelationalDatabaseMetricData(
            Consumer<GetRelationalDatabaseMetricDataRequest.Builder> getRelationalDatabaseMetricDataRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseMetricData(GetRelationalDatabaseMetricDataRequest.builder()
                .applyMutation(getRelationalDatabaseMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific
     * database in Amazon Lightsail.
     * </p>
     * <p>
     * In addition to the parameter names and values, this operation returns other information about each parameter.
     * This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed
     * values, and the data types.
     * </p>
     *
     * @param getRelationalDatabaseParametersRequest
     * @return Result of the GetRelationalDatabaseParameters operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseParametersResponse getRelationalDatabaseParameters(
            GetRelationalDatabaseParametersRequest getRelationalDatabaseParametersRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific
     * database in Amazon Lightsail.
     * </p>
     * <p>
     * In addition to the parameter names and values, this operation returns other information about each parameter.
     * This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed
     * values, and the data types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseParametersRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseParametersRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseParametersRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseParametersRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationalDatabaseParameters operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseParametersResponse getRelationalDatabaseParameters(
            Consumer<GetRelationalDatabaseParametersRequest.Builder> getRelationalDatabaseParametersRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseParameters(GetRelationalDatabaseParametersRequest.builder()
                .applyMutation(getRelationalDatabaseParametersRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific database snapshot in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseSnapshotRequest
     * @return Result of the GetRelationalDatabaseSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseSnapshotResponse getRelationalDatabaseSnapshot(
            GetRelationalDatabaseSnapshotRequest getRelationalDatabaseSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific database snapshot in Amazon Lightsail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseSnapshotRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationalDatabaseSnapshot operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseSnapshotResponse getRelationalDatabaseSnapshot(
            Consumer<GetRelationalDatabaseSnapshotRequest.Builder> getRelationalDatabaseSnapshotRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseSnapshot(GetRelationalDatabaseSnapshotRequest.builder()
                .applyMutation(getRelationalDatabaseSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about all of your database snapshots in Amazon Lightsail.
     * </p>
     *
     * @return Result of the GetRelationalDatabaseSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseSnapshots
     * @see #getRelationalDatabaseSnapshots(GetRelationalDatabaseSnapshotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseSnapshotsResponse getRelationalDatabaseSnapshots() throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseSnapshots(GetRelationalDatabaseSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all of your database snapshots in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseSnapshotsRequest
     * @return Result of the GetRelationalDatabaseSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseSnapshotsResponse getRelationalDatabaseSnapshots(
            GetRelationalDatabaseSnapshotsRequest getRelationalDatabaseSnapshotsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all of your database snapshots in Amazon Lightsail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabaseSnapshotsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRelationalDatabaseSnapshotsRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabaseSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabaseSnapshotsRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationalDatabaseSnapshots operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabaseSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabaseSnapshotsResponse getRelationalDatabaseSnapshots(
            Consumer<GetRelationalDatabaseSnapshotsRequest.Builder> getRelationalDatabaseSnapshotsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabaseSnapshots(GetRelationalDatabaseSnapshotsRequest.builder()
                .applyMutation(getRelationalDatabaseSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about all of your databases in Amazon Lightsail.
     * </p>
     *
     * @return Result of the GetRelationalDatabases operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabases
     * @see #getRelationalDatabases(GetRelationalDatabasesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabasesResponse getRelationalDatabases() throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return getRelationalDatabases(GetRelationalDatabasesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all of your databases in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabasesRequest
     * @return Result of the GetRelationalDatabases operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabasesResponse getRelationalDatabases(GetRelationalDatabasesRequest getRelationalDatabasesRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all of your databases in Amazon Lightsail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationalDatabasesRequest.Builder} avoiding the
     * need to create one manually via {@link GetRelationalDatabasesRequest#builder()}
     * </p>
     *
     * @param getRelationalDatabasesRequest
     *        A {@link Consumer} that will call methods on {@link GetRelationalDatabasesRequest.Builder} to create a
     *        request.
     * @return Result of the GetRelationalDatabases operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetRelationalDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationalDatabasesResponse getRelationalDatabases(
            Consumer<GetRelationalDatabasesRequest.Builder> getRelationalDatabasesRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getRelationalDatabases(GetRelationalDatabasesRequest.builder().applyMutation(getRelationalDatabasesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     *
     * @param getStaticIpRequest
     * @return Result of the GetStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStaticIpResponse getStaticIp(GetStaticIpRequest getStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStaticIpRequest.Builder} avoiding the need to
     * create one manually via {@link GetStaticIpRequest#builder()}
     * </p>
     *
     * @param getStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link GetStaticIpRequest.Builder} to create a request.
     * @return Result of the GetStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStaticIpResponse getStaticIp(Consumer<GetStaticIpRequest.Builder> getStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getStaticIp(GetStaticIpRequest.builder().applyMutation(getStaticIpRequest).build());
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     *
     * @return Result of the GetStaticIps operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetStaticIps
     * @see #getStaticIps(GetStaticIpsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStaticIpsResponse getStaticIps() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return getStaticIps(GetStaticIpsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     *
     * @param getStaticIpsRequest
     * @return Result of the GetStaticIps operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStaticIpsResponse getStaticIps(GetStaticIpsRequest getStaticIpsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStaticIpsRequest.Builder} avoiding the need to
     * create one manually via {@link GetStaticIpsRequest#builder()}
     * </p>
     *
     * @param getStaticIpsRequest
     *        A {@link Consumer} that will call methods on {@link GetStaticIpsRequest.Builder} to create a request.
     * @return Result of the GetStaticIps operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStaticIpsResponse getStaticIps(Consumer<GetStaticIpsRequest.Builder> getStaticIpsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return getStaticIps(GetStaticIpsRequest.builder().applyMutation(getStaticIpsRequest).build());
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     *
     * @param importKeyPairRequest
     * @return Result of the ImportKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportKeyPairResponse importKeyPair(ImportKeyPairRequest importKeyPairRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link ImportKeyPairRequest#builder()}
     * </p>
     *
     * @param importKeyPairRequest
     *        A {@link Consumer} that will call methods on {@link ImportKeyPairRequest.Builder} to create a request.
     * @return Result of the ImportKeyPair operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportKeyPairResponse importKeyPair(Consumer<ImportKeyPairRequest.Builder> importKeyPairRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return importKeyPair(ImportKeyPairRequest.builder().applyMutation(importKeyPairRequest).build());
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     *
     * @return Result of the IsVpcPeered operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.IsVpcPeered
     * @see #isVpcPeered(IsVpcPeeredRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    default IsVpcPeeredResponse isVpcPeered() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return isVpcPeered(IsVpcPeeredRequest.builder().build());
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     *
     * @param isVpcPeeredRequest
     * @return Result of the IsVpcPeered operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    default IsVpcPeeredResponse isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IsVpcPeeredRequest.Builder} avoiding the need to
     * create one manually via {@link IsVpcPeeredRequest#builder()}
     * </p>
     *
     * @param isVpcPeeredRequest
     *        A {@link Consumer} that will call methods on {@link IsVpcPeeredRequest.Builder} to create a request.
     * @return Result of the IsVpcPeered operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    default IsVpcPeeredResponse isVpcPeered(Consumer<IsVpcPeeredRequest.Builder> isVpcPeeredRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return isVpcPeered(IsVpcPeeredRequest.builder().applyMutation(isVpcPeeredRequest).build());
    }

    /**
     * <p>
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the
     * instance through the ports, and the protocol.
     * </p>
     * <p>
     * The <code>OpenInstancePublicPorts</code> action supports tag-based access control via resource tags applied to
     * the resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param openInstancePublicPortsRequest
     * @return Result of the OpenInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default OpenInstancePublicPortsResponse openInstancePublicPorts(OpenInstancePublicPortsRequest openInstancePublicPortsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the
     * instance through the ports, and the protocol.
     * </p>
     * <p>
     * The <code>OpenInstancePublicPorts</code> action supports tag-based access control via resource tags applied to
     * the resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OpenInstancePublicPortsRequest.Builder} avoiding
     * the need to create one manually via {@link OpenInstancePublicPortsRequest#builder()}
     * </p>
     *
     * @param openInstancePublicPortsRequest
     *        A {@link Consumer} that will call methods on {@link OpenInstancePublicPortsRequest.Builder} to create a
     *        request.
     * @return Result of the OpenInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default OpenInstancePublicPortsResponse openInstancePublicPorts(
            Consumer<OpenInstancePublicPortsRequest.Builder> openInstancePublicPortsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return openInstancePublicPorts(OpenInstancePublicPortsRequest.builder().applyMutation(openInstancePublicPortsRequest)
                .build());
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     *
     * @return Result of the PeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.PeerVpc
     * @see #peerVpc(PeerVpcRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default PeerVpcResponse peerVpc() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return peerVpc(PeerVpcRequest.builder().build());
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     *
     * @param peerVpcRequest
     * @return Result of the PeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default PeerVpcResponse peerVpc(PeerVpcRequest peerVpcRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PeerVpcRequest.Builder} avoiding the need to create
     * one manually via {@link PeerVpcRequest#builder()}
     * </p>
     *
     * @param peerVpcRequest
     *        A {@link Consumer} that will call methods on {@link PeerVpcRequest.Builder} to create a request.
     * @return Result of the PeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default PeerVpcResponse peerVpc(Consumer<PeerVpcRequest.Builder> peerVpcRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return peerVpc(PeerVpcRequest.builder().applyMutation(peerVpcRequest).build());
    }

    /**
     * <p>
     * Creates or updates an alarm, and associates it with the specified metric.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     * <p>
     * When this action creates an alarm, the alarm state is immediately set to <code>INSUFFICIENT_DATA</code>. The
     * alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then
     * executed.
     * </p>
     * <p>
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous
     * configuration of the alarm. The alarm is then evaluated with the updated configuration.
     * </p>
     *
     * @param putAlarmRequest
     * @return Result of the PutAlarm operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.PutAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    default PutAlarmResponse putAlarm(PutAlarmRequest putAlarmRequest) throws ServiceException, InvalidInputException,
            OperationFailureException, AccessDeniedException, UnauthenticatedException, NotFoundException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an alarm, and associates it with the specified metric.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     * <p>
     * When this action creates an alarm, the alarm state is immediately set to <code>INSUFFICIENT_DATA</code>. The
     * alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then
     * executed.
     * </p>
     * <p>
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous
     * configuration of the alarm. The alarm is then evaluated with the updated configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAlarmRequest.Builder} avoiding the need to
     * create one manually via {@link PutAlarmRequest#builder()}
     * </p>
     *
     * @param putAlarmRequest
     *        A {@link Consumer} that will call methods on {@link PutAlarmRequest.Builder} to create a request.
     * @return Result of the PutAlarm operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.PutAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    default PutAlarmResponse putAlarm(Consumer<PutAlarmRequest.Builder> putAlarmRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, AccessDeniedException, UnauthenticatedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        return putAlarm(PutAlarmRequest.builder().applyMutation(putAlarmRequest).build());
    }

    /**
     * <p>
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the
     * instance through the ports, and the protocol. This action also closes all currently open ports that are not
     * included in the request. Include all of the ports and the protocols you want to open in your
     * <code>PutInstancePublicPorts</code>request. Or use the <code>OpenInstancePublicPorts</code> action to open ports
     * without closing currently open ports.
     * </p>
     * <p>
     * The <code>PutInstancePublicPorts</code> action supports tag-based access control via resource tags applied to the
     * resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param putInstancePublicPortsRequest
     * @return Result of the PutInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInstancePublicPortsResponse putInstancePublicPorts(PutInstancePublicPortsRequest putInstancePublicPortsRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the
     * instance through the ports, and the protocol. This action also closes all currently open ports that are not
     * included in the request. Include all of the ports and the protocols you want to open in your
     * <code>PutInstancePublicPorts</code>request. Or use the <code>OpenInstancePublicPorts</code> action to open ports
     * without closing currently open ports.
     * </p>
     * <p>
     * The <code>PutInstancePublicPorts</code> action supports tag-based access control via resource tags applied to the
     * resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInstancePublicPortsRequest.Builder} avoiding the
     * need to create one manually via {@link PutInstancePublicPortsRequest#builder()}
     * </p>
     *
     * @param putInstancePublicPortsRequest
     *        A {@link Consumer} that will call methods on {@link PutInstancePublicPortsRequest.Builder} to create a
     *        request.
     * @return Result of the PutInstancePublicPorts operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInstancePublicPortsResponse putInstancePublicPorts(
            Consumer<PutInstancePublicPortsRequest.Builder> putInstancePublicPortsRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return putInstancePublicPorts(PutInstancePublicPortsRequest.builder().applyMutation(putInstancePublicPortsRequest)
                .build());
    }

    /**
     * <p>
     * Restarts a specific instance.
     * </p>
     * <p>
     * The <code>reboot instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param rebootInstanceRequest
     * @return Result of the RebootInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootInstanceResponse rebootInstance(RebootInstanceRequest rebootInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a specific instance.
     * </p>
     * <p>
     * The <code>reboot instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link RebootInstanceRequest#builder()}
     * </p>
     *
     * @param rebootInstanceRequest
     *        A {@link Consumer} that will call methods on {@link RebootInstanceRequest.Builder} to create a request.
     * @return Result of the RebootInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootInstanceResponse rebootInstance(Consumer<RebootInstanceRequest.Builder> rebootInstanceRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return rebootInstance(RebootInstanceRequest.builder().applyMutation(rebootInstanceRequest).build());
    }

    /**
     * <p>
     * Restarts a specific database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>reboot relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param rebootRelationalDatabaseRequest
     * @return Result of the RebootRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.RebootRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default RebootRelationalDatabaseResponse rebootRelationalDatabase(
            RebootRelationalDatabaseRequest rebootRelationalDatabaseRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a specific database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>reboot relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootRelationalDatabaseRequest.Builder} avoiding
     * the need to create one manually via {@link RebootRelationalDatabaseRequest#builder()}
     * </p>
     *
     * @param rebootRelationalDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link RebootRelationalDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the RebootRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.RebootRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default RebootRelationalDatabaseResponse rebootRelationalDatabase(
            Consumer<RebootRelationalDatabaseRequest.Builder> rebootRelationalDatabaseRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return rebootRelationalDatabase(RebootRelationalDatabaseRequest.builder().applyMutation(rebootRelationalDatabaseRequest)
                .build());
    }

    /**
     * <p>
     * Registers a container image to your Amazon Lightsail container service.
     * </p>
     * <note>
     * <p>
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container
     * images to your Lightsail container service. For more information, see <a
     * href="amazon-lightsail-pushing-container-images">Pushing and managing container images on your Amazon Lightsail
     * container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * </note>
     *
     * @param registerContainerImageRequest
     * @return Result of the RegisterContainerImage operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.RegisterContainerImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RegisterContainerImage"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterContainerImageResponse registerContainerImage(RegisterContainerImageRequest registerContainerImageRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a container image to your Amazon Lightsail container service.
     * </p>
     * <note>
     * <p>
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container
     * images to your Lightsail container service. For more information, see <a
     * href="amazon-lightsail-pushing-container-images">Pushing and managing container images on your Amazon Lightsail
     * container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterContainerImageRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterContainerImageRequest#builder()}
     * </p>
     *
     * @param registerContainerImageRequest
     *        A {@link Consumer} that will call methods on {@link RegisterContainerImageRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterContainerImage operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.RegisterContainerImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RegisterContainerImage"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterContainerImageResponse registerContainerImage(
            Consumer<RegisterContainerImageRequest.Builder> registerContainerImageRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return registerContainerImage(RegisterContainerImageRequest.builder().applyMutation(registerContainerImageRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     *
     * @param releaseStaticIpRequest
     * @return Result of the ReleaseStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default ReleaseStaticIpResponse releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReleaseStaticIpRequest.Builder} avoiding the need
     * to create one manually via {@link ReleaseStaticIpRequest#builder()}
     * </p>
     *
     * @param releaseStaticIpRequest
     *        A {@link Consumer} that will call methods on {@link ReleaseStaticIpRequest.Builder} to create a request.
     * @return Result of the ReleaseStaticIp operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    default ReleaseStaticIpResponse releaseStaticIp(Consumer<ReleaseStaticIpRequest.Builder> releaseStaticIpRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return releaseStaticIp(ReleaseStaticIpRequest.builder().applyMutation(releaseStaticIpRequest).build());
    }

    /**
     * <p>
     * Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches
     * it from the origin.
     * </p>
     *
     * @param resetDistributionCacheRequest
     * @return Result of the ResetDistributionCache operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ResetDistributionCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ResetDistributionCache"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetDistributionCacheResponse resetDistributionCache(ResetDistributionCacheRequest resetDistributionCacheRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches
     * it from the origin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDistributionCacheRequest.Builder} avoiding the
     * need to create one manually via {@link ResetDistributionCacheRequest#builder()}
     * </p>
     *
     * @param resetDistributionCacheRequest
     *        A {@link Consumer} that will call methods on {@link ResetDistributionCacheRequest.Builder} to create a
     *        request.
     * @return Result of the ResetDistributionCache operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.ResetDistributionCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ResetDistributionCache"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetDistributionCacheResponse resetDistributionCache(
            Consumer<ResetDistributionCacheRequest.Builder> resetDistributionCacheRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return resetDistributionCache(ResetDistributionCacheRequest.builder().applyMutation(resetDistributionCacheRequest)
                .build());
    }

    /**
     * <p>
     * Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact
     * methods don't need to be verified.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <p>
     * A verification request is sent to the contact method when you initially create it. Use this action to send
     * another verification request if a previous verification request was deleted, or has expired.
     * </p>
     * <important>
     * <p>
     * Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.
     * </p>
     * </important>
     *
     * @param sendContactMethodVerificationRequest
     * @return Result of the SendContactMethodVerification operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.SendContactMethodVerification
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SendContactMethodVerification"
     *      target="_top">AWS API Documentation</a>
     */
    default SendContactMethodVerificationResponse sendContactMethodVerification(
            SendContactMethodVerificationRequest sendContactMethodVerificationRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact
     * methods don't need to be verified.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <p>
     * A verification request is sent to the contact method when you initially create it. Use this action to send
     * another verification request if a previous verification request was deleted, or has expired.
     * </p>
     * <important>
     * <p>
     * Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendContactMethodVerificationRequest.Builder}
     * avoiding the need to create one manually via {@link SendContactMethodVerificationRequest#builder()}
     * </p>
     *
     * @param sendContactMethodVerificationRequest
     *        A {@link Consumer} that will call methods on {@link SendContactMethodVerificationRequest.Builder} to
     *        create a request.
     * @return Result of the SendContactMethodVerification operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.SendContactMethodVerification
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SendContactMethodVerification"
     *      target="_top">AWS API Documentation</a>
     */
    default SendContactMethodVerificationResponse sendContactMethodVerification(
            Consumer<SendContactMethodVerificationRequest.Builder> sendContactMethodVerificationRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        return sendContactMethodVerification(SendContactMethodVerificationRequest.builder()
                .applyMutation(sendContactMethodVerificationRequest).build());
    }

    /**
     * <p>
     * Sets the IP address type for a Amazon Lightsail resource.
     * </p>
     * <p>
     * Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource.
     * Alternately, you can use this action to disable dual-stack, and enable IPv4 only.
     * </p>
     *
     * @param setIpAddressTypeRequest
     * @return Result of the SetIpAddressType operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.SetIpAddressType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetIpAddressType" target="_top">AWS API
     *      Documentation</a>
     */
    default SetIpAddressTypeResponse setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the IP address type for a Amazon Lightsail resource.
     * </p>
     * <p>
     * Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource.
     * Alternately, you can use this action to disable dual-stack, and enable IPv4 only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIpAddressTypeRequest.Builder} avoiding the need
     * to create one manually via {@link SetIpAddressTypeRequest#builder()}
     * </p>
     *
     * @param setIpAddressTypeRequest
     *        A {@link Consumer} that will call methods on {@link SetIpAddressTypeRequest.Builder} to create a request.
     * @return Result of the SetIpAddressType operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.SetIpAddressType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetIpAddressType" target="_top">AWS API
     *      Documentation</a>
     */
    default SetIpAddressTypeResponse setIpAddressType(Consumer<SetIpAddressTypeRequest.Builder> setIpAddressTypeRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return setIpAddressType(SetIpAddressTypeRequest.builder().applyMutation(setIpAddressTypeRequest).build());
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the
     * <code>reboot instance</code> operation.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>start instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param startInstanceRequest
     * @return Result of the StartInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default StartInstanceResponse startInstance(StartInstanceRequest startInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the
     * <code>reboot instance</code> operation.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>start instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link StartInstanceRequest#builder()}
     * </p>
     *
     * @param startInstanceRequest
     *        A {@link Consumer} that will call methods on {@link StartInstanceRequest.Builder} to create a request.
     * @return Result of the StartInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default StartInstanceResponse startInstance(Consumer<StartInstanceRequest.Builder> startInstanceRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return startInstance(StartInstanceRequest.builder().applyMutation(startInstanceRequest).build());
    }

    /**
     * <p>
     * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the
     * <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>start relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param startRelationalDatabaseRequest
     * @return Result of the StartRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StartRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRelationalDatabaseResponse startRelationalDatabase(StartRelationalDatabaseRequest startRelationalDatabaseRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the
     * <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>start relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRelationalDatabaseRequest.Builder} avoiding
     * the need to create one manually via {@link StartRelationalDatabaseRequest#builder()}
     * </p>
     *
     * @param startRelationalDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link StartRelationalDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the StartRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StartRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRelationalDatabaseResponse startRelationalDatabase(
            Consumer<StartRelationalDatabaseRequest.Builder> startRelationalDatabaseRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return startRelationalDatabase(StartRelationalDatabaseRequest.builder().applyMutation(startRelationalDatabaseRequest)
                .build());
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>stop instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param stopInstanceRequest
     * @return Result of the StopInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default StopInstanceResponse stopInstance(StopInstanceRequest stopInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>stop instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link StopInstanceRequest#builder()}
     * </p>
     *
     * @param stopInstanceRequest
     *        A {@link Consumer} that will call methods on {@link StopInstanceRequest.Builder} to create a request.
     * @return Result of the StopInstance operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default StopInstanceResponse stopInstance(Consumer<StopInstanceRequest.Builder> stopInstanceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return stopInstance(StopInstanceRequest.builder().applyMutation(stopInstanceRequest).build());
    }

    /**
     * <p>
     * Stops a specific database that is currently running in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>stop relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param stopRelationalDatabaseRequest
     * @return Result of the StopRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StopRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default StopRelationalDatabaseResponse stopRelationalDatabase(StopRelationalDatabaseRequest stopRelationalDatabaseRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a specific database that is currently running in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>stop relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRelationalDatabaseRequest.Builder} avoiding the
     * need to create one manually via {@link StopRelationalDatabaseRequest#builder()}
     * </p>
     *
     * @param stopRelationalDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link StopRelationalDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the StopRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.StopRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default StopRelationalDatabaseResponse stopRelationalDatabase(
            Consumer<StopRelationalDatabaseRequest.Builder> stopRelationalDatabaseRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return stopRelationalDatabase(StopRelationalDatabaseRequest.builder().applyMutation(stopRelationalDatabaseRequest)
                .build());
    }

    /**
     * <p>
     * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
     * </p>
     * <p>
     * The <code>tag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
     * </p>
     * <p>
     * The <code>tag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured
     * for the specified alarm, the test also sends a notification to the notification protocol (<code>Email</code>
     * and/or <code>SMS</code>) configured for the alarm.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     *
     * @param testAlarmRequest
     * @return Result of the TestAlarm operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.TestAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TestAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    default TestAlarmResponse testAlarm(TestAlarmRequest testAlarmRequest) throws ServiceException, InvalidInputException,
            OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured
     * for the specified alarm, the test also sends a notification to the notification protocol (<code>Email</code>
     * and/or <code>SMS</code>) configured for the alarm.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestAlarmRequest.Builder} avoiding the need to
     * create one manually via {@link TestAlarmRequest#builder()}
     * </p>
     *
     * @param testAlarmRequest
     *        A {@link Consumer} that will call methods on {@link TestAlarmRequest.Builder} to create a request.
     * @return Result of the TestAlarm operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.TestAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TestAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    default TestAlarmResponse testAlarm(Consumer<TestAlarmRequest.Builder> testAlarmRequest) throws ServiceException,
            InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException,
            AwsServiceException, SdkClientException, LightsailException {
        return testAlarm(TestAlarmRequest.builder().applyMutation(testAlarmRequest).build());
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     *
     * @return Result of the UnpeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UnpeerVpc
     * @see #unpeerVpc(UnpeerVpcRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default UnpeerVpcResponse unpeerVpc() throws ServiceException, InvalidInputException, NotFoundException,
            OperationFailureException, AccessDeniedException, AccountSetupInProgressException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return unpeerVpc(UnpeerVpcRequest.builder().build());
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     *
     * @param unpeerVpcRequest
     * @return Result of the UnpeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default UnpeerVpcResponse unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnpeerVpcRequest.Builder} avoiding the need to
     * create one manually via {@link UnpeerVpcRequest#builder()}
     * </p>
     *
     * @param unpeerVpcRequest
     *        A {@link Consumer} that will call methods on {@link UnpeerVpcRequest.Builder} to create a request.
     * @return Result of the UnpeerVpc operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default UnpeerVpcResponse unpeerVpc(Consumer<UnpeerVpcRequest.Builder> unpeerVpcRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return unpeerVpc(UnpeerVpcRequest.builder().applyMutation(unpeerVpcRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
     * </p>
     * <p>
     * The <code>untag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
     * </p>
     * <p>
     * The <code>untag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain
     * names.
     * </p>
     *
     * @param updateContainerServiceRequest
     * @return Result of the UpdateContainerService operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContainerServiceResponse updateContainerService(UpdateContainerServiceRequest updateContainerServiceRequest)
            throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain
     * names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContainerServiceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateContainerServiceRequest#builder()}
     * </p>
     *
     * @param updateContainerServiceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContainerServiceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateContainerService operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContainerServiceResponse updateContainerService(
            Consumer<UpdateContainerServiceRequest.Builder> updateContainerServiceRequest) throws ServiceException,
            InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        return updateContainerService(UpdateContainerServiceRequest.builder().applyMutation(updateContainerServiceRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Use this action to update the configuration of your existing distribution
     * </p>
     *
     * @param updateDistributionRequest
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Use this action to update the configuration of your existing distribution
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDistributionRequest#builder()}
     * </p>
     *
     * @param updateDistributionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDistributionResponse updateDistribution(Consumer<UpdateDistributionRequest.Builder> updateDistributionRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        return updateDistribution(UpdateDistributionRequest.builder().applyMutation(updateDistributionRequest).build());
    }

    /**
     * <p>
     * Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution.
     * </p>
     * <p>
     * Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is
     * incurring an overage fee.
     * </p>
     * <p>
     * You can update your distribution's bundle only one time within your monthly AWS billing cycle. To determine if
     * you can update your distribution's bundle, use the <code>GetDistributions</code> action. The
     * <code>ableToUpdateBundle</code> parameter in the result will indicate whether you can currently update your
     * distribution's bundle.
     * </p>
     *
     * @param updateDistributionBundleRequest
     * @return Result of the UpdateDistributionBundle operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateDistributionBundle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistributionBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDistributionBundleResponse updateDistributionBundle(
            UpdateDistributionBundleRequest updateDistributionBundleRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException,
            SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution.
     * </p>
     * <p>
     * Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is
     * incurring an overage fee.
     * </p>
     * <p>
     * You can update your distribution's bundle only one time within your monthly AWS billing cycle. To determine if
     * you can update your distribution's bundle, use the <code>GetDistributions</code> action. The
     * <code>ableToUpdateBundle</code> parameter in the result will indicate whether you can currently update your
     * distribution's bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionBundleRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDistributionBundleRequest#builder()}
     * </p>
     *
     * @param updateDistributionBundleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionBundleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDistributionBundle operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateDistributionBundle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistributionBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDistributionBundleResponse updateDistributionBundle(
            Consumer<UpdateDistributionBundleRequest.Builder> updateDistributionBundleRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException,
            AwsServiceException, SdkClientException, LightsailException {
        return updateDistributionBundle(UpdateDistributionBundleRequest.builder().applyMutation(updateDistributionBundleRequest)
                .build());
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     * <p>
     * The <code>update domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateDomainEntryRequest
     * @return Result of the UpdateDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDomainEntryResponse updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     * <p>
     * The <code>update domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainEntryRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDomainEntryRequest#builder()}
     * </p>
     *
     * @param updateDomainEntryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainEntryRequest.Builder} to create a request.
     * @return Result of the UpdateDomainEntry operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDomainEntryResponse updateDomainEntry(Consumer<UpdateDomainEntryRequest.Builder> updateDomainEntryRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return updateDomainEntry(UpdateDomainEntryRequest.builder().applyMutation(updateDomainEntryRequest).build());
    }

    /**
     * <p>
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     * </p>
     * <p>
     * The <code>update load balancer attribute</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateLoadBalancerAttributeRequest
     * @return Result of the UpdateLoadBalancerAttribute operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateLoadBalancerAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoadBalancerAttributeResponse updateLoadBalancerAttribute(
            UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     * </p>
     * <p>
     * The <code>update load balancer attribute</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoadBalancerAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLoadBalancerAttributeRequest#builder()}
     * </p>
     *
     * @param updateLoadBalancerAttributeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLoadBalancerAttributeRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateLoadBalancerAttribute operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateLoadBalancerAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoadBalancerAttributeResponse updateLoadBalancerAttribute(
            Consumer<UpdateLoadBalancerAttributeRequest.Builder> updateLoadBalancerAttributeRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return updateLoadBalancerAttribute(UpdateLoadBalancerAttributeRequest.builder()
                .applyMutation(updateLoadBalancerAttributeRequest).build());
    }

    /**
     * <p>
     * Allows the update of one or more attributes of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the
     * database's predefined maintenance window.
     * </p>
     * <p>
     * The <code>update relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateRelationalDatabaseRequest
     * @return Result of the UpdateRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelationalDatabaseResponse updateRelationalDatabase(
            UpdateRelationalDatabaseRequest updateRelationalDatabaseRequest) throws ServiceException, InvalidInputException,
            NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException,
            UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the update of one or more attributes of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the
     * database's predefined maintenance window.
     * </p>
     * <p>
     * The <code>update relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRelationalDatabaseRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRelationalDatabaseRequest#builder()}
     * </p>
     *
     * @param updateRelationalDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRelationalDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRelationalDatabase operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelationalDatabaseResponse updateRelationalDatabase(
            Consumer<UpdateRelationalDatabaseRequest.Builder> updateRelationalDatabaseRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return updateRelationalDatabase(UpdateRelationalDatabaseRequest.builder().applyMutation(updateRelationalDatabaseRequest)
                .build());
    }

    /**
     * <p>
     * Allows the update of one or more parameters of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance
     * window. However, there are two ways in which parameter updates are applied: <code>dynamic</code> or
     * <code>pending-reboot</code>. Parameters marked with a <code>dynamic</code> apply type are applied immediately.
     * Parameters marked with a <code>pending-reboot</code> apply type are applied only after the database is rebooted
     * using the <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>update relational database parameters</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateRelationalDatabaseParametersRequest
     * @return Result of the UpdateRelationalDatabaseParameters operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelationalDatabaseParametersResponse updateRelationalDatabaseParameters(
            UpdateRelationalDatabaseParametersRequest updateRelationalDatabaseParametersRequest) throws ServiceException,
            InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the update of one or more parameters of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance
     * window. However, there are two ways in which parameter updates are applied: <code>dynamic</code> or
     * <code>pending-reboot</code>. Parameters marked with a <code>dynamic</code> apply type are applied immediately.
     * Parameters marked with a <code>pending-reboot</code> apply type are applied only after the database is rebooted
     * using the <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>update relational database parameters</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRelationalDatabaseParametersRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRelationalDatabaseParametersRequest#builder()}
     * </p>
     *
     * @param updateRelationalDatabaseParametersRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRelationalDatabaseParametersRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateRelationalDatabaseParameters operation returned by the service.
     * @throws ServiceException
     *         A general service exception.
     * @throws InvalidInputException
     *         Lightsail throws this exception when user input does not conform to the validation rules of an input
     *         field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     * @throws NotFoundException
     *         Lightsail throws this exception when it cannot find a resource.
     * @throws OperationFailureException
     *         Lightsail throws this exception when an operation fails to execute.
     * @throws AccessDeniedException
     *         Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to
     *         access a resource.
     * @throws AccountSetupInProgressException
     *         Lightsail throws this exception when an account is still in the setup in progress state.
     * @throws UnauthenticatedException
     *         Lightsail throws this exception when the user has not been authenticated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LightsailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LightsailClient.UpdateRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelationalDatabaseParametersResponse updateRelationalDatabaseParameters(
            Consumer<UpdateRelationalDatabaseParametersRequest.Builder> updateRelationalDatabaseParametersRequest)
            throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException,
            AccountSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException,
            LightsailException {
        return updateRelationalDatabaseParameters(UpdateRelationalDatabaseParametersRequest.builder()
                .applyMutation(updateRelationalDatabaseParametersRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("lightsail");
    }
}
