/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction;
import software.amazon.awssdk.services.lightsail.model.PendingMaintenanceActionListCopier;
import software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabase> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RelationalDatabase.getter(RelationalDatabase::name)).setter(RelationalDatabase.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RelationalDatabase.getter(RelationalDatabase::arn)).setter(RelationalDatabase.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(RelationalDatabase.getter(RelationalDatabase::supportCode)).setter(RelationalDatabase.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(RelationalDatabase.getter(RelationalDatabase::createdAt)).setter(RelationalDatabase.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(RelationalDatabase.getter(RelationalDatabase::location)).setter(RelationalDatabase.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(RelationalDatabase.getter(RelationalDatabase::resourceTypeAsString)).setter(RelationalDatabase.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(RelationalDatabase.getter(RelationalDatabase::tags)).setter(RelationalDatabase.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseBlueprintId").getter(RelationalDatabase.getter(RelationalDatabase::relationalDatabaseBlueprintId)).setter(RelationalDatabase.setter(Builder::relationalDatabaseBlueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBlueprintId").build()}).build();
    private static final SdkField<String> RELATIONAL_DATABASE_BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseBundleId").getter(RelationalDatabase.getter(RelationalDatabase::relationalDatabaseBundleId)).setter(RelationalDatabase.setter(Builder::relationalDatabaseBundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBundleId").build()}).build();
    private static final SdkField<String> MASTER_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("masterDatabaseName").getter(RelationalDatabase.getter(RelationalDatabase::masterDatabaseName)).setter(RelationalDatabase.setter(Builder::masterDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterDatabaseName").build()}).build();
    private static final SdkField<RelationalDatabaseHardware> HARDWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hardware").getter(RelationalDatabase.getter(RelationalDatabase::hardware)).setter(RelationalDatabase.setter(Builder::hardware)).constructor(RelationalDatabaseHardware::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardware").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(RelationalDatabase.getter(RelationalDatabase::state)).setter(RelationalDatabase.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secondaryAvailabilityZone").getter(RelationalDatabase.getter(RelationalDatabase::secondaryAvailabilityZone)).setter(RelationalDatabase.setter(Builder::secondaryAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryAvailabilityZone").build()}).build();
    private static final SdkField<Boolean> BACKUP_RETENTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("backupRetentionEnabled").getter(RelationalDatabase.getter(RelationalDatabase::backupRetentionEnabled)).setter(RelationalDatabase.setter(Builder::backupRetentionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupRetentionEnabled").build()}).build();
    private static final SdkField<PendingModifiedRelationalDatabaseValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pendingModifiedValues").getter(RelationalDatabase.getter(RelationalDatabase::pendingModifiedValues)).setter(RelationalDatabase.setter(Builder::pendingModifiedValues)).constructor(PendingModifiedRelationalDatabaseValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingModifiedValues").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(RelationalDatabase.getter(RelationalDatabase::engine)).setter(RelationalDatabase.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersion").getter(RelationalDatabase.getter(RelationalDatabase::engineVersion)).setter(RelationalDatabase.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("latestRestorableTime").getter(RelationalDatabase.getter(RelationalDatabase::latestRestorableTime)).setter(RelationalDatabase.setter(Builder::latestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRestorableTime").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("masterUsername").getter(RelationalDatabase.getter(RelationalDatabase::masterUsername)).setter(RelationalDatabase.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUsername").build()}).build();
    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parameterApplyStatus").getter(RelationalDatabase.getter(RelationalDatabase::parameterApplyStatus)).setter(RelationalDatabase.setter(Builder::parameterApplyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterApplyStatus").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredBackupWindow").getter(RelationalDatabase.getter(RelationalDatabase::preferredBackupWindow)).setter(RelationalDatabase.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredMaintenanceWindow").getter(RelationalDatabase.getter(RelationalDatabase::preferredMaintenanceWindow)).setter(RelationalDatabase.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(RelationalDatabase.getter(RelationalDatabase::publiclyAccessible)).setter(RelationalDatabase.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<RelationalDatabaseEndpoint> MASTER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("masterEndpoint").getter(RelationalDatabase.getter(RelationalDatabase::masterEndpoint)).setter(RelationalDatabase.setter(Builder::masterEndpoint)).constructor(RelationalDatabaseEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterEndpoint").build()}).build();
    private static final SdkField<List<PendingMaintenanceAction>> PENDING_MAINTENANCE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pendingMaintenanceActions").getter(RelationalDatabase.getter(RelationalDatabase::pendingMaintenanceActions)).setter(RelationalDatabase.setter(Builder::pendingMaintenanceActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingMaintenanceActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingMaintenanceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caCertificateIdentifier").getter(RelationalDatabase.getter(RelationalDatabase::caCertificateIdentifier)).setter(RelationalDatabase.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD, RELATIONAL_DATABASE_BUNDLE_ID_FIELD, MASTER_DATABASE_NAME_FIELD, HARDWARE_FIELD, STATE_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD, BACKUP_RETENTION_ENABLED_FIELD, PENDING_MODIFIED_VALUES_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, LATEST_RESTORABLE_TIME_FIELD, MASTER_USERNAME_FIELD, PARAMETER_APPLY_STATUS_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD, MASTER_ENDPOINT_FIELD, PENDING_MAINTENANCE_ACTIONS_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final String relationalDatabaseBlueprintId;
    private final String relationalDatabaseBundleId;
    private final String masterDatabaseName;
    private final RelationalDatabaseHardware hardware;
    private final String state;
    private final String secondaryAvailabilityZone;
    private final Boolean backupRetentionEnabled;
    private final PendingModifiedRelationalDatabaseValues pendingModifiedValues;
    private final String engine;
    private final String engineVersion;
    private final Instant latestRestorableTime;
    private final String masterUsername;
    private final String parameterApplyStatus;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Boolean publiclyAccessible;
    private final RelationalDatabaseEndpoint masterEndpoint;
    private final List<PendingMaintenanceAction> pendingMaintenanceActions;
    private final String caCertificateIdentifier;

    private RelationalDatabase(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.relationalDatabaseBlueprintId = builder.relationalDatabaseBlueprintId;
        this.relationalDatabaseBundleId = builder.relationalDatabaseBundleId;
        this.masterDatabaseName = builder.masterDatabaseName;
        this.hardware = builder.hardware;
        this.state = builder.state;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.backupRetentionEnabled = builder.backupRetentionEnabled;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.masterUsername = builder.masterUsername;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.masterEndpoint = builder.masterEndpoint;
        this.pendingMaintenanceActions = builder.pendingMaintenanceActions;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String relationalDatabaseBlueprintId() {
        return this.relationalDatabaseBlueprintId;
    }

    public final String relationalDatabaseBundleId() {
        return this.relationalDatabaseBundleId;
    }

    public final String masterDatabaseName() {
        return this.masterDatabaseName;
    }

    public final RelationalDatabaseHardware hardware() {
        return this.hardware;
    }

    public final String state() {
        return this.state;
    }

    public final String secondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public final Boolean backupRetentionEnabled() {
        return this.backupRetentionEnabled;
    }

    public final PendingModifiedRelationalDatabaseValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Instant latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String parameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final RelationalDatabaseEndpoint masterEndpoint() {
        return this.masterEndpoint;
    }

    public final boolean hasPendingMaintenanceActions() {
        return this.pendingMaintenanceActions != null && !(this.pendingMaintenanceActions instanceof SdkAutoConstructList);
    }

    public final List<PendingMaintenanceAction> pendingMaintenanceActions() {
        return this.pendingMaintenanceActions;
    }

    public final String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hardware());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingMaintenanceActions() ? this.pendingMaintenanceActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabase)) {
            return false;
        }
        RelationalDatabase other = (RelationalDatabase)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.relationalDatabaseBlueprintId(), other.relationalDatabaseBlueprintId()) && Objects.equals(this.relationalDatabaseBundleId(), other.relationalDatabaseBundleId()) && Objects.equals(this.masterDatabaseName(), other.masterDatabaseName()) && Objects.equals(this.hardware(), other.hardware()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.secondaryAvailabilityZone(), other.secondaryAvailabilityZone()) && Objects.equals(this.backupRetentionEnabled(), other.backupRetentionEnabled()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.parameterApplyStatus(), other.parameterApplyStatus()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.masterEndpoint(), other.masterEndpoint()) && this.hasPendingMaintenanceActions() == other.hasPendingMaintenanceActions() && Objects.equals(this.pendingMaintenanceActions(), other.pendingMaintenanceActions()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalDatabase").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("RelationalDatabaseBlueprintId", (Object)this.relationalDatabaseBlueprintId()).add("RelationalDatabaseBundleId", (Object)this.relationalDatabaseBundleId()).add("MasterDatabaseName", (Object)this.masterDatabaseName()).add("Hardware", (Object)this.hardware()).add("State", (Object)this.state()).add("SecondaryAvailabilityZone", (Object)this.secondaryAvailabilityZone()).add("BackupRetentionEnabled", (Object)this.backupRetentionEnabled()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("LatestRestorableTime", (Object)this.latestRestorableTime()).add("MasterUsername", (Object)this.masterUsername()).add("ParameterApplyStatus", (Object)this.parameterApplyStatus()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("MasterEndpoint", (Object)this.masterEndpoint()).add("PendingMaintenanceActions", this.hasPendingMaintenanceActions() ? this.pendingMaintenanceActions() : null).add("CaCertificateIdentifier", (Object)this.caCertificateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "relationalDatabaseBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseBlueprintId()));
            }
            case "relationalDatabaseBundleId": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseBundleId()));
            }
            case "masterDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.masterDatabaseName()));
            }
            case "hardware": {
                return Optional.ofNullable(clazz.cast(this.hardware()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "secondaryAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.secondaryAvailabilityZone()));
            }
            case "backupRetentionEnabled": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionEnabled()));
            }
            case "pendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "latestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.latestRestorableTime()));
            }
            case "masterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "parameterApplyStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterApplyStatus()));
            }
            case "preferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "preferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "masterEndpoint": {
                return Optional.ofNullable(clazz.cast(this.masterEndpoint()));
            }
            case "pendingMaintenanceActions": {
                return Optional.ofNullable(clazz.cast(this.pendingMaintenanceActions()));
            }
            case "caCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabase, T> g) {
        return obj -> g.apply((RelationalDatabase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String relationalDatabaseBlueprintId;
        private String relationalDatabaseBundleId;
        private String masterDatabaseName;
        private RelationalDatabaseHardware hardware;
        private String state;
        private String secondaryAvailabilityZone;
        private Boolean backupRetentionEnabled;
        private PendingModifiedRelationalDatabaseValues pendingModifiedValues;
        private String engine;
        private String engineVersion;
        private Instant latestRestorableTime;
        private String masterUsername;
        private String parameterApplyStatus;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Boolean publiclyAccessible;
        private RelationalDatabaseEndpoint masterEndpoint;
        private List<PendingMaintenanceAction> pendingMaintenanceActions = DefaultSdkAutoConstructList.getInstance();
        private String caCertificateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabase model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.relationalDatabaseBlueprintId(model.relationalDatabaseBlueprintId);
            this.relationalDatabaseBundleId(model.relationalDatabaseBundleId);
            this.masterDatabaseName(model.masterDatabaseName);
            this.hardware(model.hardware);
            this.state(model.state);
            this.secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            this.backupRetentionEnabled(model.backupRetentionEnabled);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.latestRestorableTime(model.latestRestorableTime);
            this.masterUsername(model.masterUsername);
            this.parameterApplyStatus(model.parameterApplyStatus);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.publiclyAccessible(model.publiclyAccessible);
            this.masterEndpoint(model.masterEndpoint);
            this.pendingMaintenanceActions(model.pendingMaintenanceActions);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getRelationalDatabaseBlueprintId() {
            return this.relationalDatabaseBlueprintId;
        }

        @Override
        public final Builder relationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
            return this;
        }

        public final void setRelationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
        }

        public final String getRelationalDatabaseBundleId() {
            return this.relationalDatabaseBundleId;
        }

        @Override
        public final Builder relationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
            return this;
        }

        public final void setRelationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
        }

        public final String getMasterDatabaseName() {
            return this.masterDatabaseName;
        }

        @Override
        public final Builder masterDatabaseName(String masterDatabaseName) {
            this.masterDatabaseName = masterDatabaseName;
            return this;
        }

        public final void setMasterDatabaseName(String masterDatabaseName) {
            this.masterDatabaseName = masterDatabaseName;
        }

        public final RelationalDatabaseHardware.Builder getHardware() {
            return this.hardware != null ? this.hardware.toBuilder() : null;
        }

        @Override
        public final Builder hardware(RelationalDatabaseHardware hardware) {
            this.hardware = hardware;
            return this;
        }

        public final void setHardware(RelationalDatabaseHardware.BuilderImpl hardware) {
            this.hardware = hardware != null ? hardware.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSecondaryAvailabilityZone() {
            return this.secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        public final Boolean getBackupRetentionEnabled() {
            return this.backupRetentionEnabled;
        }

        @Override
        public final Builder backupRetentionEnabled(Boolean backupRetentionEnabled) {
            this.backupRetentionEnabled = backupRetentionEnabled;
            return this;
        }

        public final void setBackupRetentionEnabled(Boolean backupRetentionEnabled) {
            this.backupRetentionEnabled = backupRetentionEnabled;
        }

        public final PendingModifiedRelationalDatabaseValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedRelationalDatabaseValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedRelationalDatabaseValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Instant getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getParameterApplyStatus() {
            return this.parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final RelationalDatabaseEndpoint.Builder getMasterEndpoint() {
            return this.masterEndpoint != null ? this.masterEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder masterEndpoint(RelationalDatabaseEndpoint masterEndpoint) {
            this.masterEndpoint = masterEndpoint;
            return this;
        }

        public final void setMasterEndpoint(RelationalDatabaseEndpoint.BuilderImpl masterEndpoint) {
            this.masterEndpoint = masterEndpoint != null ? masterEndpoint.build() : null;
        }

        public final Collection<PendingMaintenanceAction.Builder> getPendingMaintenanceActions() {
            if (this.pendingMaintenanceActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pendingMaintenanceActions != null ? (Collection)this.pendingMaintenanceActions.stream().map(PendingMaintenanceAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingMaintenanceActions(Collection<PendingMaintenanceAction> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionListCopier.copy(pendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(PendingMaintenanceAction ... pendingMaintenanceActions) {
            this.pendingMaintenanceActions(Arrays.asList(pendingMaintenanceActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(Consumer<PendingMaintenanceAction.Builder> ... pendingMaintenanceActions) {
            this.pendingMaintenanceActions(Stream.of(pendingMaintenanceActions).map(c -> (PendingMaintenanceAction)((PendingMaintenanceAction.Builder)PendingMaintenanceAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingMaintenanceActions(Collection<PendingMaintenanceAction.BuilderImpl> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionListCopier.copyFromBuilder(pendingMaintenanceActions);
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public RelationalDatabase build() {
            return new RelationalDatabase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabase> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder relationalDatabaseBlueprintId(String var1);

        public Builder relationalDatabaseBundleId(String var1);

        public Builder masterDatabaseName(String var1);

        public Builder hardware(RelationalDatabaseHardware var1);

        default public Builder hardware(Consumer<RelationalDatabaseHardware.Builder> hardware) {
            return this.hardware((RelationalDatabaseHardware)((RelationalDatabaseHardware.Builder)RelationalDatabaseHardware.builder().applyMutation(hardware)).build());
        }

        public Builder state(String var1);

        public Builder secondaryAvailabilityZone(String var1);

        public Builder backupRetentionEnabled(Boolean var1);

        public Builder pendingModifiedValues(PendingModifiedRelationalDatabaseValues var1);

        default public Builder pendingModifiedValues(Consumer<PendingModifiedRelationalDatabaseValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((PendingModifiedRelationalDatabaseValues)((PendingModifiedRelationalDatabaseValues.Builder)PendingModifiedRelationalDatabaseValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder latestRestorableTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder parameterApplyStatus(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder masterEndpoint(RelationalDatabaseEndpoint var1);

        default public Builder masterEndpoint(Consumer<RelationalDatabaseEndpoint.Builder> masterEndpoint) {
            return this.masterEndpoint((RelationalDatabaseEndpoint)((RelationalDatabaseEndpoint.Builder)RelationalDatabaseEndpoint.builder().applyMutation(masterEndpoint)).build());
        }

        public Builder pendingMaintenanceActions(Collection<PendingMaintenanceAction> var1);

        public Builder pendingMaintenanceActions(PendingMaintenanceAction ... var1);

        public Builder pendingMaintenanceActions(Consumer<PendingMaintenanceAction.Builder> ... var1);

        public Builder caCertificateIdentifier(String var1);
    }
}

