/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the default cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheBehavior implements SdkPojo, Serializable, ToCopyableBuilder<CacheBehavior.Builder, CacheBehavior> {
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("behavior").getter(getter(CacheBehavior::behaviorAsString)).setter(setter(Builder::behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String behavior;

    private CacheBehavior(BuilderImpl builder) {
        this.behavior = builder.behavior;
    }

    /**
     * <p>
     * The cache behavior of the distribution.
     * </p>
     * <p>
     * The following cache behaviors can be specified:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution caches and
     * serves your entire website as static content. This behavior is ideal for websites with static content that
     * doesn't change depending on who views it, or for websites that don't use cookies, headers, or query strings to
     * personalize content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and dynamic content.
     * When specified, your distribution caches and serve only the content that is specified in the distribution's
     * <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web applications that use
     * cookies, headers, and query strings to personalize content for individual users.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link BehaviorEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return The cache behavior of the distribution.</p>
     *         <p>
     *         The following cache behaviors can be specified:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution
     *         caches and serves your entire website as static content. This behavior is ideal for websites with static
     *         content that doesn't change depending on who views it, or for websites that don't use cookies, headers,
     *         or query strings to personalize content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and dynamic
     *         content. When specified, your distribution caches and serve only the content that is specified in the
     *         distribution's <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web
     *         applications that use cookies, headers, and query strings to personalize content for individual users.
     *         </p>
     *         </li>
     * @see BehaviorEnum
     */
    public final BehaviorEnum behavior() {
        return BehaviorEnum.fromValue(behavior);
    }

    /**
     * <p>
     * The cache behavior of the distribution.
     * </p>
     * <p>
     * The following cache behaviors can be specified:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution caches and
     * serves your entire website as static content. This behavior is ideal for websites with static content that
     * doesn't change depending on who views it, or for websites that don't use cookies, headers, or query strings to
     * personalize content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and dynamic content.
     * When specified, your distribution caches and serve only the content that is specified in the distribution's
     * <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web applications that use
     * cookies, headers, and query strings to personalize content for individual users.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link BehaviorEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return The cache behavior of the distribution.</p>
     *         <p>
     *         The following cache behaviors can be specified:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution
     *         caches and serves your entire website as static content. This behavior is ideal for websites with static
     *         content that doesn't change depending on who views it, or for websites that don't use cookies, headers,
     *         or query strings to personalize content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and dynamic
     *         content. When specified, your distribution caches and serve only the content that is specified in the
     *         distribution's <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web
     *         applications that use cookies, headers, and query strings to personalize content for individual users.
     *         </p>
     *         </li>
     * @see BehaviorEnum
     */
    public final String behaviorAsString() {
        return behavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(behaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehavior)) {
            return false;
        }
        CacheBehavior other = (CacheBehavior) obj;
        return Objects.equals(behaviorAsString(), other.behaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CacheBehavior").add("Behavior", behaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "behavior":
            return Optional.ofNullable(clazz.cast(behaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheBehavior, T> g) {
        return obj -> g.apply((CacheBehavior) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheBehavior> {
        /**
         * <p>
         * The cache behavior of the distribution.
         * </p>
         * <p>
         * The following cache behaviors can be specified:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution caches
         * and serves your entire website as static content. This behavior is ideal for websites with static content
         * that doesn't change depending on who views it, or for websites that don't use cookies, headers, or query
         * strings to personalize content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and dynamic
         * content. When specified, your distribution caches and serve only the content that is specified in the
         * distribution's <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web
         * applications that use cookies, headers, and query strings to personalize content for individual users.
         * </p>
         * </li>
         * </ul>
         * 
         * @param behavior
         *        The cache behavior of the distribution.</p>
         *        <p>
         *        The following cache behaviors can be specified:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution
         *        caches and serves your entire website as static content. This behavior is ideal for websites with
         *        static content that doesn't change depending on who views it, or for websites that don't use cookies,
         *        headers, or query strings to personalize content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and
         *        dynamic content. When specified, your distribution caches and serve only the content that is specified
         *        in the distribution's <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites
         *        or web applications that use cookies, headers, and query strings to personalize content for individual
         *        users.
         *        </p>
         *        </li>
         * @see BehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorEnum
         */
        Builder behavior(String behavior);

        /**
         * <p>
         * The cache behavior of the distribution.
         * </p>
         * <p>
         * The following cache behaviors can be specified:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution caches
         * and serves your entire website as static content. This behavior is ideal for websites with static content
         * that doesn't change depending on who views it, or for websites that don't use cookies, headers, or query
         * strings to personalize content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and dynamic
         * content. When specified, your distribution caches and serve only the content that is specified in the
         * distribution's <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web
         * applications that use cookies, headers, and query strings to personalize content for individual users.
         * </p>
         * </li>
         * </ul>
         * 
         * @param behavior
         *        The cache behavior of the distribution.</p>
         *        <p>
         *        The following cache behaviors can be specified:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>cache</code> </b> - This option is best for static sites. When specified, your distribution
         *        caches and serves your entire website as static content. This behavior is ideal for websites with
         *        static content that doesn't change depending on who views it, or for websites that don't use cookies,
         *        headers, or query strings to personalize content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>dont-cache</code> </b> - This option is best for sites that serve a mix of static and
         *        dynamic content. When specified, your distribution caches and serve only the content that is specified
         *        in the distribution's <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites
         *        or web applications that use cookies, headers, and query strings to personalize content for individual
         *        users.
         *        </p>
         *        </li>
         * @see BehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorEnum
         */
        Builder behavior(BehaviorEnum behavior);
    }

    static final class BuilderImpl implements Builder {
        private String behavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheBehavior model) {
            behavior(model.behavior);
        }

        public final String getBehavior() {
            return behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(BehaviorEnum behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public CacheBehavior build() {
            return new CacheBehavior(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
