/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerServiceRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateContainerServiceRequest.Builder, CreateContainerServiceRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(CreateContainerServiceRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> POWER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("power")
            .getter(getter(CreateContainerServiceRequest::powerAsString)).setter(setter(Builder::power))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("power").build()).build();

    private static final SdkField<Integer> SCALE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("scale")
            .getter(getter(CreateContainerServiceRequest::scale)).setter(setter(Builder::scale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateContainerServiceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> PUBLIC_DOMAIN_NAMES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("publicDomainNames")
            .getter(getter(CreateContainerServiceRequest::publicDomainNames))
            .setter(setter(Builder::publicDomainNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDomainNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<ContainerServiceDeploymentRequest> DEPLOYMENT_FIELD = SdkField
            .<ContainerServiceDeploymentRequest> builder(MarshallingType.SDK_POJO).memberName("deployment")
            .getter(getter(CreateContainerServiceRequest::deployment)).setter(setter(Builder::deployment))
            .constructor(ContainerServiceDeploymentRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            POWER_FIELD, SCALE_FIELD, TAGS_FIELD, PUBLIC_DOMAIN_NAMES_FIELD, DEPLOYMENT_FIELD));

    private final String serviceName;

    private final String power;

    private final Integer scale;

    private final List<Tag> tags;

    private final Map<String, List<String>> publicDomainNames;

    private final ContainerServiceDeploymentRequest deployment;

    private CreateContainerServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.power = builder.power;
        this.scale = builder.scale;
        this.tags = builder.tags;
        this.publicDomainNames = builder.publicDomainNames;
        this.deployment = builder.deployment;
    }

    /**
     * <p>
     * The name for the container service.
     * </p>
     * <p>
     * The name that you specify for your container service will make up part of its default domain. The default domain
     * of a container service is typically
     * <code>https://&lt;ServiceName&gt;.&lt;RandomGUID&gt;.&lt;AWSRegion&gt;.cs.amazonlightsail.com</code>. If the name
     * of your container service is <code>container-service-1</code>, and it's located in the US East (Ohio) AWS region
     * (<code>us-east-2</code>), then the domain for your container service will be like the following example:
     * <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code>
     * </p>
     * <p>
     * The following are the requirements for container service names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be unique within each AWS Region in your Lightsail account.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain 1 to 63 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain only alphanumeric characters and hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * A hyphen (-) can separate words but cannot be at the start or end of the name.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the container service.</p>
     *         <p>
     *         The name that you specify for your container service will make up part of its default domain. The default
     *         domain of a container service is typically
     *         <code>https://&lt;ServiceName&gt;.&lt;RandomGUID&gt;.&lt;AWSRegion&gt;.cs.amazonlightsail.com</code>. If
     *         the name of your container service is <code>container-service-1</code>, and it's located in the US East
     *         (Ohio) AWS region (<code>us-east-2</code>), then the domain for your container service will be like the
     *         following example:
     *         <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code>
     *         </p>
     *         <p>
     *         The following are the requirements for container service names:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be unique within each AWS Region in your Lightsail account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain 1 to 63 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain only alphanumeric characters and hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A hyphen (-) can separate words but cannot be at the start or end of the name.
     *         </p>
     *         </li>
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The power specification for the container service.
     * </p>
     * <p>
     * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The
     * <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine
     * the monthly price of your container service, multiply the base price of the <code>power</code> with the
     * <code>scale</code> (the number of nodes) of the service.
     * </p>
     * <p>
     * Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify using
     * this parameter, and their base monthly cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #power} will return
     * {@link ContainerServicePowerName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerAsString}.
     * </p>
     * 
     * @return The power specification for the container service.</p>
     *         <p>
     *         The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
     *         service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
     *         capacity. To determine the monthly price of your container service, multiply the base price of the
     *         <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
     *         </p>
     *         <p>
     *         Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify
     *         using this parameter, and their base monthly cost.
     * @see ContainerServicePowerName
     */
    public final ContainerServicePowerName power() {
        return ContainerServicePowerName.fromValue(power);
    }

    /**
     * <p>
     * The power specification for the container service.
     * </p>
     * <p>
     * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The
     * <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine
     * the monthly price of your container service, multiply the base price of the <code>power</code> with the
     * <code>scale</code> (the number of nodes) of the service.
     * </p>
     * <p>
     * Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify using
     * this parameter, and their base monthly cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #power} will return
     * {@link ContainerServicePowerName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerAsString}.
     * </p>
     * 
     * @return The power specification for the container service.</p>
     *         <p>
     *         The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
     *         service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
     *         capacity. To determine the monthly price of your container service, multiply the base price of the
     *         <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
     *         </p>
     *         <p>
     *         Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify
     *         using this parameter, and their base monthly cost.
     * @see ContainerServicePowerName
     */
    public final String powerAsString() {
        return power;
    }

    /**
     * <p>
     * The scale specification for the container service.
     * </p>
     * <p>
     * The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
     * <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of
     * your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the number
     * of nodes) of the service.
     * </p>
     * 
     * @return The scale specification for the container service.</p>
     *         <p>
     *         The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
     *         <code>scale</code> of a container service makes up its configured capacity. To determine the monthly
     *         price of your container service, multiply the base price of the <code>power</code> with the
     *         <code>scale</code> (the number of nodes) of the service.
     */
    public final Integer scale() {
        return scale;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values for the container service.
     * </p>
     * <p>
     * For more information about tags in Lightsail, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values for the container service.</p>
     *         <p>
     *         For more information about tags in Lightsail, see the <a
     *         href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
     *         Guide</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the PublicDomainNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPublicDomainNames() {
        return publicDomainNames != null && !(publicDomainNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The public domain names to use with the container service, such as <code>example.com</code> and
     * <code>www.example.com</code>.
     * </p>
     * <p>
     * You can specify up to four public domain names for a container service. The domain names that you specify are
     * used when you create a deployment with a container configured as the public endpoint of your container service.
     * </p>
     * <p>
     * If you don't specify public domain names, then you can use the default domain of the container service.
     * </p>
     * <important>
     * <p>
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container
     * service. Use the <code>CreateCertificate</code> action to create a certificate for the public domain names you
     * want to use with your container service.
     * </p>
     * </important>
     * <p>
     * You can specify public domain names using a string to array map as shown in the example later on this page.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPublicDomainNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The public domain names to use with the container service, such as <code>example.com</code> and
     *         <code>www.example.com</code>.</p>
     *         <p>
     *         You can specify up to four public domain names for a container service. The domain names that you specify
     *         are used when you create a deployment with a container configured as the public endpoint of your
     *         container service.
     *         </p>
     *         <p>
     *         If you don't specify public domain names, then you can use the default domain of the container service.
     *         </p>
     *         <important>
     *         <p>
     *         You must create and validate an SSL/TLS certificate before you can use public domain names with your
     *         container service. Use the <code>CreateCertificate</code> action to create a certificate for the public
     *         domain names you want to use with your container service.
     *         </p>
     *         </important>
     *         <p>
     *         You can specify public domain names using a string to array map as shown in the example later on this
     *         page.
     */
    public final Map<String, List<String>> publicDomainNames() {
        return publicDomainNames;
    }

    /**
     * <p>
     * An object that describes a deployment for the container service.
     * </p>
     * <p>
     * A deployment specifies the containers that will be launched on the container service and their settings, such as
     * the ports to open, the environment variables to apply, and the launch command to run. It also specifies the
     * container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS
     * port to use, and the health check configuration.
     * </p>
     * 
     * @return An object that describes a deployment for the container service.</p>
     *         <p>
     *         A deployment specifies the containers that will be launched on the container service and their settings,
     *         such as the ports to open, the environment variables to apply, and the launch command to run. It also
     *         specifies the container that will serve as the public endpoint of the deployment and its settings, such
     *         as the HTTP or HTTPS port to use, and the health check configuration.
     */
    public final ContainerServiceDeploymentRequest deployment() {
        return deployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(powerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicDomainNames() ? publicDomainNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deployment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerServiceRequest)) {
            return false;
        }
        CreateContainerServiceRequest other = (CreateContainerServiceRequest) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(powerAsString(), other.powerAsString())
                && Objects.equals(scale(), other.scale()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasPublicDomainNames() == other.hasPublicDomainNames()
                && Objects.equals(publicDomainNames(), other.publicDomainNames())
                && Objects.equals(deployment(), other.deployment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContainerServiceRequest").add("ServiceName", serviceName()).add("Power", powerAsString())
                .add("Scale", scale()).add("Tags", hasTags() ? tags() : null)
                .add("PublicDomainNames", hasPublicDomainNames() ? publicDomainNames() : null).add("Deployment", deployment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "power":
            return Optional.ofNullable(clazz.cast(powerAsString()));
        case "scale":
            return Optional.ofNullable(clazz.cast(scale()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "publicDomainNames":
            return Optional.ofNullable(clazz.cast(publicDomainNames()));
        case "deployment":
            return Optional.ofNullable(clazz.cast(deployment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerServiceRequest, T> g) {
        return obj -> g.apply((CreateContainerServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContainerServiceRequest> {
        /**
         * <p>
         * The name for the container service.
         * </p>
         * <p>
         * The name that you specify for your container service will make up part of its default domain. The default
         * domain of a container service is typically
         * <code>https://&lt;ServiceName&gt;.&lt;RandomGUID&gt;.&lt;AWSRegion&gt;.cs.amazonlightsail.com</code>. If the
         * name of your container service is <code>container-service-1</code>, and it's located in the US East (Ohio)
         * AWS region (<code>us-east-2</code>), then the domain for your container service will be like the following
         * example: <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code>
         * </p>
         * <p>
         * The following are the requirements for container service names:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be unique within each AWS Region in your Lightsail account.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain 1 to 63 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain only alphanumeric characters and hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * A hyphen (-) can separate words but cannot be at the start or end of the name.
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceName
         *        The name for the container service.</p>
         *        <p>
         *        The name that you specify for your container service will make up part of its default domain. The
         *        default domain of a container service is typically
         *        <code>https://&lt;ServiceName&gt;.&lt;RandomGUID&gt;.&lt;AWSRegion&gt;.cs.amazonlightsail.com</code>.
         *        If the name of your container service is <code>container-service-1</code>, and it's located in the US
         *        East (Ohio) AWS region (<code>us-east-2</code>), then the domain for your container service will be
         *        like the following example:
         *        <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code>
         *        </p>
         *        <p>
         *        The following are the requirements for container service names:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be unique within each AWS Region in your Lightsail account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain 1 to 63 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain only alphanumeric characters and hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A hyphen (-) can separate words but cannot be at the start or end of the name.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The power specification for the container service.
         * </p>
         * <p>
         * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service.
         * The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To
         * determine the monthly price of your container service, multiply the base price of the <code>power</code> with
         * the <code>scale</code> (the number of nodes) of the service.
         * </p>
         * <p>
         * Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify
         * using this parameter, and their base monthly cost.
         * </p>
         * 
         * @param power
         *        The power specification for the container service.</p>
         *        <p>
         *        The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
         *        service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
         *        capacity. To determine the monthly price of your container service, multiply the base price of the
         *        <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
         *        </p>
         *        <p>
         *        Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can
         *        specify using this parameter, and their base monthly cost.
         * @see ContainerServicePowerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerServicePowerName
         */
        Builder power(String power);

        /**
         * <p>
         * The power specification for the container service.
         * </p>
         * <p>
         * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service.
         * The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To
         * determine the monthly price of your container service, multiply the base price of the <code>power</code> with
         * the <code>scale</code> (the number of nodes) of the service.
         * </p>
         * <p>
         * Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify
         * using this parameter, and their base monthly cost.
         * </p>
         * 
         * @param power
         *        The power specification for the container service.</p>
         *        <p>
         *        The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container
         *        service. The <code>power</code> and <code>scale</code> of a container service makes up its configured
         *        capacity. To determine the monthly price of your container service, multiply the base price of the
         *        <code>power</code> with the <code>scale</code> (the number of nodes) of the service.
         *        </p>
         *        <p>
         *        Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can
         *        specify using this parameter, and their base monthly cost.
         * @see ContainerServicePowerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerServicePowerName
         */
        Builder power(ContainerServicePowerName power);

        /**
         * <p>
         * The scale specification for the container service.
         * </p>
         * <p>
         * The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
         * <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of
         * your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the
         * number of nodes) of the service.
         * </p>
         * 
         * @param scale
         *        The scale specification for the container service.</p>
         *        <p>
         *        The scale specifies the allocated compute nodes of the container service. The <code>power</code> and
         *        <code>scale</code> of a container service makes up its configured capacity. To determine the monthly
         *        price of your container service, multiply the base price of the <code>power</code> with the
         *        <code>scale</code> (the number of nodes) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(Integer scale);

        /**
         * <p>
         * The tag keys and optional values for the container service.
         * </p>
         * <p>
         * For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the container service.</p>
         *        <p>
         *        For more information about tags in Lightsail, see the <a
         *        href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values for the container service.
         * </p>
         * <p>
         * For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the container service.</p>
         *        <p>
         *        For more information about tags in Lightsail, see the <a
         *        href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values for the container service.
         * </p>
         * <p>
         * For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The public domain names to use with the container service, such as <code>example.com</code> and
         * <code>www.example.com</code>.
         * </p>
         * <p>
         * You can specify up to four public domain names for a container service. The domain names that you specify are
         * used when you create a deployment with a container configured as the public endpoint of your container
         * service.
         * </p>
         * <p>
         * If you don't specify public domain names, then you can use the default domain of the container service.
         * </p>
         * <important>
         * <p>
         * You must create and validate an SSL/TLS certificate before you can use public domain names with your
         * container service. Use the <code>CreateCertificate</code> action to create a certificate for the public
         * domain names you want to use with your container service.
         * </p>
         * </important>
         * <p>
         * You can specify public domain names using a string to array map as shown in the example later on this page.
         * </p>
         * 
         * @param publicDomainNames
         *        The public domain names to use with the container service, such as <code>example.com</code> and
         *        <code>www.example.com</code>.</p>
         *        <p>
         *        You can specify up to four public domain names for a container service. The domain names that you
         *        specify are used when you create a deployment with a container configured as the public endpoint of
         *        your container service.
         *        </p>
         *        <p>
         *        If you don't specify public domain names, then you can use the default domain of the container
         *        service.
         *        </p>
         *        <important>
         *        <p>
         *        You must create and validate an SSL/TLS certificate before you can use public domain names with your
         *        container service. Use the <code>CreateCertificate</code> action to create a certificate for the
         *        public domain names you want to use with your container service.
         *        </p>
         *        </important>
         *        <p>
         *        You can specify public domain names using a string to array map as shown in the example later on this
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames);

        /**
         * <p>
         * An object that describes a deployment for the container service.
         * </p>
         * <p>
         * A deployment specifies the containers that will be launched on the container service and their settings, such
         * as the ports to open, the environment variables to apply, and the launch command to run. It also specifies
         * the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or
         * HTTPS port to use, and the health check configuration.
         * </p>
         * 
         * @param deployment
         *        An object that describes a deployment for the container service.</p>
         *        <p>
         *        A deployment specifies the containers that will be launched on the container service and their
         *        settings, such as the ports to open, the environment variables to apply, and the launch command to
         *        run. It also specifies the container that will serve as the public endpoint of the deployment and its
         *        settings, such as the HTTP or HTTPS port to use, and the health check configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployment(ContainerServiceDeploymentRequest deployment);

        /**
         * <p>
         * An object that describes a deployment for the container service.
         * </p>
         * <p>
         * A deployment specifies the containers that will be launched on the container service and their settings, such
         * as the ports to open, the environment variables to apply, and the launch command to run. It also specifies
         * the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or
         * HTTPS port to use, and the health check configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerServiceDeploymentRequest.Builder}
         * avoiding the need to create one manually via {@link ContainerServiceDeploymentRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerServiceDeploymentRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #deployment(ContainerServiceDeploymentRequest)}.
         * 
         * @param deployment
         *        a consumer that will call methods on {@link ContainerServiceDeploymentRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployment(ContainerServiceDeploymentRequest)
         */
        default Builder deployment(Consumer<ContainerServiceDeploymentRequest.Builder> deployment) {
            return deployment(ContainerServiceDeploymentRequest.builder().applyMutation(deployment).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String serviceName;

        private String power;

        private Integer scale;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> publicDomainNames = DefaultSdkAutoConstructMap.getInstance();

        private ContainerServiceDeploymentRequest deployment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerServiceRequest model) {
            super(model);
            serviceName(model.serviceName);
            power(model.power);
            scale(model.scale);
            tags(model.tags);
            publicDomainNames(model.publicDomainNames);
            deployment(model.deployment);
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getPower() {
            return power;
        }

        @Override
        public final Builder power(String power) {
            this.power = power;
            return this;
        }

        @Override
        public final Builder power(ContainerServicePowerName power) {
            this.power(power == null ? null : power.toString());
            return this;
        }

        public final void setPower(String power) {
            this.power = power;
        }

        public final Integer getScale() {
            return scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Map<String, ? extends Collection<String>> getPublicDomainNames() {
            if (publicDomainNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return publicDomainNames;
        }

        @Override
        public final Builder publicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
            return this;
        }

        public final void setPublicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
        }

        public final ContainerServiceDeploymentRequest.Builder getDeployment() {
            return deployment != null ? deployment.toBuilder() : null;
        }

        @Override
        public final Builder deployment(ContainerServiceDeploymentRequest deployment) {
            this.deployment = deployment;
            return this;
        }

        public final void setDeployment(ContainerServiceDeploymentRequest.BuilderImpl deployment) {
            this.deployment = deployment != null ? deployment.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerServiceRequest build() {
            return new CreateContainerServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
