/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDiskRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateDiskRequest.Builder, CreateDiskRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskName").getter(getter(CreateDiskRequest::diskName)).setter(setter(Builder::diskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateDiskRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInGb").getter(getter(CreateDiskRequest::sizeInGb)).setter(setter(Builder::sizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDiskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField
            .<List<AddOnRequest>> builder(MarshallingType.LIST)
            .memberName("addOns")
            .getter(getter(CreateDiskRequest::addOns))
            .setter(setter(Builder::addOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOnRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOnRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD,
            AVAILABILITY_ZONE_FIELD, SIZE_IN_GB_FIELD, TAGS_FIELD, ADD_ONS_FIELD));

    private final String diskName;

    private final String availabilityZone;

    private final Integer sizeInGb;

    private final List<Tag> tags;

    private final List<AddOnRequest> addOns;

    private CreateDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.availabilityZone = builder.availabilityZone;
        this.sizeInGb = builder.sizeInGb;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
    }

    /**
     * <p>
     * The unique Lightsail disk name (e.g., <code>my-disk</code>).
     * </p>
     * 
     * @return The unique Lightsail disk name (e.g., <code>my-disk</code>).
     */
    public final String diskName() {
        return diskName;
    }

    /**
     * <p>
     * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Use the same
     * Availability Zone as the Lightsail instance to which you want to attach the disk.
     * </p>
     * <p>
     * Use the <code>get regions</code> operation to list the Availability Zones where Lightsail is currently available.
     * </p>
     * 
     * @return The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Use the same
     *         Availability Zone as the Lightsail instance to which you want to attach the disk.</p>
     *         <p>
     *         Use the <code>get regions</code> operation to list the Availability Zones where Lightsail is currently
     *         available.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The size of the disk in GB (e.g., <code>32</code>).
     * </p>
     * 
     * @return The size of the disk in GB (e.g., <code>32</code>).
     */
    public final Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the AddOns property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAddOns() {
        return addOns != null && !(addOns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that represent the add-ons to enable for the new disk.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddOns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that represent the add-ons to enable for the new disk.
     */
    public final List<AddOnRequest> addOns() {
        return addOns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOns() ? addOns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskRequest)) {
            return false;
        }
        CreateDiskRequest other = (CreateDiskRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(sizeInGb(), other.sizeInGb()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasAddOns() == other.hasAddOns()
                && Objects.equals(addOns(), other.addOns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDiskRequest").add("DiskName", diskName()).add("AvailabilityZone", availabilityZone())
                .add("SizeInGb", sizeInGb()).add("Tags", hasTags() ? tags() : null).add("AddOns", hasAddOns() ? addOns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.ofNullable(clazz.cast(diskName()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "sizeInGb":
            return Optional.ofNullable(clazz.cast(sizeInGb()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "addOns":
            return Optional.ofNullable(clazz.cast(addOns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDiskRequest, T> g) {
        return obj -> g.apply((CreateDiskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDiskRequest> {
        /**
         * <p>
         * The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Use the same
         * Availability Zone as the Lightsail instance to which you want to attach the disk.
         * </p>
         * <p>
         * Use the <code>get regions</code> operation to list the Availability Zones where Lightsail is currently
         * available.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Use the same
         *        Availability Zone as the Lightsail instance to which you want to attach the disk.</p>
         *        <p>
         *        Use the <code>get regions</code> operation to list the Availability Zones where Lightsail is currently
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The size of the disk in GB (e.g., <code>32</code>).
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB (e.g., <code>32</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * 
         * @param addOns
         *        An array of objects that represent the add-ons to enable for the new disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(Collection<AddOnRequest> addOns);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * 
         * @param addOns
         *        An array of objects that represent the add-ons to enable for the new disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(AddOnRequest... addOns);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddOnRequest>.Builder} avoiding the need to
         * create one manually via {@link List<AddOnRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddOnRequest>.Builder#build()} is called immediately and its
         * result is passed to {@link #addOns(List<AddOnRequest>)}.
         * 
         * @param addOns
         *        a consumer that will call methods on {@link List<AddOnRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOns(List<AddOnRequest>)
         */
        Builder addOns(Consumer<AddOnRequest.Builder>... addOns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private String availabilityZone;

        private Integer sizeInGb;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskRequest model) {
            super(model);
            diskName(model.diskName);
            availabilityZone(model.availabilityZone);
            sizeInGb(model.sizeInGb);
            tags(model.tags);
            addOns(model.addOns);
        }

        public final String getDiskName() {
            return diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final List<AddOnRequest.Builder> getAddOns() {
            List<AddOnRequest.Builder> result = AddOnRequestListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOnRequest... addOns) {
            addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder>... addOns) {
            addOns(Stream.of(addOns).map(c -> AddOnRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskRequest build() {
            return new CreateDiskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
