/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the domain validation records of an Amazon Lightsail SSL/TLS certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainValidationRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainValidationRecord.Builder, DomainValidationRecord> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(DomainValidationRecord::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<ResourceRecord> RESOURCE_RECORD_FIELD = SdkField
            .<ResourceRecord> builder(MarshallingType.SDK_POJO).memberName("resourceRecord")
            .getter(getter(DomainValidationRecord::resourceRecord)).setter(setter(Builder::resourceRecord))
            .constructor(ResourceRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRecord").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            RESOURCE_RECORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final ResourceRecord resourceRecord;

    private DomainValidationRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.resourceRecord = builder.resourceRecord;
    }

    /**
     * <p>
     * The domain name of the certificate validation record. For example, <code>example.com</code> or
     * <code>www.example.com</code>.
     * </p>
     * 
     * @return The domain name of the certificate validation record. For example, <code>example.com</code> or
     *         <code>www.example.com</code>.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
     * </p>
     * 
     * @return An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
     */
    public final ResourceRecord resourceRecord() {
        return resourceRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecord());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidationRecord)) {
            return false;
        }
        DomainValidationRecord other = (DomainValidationRecord) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(resourceRecord(), other.resourceRecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainValidationRecord").add("DomainName", domainName()).add("ResourceRecord", resourceRecord())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "resourceRecord":
            return Optional.ofNullable(clazz.cast(resourceRecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainValidationRecord, T> g) {
        return obj -> g.apply((DomainValidationRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainValidationRecord> {
        /**
         * <p>
         * The domain name of the certificate validation record. For example, <code>example.com</code> or
         * <code>www.example.com</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name of the certificate validation record. For example, <code>example.com</code> or
         *        <code>www.example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
         * </p>
         * 
         * @param resourceRecord
         *        An object that describes the DNS records to add to your domain's DNS to validate it for the
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecord(ResourceRecord resourceRecord);

        /**
         * <p>
         * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceRecord.Builder} avoiding the need to
         * create one manually via {@link ResourceRecord#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceRecord.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceRecord(ResourceRecord)}.
         * 
         * @param resourceRecord
         *        a consumer that will call methods on {@link ResourceRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRecord(ResourceRecord)
         */
        default Builder resourceRecord(Consumer<ResourceRecord.Builder> resourceRecord) {
            return resourceRecord(ResourceRecord.builder().applyMutation(resourceRecord).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private ResourceRecord resourceRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidationRecord model) {
            domainName(model.domainName);
            resourceRecord(model.resourceRecord);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ResourceRecord.Builder getResourceRecord() {
            return resourceRecord != null ? resourceRecord.toBuilder() : null;
        }

        @Override
        public final Builder resourceRecord(ResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public final void setResourceRecord(ResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        @Override
        public DomainValidationRecord build() {
            return new DomainValidationRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
