/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetBucketsRequest.Builder, GetBucketsRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(GetBucketsRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pageToken").getter(getter(GetBucketsRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()).build();

    private static final SdkField<Boolean> INCLUDE_CONNECTED_RESOURCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("includeConnectedResources")
            .getter(getter(GetBucketsRequest::includeConnectedResources)).setter(setter(Builder::includeConnectedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeConnectedResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            PAGE_TOKEN_FIELD, INCLUDE_CONNECTED_RESOURCES_FIELD));

    private final String bucketName;

    private final String pageToken;

    private final Boolean includeConnectedResources;

    private GetBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.pageToken = builder.pageToken;
        this.includeConnectedResources = builder.includeConnectedResources;
    }

    /**
     * <p>
     * The name of the bucket for which to return information.
     * </p>
     * <p>
     * When omitted, the response includes all of your buckets in the AWS Region where the request is made.
     * </p>
     * 
     * @return The name of the bucket for which to return information.</p>
     *         <p>
     *         When omitted, the response includes all of your buckets in the AWS Region where the request is made.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * To get a page token, perform an initial <code>GetBuckets</code> request. If your results are paginated, the
     * response will return a next page token that you can specify as the page token in a subsequent request.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         To get a page token, perform an initial <code>GetBuckets</code> request. If your results are paginated,
     *         the response will return a next page token that you can specify as the page token in a subsequent
     *         request.
     */
    public final String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to include Lightsail instances that were given access to the bucket using
     * the <a>SetResourceAccessForBucket</a> action.
     * </p>
     * 
     * @return A Boolean value that indicates whether to include Lightsail instances that were given access to the
     *         bucket using the <a>SetResourceAccessForBucket</a> action.
     */
    public final Boolean includeConnectedResources() {
        return includeConnectedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(includeConnectedResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsRequest)) {
            return false;
        }
        GetBucketsRequest other = (GetBucketsRequest) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(pageToken(), other.pageToken())
                && Objects.equals(includeConnectedResources(), other.includeConnectedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketsRequest").add("BucketName", bucketName()).add("PageToken", pageToken())
                .add("IncludeConnectedResources", includeConnectedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "pageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "includeConnectedResources":
            return Optional.ofNullable(clazz.cast(includeConnectedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketsRequest, T> g) {
        return obj -> g.apply((GetBucketsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketsRequest> {
        /**
         * <p>
         * The name of the bucket for which to return information.
         * </p>
         * <p>
         * When omitted, the response includes all of your buckets in the AWS Region where the request is made.
         * </p>
         * 
         * @param bucketName
         *        The name of the bucket for which to return information.</p>
         *        <p>
         *        When omitted, the response includes all of your buckets in the AWS Region where the request is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * To get a page token, perform an initial <code>GetBuckets</code> request. If your results are paginated, the
         * response will return a next page token that you can specify as the page token in a subsequent request.
         * </p>
         * 
         * @param pageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        To get a page token, perform an initial <code>GetBuckets</code> request. If your results are
         *        paginated, the response will return a next page token that you can specify as the page token in a
         *        subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * A Boolean value that indicates whether to include Lightsail instances that were given access to the bucket
         * using the <a>SetResourceAccessForBucket</a> action.
         * </p>
         * 
         * @param includeConnectedResources
         *        A Boolean value that indicates whether to include Lightsail instances that were given access to the
         *        bucket using the <a>SetResourceAccessForBucket</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeConnectedResources(Boolean includeConnectedResources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String bucketName;

        private String pageToken;

        private Boolean includeConnectedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketsRequest model) {
            super(model);
            bucketName(model.bucketName);
            pageToken(model.pageToken);
            includeConnectedResources(model.includeConnectedResources);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Boolean getIncludeConnectedResources() {
            return includeConnectedResources;
        }

        @Override
        public final Builder includeConnectedResources(Boolean includeConnectedResources) {
            this.includeConnectedResources = includeConnectedResources;
            return this;
        }

        public final void setIncludeConnectedResources(Boolean includeConnectedResources) {
            this.includeConnectedResources = includeConnectedResources;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBucketsRequest build() {
            return new GetBucketsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
