/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an endpoint for a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalDatabaseEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalDatabaseEndpoint.Builder, RelationalDatabaseEndpoint> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(RelationalDatabaseEndpoint::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("address")
            .getter(getter(RelationalDatabaseEndpoint::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final String address;

    private RelationalDatabaseEndpoint(BuilderImpl builder) {
        this.port = builder.port;
        this.address = builder.address;
    }

    /**
     * <p>
     * Specifies the port that the database is listening on.
     * </p>
     * 
     * @return Specifies the port that the database is listening on.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies the DNS address of the database.
     * </p>
     * 
     * @return Specifies the DNS address of the database.
     */
    public final String address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseEndpoint)) {
            return false;
        }
        RelationalDatabaseEndpoint other = (RelationalDatabaseEndpoint) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationalDatabaseEndpoint").add("Port", port()).add("Address", address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseEndpoint, T> g) {
        return obj -> g.apply((RelationalDatabaseEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalDatabaseEndpoint> {
        /**
         * <p>
         * Specifies the port that the database is listening on.
         * </p>
         * 
         * @param port
         *        Specifies the port that the database is listening on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies the DNS address of the database.
         * </p>
         * 
         * @param address
         *        Specifies the DNS address of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseEndpoint model) {
            port(model.port);
            address(model.address);
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public RelationalDatabaseEndpoint build() {
            return new RelationalDatabaseEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
