/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseSnapshotsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRelationalDatabaseSnapshotsResponse.Builder, GetRelationalDatabaseSnapshotsResponse> {
    private static final SdkField<List<RelationalDatabaseSnapshot>> RELATIONAL_DATABASE_SNAPSHOTS_FIELD = SdkField
            .<List<RelationalDatabaseSnapshot>> builder(MarshallingType.LIST)
            .memberName("relationalDatabaseSnapshots")
            .getter(getter(GetRelationalDatabaseSnapshotsResponse::relationalDatabaseSnapshots))
            .setter(setter(Builder::relationalDatabaseSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSnapshots")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelationalDatabaseSnapshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelationalDatabaseSnapshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetRelationalDatabaseSnapshotsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_SNAPSHOTS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<RelationalDatabaseSnapshot> relationalDatabaseSnapshots;

    private final String nextPageToken;

    private GetRelationalDatabaseSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseSnapshots = builder.relationalDatabaseSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the RelationalDatabaseSnapshots property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasRelationalDatabaseSnapshots() {
        return relationalDatabaseSnapshots != null && !(relationalDatabaseSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object describing the result of your get relational database snapshots request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelationalDatabaseSnapshots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object describing the result of your get relational database snapshots request.
     */
    public final List<RelationalDatabaseSnapshot> relationalDatabaseSnapshots() {
        return relationalDatabaseSnapshots;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetRelationalDatabaseSnapshots</code> request and specify
     * the next page token using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetRelationalDatabaseSnapshots</code> request and
     *         specify the next page token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRelationalDatabaseSnapshots() ? relationalDatabaseSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseSnapshotsResponse)) {
            return false;
        }
        GetRelationalDatabaseSnapshotsResponse other = (GetRelationalDatabaseSnapshotsResponse) obj;
        return hasRelationalDatabaseSnapshots() == other.hasRelationalDatabaseSnapshots()
                && Objects.equals(relationalDatabaseSnapshots(), other.relationalDatabaseSnapshots())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelationalDatabaseSnapshotsResponse")
                .add("RelationalDatabaseSnapshots", hasRelationalDatabaseSnapshots() ? relationalDatabaseSnapshots() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseSnapshots":
            return Optional.ofNullable(clazz.cast(relationalDatabaseSnapshots()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseSnapshotsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseSnapshotsResponse> {
        /**
         * <p>
         * An object describing the result of your get relational database snapshots request.
         * </p>
         * 
         * @param relationalDatabaseSnapshots
         *        An object describing the result of your get relational database snapshots request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseSnapshots(Collection<RelationalDatabaseSnapshot> relationalDatabaseSnapshots);

        /**
         * <p>
         * An object describing the result of your get relational database snapshots request.
         * </p>
         * 
         * @param relationalDatabaseSnapshots
         *        An object describing the result of your get relational database snapshots request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseSnapshots(RelationalDatabaseSnapshot... relationalDatabaseSnapshots);

        /**
         * <p>
         * An object describing the result of your get relational database snapshots request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RelationalDatabaseSnapshot>.Builder}
         * avoiding the need to create one manually via {@link List<RelationalDatabaseSnapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RelationalDatabaseSnapshot>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #relationalDatabaseSnapshots(List<RelationalDatabaseSnapshot>)}.
         * 
         * @param relationalDatabaseSnapshots
         *        a consumer that will call methods on {@link List<RelationalDatabaseSnapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabaseSnapshots(List<RelationalDatabaseSnapshot>)
         */
        Builder relationalDatabaseSnapshots(Consumer<RelationalDatabaseSnapshot.Builder>... relationalDatabaseSnapshots);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetRelationalDatabaseSnapshots</code> request and
         * specify the next page token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetRelationalDatabaseSnapshots</code> request
         *        and specify the next page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<RelationalDatabaseSnapshot> relationalDatabaseSnapshots = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseSnapshotsResponse model) {
            super(model);
            relationalDatabaseSnapshots(model.relationalDatabaseSnapshots);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<RelationalDatabaseSnapshot.Builder> getRelationalDatabaseSnapshots() {
            if (relationalDatabaseSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return relationalDatabaseSnapshots != null ? relationalDatabaseSnapshots.stream()
                    .map(RelationalDatabaseSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relationalDatabaseSnapshots(Collection<RelationalDatabaseSnapshot> relationalDatabaseSnapshots) {
            this.relationalDatabaseSnapshots = RelationalDatabaseSnapshotListCopier.copy(relationalDatabaseSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseSnapshots(RelationalDatabaseSnapshot... relationalDatabaseSnapshots) {
            relationalDatabaseSnapshots(Arrays.asList(relationalDatabaseSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseSnapshots(
                Consumer<RelationalDatabaseSnapshot.Builder>... relationalDatabaseSnapshots) {
            relationalDatabaseSnapshots(Stream.of(relationalDatabaseSnapshots)
                    .map(c -> RelationalDatabaseSnapshot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelationalDatabaseSnapshots(
                Collection<RelationalDatabaseSnapshot.BuilderImpl> relationalDatabaseSnapshots) {
            this.relationalDatabaseSnapshots = RelationalDatabaseSnapshotListCopier.copyFromBuilder(relationalDatabaseSnapshots);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetRelationalDatabaseSnapshotsResponse build() {
            return new GetRelationalDatabaseSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
